# -*- coding: utf-8 -*-
# Generated by Django 1.10.7 on 2017-05-10 11:31
from __future__ import unicode_literals

import django.db.models.deletion
import jsonfield.fields
import openslides.utils.models
from django.db import migrations, models


def add_protocol(apps, schema_editor):
    """
    Adds the one and only projector
    """
    Protocol = apps.get_model('openslides_protocol', 'Protocol')
    Protocol.objects.bulk_create([Protocol(protocol=[])])


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('agenda', '0002_item_duration'),
        ('contenttypes', '0002_remove_content_type_name'),
    ]

    operations = [
        migrations.CreateModel(
            name='Protocol',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('protocol', jsonfield.fields.JSONField()),
            ],
            options={
                'default_permissions': (),
            },
            bases=(openslides.utils.models.RESTModelMixin, models.Model),
        ),
        migrations.CreateModel(
            name='ObjectProtocol',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('object_id', models.PositiveIntegerField(blank=True, null=True)),
                ('protocol', models.TextField(blank=True)),
                ('content_type', models.ForeignKey(
                    blank=True,
                    null=True,
                    on_delete=django.db.models.deletion.SET_NULL,
                    to='contenttypes.ContentType')),
            ],
            options={
                'default_permissions': (),
                'permissions': (('can_write_protocol', 'Can write protocol'),),
            },
            bases=(openslides.utils.models.RESTModelMixin, models.Model),
        ),
        migrations.AlterUniqueTogether(
            name='objectprotocol',
            unique_together=set([('content_type', 'object_id')]),
        ),
        migrations.RunPython(
            add_protocol
        ),
    ]
