(function(){angular.module('OpenSlidesApp.openslides_voting.templates', []).run(['$templateCache', function($templateCache) {$templateCache.put('static/templates/openslides_voting/absentee-vote-form.html','<h1 ng-if="model.id" translate>Edit absentee vote</h1>\n<h1 ng-if="!model.id" translate>New absentee vote</h1>\n\n<div uib-alert ng-show="alert.show" ng-class="\'alert-\' + alert.type" close="alert={}">\n  {{ alert.msg }}\n</div>\n\n<form name="absenteeVoteForm" ng-submit="save(model)">\n  <formly-form model="model" fields="formFields">\n    <button type="submit" ng-disabled="absenteeVoteForm.$invalid" class="btn btn-primary" translate>\n      Save\n    </button>\n    <button type="button" ng-click="closeThisDialog()" class="btn btn-default" translate>\n      Cancel\n    </button>\n  </formly-form>\n</form>\n');
$templateCache.put('static/templates/openslides_voting/absentee-vote-import.html','<div class="header">\n  <div class="title">\n    <div class="submenu">\n      <a ui-sref="openslides_voting.absenteeVote.list" class="btn btn-sm btn-default">\n        <i class="fa fa-angle-double-left fa-lg"></i>\n        <translate>Back to overview</translate>\n      </a>\n    </div>\n    <h1 translate>Import absentee votes</h1>\n  </div>\n</div>\n\n<div class="details">\n  <h3 translate>Select a CSV file</h3>\n  <csv-import change="onCsvChange(csv)" config="csvConfig"></csv-import>\n\n\n  <h4 translate>Please note:</h4>\n  <ul class="indentation">\n      <li><translate>Required comma or semicolon separated values with these column header names in the first row</translate>:<br>\n        <code>\n          <translate>Given name</translate>,\n          <translate>Surname</translate>,\n          <translate>Participant number</translate>,\n          <translate>Motion identifier</translate>,\n          <translate>Voting intention</translate>\n        </code>\n      <li translate>Only double quotes are accepted as text delimiter (no single quotes).\n  </ul>\n\n  <div ng-if="delegateVotes.length">\n    <h3 translate>Preview</h3>\n    <table class="table table-striped table-bordered table-condensed">\n      <thead>\n        <tr>\n          <th>\n          <th>#\n          <th translate>Delegate\n          <th translate>Motion\n          <th translate>Voting intention</th>\n      <tbody>\n        <tr ng-repeat="delegateVote in delegateVotes | limitTo:pagination.itemsPerPage:pagination.limitBegin">\n          <td class="minimum"\n              ng-class="{ \'text-danger\': delegateVote.importerror, \'text-success\': delegateVote.imported }">\n            <span ng-if="delegateVote.importerror">\n              <i class="fa fa-exclamation-triangle fa-lg"></i>\n            </span>\n            <span ng-if="!delegateVote.importerror && !delegateVote.imported" class="pointer">\n              <i class="fa fa-check-circle-o fa-lg"\n                 ng-if="delegateVote.selected" ng-click="delegateVote.selected=false; calcStats();"></i>\n              <i class="fa fa-circle-o fa-lg"\n                 ng-if="!delegateVote.selected" ng-click="delegateVote.selected=true; calcStats();"></i>\n            </span>\n            <span ng-if="delegateVote.imported">\n              <i class="fa fa-check-circle fa-lg"></i>\n            </span>\n          <td class="nobr">\n            {{ (pagination.currentPage - 1) * pagination.itemsPerPage + $index + 1 }}\n          <td ng-class="{ \'text-danger\': delegateVote.user_error }">\n            <span ng-if="delegateVote.user_error" title="{{ delegateVote.user_error | translate }}">\n              <i class="fa fa-exclamation-triangle"></i>\n            </span>\n            {{ delegateVote.fullname }}\n          <td ng-class="{ \'text-danger\': delegateVote.motion_error }">\n            <span ng-if="delegateVote.motion_error" title="{{ delegateVote.motion_error | translate }}">\n              <i class="fa fa-exclamation-triangle"></i>\n            </span>\n            {{ delegateVote.motion }}\n          <td ng-class="{ \'text-danger\': delegateVote.vote_error }">\n            <span ng-if="delegateVote.vote_error" title="{{ delegateVote.vote_error | translate }}">\n              <i class="fa fa-exclamation-triangle"></i>\n            </span>\n            <i class="fa fa-{{ delegateVote.vote_icon }}"></i>\n            <span style="margin-left: 5px">{{ delegateVote.vote_name }}</span>\n    </table>\n    <ul uib-pagination\n        ng-show="delegateVotes.length > pagination.itemsPerPage"\n        total-items="delegateVotes.length"\n        items-per-page="pagination.itemsPerPage"\n        ng-model="pagination.currentPage"\n        ng-change="pagination.pageChanged()"\n        class="pagination-sm"\n        direction-links="false"\n        boundary-links="true"\n        first-text="&laquo;"\n        last-text="&raquo;">\n    </ul>\n\n    <div class="text-danger">\n      <i class="fa fa-exclamation-triangle"></i>\n      {{ votesWillNotBeImported }}\n      <translate>absentee votes will not be imported.</translate>\n    </div>\n    <div>\n      <i class="fa fa-check-circle-o fa-lg"></i>\n      {{ votesWillBeImported }}\n      <translate>absentee votes will be imported.</translate>\n    </div>\n    <div ng-repeat="delegateVote in delegateVotesImported = (delegateVotes | filter:{imported:true})"></div>\n    <div ng-if="delegateVotesImported.length" class="text-success">\n      <hr class="smallhr">\n      <i class="fa fa-check-circle fa-lg"></i>\n      {{ delegateVotesImported.length }}\n      <translate>absentee votes were successfully imported.</translate>\n    </div>\n\n    <div class="spacer">\n      <button ng-click="clear()" class="btn btn-default" translate>\n        Clear preview\n      </button>\n      <button ng-if="!csvImporting && votesWillBeImported > 0" ng-click="import()" class="btn btn-primary" translate>\n        Import {{ votesWillBeImported }} absentee votes\n      </button>\n    </div>\n    <div class="spacer">\n      <a ng-if="csvImported" ui-sref="openslides_voting.absenteeVote.list" class="btn btn-default">\n        <i class="fa fa-angle-double-left fa-lg"></i>\n        <translate>Back to overview</translate>\n      </a>\n    </div>\n  </div>\n</div>\n');
$templateCache.put('static/templates/openslides_voting/absentee-vote-list.html','<div class="header">\n  <div class="title">\n    <div class="submenu">\n      <a ui-sref="users.user.list" class="btn btn-sm btn-default">\n        <i class="fa fa-angle-double-left fa-lg"></i>\n        <translate>Back to overview</translate>\n      </a>\n      <a ng-click="openDialog()" class="btn btn-primary btn-sm">\n        <i class="fa fa-plus fa-lg"></i>\n        <translate>New</translate>\n      </a>\n      <a ui-sref="openslides_voting.absenteeVote.import" class="btn btn-default btn-sm">\n        <i class="fa fa-download fa-lg"></i>\n        <translate>Import</translate>\n      </a>\n    </div>\n    <h1 translate>Absentee votes</h1>\n  </div>\n</div>\n\n<div class="details">\n  <div class="row">\n    <div class="col-sm-6">\n      <!-- Delete mode -->\n      <button class="btn"\n          ng-class="isDeleteMode ? \'btn-primary\' : \'btn-default\'"\n          ng-click="isDeleteMode = !isDeleteMode; uncheckAll()">\n        <i class="fa fa-check-square-o"></i>\n        <translate>Select ...</translate>\n      </button>\n    </div>\n    <div class="col-sm-4 pull-right">\n      <!-- Search/filter -->\n      <input type="text" ng-model="filter.filterString" class="form-control"\n             ng-change="filter.save()"\n             placeholder="{{ \'Search\' | translate }}">\n    </div>\n  </div>\n  <!-- Delete mode options -->\n  <div uib-collapse="!isDeleteMode" class="row spacer">\n    <div class="col-sm-12 text-left">\n      <!-- Delete button -->\n      <a ng-show="isDeleteMode"\n         ng-bootbox-confirm="{{ \'Are you sure you want to delete all selected absentee votes?\' | translate }}"\n         ng-bootbox-confirm-action="deleteMultiple()"\n         class="btn btn-primary">\n        <i class="fa fa-trash fa-lg"></i>\n        <translate>Delete selected absentee votes</translate>\n      </a>\n    </div>\n  </div>\n\n  <div class="spacer-top-lg italic">\n    {{ absenteeVotesFiltered.length }} / {{ absenteeVotes.length }} {{ "Absentee votes" | translate }}\n    <span ng-if="(absenteeVotes | filter:{selected:true}).length > 0">,\n    {{(absenteeVotes | filter:{selected:true}).length}} {{ "selected" | translate }}</span>\n  </div>\n\n  <table class="table table-striped table-bordered table-hover">\n    <thead>\n      <tr>\n        <!-- Delete selection column -->\n        <th ng-show="isDeleteMode" class="minimum deleteColumn">\n          <input type="checkbox" ng-model="$parent.selectedAll" ng-change="checkAll()">\n        </th>\n\n        <!-- Delegate column -->\n        <th ng-click="sort.toggle(\'user.full_name\')" class="sortable">\n          <translate>Delegate</translate>\n          <i class="pull-right fa" ng-show="sort.column === \'user.full_name\'"\n              ng-class="sort.reverse ? \'fa-sort-desc\' : \'fa-sort-asc\'">\n          </i>\n        </th>\n\n        <!-- Motion column -->\n        <th ng-click="sort.toggle(\'motion.identifier\')" class="sortable">\n          <translate>Motion</translate>\n          <i class="pull-right fa" ng-show="sort.column === \'motion.identifier\'"\n              ng-class="sort.reverse ? \'fa-sort-desc\' : \'fa-sort-asc\'">\n          </i>\n        </th>\n\n        <!-- Vote column -->\n        <th ng-click="sort.toggle(\'vote\')" class="sortable">\n          <translate>Voting intention</translate>\n          <i class="pull-right fa" ng-show="sort.column === \'vote\'"\n              ng-class="sort.reverse ? \'fa-sort-desc\' : \'fa-sort-asc\'">\n          </i>\n        </th>\n      </tr>\n    </thead>\n    <tbody>\n      <tr ng-repeat="absenteeVote in absenteeVotesFiltered = (absenteeVotes\n        | osFilter : filter.filterString : filter.getObjectQueryString\n        | orderBy : sort.column : sort.reverse)\n        | limitTo : pagination.itemsPerPage : pagination.limitBegin"\n        ng-class="{\'selected\':absenteeVote.selected}"\n        ng-mouseover="absenteeVote.hover=true" ng-mouseleave="absenteeVote.hover=false">\n\n        <!-- Delete selection -->\n        <td ng-show="isDeleteMode" class="deleteColumn">\n          <input type="checkbox" ng-model="absenteeVote.selected">\n        </td>\n\n        <!-- Delegate -->\n        <td>\n          <a href="" ui-sref="users.user.detail({id: absenteeVote.delegate_id})">{{ absenteeVote.delegate.full_name }}</a>\n          <div class="hoverActions" ng-class="{\'hiddenDiv\': !absenteeVote.hover}">\n            <span>\n              <a href="" ng-click="openDialog(absenteeVote)" translate>Edit</a> &middot;\n              <a href="" class="text-danger"\n                ng-bootbox-confirm="{{ \'Are you sure you want to delete this entry?\' | translate }}<br>\n                <b>{{ absenteeVote.getTitle() }}</b>"\n                ng-bootbox-confirm-action="delete(absenteeVote)" translate>Delete</a>\n            </span>\n          </div>\n        </td>\n\n        <!-- Object -->\n        <td ng-if="absenteeVote.getResourceName() === \'openslides_voting/motion-absentee-vote\'">\n          <a ui-sref="motions.motion.detail({id: absenteeVote.motion_id})">\n            {{ absenteeVote.getObjectTitle() }}\n          </a>\n        </td>\n        <td ng-if="absenteeVote.getResourceName() === \'openslides_voting/assignment-absentee-vote\'">\n          <a ui-sref="assignments.assignment.detail({id: absenteeVote.assignment_id})">\n            {{ absenteeVote.getObjectTitle() }}\n          </a>\n        </td>\n\n        <!-- Vote -->\n        <td>\n          <i ng-if="absenteeVote.getVoteIcon()" class="fa fa-{{ absenteeVote.getVoteIcon() }}"></i>\n          <span style="margin-left: 5px">{{ absenteeVote.getVote() | translate }}</span>\n        </td>\n      </tr>\n    </tbody>\n  </table>\n  <ul uib-pagination\n      ng-show="absenteeVotesFiltered.length > pagination.itemsPerPage"\n      total-items="absenteeVotesFiltered.length"\n      items-per-page="pagination.itemsPerPage"\n      ng-model="pagination.currentPage"\n      ng-change="pagination.pageChanged()"\n      class="pagination-sm"\n      direction-links="false"\n      boundary-links="true"\n      first-text="&laquo;"\n      last-text="&raquo;">\n  </ul>\n\n  <p class="grey" translate>Note: Absentee votes for elections are not supported yet.</p>\n</div>\n');
$templateCache.put('static/templates/openslides_voting/assignment-poll-detail.html','<div class="header">\n  <div class="title">\n    <div class="submenu">\n      <!-- Back to assignment -->\n      <a ui-sref="assignments.assignment.detail({id: assignment.id})" class="btn btn-sm btn-default">\n        <i class="fa fa-angle-double-left fa-lg"></i>\n        <translate>Back to Election</translate>\n      </a>\n      <!-- pdf -->\n      <a ng-click="pdfExport()" class="btn btn-default btn-sm">\n        <i class="fa fa-file-pdf-o fa-lg"></i>\n        PDF\n      </a>\n      <!-- Anonymize -->\n      <a os-perms="openslides_voting.can_manage"\n        class="btn btn-sm btn-default"\n        ng-bootbox-confirm="{{ \'Are you sure you want to anonymize all votes?\' | translate }}"\n        ng-bootbox-confirm-action="anonymizeVotes()">\n        <i class="fa fa-exclamation-triangle fa-lg"></i>\n        <translate>Anonymize votes</translate>\n      </a>\n    </div>\n    <h1>{{ assignment.getTitle() }}</h1>\n    <h2>\n      <translate translate-comment=\'ballot of a assignment\'>Election result</translate>\n    </h2>\n  </div>\n</div>\n\n<div class="details">\n  <!-- Single votes -->\n  <div class="row">\n    <div class="col-sm-6"><h3 translate>Single votes</h3></div>\n    <div class="col-sm-4 pull-right">\n      <!-- Search/filter -->\n      <input type="text" ng-model="filter.filterString" class="form-control"\n          ng-change="filter.save()"\n          placeholder="{{ \'Search\' | translate }}">\n    </div>\n  </div>\n\n  <div class="italic row">\n    <div class="col-md-6">\n      {{ ballotsFiltered.length }} / {{ ballots.length }} {{ "Single votes" | translate }}\n    </div>\n\n    <div class="col-md-6" ng-show="ballotsFiltered.length > pagination.itemsPerPage">\n      <span class="pull-right">\n        <a href="" class="pagination-arrow" ng-click="pagination.prevPage()"\n          ng-if="pagination.showPrevPageArrow()">\n          &laquo;\n        </a>\n        <translate>Page</translate> {{ pagination.currentPage }} /\n        {{ pagination.getPageCount(ballotsFiltered) }}\n        <a href="" class="pagination-arrow" ng-click="pagination.nextPage(ballotsFiltered)"\n          ng-if="pagination.showNextPageArrow(ballotsFiltered)">\n          &raquo;\n        </a>\n      </span>\n    </div>\n  </div>\n\n  <table class="table table-striped table-bordered table-hover">\n    <thead>\n      <tr>\n        <!-- Delegate column -->\n        <th ng-click="sort.toggle(\'user.full_name\')" class="sortable" ng-if="pollType !== \'token_based_electronic\'">\n          <translate>Delegate</translate>\n          <i class="pull-right fa" ng-show="sort.column === \'user.full_name\'"\n              ng-class="sort.reverse ? \'fa-sort-desc\' : \'fa-sort-asc\'">\n          </i>\n        </th>\n\n        <!-- Voting device column -->\n        <th ng-click="sort.toggle(\'device\')" class="sortable"\n            ng-if="!pollType.indexOf(\'votecollector\')">\n          <translate>Keypad serial number</translate>\n          <i class="pull-right fa" ng-show="sort.column === \'device\'"\n              ng-class="sort.reverse ? \'fa-sort-desc\' : \'fa-sort-asc\'">\n          </i>\n          <i class="fa fa-info-circle"\n             uib-tooltip="{{ \'Press \\\'Fn+6\\\' on keypad to display the serial number.\' | translate}}"></i>\n        </th>\n\n        <!-- Result number column -->\n        <th ng-click="sort.toggle(\'result_token\')" class="sortable" ng-if="pollType === \'token_based_electronic\'">\n          <translate>Result number</translate>\n          <i class="pull-right fa" ng-show="sort.column === \'result_token\'"\n              ng-class="sort.reverse ? \'fa-sort-desc\' : \'fa-sort-asc\'">\n          </i>\n        </th>\n\n        <!-- Vote column -->\n        <!-- TODO: Make vote column sortable. -->\n        <th>\n          <translate>Casted vote</translate>\n        </th>\n    </thead>\n\n    <tbody>\n      <tr ng-repeat="ballot in (ballotsFiltered = (ballots\n        | osFilter : filter.filterString : filter.getObjectQueryString\n        | orderBy : sort.column : sort.reverse)\n        | limitTo : pagination.itemsPerPage : pagination.limitBegin)"\n        class="animate-item" ng-class="{\'selected\':ballot.selected}">\n\n        <!-- Delegate -->\n        <td ng-if="pollType !== \'token_based_electronic\'">\n          <a href="" ng-if="ballot.user" ui-sref="users.user.detail({id: ballot.user.id})">\n            {{ ballot.user.full_name }}\n          </a>\n          <span ng-if="!ballot.user"><i><translate>Anonymous</translate></i></span>\n        </td>\n\n        <!-- Voting device -->\n        <td ng-if="!pollType.indexOf(\'votecollector\')">\n          {{ ballot.device }}\n        </td>\n\n        <!-- Result token-->\n        <td ng-if="pollType === \'token_based_electronic\'">\n          {{ ballot.result_token }}\n        </td>\n\n        <!-- Vote -->\n        <td>\n          <i class="fa fa-{{ ballot.getVoteIcon() }}" ng-if="(poll.pollmethod === \'yna\' || poll.pollmethod === \'yn\') && poll.options.length === 1"></i>\n          <span style="margin-left: 5px">{{ ballot.getVote() | translate }}</span>\n        </td>\n  </table>\n  <ul uib-pagination\n      ng-show="ballotsFiltered.length > pagination.itemsPerPage"\n      total-items="ballotsFiltered.length"\n      items-per-page="pagination.itemsPerPage"\n      ng-model="pagination.currentPage"\n      ng-change="pagination.pageChanged()"\n      class="pagination-sm"\n      direction-links="false"\n      boundary-links="true"\n      first-text="&laquo;"\n      last-text="&raquo;">\n  </ul>\n</div>\n');
$templateCache.put('static/templates/openslides_voting/assignment-poll-form-buttons-hook.html','<div ng-controller="AssignmentPollFormVotingCtrl" ng-init="poll=$parent.$parent.model">\n  <div ng-if="!isAnalogPoll()" class="spacer-top-lg">\n    <button type="button"\n      ng-if="canStartVoting()" ng-click="startVoting()"\n      class="btn btn-default btn-sm">\n      <i class="fa fa-bullseye" aria-hidden="true"></i>\n      {{ \'Start voting\' | translate }}</button>\n    <button type="button"\n      ng-if="canStopVoting() && isThisPollActive()" ng-click="stopVoting()"\n      class="btn btn-primary btn-sm">\n      <i class="fa fa-spinner fa-lg fa-spin" aria-hidden="true"></i>\n      {{ \'Stop voting\' | translate }}</button>\n    <button type="button"\n      ng-if="canStopVoting() && !isThisPollActive()" ng-click="stopVoting()"\n      class="btn btn-danger btn-sm">\n      <i class="fa fa-bullseye" aria-hidden="true"></i>\n      {{ \'Stop another voting\' | translate }}</button>\n    <button type="button"\n      ng-if="canClearVotes()" ng-click="clearVotes()"\n      class="btn btn-default btn-sm">\n      <i class="fa fa-trash" aria-hidden="true"></i>\n      {{ \'Clear votes\' | translate }}</button>\n    <projector-button model="projectModel" default-projector-id="1"\n      content="{{ getProjectorButtonText() }}"></projector-button>\n    <p>{{ getVotingStatus() }}</p><br>\n  </div>\n</div>\n');
$templateCache.put('static/templates/openslides_voting/assignment-poll-small-buttons-hook.html','<div os-perms="openslides_voting.can_manage">\n  <div class="spacer-top" ng-if="poll.has_votes && showSingleVotes">\n    <span class="spacer" ng-if="config(\'voting_enable_principles\')">\n      <button type="button" ng-click="countVotes()"\n        class="btn btn-xs btn-default">\n        <i class="fa fa-repeat" aria-hidden="true"></i>\n        {{ \'Recount votes\' | translate }}\n      </button>\n    </span>\n    <span class="spacer">\n      <a ui-sref="openslides_voting.assignmentPoll.detail({id: poll.id})" role="button"\n        class="btn btn-xs btn-default">\n        <i class="fa fa-table" aria-hidden="true"></i>\n        {{ \'Single votes\' | translate }}\n      </a>\n    </span>\n  </div>\n  <small>\n    {{ pollType | translate }}\n  </small>\n</div>\n');
$templateCache.put('static/templates/openslides_voting/assignment-poll-voting-header-hook.html','<a ui-sref="submit_votes.assignmentPoll({id: getActivePoll()})"\n  ng-if="getActivePoll()"\n  class="btn btn-sm btn-sm" ng-class="getVoteForActivePoll() ? \'btn-default\' : \'btn-primary\'">\n  <span ng-if="!getVoteForActivePoll()">\n    <translate>Vote now!</translate>\n  </span>\n  <span ng-if="getVoteForActivePoll()">\n    <translate>You have already voted.</translate>\n  </span>\n</a>\n');
$templateCache.put('static/templates/openslides_voting/attendance.html','<style type="text/css">\n  #attendance-table, #history-table {\n    width: auto;\n  }\n  #attendance-table, #history-table td:first-child {\n    white-space: nowrap;\n  }\n</style>\n\n<div class="header">\n  <div class="title">\n    <div class="submenu">\n      <a ui-sref="users.user.list" class="btn btn-sm btn-default">\n        <i class="fa fa-angle-double-left fa-lg"></i>\n        <translate>Back to overview</translate>\n      </a>\n    </div>\n    <h1 translate>Attendance</h1>\n  </div>\n</div>\n\n<div class="details">\n  <div class="scroll-x-container">\n    <table class="table table-bordered" id="attendance-table">\n      <thead>\n        <tr>\n          <th></th>\n          <th class="text-right">\n            <translate>Heads</translate>\n          </th>\n\n          <!-- Voting principle columns -->\n          <th ng-repeat="principle in (principles | orderBy: \'id\')" class="text-right">\n            {{ principle.name }}\n          </th>\n        </tr>\n      </thead>\n      <tbody>\n        <tr ng-repeat="i in [0, 1, 2, 3]" ng-init="principle = [\'Total\', \'Present\', \'Present in person\', \'Represented\']">\n          <td>\n            {{ principle[i] | translate }}\n          </td>\n          <td class="text-right">\n            {{ attendance.heads[i] }}\n          </td>\n          <!-- Voting principle columns. Categories must be sorted in the same order as the header. -->\n          <td ng-repeat="principle in (principles | orderBy: \'id\')" class="text-right">\n            {{ attendance[principle.id][i] | number: principle.decimal_places }}\n          </td>\n          <!-- TODO: Show percentages and indicate if attendance drops below 50 % -->\n        </tr>\n      </tbody>\n    </table>\n  </div>\n\n  <div class="spacer">\n    <button type="button" class="btn btn-sm btn-default" ng-click="historyVisible = !historyVisible" translate>\n      Show attendance history\n    </button>\n    <button type="button" class="btn btn-sm btn-default" ng-if="historyVisible" ng-click="pdfExport()">\n      <i class="fa fa-file-pdf-o fa-lg"></i>\n      PDF\n    </button>\n    <button type="button" class="btn btn-sm btn-default" ng-if="historyVisible"\n            ng-bootbox-confirm="{{ \'Are you sure you want to delete the attendance history?\' | translate }}"\n            ng-bootbox-confirm-action="deleteHistory()">\n      <i class="fa fa-remove fa-lg"></i>\n      <translate>Delete</translate>\n    </button>\n  </div>\n\n  <div class="spacer scroll-x-container well well-sm" uib-collapse="!historyVisible">\n    <table class="table table-striped table-bordered table-condensed small" id="history-table">\n      <thead>\n        <tr>\n          <th>\n            <translate>Time</translate>\n          </th>\n          <th class="text-right">\n            <translate>Heads</translate>\n          </th>\n\n          <!-- Shares columns -->\n          <th ng-repeat="principle in (principles | orderBy: \'id\')" class="text-right">\n            {{ principle.name }}\n          </th>\n\n      <tbody>\n        <tr ng-repeat="log in attendanceLogs | orderBy:\'-created\'">\n          <!-- TODO: Use localized time format -->\n          <td>\n            {{ log.created | date:\'yyyy-MM-dd HH:mm:ss\' }}\n          </td>\n          <td class="text-right">\n            {{ log.json().heads }}\n          </td>\n\n          <!-- Shares collection, categories must be sorted in the same order as the header -->\n          <td ng-repeat="principle in (principles | orderBy: \'id\')" class="text-right">\n            {{ log.json()[principle.id] | number: principle.decimal_places }}\n          </td>\n    </table>\n  </div>\n</div>\n');
$templateCache.put('static/templates/openslides_voting/delegate-attendance.html','<style type="text/css">\n  #attendance-table, #history-table {\n    width: auto;\n  }\n  #attendance-table, #history-table td:first-child {\n    white-space: nowrap;\n  }\n</style>\n\n<div class="header">\n  <div class="title">\n    <div class="submenu">\n      <a ui-sref="openslides_voting.delegate.list" class="btn btn-sm btn-default">\n        <i class="fa fa-angle-double-left fa-lg"></i>\n        <translate>Back to overview</translate>\n      </a>\n    </div>\n    <h1 translate>Attendance</h1>\n  </div>\n</div>\n\n<div class="details">\n  <div class="scroll-x-container">\n    <table class="table table-bordered" id="attendance-table">\n      <thead>\n        <tr>\n          <th><!--<translate>Voting principle</translate>-->\n          <th class="text-right"><translate>Heads</translate>\n\n          <!-- Voting principle columns -->\n          <th ng-repeat="category in (categories | orderBy:\'id\')" class="text-right">\n            {{ category.name }}\n\n      <tbody>\n        <tr ng-repeat="i in [0, 1, 2, 3]" ng-init="principle = [\'Total\', \'Present\', \'Present in person\', \'Represented\']">\n          <td>{{ principle[i] | translate }}\n          <td class="text-right">{{ attendance.heads[i] }}\n          <!-- Voting principle columns. Categories must be sorted in the same order as the header. -->\n          <td ng-repeat="category in (categories | orderBy:\'id\')" class="text-right">\n            {{ attendance[category.id][i] | number:getVPPrecision(category.name) }}\n          <!-- TODO: Show percentages and indicate if attendance drops below 50 % -->\n    </table>\n  </div>\n\n  <div class="spacer">\n    <button type="button" class="btn btn-sm btn-default" ng-click="historyVisible = !historyVisible" translate>\n      Show attendance history\n    </button>\n    <button type="button" class="btn btn-sm btn-default" ng-if="historyVisible" ng-click="pdfExport()">\n      <i class="fa fa-file-pdf-o fa-lg"></i>\n      PDF\n    </button>\n    <button type="button" class="btn btn-sm btn-default" ng-if="historyVisible"\n            ng-bootbox-confirm="{{ \'Are you sure you want to delete the attendance history?\' | translate }}"\n            ng-bootbox-confirm-action="deleteHistory()">\n      <i class="fa fa-remove fa-lg"></i>\n      <translate>Delete</translate>\n    </button>\n  </div>\n\n  <div class="spacer scroll-x-container well well-sm" uib-collapse="!historyVisible">\n    <table class="table table-striped table-bordered table-condensed small" id="history-table">\n      <thead>\n        <tr>\n          <th><translate>Time</translate>\n          <th class="text-right"><translate>Heads</translate>\n\n          <!-- Shares columns -->\n          <th ng-repeat="category in (categories | orderBy:\'id\')" class="text-right">\n            {{ category.name }}\n\n      <tbody>\n        <tr ng-repeat="log in attendanceLogs | orderBy:\'-created\'">\n          <!-- TODO: Use localized time format -->\n          <td>{{ log.created | date:\'yyyy-MM-dd HH:mm:ss\' }}\n          <td class="text-right">{{ log.json().heads }}\n\n          <!-- Shares collection, categories must be sorted in the same order as the header -->\n          <td ng-repeat="category in (categories | orderBy:\'id\')" class="text-right">\n            {{ log.json()[category.id] | number:getVPPrecision(category.name)  }}\n    </table>\n  </div>\n</div>\n');
$templateCache.put('static/templates/openslides_voting/delegate-form.html','<div ng-controller="DelegateUpdateCtrl">\n  <h1 translate>Edit participant</h1>\n\n  <div uib-alert ng-show="$parent.alert.show" ng-class="\'alert-\' + $parent.alert.type" close="$parent.alert={}">\n    {{ $parent.$parent.alert.msg }}\n  </div>\n\n  <form name="delegateForm" ng-submit="delegateSave(model)">\n    <formly-form model="model" fields="delegateFormFields">\n      <button type="submit" ng-disabled="delegateForm.$invalid" class="btn btn-primary" translate>\n        Save\n      </button>\n      <button type="button" ng-click="closeThisDialog()" class="btn btn-default" translate>\n        Cancel\n      </button>\n    </formly-form>\n  </form>\n</div>\n');
$templateCache.put('static/templates/openslides_voting/item-detail-list-of-speakers-buttons-hook.html','<div ng-controller="SpeakerListCtrl" ng-init="item=$parent.$parent.item" class="spacer">\n  <button type="button"\n    ng-if="canStartVoting()" ng-click="startVoting()"\n    class="btn btn-sm btn-default">\n    <i class="fa fa-bullseye" aria-hidden="true"></i>\n    {{ \'Start speakers voting\' | translate }}</button>\n  <button type="button"\n    ng-if="canStopVoting() && isThisPollActive()" ng-click="stopVoting()"\n    class="btn btn-sm btn-primary">\n    <i class="fa fa-spinner fa-lg fa-spin" aria-hidden="true"></i>\n    {{ \'Stop speakers voting\' | translate }}</button>\n  <button type="button"\n    ng-if="canStopVoting() && !isThisPollActive()" ng-click="stopVoting()"\n    class="btn btn-danger">\n    <i class="fa fa-bullseye" aria-hidden="true"></i>\n    {{ \'Stop another voting\' | translate }}</button>\n</div>\n');
$templateCache.put('static/templates/openslides_voting/keypad-form.html','<h1 ng-if="model.id" translate>Edit keypad</h1>\n<h1 ng-if="!model.id" translate>New keypad</h1>\n\n<div uib-alert ng-show="alert.show" ng-class="\'alert-\' + alert.type" close="alert={}">\n  {{ alert.msg }}\n</div>\n\n<form name="keypadForm" ng-submit="save(model)">\n  <formly-form model="model" fields="formFields">\n    <button type="submit" ng-disabled="keypadForm.$invalid" class="btn btn-primary" translate>\n      Save\n    </button>\n    <button type="button" ng-click="closeThisDialog()" class="btn btn-default" translate>\n      Cancel\n    </button>\n  </formly-form>\n</form>\n');
$templateCache.put('static/templates/openslides_voting/keypad-import.html','<div class="header">\n  <div class="title">\n    <div class="submenu">\n      <a ui-sref="openslides_voting.keypad.list" class="btn btn-sm btn-default">\n        <i class="fa fa-angle-double-left fa-lg"></i>\n        <translate>Back to overview</translate>\n      </a>\n    </div>\n    <h1 translate>Import keypads</h1>\n  </div>\n</div>\n\n<div class="details">\n  <h3 translate>Select a CSV file</h3>\n  <csv-import change="onCsvChange(csv)" config="csvConfig"></csv-import>\n\n  <h4 translate>Please note:</h4>\n  <ul class="indentation">\n      <li><translate>Required comma or semicolon separated values with these column header names in the first row</translate>:<br>\n        <code>\n          <translate>Given name</translate>,\n          <translate>Surname</translate>,\n          <translate>Participant number</translate>,\n          <translate>Keypad</translate>\n        </code>\n      <li translate>Only double quotes are accepted as text delimiter (no single quotes).\n  </ul>\n\n  <div ng-if="users.length">\n    <h3 translate>Preview</h3>\n    <div class="scroll-x-container">\n      <table class="table table-striped table-bordered table-condensed">\n        <thead>\n          <tr>\n            <th>\n            <th>#\n            <th translate>Keypad\n            <th translate>Participant</th>\n        <tbody>\n          <tr ng-repeat="user in users | limitTo:pagination.itemsPerPage:pagination.limitBegin">\n            <td class="minimum"\n                ng-class="{ \'text-danger\': user.importerror, \'text-success\': user.imported }">\n              <span ng-if="user.importerror">\n                <i class="fa fa-exclamation-triangle fa-lg"></i>\n              </span>\n              <span ng-if="!user.importerror && !user.imported" class="pointer">\n                <i class="fa fa-check-circle-o fa-lg" ng-if="user.selected" ng-click="user.selected=false; calcStats();"></i>\n                <i class="fa fa-circle-o fa-lg" ng-if="!user.selected" ng-click="user.selected=true; calcStats();"></i>\n              </span>\n              <span ng-if="user.imported">\n                <i class="fa fa-check-circle fa-lg"></i>\n              </span>\n            <td class="nobr">\n              {{ (pagination.currentPage - 1) * pagination.itemsPerPage + $index + 1 }}\n            <td ng-class="{ \'text-danger\': user.keypad_error }">\n              <span ng-if="user.keypad_error" title="{{ user.keypad_error | translate }}">\n                <i class="fa fa-exclamation-triangle"></i>\n              </span>\n              {{ user.keypad }}\n            <td ng-class="{ \'text-danger\': user.user_error }">\n              <span ng-if="user.user_error" title="{{ user.user_error | translate }}">\n                <i class="fa fa-exclamation-triangle"></i>\n              </span>\n              <span ng-if="user.user_id">\n                {{ user.fullname }}\n              </span>\n              <span ng-if="!user.user_id"><i><translate>Anonymous</translate></i></span>\n      </table>\n    </div>\n    <ul uib-pagination\n        ng-show="users.length > pagination.itemsPerPage"\n        total-items="users.length"\n        items-per-page="pagination.itemsPerPage"\n        ng-model="pagination.currentPage"\n        ng-change="pagination.pageChanged()"\n        class="pagination-sm"\n        direction-links="false"\n        boundary-links="true"\n        first-text="&laquo;"\n        last-text="&raquo;">\n    </ul>\n\n    <div class="text-danger">\n      <i class="fa fa-exclamation-triangle"></i>\n      {{ keypadsWillNotBeImported }}\n      <translate>keypads will not be imported.</translate>\n    </div>\n    <div>\n      <i class="fa fa-check-circle-o fa-lg"></i>\n      {{ keypadsWillBeImported }}\n      <translate>keypads will be imported.</translate>\n    </div>\n    <div ng-repeat="user in keypadsImported = (users | filter:{imported:true})"></div>\n    <div ng-if="keypadsImported.length" class="text-success">\n      <hr class="smallhr">\n      <i class="fa fa-check-circle fa-lg"></i>\n      {{ keypadsImported.length }}\n      <translate>keypads were successfully imported.</translate>\n    </div>\n\n    <div class="spacer">\n      <button ng-click="clear()" class="btn btn-default" translate>\n        Clear preview\n      </button>\n      <button ng-if="!csvImporting && keypadsWillBeImported > 0" ng-click="import()" class="btn btn-primary" translate>\n        Import {{ keypadsWillBeImported }} keypads\n      </button>\n    </div>\n    <div class="spacer">\n      <a ng-if="csvImported" ui-sref="openslides_voting.keypad.list" class="btn btn-default">\n        <i class="fa fa-angle-double-left fa-lg"></i>\n        <translate>Back to overview</translate>\n      </a>\n    </div>\n  </div>\n</div>\n');
$templateCache.put('static/templates/openslides_voting/keypad-list.html','<div class="header">\n  <div class="title">\n    <div class="submenu">\n      <div>\n        <a ui-sref="users.user.list" class="btn btn-sm btn-default">\n          <i class="fa fa-angle-double-left fa-lg"></i>\n          <translate>Back to overview</translate>\n        </a>\n        <a ng-click="openDialog()" class="btn btn-primary btn-sm">\n          <i class="fa fa-plus fa-lg"></i>\n          <translate>New</translate>\n        </a>\n        <a ui-sref="openslides_voting.keypad.import" class="btn btn-default btn-sm">\n          <i class="fa fa-download fa-lg"></i>\n          <translate>Import</translate>\n        </a>\n        <span ng-if="config(\'voting_enable_votecollector\')">\n          <a ng-if="!vc.is_voting || vc.voting_mode != \'ping\'" ng-click="startSystemTest()" class="btn btn-default btn-sm">\n            <i class="fa fa-cogs fa-lg"></i>\n            <translate>Start system test</translate>\n          </a>\n          <a ng-if="vc.is_voting && vc.voting_mode == \'ping\'" ng-click="stopSystemTest()" class="btn btn-danger btn-sm">\n            <i class="fa fa-cogs fa-lg"></i>\n            <translate>Stop system test</translate>\n          </a>\n        </span>\n      </div>\n      <div class="spacer">\n        <span class="small pull-right">{{ device }}</span>\n      </div>\n    </div>\n    <h1 translate>Keypads</h1>\n  </div>\n</div>\n\n<div class="details">\n  <div class="row">\n    <div class="col-sm-6">\n      <!-- Delete mode -->\n      <button class="btn"\n          ng-class="isDeleteMode ? \'btn-primary\' : \'btn-default\'"\n          ng-click="isDeleteMode = !isDeleteMode; uncheckAll()">\n        <i class="fa fa-check-square-o"></i>\n        <translate>Select ...</translate>\n      </button>\n    </div>\n    <!-- Search/filter -->\n    <div class="col-sm-6">\n      <div class="form-inline text-right">\n        <div class="form-group">\n          <div class="input-group">\n            <div class="input-group-addon"><i class="fa fa-search"></i></div>\n            <input type="text" ng-model="filter.filterString" class="form-control"\n                   ng-change="filter.save()"\n                   placeholder="{{ \'Search\' | translate}}">\n          </div>\n        </div>\n        <button class="btn btn-default" ng-click="isFilterOpen = !isFilterOpen"\n            ng-class="isFilterOpen ? \'btn-primary\' : \'btn-default\'">\n          <i class="fa fa-filter"></i>\n          <translate>Filter ...</translate>\n        </button>\n      </div>\n    </div>\n  </div>\n  <!-- Filter options -->\n  <div uib-collapse="!isFilterOpen" class="row spacer">\n    <div class="col-sm-6 text-right"></div>\n    <div class="col-sm-6 text-right form-inline">\n      <!-- User filter -->\n      <select ng-model="userFilter" class="form-control" id="userFilter">\n        <option value="" translate>--- Select keypad usage ---</option>\n        <option value="false" translate>anonymous</option>\n        <option value="true" translate>personalized</option>\n      </select>\n      <!-- Active filter -->\n      <select ng-model="activeFilter" class="form-control" id="activeFilter">\n        <option value="" translate>--- Select status ---</option>\n        <option value="true" translate>active</option>\n        <option value="false" translate>inactive</option>\n      </select>\n      <!-- TODO: Add in range and battery filter -->\n    </div>\n  </div>\n  <!-- Delete mode options -->\n  <div uib-collapse="!isDeleteMode" class="row spacer">\n    <div class="col-sm-12 text-left">\n      <!-- Delete button -->\n      <a ng-show="isDeleteMode"\n         ng-bootbox-confirm="{{ \'Are you sure you want to delete all selected keypads?\' | translate }}"\n         ng-bootbox-confirm-action="deleteMultiple()"\n         class="btn btn-primary">\n        <i class="fa fa-trash fa-lg"></i>\n        <translate>Delete selected keypads</translate>\n      </a>\n    </div>\n  </div>\n\n  <div class="spacer-top-lg italic">\n    <div ng-repeat="kp in keypadsFiltered = (keypads\n      | osFilter : filter.filterString : filter.getObjectQueryString\n      | filter : {active: activeFilter}\n      | filter : {identified: userFilter}\n      | orderBy : sort.column : sort.reverse)"></div>\n    {{ keypadsFiltered.length }} /\n    {{ keypads.length }} {{ "keypads" | translate }}<span ng-if="(keypads|filter:{selected:true}).length > 0">,\n    {{(keypads|filter:{selected:true}).length}} {{ "selected" | translate }}</span>\n  </div>\n\n  <table class="table table-striped table-bordered table-hover">\n    <thead>\n      <tr>\n        <!-- Delete selection column -->\n        <th ng-show="isDeleteMode" class="minimum deleteColumn">\n          <input type="checkbox" ng-model="$parent.selectedAll" ng-change="checkAll()">\n\n        <!-- Keypad number column -->\n        <th ng-click="sort.toggle(\'number\')" class="sortable">\n          <translate>Keypad</translate>\n          <i class="pull-right fa" ng-show="sort.column === \'number\'"\n              ng-class="sort.reverse ? \'fa-sort-desc\' : \'fa-sort-asc\'">\n          </i>\n\n        <!-- User column -->\n        <th ng-click="sort.toggle(\'user.full_name\')" class="sortable optional">\n          <translate>Participant</translate>\n          <i class="pull-right fa" ng-show="sort.column === \'user.full_name\'"\n              ng-class="sort.reverse ? \'fa-sort-desc\' : \'fa-sort-asc\'">\n          </i>\n\n        <!-- In range column -->\n        <!-- TODO: Make range column sortable. -->\n        <th>\n          <translate>In range</translate>\n\n        <!-- Battery column -->\n        <!-- TODO: Make battery column sortable. -->\n        <th>\n          <translate>Battery</translate>\n          <i class="fa fa-info-circle"\n            uib-tooltip="{{ \'Battery state is checked with each voting. Available states: full, medium, low, empty\' | translate }}"></i>\n\n    <tbody>\n      <tr ng-repeat="keypad in keypadsFiltered | limitTo:pagination.itemsPerPage:pagination.limitBegin"\n        class="animate-item"\n        ng-class="{\'selected\':keypad.selected}">\n\n        <!-- Delete selection -->\n        <td ng-show="isDeleteMode" class="deleteColumn">\n          <input type="checkbox" ng-model="keypad.selected">\n\n        <!-- Keypad number-->\n        <td ng-mouseover="keypad.hover=true" ng-mouseleave="keypad.hover=false">\n            <strong>{{ keypad.number }}</strong>\n            &nbsp; <span ng-if="!keypad.active" class="label label-warning"><translate>inactive</translate></span>\n            <div class="hoverActions" ng-class="{\'hiddenDiv\': !keypad.hover}">\n              <span>\n                <a href="" ng-click="openDialog(keypad)" translate>Edit</a> &middot;\n                <a href="" class="text-danger"\n                  ng-bootbox-confirm="{{ \'Are you sure you want to delete this entry?\' | translate }}<br>\n                  <b>{{ keypad.getTitle() }}</b>"\n                  ng-bootbox-confirm-action="delete(keypad)" translate>Delete</a>\n              </span>\n            </div>\n\n        <!-- User -->\n        <td class="optional">\n          <span ng-if="keypad.user">\n            <a href="" ui-sref="users.user.detail({id: keypad.user.id})">{{ keypad.user.full_name }}</a>\n          </span>\n          <span ng-if="!keypad.user"><i><translate>Anonymous</translate></i></span>\n\n        <!-- In range -->\n        <td>\n          <i ng-if="keypad.in_range" class="fa fa-check-square-o fa-lg" title="{{ \'Yes\' | translate }}" aria-hidden="true"></i>\n          <i ng-if="!keypad.in_range" class="fa fa-ban fa-lg text-danger" title="{{ \'No\' | translate }}" aria-hidden="true"></i>\n\n        <!-- Battery -->\n        <td>\n          <i class="fa fa-lg fa-battery-{{ keypad.powerCSSIcon() }} text-{{ keypad.powerCSSColor() }}"\n            title="{{ keypad.power() | translate }}" aria-hidden="true"></i>\n  </table>\n  <ul uib-pagination\n      ng-show="keypadsFiltered.length > pagination.itemsPerPage"\n      total-items="keypadsFiltered.length"\n      items-per-page="pagination.itemsPerPage"\n      ng-model="pagination.currentPage"\n      ng-change="pagination.pageChanged()"\n      class="pagination-sm"\n      direction-links="false"\n      boundary-links="true"\n      first-text="&laquo;"\n      last-text="&raquo;">\n  </ul>\n</div>\n');
$templateCache.put('static/templates/openslides_voting/motion-poll-detail.html','<ng-include src="\'static/templates/openslides_voting/submit-buttons-css.html\'"></ng-include>\n\n<div class="header">\n  <div class="title">\n    <div class="submenu">\n      <!-- Back to motion -->\n      <a ui-sref="motions.motion.detail({id: motion.id})" class="btn btn-sm btn-default">\n        <i class="fa fa-angle-double-left fa-lg"></i>\n        <translate>Back to motion</translate>\n      </a>\n      <!-- pdf -->\n      <a ng-click="pdfExport()" class="btn btn-default btn-sm">\n        <i class="fa fa-file-pdf-o fa-lg"></i>\n        PDF\n      </a>\n      <!-- Anonymize -->\n      <a os-perms="openslides_voting.can_manage"\n        class="btn btn-sm btn-default"\n        ng-bootbox-confirm="{{ \'Are you sure you want to anonymize all votes?\' | translate }}"\n        ng-bootbox-confirm-action="anonymizeVotes()">\n        <i class="fa fa-exclamation-triangle fa-lg"></i>\n        <translate>Anonymize votes</translate>\n      </a>\n    </div>\n    <h1>{{ motion.getTitle() }}</h1>\n    <h2><translate>Motion</translate> {{ motion.identifier }} &middot;\n      <translate>Voting result</translate></h2>\n  </div>\n</div>\n\n<div class="details">\n  <!-- Result table -->\n  <table class="table table-bordered" id="resultTable">\n    <!-- yes -->\n    <tr>\n      <td>\n        <button type="button" class="btn btn-default btn-voting-xs btn-yes">\n          <i class="fa fa-thumbs-o-up fa-2x"></i>\n        </button>\n        <translate>Yes</translate>\n      <td class="bold-left">\n        {{ poll.getVote(poll.yes, \'yes\').value | number:votesPrecision }}\n        {{ poll.getVote(poll.yes, \'yes\').percentStr }}\n    <!-- no -->\n    <tr>\n      <td>\n        <button type="button" class="btn btn-default btn-voting-xs btn-no">\n          <i class="fa fa-thumbs-o-down fa-2x"></i>\n        </button>\n        <strong translate>No</strong>\n      <td class="bold-left">\n        {{ poll.getVote(poll.no, \'no\').value | number:votesPrecision }}\n        {{ poll.getVote(poll.yes, \'no\').percentStr }}\n\n    <!-- abstain -->\n    <tr>\n      <td>\n        <button type="button" class="btn btn-default btn-voting-xs btn-abstain">\n          <i class="fa fa-circle-o fa-2x"></i>\n        </button>\n        <strong translate>Abstain</strong>\n      <td class="bold-left">\n        {{ poll.getVote(poll.abstain, \'abstain\').value | number:votesPrecision }}\n        {{ poll.getVote(poll.abstain, \'abstain\').percentStr }}\n\n    <!-- valid votes -->\n    <tr>\n      <td><strong translate>Valid votes</strong>\n      <td class="bold-left middle">\n        {{ poll.getVote(poll.votesvalid, \'votesvalid\').value | number:votesPrecision }}\n        {{ poll.getVote(poll.votesvalid, \'votesvalid\').percentStr }}\n  </table>\n\n  <!-- Single votes -->\n  <div class="row">\n    <div class="col-sm-6"><h3 translate>Single votes</h3></div>\n    <div class="col-sm-4 pull-right">\n      <!-- Search/filter -->\n      <input type="text" ng-model="filter.filterString" class="form-control"\n          ng-change="filter.save()"\n          placeholder="{{ \'Search\' | translate }}">\n    </div>\n  </div>\n\n  <div class="italic row">\n    <div class="col-md-6">\n      {{ ballotsFiltered.length }} / {{ ballots.length }} {{ "Single votes" | translate }}\n    </div>\n\n    <div class="col-md-6" ng-show="ballotsFiltered.length > pagination.itemsPerPage">\n      <span class="pull-right">\n        <a href="" class="pagination-arrow" ng-click="pagination.prevPage()"\n          ng-if="pagination.showPrevPageArrow()">\n          &laquo;\n        </a>\n        <translate>Page</translate> {{ pagination.currentPage }} /\n        {{ pagination.getPageCount(ballotsFiltered) }}\n        <a href="" class="pagination-arrow" ng-click="pagination.nextPage(ballotsFiltered)"\n          ng-if="pagination.showNextPageArrow(ballotsFiltered)">\n          &raquo;\n        </a>\n      </span>\n    </div>\n  </div>\n\n  <table class="table table-striped table-bordered table-hover">\n    <thead>\n      <tr>\n        <!-- Delegate column -->\n        <th ng-click="sort.toggle(\'user.full_name\')" class="sortable"\n          ng-if="pollType !== \'token_based_electronic\'">\n          <translate>Delegate</translate>\n          <i class="pull-right fa" ng-show="sort.column === \'user.full_name\'"\n              ng-class="sort.reverse ? \'fa-sort-desc\' : \'fa-sort-asc\'">\n          </i>\n        </th>\n\n        <!-- Voting device column -->\n        <th ng-click="sort.toggle(\'device\')" class="sortable"\n            ng-if="!pollType.indexOf(\'votecollector\')">\n          <translate>Keypad serial number</translate>\n          <i class="pull-right fa" ng-show="sort.column === \'device\'"\n              ng-class="sort.reverse ? \'fa-sort-desc\' : \'fa-sort-asc\'">\n          </i>\n          <i class="fa fa-info-circle"\n             uib-tooltip="{{ \'Press \\\'Fn+6\\\' on keypad to display the serial number.\' | translate}}"></i>\n        </th>\n\n        <!-- Result number column -->\n        <th ng-click="sort.toggle(\'result_token\')" class="sortable" ng-if="pollType === \'token_based_electronic\'">\n          <translate>Result number</translate>\n          <i class="pull-right fa" ng-show="sort.column === \'result_token\'"\n              ng-class="sort.reverse ? \'fa-sort-desc\' : \'fa-sort-asc\'">\n          </i>\n        </th>\n\n        <!-- Vote column -->\n        <th ng-click="sort.toggle(\'vote\')" class="sortable">\n          <translate>Casted vote</translate>\n          <i class="pull-right fa" ng-show="sort.column === \'vote\'"\n              ng-class="sort.reverse ? \'fa-sort-desc\' : \'fa-sort-asc\'">\n          </i>\n        </th>\n    </thead>\n\n    <tbody>\n      <tr ng-repeat="ballot in (ballotsFiltered = (ballots\n        | osFilter : filter.filterString : filter.getObjectQueryString\n        | orderBy : sort.column : sort.reverse)\n        | limitTo : pagination.itemsPerPage : pagination.limitBegin)"\n        class="animate-item" ng-class="{\'selected\':ballot.selected}">\n\n        <!-- Delegate -->\n        <td ng-if="pollType !== \'token_based_electronic\'">\n          <a href="" ng-if="ballot.user" ui-sref="users.user.detail({id: ballot.user.id})">\n            {{ ballot.user.full_name }}\n          </a>\n          <span ng-if="!ballot.user"><i><translate>Anonymous</translate></i></span>\n        </td>\n\n        <!-- Voting device -->\n        <td ng-if="!pollType.indexOf(\'votecollector\')">\n          {{ ballot.device }}\n        </td>\n\n        <!-- Result token-->\n        <td ng-if="pollType === \'token_based_electronic\'">\n          <span ng-if="ballot.result_token > 0">\n            {{ ballot.result_token }}\n          </span>\n          <span ng-if="ballot.result_token === 0" translate>\n            anonymous\n          </span>\n        </td>\n\n        <!-- Vote -->\n        <td>\n          <i class="fa fa-{{ ballot.getVoteIcon() }}"></i>\n          <span style="margin-left: 5px">{{ ballot.getVote() | translate }}</span>\n        </td>\n  </table>\n  <ul uib-pagination\n      ng-show="ballotsFiltered.length > pagination.itemsPerPage"\n      total-items="ballotsFiltered.length"\n      items-per-page="pagination.itemsPerPage"\n      ng-model="pagination.currentPage"\n      ng-change="pagination.pageChanged()"\n      class="pagination-sm"\n      direction-links="false"\n      boundary-links="true"\n      first-text="&laquo;"\n      last-text="&raquo;">\n  </ul>\n\n</div>\n');
$templateCache.put('static/templates/openslides_voting/motion-poll-form-buttons-hook.html','<div ng-controller="MotionPollFormVotingCtrl" ng-init="poll=$parent.$parent.model">\n  <div ng-if="!isAnalogPoll()" class="spacer-top-lg">\n    <button type="button"\n      ng-if="canStartVoting()" ng-click="startVoting()"\n      class="btn btn-default btn-sm">\n      <i class="fa fa-bullseye" aria-hidden="true"></i>\n      {{ \'Start voting\' | translate }}</button>\n    <button type="button"\n      ng-if="canStopVoting() && isThisPollActive()" ng-click="stopVoting()"\n      class="btn btn-primary btn-sm">\n      <i class="fa fa-spinner fa-lg fa-spin" aria-hidden="true"></i>\n      {{ \'Stop voting\' | translate }}</button>\n    <button type="button"\n      ng-if="canStopVoting() && !isThisPollActive()" ng-click="stopVoting()"\n      class="btn btn-danger btn-sm">\n      <i class="fa fa-bullseye" aria-hidden="true"></i>\n      {{ \'Stop another voting\' | translate }}</button>\n    <button type="button"\n      ng-if="canClearVotes()" ng-click="clearVotes()"\n      class="btn btn-default btn-sm">\n      <i class="fa fa-trash" aria-hidden="true"></i>\n      {{ \'Clear votes\' | translate }}</button>\n    <projector-button model="projectModel" default-projector-id="1"\n      content="Project result"></projector-button>\n    <p>{{ getVotingStatus() }}</p><br>\n  </div>\n</div>\n');
$templateCache.put('static/templates/openslides_voting/motion-poll-small-buttons-hook.html','<div os-perms="openslides_voting.can_manage">\n  <small>{{ pollType | translate }}</small>\n</div>\n<div os-perms="openslides_voting.can_manage">\n  <div ng-if="poll.has_votes && showSingleVotes">\n    <div class="spacer" ng-if="config(\'voting_enable_principles\')">\n      <button type="button" ng-click="countVotes()"\n        class="btn btn-xs btn-default">\n        <i class="fa fa-repeat" aria-hidden="true"></i>\n        {{ \'Recount votes\' | translate }}\n      </button>\n    </div>\n    <div class="spacer">\n      <a ui-sref="openslides_voting.motionPoll.detail({id: poll.id})" role="button"\n        class="btn btn-xs btn-default">\n        <i class="fa fa-table" aria-hidden="true"></i>\n        {{ \'Single votes\' | translate }}\n      </a>\n    </div>\n  </div>\n</div>\n');
$templateCache.put('static/templates/openslides_voting/motion-poll-voting-header-hook.html','<a ui-sref="submit_votes.motionPoll({id: getActivePoll()})"\n  ng-if="getActivePoll()"\n  class="btn btn-sm btn-sm" ng-class="getVoteForActivePoll() ? \'btn-default\' : \'btn-primary\'">\n  <span ng-if="!getVoteForActivePoll()">\n    <translate>Vote now!</translate>\n  </span>\n  <span ng-if="getVoteForActivePoll()">\n    <translate>You have already voted for</translate>\n    <strong>{{ getVoteForActivePoll() | translate }}</strong>\n  </span>\n</a>\n');
$templateCache.put('static/templates/openslides_voting/poll-create-form.html','<h1>\n  {{ obj.getTitle() }}\n</h1>\n\n<div uib-alert ng-show="alert.show" ng-class="\'alert-\' + alert.type" close="alert={}">\n  {{ alert.msg }}\n</div>\n\n<form name="pollCreateForm" ng-submit="select(model)">\n  <formly-form model="model" fields="formFields">\n    <button type="submit" ng-disabled="pollCreateForm.$invalid" class="btn btn-primary" translate>\n      OK\n    </button>\n    <button type="button" ng-click="closeThisDialog()" class="btn btn-default" translate>\n      Cancel\n    </button>\n  </formly-form>\n</form>\n');
$templateCache.put('static/templates/openslides_voting/principle-form.html','<h1 ng-if="model.id" translate>Edit voting principle</h1>\n<h1 ng-if="!model.id" translate>New voting principle</h1>\n\n<div uib-alert ng-show="alert.show" ng-class="\'alert-\' + (alert.type || \'warning\')" close="alert={}">\n  {{ alert.msg }}\n</div>\n\n<form name="principleForm" ng-submit="save(model)" novalidate>\n  <formly-form model="model" fields="formFields">\n    <button type="submit" ng-disabled="principleForm.$invalid" class="btn btn-primary" translate>\n      Save\n    </button>\n    <button type="button" ng-click="closeThisDialog()" class="btn btn-default" translate>\n      Cancel\n    </button>\n  </formly-form>\n</form>\n');
$templateCache.put('static/templates/openslides_voting/shares-import.html','<div class="header">\n  <div class="title">\n    <div class="submenu">\n      <a ui-sref="openslides_voting.shares.list" class="btn btn-sm btn-default">\n        <i class="fa fa-angle-double-left fa-lg"></i>\n        <translate>Back to overview</translate>\n      </a>\n    </div>\n    <h1 translate>Import voting shares</h1>\n  </div>\n</div>\n\n<div class="details">\n  <h3 translate>Select a CSV file</h3>\n  <csv-import change="onCsvChange(csv)" config="csvConfig"></csv-import>\n\n  <h4 translate>Please note:</h4>\n  <ul class="indentation">\n      <li><translate>Required comma or semicolon separated values with these column header names in the first row</translate>:<br>\n        <code>\n          <translate>Given name</translate>,\n          <translate>Surname</translate>,\n          <translate>Participant number</translate>,\n          <translate>Voting principle</translate> 1,\n          <translate>Voting principle</translate> 2\n        </code>\n      <li translate>You may provide as many voting principles as you like.\n      <li translate>Only double quotes are accepted as text delimiter (no single quotes).\n  </ul>\n\n  <div ng-if="delegateShares.length">\n    <h3 translate>Preview</h3>\n    <div class="scroll-x-container">\n      <table class="table table-striped table-bordered table-condensed">\n        <thead>\n          <tr>\n            <th>\n            <th>#\n            <th translate>Delegate\n            <th ng-repeat="p in principles">{{ p }}\n        <tbody>\n          <tr ng-repeat="delegateShare in delegateShares | limitTo:pagination.itemsPerPage:pagination.limitBegin">\n            <td class="minimum"\n                ng-class="{ \'text-danger\': delegateShare.importerror, \'text-success\': delegateShare.imported }">\n              <span ng-if="delegateShare.importerror">\n                <i class="fa fa-exclamation-triangle fa-lg"></i>\n              </span>\n                <span ng-if="!delegateShare.importerror && !delegateShare.imported" class="pointer">\n                  <i class="fa fa-check-circle-o fa-lg" ng-if="delegateShare.selected" ng-click="delegateShare.selected=false; calcStats();"></i>\n                  <i class="fa fa-circle-o fa-lg" ng-if="!delegateShare.selected" ng-click="delegateShare.selected=true; calcStats();"></i>\n                </span>\n              <span ng-if="delegateShare.imported">\n                <i class="fa fa-check-circle fa-lg"></i>\n              </span>\n            <td class="nobr">\n              {{ (pagination.currentPage - 1) * pagination.itemsPerPage + $index + 1 }}\n            <td ng-class="{ \'text-danger\': delegateShare.error.user }">\n              <span ng-if="delegateShare.error.user" title="{{ delegateShare.error.user | translate }}">\n                <i class="fa fa-exclamation-triangle"></i>\n              </span>\n              {{ delegateShare.fullname }}\n            <td ng-repeat="p in principles"\n                ng-class="{ \'text-danger\': delegateShare.error[p] }">\n              <span ng-if="delegateShare.error[p]" title="{{ delegateShare.error[p] | translate }}">\n                <i class="fa fa-exclamation-triangle"></i>\n              </span>\n              {{ delegateShare[p] }}\n      </table>\n    </div>\n    <ul uib-pagination\n        ng-show="delegateShares.length > pagination.itemsPerPage"\n        total-items="delegateShares.length"\n        items-per-page="pagination.itemsPerPage"\n        ng-model="pagination.currentPage"\n        ng-change="pagination.pageChanged()"\n        class="pagination-sm"\n        direction-links="false"\n        boundary-links="true"\n        first-text="&laquo;"\n        last-text="&raquo;">\n    </ul>\n\n    <div class="text-danger">\n      <i class="fa fa-exclamation-triangle"></i>\n      {{ sharesWillNotBeImported }}\n      <translate>voting shares will not be imported.</translate>\n    </div>\n    <div>\n      <i class="fa fa-check-circle-o fa-lg"></i>\n      {{ sharesWillBeImported }}\n      <translate>voting shares will be imported.</translate>\n    </div>\n    <div ng-repeat="share in delegateSharesImported = (delegateShares | filter:{imported:true})"></div>\n    <div ng-if="delegateSharesImported.length" class="text-success">\n      <hr class="smallhr">\n      <i class="fa fa-check-circle fa-lg"></i>\n      {{ delegateSharesImported.length }}\n      <translate>voting shares were successfully imported.</translate>\n    </div>\n\n    <div class="spacer">\n      <button ng-click="clear()" class="btn btn-default" translate>\n        Clear preview\n      </button>\n      <button ng-if="!csvImporting && sharesWillBeImported > 0" ng-click="import()" class="btn btn-primary" translate>\n        Import {{ sharesWillBeImported }} voting shares\n      </button>\n    </div>\n    <div class="spacer">\n      <a ng-if="csvImported" ui-sref="openslides_voting.shares.list" class="btn btn-default">\n        <i class="fa fa-angle-double-left fa-lg"></i>\n        <translate>Back to overview</translate>\n      </a>\n    </div>\n  </div>\n</div>\n');
$templateCache.put('static/templates/openslides_voting/shares-list.html','<div class="header">\n  <div class="title">\n    <div class="submenu">\n      <a ui-sref="users.user.list" class="btn btn-sm btn-default">\n        <i class="fa fa-angle-double-left fa-lg"></i>\n        <translate>Back to overview</translate>\n      </a>\n        <a ng-click="openDialog()" class="btn btn-primary btn-sm">\n          <i class="fa fa-plus fa-lg"></i>\n          <translate>New</translate>\n        </a>\n      <a ui-sref="openslides_voting.shares.import" class="btn btn-default btn-sm">\n        <i class="fa fa-download fa-lg"></i>\n        <translate>Import voting shares</translate>\n      </a>\n    </div>\n    <h1 translate>Voting shares</h1>\n  </div>\n</div>\n\n<div class="details">\n  <div class="row">\n    <div class="col-sm-12">\n      <div class="form-inline text-right">\n        <div class="form-group">\n          <div class="input-group">\n            <div class="input-group-addon"><i class="fa fa-search"></i></div>\n            <input type="text" ng-model="search" class="form-control"\n               placeholder="{{ \'Search\' | translate}}">\n          </div>\n        </div>\n      </div>\n    </div>\n  </div>\n\n  <div class="italic">\n    {{ delegatesFiltered.length }} / {{ delegates.length }} {{ "Voting shares" | translate }}\n  </div>\n\n  <table class="table table-bordered">\n    <thead>\n      <tr>\n        <th>\n          <strong translate>\n            Delegates\n          </strong>\n        </th>\n        <th ng-repeat="principle in principles"\n          ng-mouseover="principle.headhover=true" ng-mouseleave="principle.headhover=false">\n          <div>\n            <a href="" ng-click="openDialog(principle)">\n              {{ principle.name }}\n            </a>\n          </div>\n          <div>\n            <small style="color: #555;">\n              {{ principle.decimal_places }}\n              <translate>places</translate>\n            </small>\n            <span class="pull-right pointer" ng-if="principle.headhover"\n              ng-bootbox-confirm="{{ \'Are you sure you want to delete this principle?\' | translate }}<br>\n              <b>{{ principle.name | translate }}</b>"\n              ng-bootbox-confirm-action="delete(principle)">\n\n              <i class="fa fa-trash text-danger"></i>\n            </span>\n          </div>\n        </th>\n      </tr>\n    </thead>\n    <tbody>\n      <tr ng-repeat="delegate in delegatesFiltered = (delegates\n        | filter: {full_name: search}\n        | orderBy: \'full_name\')\n        | limitTo: pagination.itemsPerPage : pagination.limitBegin"\n        ng-mouseover="delegate.hover=true" ng-mouseleave="delegate.hover=false">\n        <td>\n          {{ delegate.full_name }}\n        </td>\n        <td ng-repeat="principle in principles"\n          ng-mouseover="principle.hover=true" ng-mouseleave="principle.hover=false">\n\n          <div ng-style="{\'visibility\': (getShare(delegate, principle) || (delegate.hover && principle.hover)) ? \'visible\' : \'hidden\'}">\n            <div class="popover-wrapper">\n              <span editable-text="newShares[delegate.id][principle.id]"\n                onaftersave="saveShare(newShares[delegate.id][principle.id], delegate, principle)">\n                <small ng-if="!getShare(delegate, principle)" translate>Set share ...</small>\n                <span ng-if="getShare(delegate, principle)">\n                  {{ getShare(delegate, principle).shares | number: principle.decimal_places }}\n                </span>\n              </span>\n            </div>\n          </div>\n\n        </td>\n      </tr>\n    </tbody>\n  </table>\n  <ul uib-pagination\n      ng-show="delegatesFiltered.length > pagination.itemsPerPage"\n      total-items="delegatesFiltered.length"\n      items-per-page="pagination.itemsPerPage"\n      ng-model="pagination.currentPage"\n      ng-change="pagination.pageChanged()"\n      class="pagination-sm"\n      direction-links="false"\n      boundary-links="true"\n      first-text="&laquo;"\n      last-text="&raquo;">\n  </ul>\n</div>\n');
$templateCache.put('static/templates/openslides_voting/slide_assignment_poll.html','<div ng-controller="SlideAssignmentPollCtrl" class="content scrollcontent">\n  <ng-include src="\'static/templates/openslides_voting/submit-buttons-css.html\'"></ng-include>\n\n  <style type="text/css">\n    #resultTable {\n      font-size: 150%;\n      line-height: 40px;\n      margin: 0 20px 0 0;\n      width: auto;\n    }\n    .width100  {\n      width: 100% !important;\n    }\n    #resultTable td {\n      padding: 9px;\n    }\n    #resultTable td.bold {\n      font-weight: bold;\n      text-align: right;\n    }\n    #resultTable td.vote {\n      min-width: 30px;\n    }\n    #resultTable td.chart {\n      width: 200px;\n    }\n    #resultTable td.percentage {\n        font-weight: normal;\n        font-size: 70%;\n        min-width: 80px;\n    }\n    #resultTable .key {\n      width: 45px;\n      height: 45px;\n      -webkit-border-radius: 7px;\n      -moz-border-radius: 7px;\n      border-radius: 7px;\n      background-color:#100A4A;\n      color: white;\n      font-weight: bold;\n      font-size: 1.2em;\n      display: inline-block;\n      text-align: center;\n    }\n\n    #delegateBoard table {\n        border-collapse: separate;\n        border-spacing: 5px;\n        border: none;\n        width: 100%;\n    }\n    #delegateBoard table td {\n        background-color: #ffffff;\n        padding: 0 2px;\n        font-size: 0.75em;\n        border: none;\n        height: 50px;\n    }\n    #delegateBoard table td.label {\n        font-weight: bold;\n        color: #000000;\n        white-space: nowrap;\n        width: auto;\n        padding-top: 10px;\n        margin-right: 0;\n    }\n    #delegateBoard table td.seat {\n        border: 1px solid black;\n        line-height: 120%;\n        text-align: center;\n    }\n    #delegateBoard table td.seat-N {\n        background-color: #d9534f;\n    }\n    #delegateBoard table td.seat-Y {\n        background-color: #5cb85c;\n    }\n    #delegateBoard table td.seat-A {\n        background-color: #f1d300;\n    }\n    #delegateBoard table td.seat-anonymous {\n        background-color: #999;\n    }\n    #delegateBoard table td.seat-invalid {\n        background-color: #fe9a9a;\n    }\n    #delegateBoard table td.seat-voted {\n        background-color: #92b8de;\n    }\n    #delegateBoard table td span.key {\n        font-weight: bold;\n        -webkit-border-radius: 5px;\n        -moz-border-radius: 5px;\n        border-radius: 5px;\n        background-color: #100A4A;\n        color: white;\n        font-size: 140%;\n        float: right;\n        text-align: center;\n        padding: 5px;\n        margin-top: 1px;\n    }\n  </style>\n\n  <!-- Title -->\n  <div id="title">\n    <h1>{{ assignment.agenda_item.getTitle() }}</h1>\n    <h2>\n      <span ng-if="poll.has_votes && poll.options.length == 1">\n        {{ poll.options[0].candidate.full_name }}\n      </span>\n      <span ng-if="poll.has_votes && poll.options.length > 1" translate>\n        Election result\n      </span>\n      <span ng-if="!poll.has_votes && poll.options.length > 1" translate>\n        Election\n      </span>\n    </h2>\n  </div>\n\n  <!-- Result table for Yes/No/Abstain (for one candidate only! = same as motion poll result table) -->\n  <table ng-if="poll.has_votes && poll.options.length == 1" class="well pull-left" id="resultTable">\n    <tbody ng-init="option = poll.options[0]">\n    <!-- yes -->\n    <tr>\n      <td>\n        <button type="button" class="btn btn-default btn-voting-md btn-yes">\n          <i class="fa fa-thumbs-o-up fa-2x"></i>\n        </button>\n        <strong translate>Yes</strong>\n      <td class="bold">{{ option.getVotes()[0].value | number:votesPrecision }}\n      <td class="bold nobr">\n        <div ng-if="option.getVotes()[0].percentNumber">\n          {{ option.getVotes()[0].percentStr || \'&nbsp;\' }}\n        </div>\n      <td class="chart">\n        <div ng-if="option.getVotes()[0].percentNumber">\n          <uib-progressbar value="option.getVotes()[0].percentNumber" type="success"></uib-progressbar>\n        </div>\n\n    <!-- no -->\n    <tr>\n      <td>\n        <button type="button" class="btn btn-default btn-voting-md btn-no">\n          <i class="fa fa-thumbs-o-down fa-2x"></i>\n        </button>\n        <strong translate>No</strong>\n      <td class="bold">{{ option.getVotes()[1].value | number:votesPrecision }}\n      <td class="bold nobr">\n        <div ng-if="option.getVotes()[1].percentNumber">\n          {{ option.getVotes()[1].percentStr || \'&nbsp;\' }}\n        </div>\n      <td class="chart">\n        <div ng-if="option.getVotes()[1].percentNumber">\n          <uib-progressbar value="option.getVotes()[1].percentNumber" type="danger"></uib-progressbar>\n        </div>\n\n    <!-- abstain -->\n    <tr ng-if="poll.pollmethod === \'yna\'">\n      <td>\n        <button type="button" class="btn btn-default btn-voting-md btn-abstain">\n          <i class="fa fa-circle-o fa-2x"></i>\n        </button>\n        <strong translate>Abstain</strong>\n      <td class="bold">{{ option.getVotes()[2].value | number:votesPrecision }}\n      <td class="bold nobr">\n        <div ng-if="option.getVotes()[2].percentNumber">\n          {{ option.getVotes()[2].percentStr || \'&nbsp;\' }}\n        </div>\n      <td class="chart">\n        <div ng-if="option.getVotes()[2].percentNumber">\n          <uib-progressbar value="option.getVotes()[2].percentNumber" type="warning"></uib-progressbar>\n        </div>\n\n    <!-- valid votes -->\n    <tr class="total">\n      <td><strong translate>Valid votes</strong>\n      <td class="bold">{{ poll.votesvalid }}\n      <td class="bold">{{ poll.getVote(\'votesvalid\').percentStr }}\n\n      <td>\n    </tbody>\n  </table>\n\n\n  <!-- Result table for Yes/No/Abstain (>1 candidates), with votecollector not possible -->\n  <table ng-if="(poll.pollmethod === \'yna\' || poll.pollmethod ===\n\'yn\') && poll.has_votes && poll.options.length > 1"\n         class="well pull-left width100" id="resultTable">\n    <thead>\n      <td>\n      <td colspan="2" class="nobr">\n        <button type="button" class="btn btn-default btn-voting-sm no-margin btn-yes">\n          <i class="fa fa-thumbs-o-up fa-2x"></i>\n        </button>\n        <translate>Yes</translate>\n      <td colspan="2" class="nobr">\n        <button type="button" class="btn btn-default btn-voting-sm no-margin btn-no">\n          <i class="fa fa-thumbs-o-down fa-2x"></i>\n        </button>\n        <translate>No</translate>\n      <td ng-if="poll.pollmethod === \'yna\'" colspan="2" class="nobr">\n        <button type="button" class="btn btn-default btn-voting-sm no-margin btn-abstain">\n          <i class="fa fa-circle-o fa-2x"></i>\n        </button>\n        <translate>Abstain</translate>\n    </thead>\n    <tr ng-repeat="option in poll.options">\n      <td>{{ option.candidate.short_name }}<br>\n\n      <!-- yes -->\n      <td class="bold">{{ option.getVotes()[0].value }}\n      <td class="bold-left no-left-padding nobr">\n        <div ng-if="option.getVotes()[0].percentNumber">\n          <span>{{ option.getVotes()[0].percentStr || \'&nbsp;\' }}</span>\n        </div>\n      <!-- no -->\n      <td class="bold">{{ option.getVotes()[1].value }}\n      <td class="bold-left no-left-padding nobr">\n        <div ng-if="option.getVotes()[1].percentNumber">\n          <span>{{ option.getVotes()[1].percentStr || \'&nbsp;\' }}</span>\n        </div>\n      <!-- abstain -->\n      <td ng-if="poll.pollmethod === \'yna\'" class="bold">{{ option.getVotes()[2].value }}\n      <td ng-if="poll.pollmethod === \'yna\'" class="bold-left no-left-padding nobr">\n        <div ng-if="option.getVotes()[2].percentNumber">\n          <span>{{ option.getVotes()[2].percentStr || \'&nbsp;\' }}</span>\n        </div>\n\n    <!-- valid votes -->\n    <tr class="total">\n      <td translate>Valid votes\n      <td class="bold-left" colspan="2">{{ poll.votesvalid | number:votesPrecision }}\n      {{ poll.votesvalid | number:votesPrecision }}\n      <td>\n      <td>\n      <td ng-if="poll.pollmethod === \'yna\'">\n      <td ng-if="poll.pollmethod === \'yna\'">\n  </table>\n\n  <!-- Result table for yes votes (1..n candidates) -->\n  <div ng-if="poll.pollmethod == \'votes\' && poll.has_votes">\n    <!-- total votes -->\n    <table class="well table-striped width100" id="resultTable">\n      <tr ng-repeat="option in poll.options" ng-init="votes = option.getVotes()">\n\n        <!-- candidate name -->\n        <td>\n          <!-- keypad key -->\n          <span ng-if="showKey" class="key">{{ $index + 1 }} </span>\n          <i ng-if="option.is_elected" class="fa fa-star"></i>\n          <strong>{{ option.candidate.short_name }}</strong>\n\n        <!-- votes -->\n        <td class="bold">{{votes[0].value | number:votesPrecision}}\n        <td class="bold-left">{{votes[0].percentStr}}\n        <td class="chart">\n          <uib-progressbar ng-if="votes[0].percentNumber" value="votes[0].percentNumber" type="success"></uib-progressbar>\n\n      <!-- abstain -->\n      <tr ng-if="poll.pollmethod === \'votes\'">\n        <td translate>Abstain\n        <td class="text-right">{{ poll.votesabstain | number:votesPrecision }}\n        <td>{{ poll.getVote(\'votesabstain\').percentStr }}\n        <td>\n\n      <!-- no -->\n      <tr  ng-if="poll.pollmethod === \'votes\'">\n        <td translate>No\n        <td class="text-right">{{ poll.votesno | number:votesPrecision }}\n        <td>{{ poll.getVote(\'votesno\').percentStr }}\n        <td>\n\n      <!-- valid votes -->\n      <tr class="total">\n        <td><strong translate>Valid votes</strong>\n        <td class="bold">{{ poll.votesvalid | number:votesPrecision }}\n        <td class="bold-left">{{ poll.getVote(\'votesvalid\').percentStr }}\n        <td>\n\n      <!-- invalid votes -->\n      <tr>\n        <td><translate>Invalid votes</translate>\n        <td class="text-right">{{ poll.votesinvalid | number:votesPrecision }}\n        <td>{{ poll.getVote(\'votesinvalid\').percentStr }}\n        <td>\n\n      </table>\n  </div>\n\n  <!-- Delegate board -->\n  <div id="delegateBoard" ng-if="!poll.has_votes" ng-bind-html="delegateBoardHtml | trusted"></div>\n</div>\n');
$templateCache.put('static/templates/openslides_voting/slide_icon.html','<div ng-controller="SlideIconCtrl">\n\n  <style type="text/css">\n    #voting_slide_icon {\n        font-size: 1.25em;\n        position: fixed;\n        top: 25px;\n        right: 20px;\n        z-index: 100;\n        color: {{ config(\'projector_header_fontcolor\') }};\n    }\n  </style>\n\n  <i id="voting_slide_icon" class="fa fa-microphone"></i>\n</div>\n');
$templateCache.put('static/templates/openslides_voting/slide_motion_poll.html','<div ng-controller="SlideMotionPollCtrl" class="content scrollcontent">\n  <ng-include src="\'static/templates/openslides_voting/submit-buttons-css.html\'"></ng-include>\n\n  <style type="text/css">\n    #resultTable {\n      font-size: 150%;\n      line-height: 40px;\n      margin: 0 20px 0 0;\n      font-weight: bold;\n      width: auto;\n    }\n    #resultTable img {\n      width: auto;\n    }\n    #resultTable td {\n      padding: 9px;\n    }\n    #resultTable td.bold {\n      font-weight: bold;\n      text-align: right;\n    }\n    #resultTable td.vote {\n      min-width: 30px;\n    }\n    #resultTable td.chart {\n      min-width: 200px;\n    }\n\n    #delegateBoard table {\n        border-collapse: separate;\n        border-spacing: 5px;\n        border: none;\n        width: 100%;\n    }\n    #delegateBoard table td {\n        background-color: #ffffff;\n        padding: 0 2px;\n        font-size: 0.75em;\n        border: none;\n        height: 50px;\n    }\n    #delegateBoard table td.seat {\n        border: 1px solid black;\n        line-height: 120%;\n        text-align: center;\n    }\n    #delegateBoard table td.seat-N {\n        background-color: #ff201c;\n    }\n    #delegateBoard table td.seat-Y {\n        background-color: #008f2a;\n    }\n    #delegateBoard table td.seat-A {\n        background-color: #f1d300;\n    }\n    #delegateBoard table td.seat-anonymous {\n        background-color: #999;\n    }\n  </style>\n\n  <!-- Title -->\n  <div id="title">\n    <h1>{{ motion.getTitle() }}</h1>\n    <h2>\n      <span><translate>Motion</translate> {{ motion.identifier }} </span>\n      <span ng-if="poll.has_votes"> | <translate>Voting result</translate></span>\n    </h2>\n  </div>\n\n  <!-- Result table -->\n  <table ng-if="poll.has_votes" class="well pull-left" id="resultTable">\n    <!-- yes -->\n    <tr>\n      <td>\n        <button type="button" class="btn btn-default btn-voting-md btn-yes">\n          <i class="fa fa-thumbs-o-up fa-2x"></i>\n        </button>\n        <translate>Yes</translate>\n      <td class="bold">{{ poll.yes | number:votesPrecision }}\n      <td class="bold nobr">\n        <div ng-if="poll.getVote(poll.yes, \'yes\').percentNumber">\n          {{ poll.getVote(poll.yes, \'yes\').percentStr || \'&nbsp;\' }}\n        </div>\n      <td class="chart">\n        <div ng-if="poll.getVote(poll.yes, \'yes\').percentNumber">\n          <uib-progressbar value="poll.getVote(poll.yes, \'yes\').percentNumber" type="success"></uib-progressbar>\n        </div>\n\n    <!-- no -->\n    <tr>\n      <td>\n        <button type="button" class="btn btn-default btn-voting-md btn-no">\n          <i class="fa fa-thumbs-o-down fa-2x"></i>\n        </button>\n        <translate>No</translate>\n      <td class="bold">{{ poll.no | number:votesPrecision }}\n      <td class="bold nobr">\n        <div ng-if="poll.getVote(poll.no, \'no\').percentNumber">\n          {{ poll.getVote(poll.no, \'no\').percentStr || \'&nbsp;\' }}\n        </div>\n      <td class="chart">\n        <div ng-if="poll.getVote(poll.no, \'no\').percentNumber">\n          <uib-progressbar value="poll.getVote(poll.no, \'no\').percentNumber" type="danger"></uib-progressbar>\n        </div>\n\n    <!-- abstain -->\n    <tr>\n      <td>\n        <button type="button" class="btn btn-default btn-voting-md btn-abstain">\n          <i class="fa fa-circle-o fa-2x"></i>\n        </button>\n        <translate>Abstain</translate>\n      <td class="bold">{{ poll.abstain | number:votesPrecision }}\n      <td class="bold">\n        <div ng-if="poll.getVote(poll.abstain, \'abstain\').percentNumber">\n          {{ poll.getVote(poll.abstain, \'abstain\').percentStr || \'&nbsp;\'}}\n        </div>\n      <td class="chart">\n        <div ng-if="poll.getVote(poll.abstain, \'abstain\').percentNumber">\n          <uib-progressbar value="poll.getVote(poll.abstain, \'abstain\').percentNumber" type="warning"></uib-progressbar>\n        </div>\n\n    <!-- valid votes -->\n    <tr class="total">\n      <td><translate>Valid votes</translate>\n      <td class="bold">{{ poll.votesvalid | number:votesPrecision }}\n      <td> {{ poll.getVote(poll.votesvalid, \'votesvalid\').percentStr }}\n      <td>\n  </table>\n\n  <!-- Delegate board -->\n  <div id="delegateBoard" ng-if="!poll.has_votes" ng-bind-html="delegateBoardHtml | trusted"></div>\n</div>\n');
$templateCache.put('static/templates/openslides_voting/slide_prompt.html','<div ng-controller="SlidePromptCtrl">\n  <ng-include src="\'static/templates/openslides_voting/submit-buttons-css.html\'"></ng-include>\n\n  <style type="text/css">\n    #voting_slide_message {\n        border-radius: 0 0 0.2em 0.2em;\n        font-size: 1.5em;\n        font-weight: bold;\n        text-align: center;\n        position: fixed;\n        padding: 0 0 5px 0;\n        margin: 0;\n        top: 0;\n        right: 50px;\n        left: 50px;\n        min-height: 70px;  /* to cover up header */\n        line-height: 160%;\n        opacity: 0.95;\n        z-index: 100;\n    }\n    #voting_slide_message img {\n        width: 50px;\n    }\n    #voting_slide_message .candidate {\n      font-weight: normal;\n    }\n    #voting_slide_message .key {\n      width: 45px;\n      height: 45px;\n      margin-right: 12px;\n      -webkit-border-radius: 7px;\n      -moz-border-radius: 7px;\n      border-radius: 7px;\n      background-color:#100A4A;\n      color: white;\n      font-weight: bold;\n      font-size: 1.2em;\n      display: inline-block;\n      text-align: center;\n    }\n    #voting_slide_message .columns {\n      text-align: left;\n      list-style: none;\n      columns: 2;\n      -webkit-columns: 2;\n      -moz-columns: 2;\n    }\n  </style>\n\n  <div id="voting_slide_message" class="well" ng-bind-html="message | trusted"></div>\n</div>\n');
$templateCache.put('static/templates/openslides_voting/submit-assignment-poll-buttons.html','<ng-include src="\'static/templates/openslides_voting/submit-buttons-css.html\'"></ng-include>\n<!-- YN or YNA election -->\n<div ng-if="poll.pollmethod !== \'votes\'">\n<table class="table table-striped table-bordered">\n  <tbody>\n    <tr ng-repeat="option in poll.options | orderBy: \'weight\'">\n      <td class="candidatename"><strong>{{ option.candidate.short_name }}</strong><br>\n        <span class="grey">\n          {{ option.candidate.structure_level }}\n          <span ng-if="option.candidate.structure_level && option.candidate.number">\n            &middot;\n          </span>\n          <span ng-if="option.candidate.number">\n            <translate>No.</translate> {{ option.candidate.number }}\n          </span>\n        </span>\n      </td>\n      <td ng-click="votes[option.candidate.id] = \'Y\'" class="vote-column">\n          <button type="button" class="btn btn-default btn-voting"\n            ng-class="votes[option.candidate.id] == \'Y\' ? \'btn-yes\' : \'btn-gray\'">\n            <i class="fa fa-thumbs-o-up fa-2x"></i>\n          </button>\n          <translate>Yes</translate>\n      </td>\n      <td ng-click="votes[option.candidate.id] = \'N\'" class="vote-column">\n          <button type="button" class="btn btn-default btn-voting"\n            ng-class="votes[option.candidate.id] == \'N\' ? \'btn-no\' : \'btn-gray\'">\n            <i class="fa fa-thumbs-o-down fa-2x"></i>\n          </button>\n          <translate>No</translate>\n      </td>\n      <td ng-click="votes[option.candidate.id] = \'A\'" class="vote-column"\n        ng-if="poll.pollmethod === \'yna\'">\n          <button type="button" class="btn btn-default btn-voting"\n            ng-class="votes[option.candidate.id] == \'A\' ? \'btn-abstain\' : \'btn-gray\'">\n            <i class="fa fa-circle-o fa-2x"></i>\n          </button>\n          <translate>Abstain</translate>\n      </td>\n    </tr>\n  </tbody>\n</table>\n<div class="spacer-top-lg bold" ng-if="poll.options.length === 1">\n  <translate>Your current choice:</translate>\n  <span ng-if="votes[candidatesSelected()[0]] === \'Y\'" translate>\n    Yes\n  </span>\n  <span ng-if="votes[candidatesSelected()[0]] === \'N\'" translate>\n    No\n  </span>\n  <span ng-if="votes[candidatesSelected()[0]] === \'A\'" translate>\n    Abstain\n  </span>\n</div>\n</div>\n\n<!-- Y election -->\n<div ng-if="poll.pollmethod === \'votes\'">\n  <table class="table table-striped table-bordered">\n    <tbody>\n      <tr ng-repeat="options in optionsForTable">\n        <td class="pointer more-space-here" ng-repeat="option in options" ng-click="clickCandidate(option.index + 1)"\n            ng-class="{\'col-md-6\': columns === 2}">\n          <button type="button" class="btn btn-default btn-voting pull-left"\n            ng-class="votes[(option.index + 1)] ? \'btn-yes\' : \'btn-gray\'">\n            <i class="fa fa-thumbs-o-up fa-2x"></i>\n          </button>\n          <strong>{{ option.candidate.short_name }}</strong><br>\n          <span class="grey">\n            {{ option.candidate.structure_level }}\n            <span ng-if="option.candidate.structure_level && option.candidate.number">\n              &middot;\n            </span>\n            <span ng-if="option.candidate.number">\n              <translate>No.</translate>{{ option.candidate.number }}\n            </span>\n          </span>\n        </td>\n\n        <td ng-if="columns === 2 && options.length === 1" class="empty-column"></td>\n      </tr>\n    </tbody>\n  </table>\n  <button type="button" class="btn btn-default btn-voting spacer-left" ng-click="clickNo()"\n    ng-class="votes.no ? \'btn-no\' : \'btn-gray\'">\n    <i class="fa fa-thumbs-o-down fa-2x"></i>\n  </button>\n  <translate>No</translate>\n  <button type="button" class="btn btn-default btn-voting spacer-left-lg" ng-click="clickAbstain()"\n    ng-class="votes.abstain ? \'btn-abstain\' : \'btn-gray\'">\n    <i class="fa fa-circle-o fa-2x"></i>\n  </button>\n  <translate>Abstain</translate>\n\n  <div class="spacer-top-lg bold">\n    <translate>Your current choice:</translate>\n    <span ng-if="candidatesSelected().length == 1">\n      {{ poll.options[candidatesSelected()[0]-1].candidate.short_name }}\n    </span>\n    <span ng-if="candidatesSelected().length > 1">\n      {{ candidatesSelected().length }} / {{ poll.assignment.open_posts }} <translate>candidates</translate>\n    </span>\n    <span ng-if="votes.no">\n      <translate>No</translate>\n    </span>\n    <span ng-if="votes.abstain">\n      <translate>Abstain</translate>\n    </span>\n    <span ng-if="!somethingSelected()">&mdash;</span>\n  </div>\n</div>\n');
$templateCache.put('static/templates/openslides_voting/submit-assignment-poll.html','<div class="header tokenvoting">\n  <div class="title">\n    <div class="submenu">\n      <a href="javascript:history.back()" class="btn btn-sm btn-default">\n        <i class="fa fa-angle-double-left fa-lg"></i>\n        <translate>Back</translate>\n      </a>\n    </div>\n    <h1>\n      {{ poll.assignment.getTitle() }}\n    </h1>\n    <div class="row" ng-if="apb">\n      <div class="col-sm-12">\n        <strong>\n          <translate>You have already voted for</translate>\n        </strong>\n        <div>\n          <div ng-repeat="option in poll.options | orderBy: \'weight\'"\n            ng-if="poll.pollmethod !== \'votes\'">\n            {{ option.candidate.full_name }}:\n            <span ng-if="apb.vote[option.candidate.id] === \'Y\'" translate>\n              Yes\n            </span>\n            <span ng-if="apb.vote[option.candidate.id] === \'N\'" translate>\n              No\n            </span>\n            <span ng-if="apb.vote[option.candidate.id] === \'A\'" translate>\n              Abstain\n            </span>\n          </div>\n          <strong ng-if="poll.pollmethod === \'votes\'">\n            {{ getUsersVotedFor() }}\n          </strong>\n        </div>\n      </div>\n    </div>\n  </div>\n</div>\n\n<div class="details">\n  <div uib-alert ng-show="alert.show" ng-class="\'alert-\' + (alert.type || \'warning\')" close="alert={}">\n    {{ alert.msg }}\n  </div>\n  <ng-include src="\'static/templates/openslides_voting/submit-assignment-poll-buttons.html\'"></ng-include>\n  <button type="button" class="btn btn-primary spacer-top" ng-click="vote()"\n    ng-disabled="!canSubmitAssignmentPoll()" translate>\n    Submit\n  </button>\n</div>\n');
$templateCache.put('static/templates/openslides_voting/submit-buttons-css.html','<style type="text/css">\n    .spacer-left {\n        margin-left: 20px;\n    }\n    .spacer-left-lg {\n        margin-left: 80px;\n    }\n    .vote-column {\n        width: 20%;\n        white-space: nowrap;\n    }\n    .candidatename {\n        vertical-align: middle !important;\n    }\n    .empty-column {\n        width: 10px;\n        background-color: #fff !important;\n        border: 0px solid #fff !important;\n    }\n    .table > tbody > tr > td.more-space-here {\n        padding: 20px;\n    }\n    #resultTable {\n        width: auto;\n    }\n    #resultTable td {\n        vertical-align: middle;\n    }\n    #resultTable td.chart .progress{\n        height: 30px;\n        margin-bottom: 3px;\n    }\n    .total {\n        border-top: 2px solid #d3d3d3;\n    }\n    .total td {\n        background-color: #e3e3e3\n    }\n    .votingoption, .votingoptions {\n        font-size: 22px;\n    }\n    .bold-left {\n      font-weight: bold;\n    }\n    .no-margin {\n      margin-right: 0 !important;\n    }\n    .no-left-padding {\n      padding-left: 0 !important;\n    }\n    .btn-voting, .btn-voting:hover, .btn-voting:focus, .btn-voting:active, .btn-voting:active:focus {\n      width: 75px;\n      height: 75px;\n      margin-right: 12px;\n      color: #fff;\n      font-size: 22px;\n    }\n    .btn-voting-md {\n      width: 65px;\n      height: 65px;\n      margin-right: 12px;\n      color: #fff;\n      font-size: 20px;\n    }\n    .btn-voting-sm {\n      width: 55px;\n      height: 55px;\n      margin-right: 12px;\n      color: #fff;\n      font-size: 16px;\n    }\n    .btn-voting-xs, .btn-voting-xs:hover, .btn-voting-xs:focus, .btn-voting-xs:active, .btn-voting-xs:active:focus {\n      width: 40px;\n      height: 40px;\n      margin-right: 8px;\n      color: #fff;\n      font-size: 9px;\n    }\n    .btn-yes, .progress-bar-success {\n        background-color: #008842;\n        border-color: #008842;\n    }\n    .btn-yes:hover, .btn-yes:focus, .btn-yes:active, .btn-yes:active:focus {\n        background-color: #136d3f;\n        border-color: #136d3f;\n    }\n    .btn-no, .progress-bar-danger {\n        background-color: #e3131e;\n        border-color: #e3131e;\n    }\n    .btn-no:hover, .btn-no:focus, .btn-no:active, .btn-no:active:focus {\n        background-color: #c82029;\n        border-color: #c82029;\n    }\n    .btn-abstain, .progress-bar-warning {\n        background-color: #f0d300;\n        border-color: #f0d300;\n    }\n    .btn-abstain:hover, .btn-abstain:focus, .btn-abstain:active, .btn-abstain:active:focus {\n        background-color: #d7c016;\n        border-color: #d7c016;\n    }\n    .btn-gray {\n        background-color: #a0a0a0;\n        border-color: #a0a0a0;\n    }\n    .btn-gray:hover, .btn-gray:focus, .btn-gray:active, .btn-gray:active:focus {\n        background-color: #888;\n        border-color: #888;\n    }\n</style>\n');
$templateCache.put('static/templates/openslides_voting/submit-motion-poll-buttons.html','<ng-include src="\'static/templates/openslides_voting/submit-buttons-css.html\'"></ng-include>\n<div class="pointer votingoption" ng-click="vote(\'Y\');">\n  <button type="button" class="btn btn-default btn-voting"\n    ng-class="mpbVote.value == \'Y\' ? \'btn-yes\' : \'btn-gray\'">\n    <i class="fa fa-thumbs-o-up fa-2x"></i>\n  </button>\n  <translate>Yes</translate>\n</div>\n  \n<div class="pointer votingoption spacer-top-lg" ng-click="vote(\'N\');">\n  <button type="button" class="btn btn-default btn-voting"\n  ng-class="mpbVote.value == \'N\' ? \'btn-no\' : \'btn-gray\'">\n    <i class="fa fa-thumbs-o-down fa-2x"></i>\n  </button>\n  <translate>No</translate>\n</div>\n      \n<div class="pointer votingoption spacer-top-lg" ng-click="vote(\'A\');">\n  <button type="button" class="btn btn-default btn-voting"\n    ng-class="mpbVote.value == \'A\' ? \'btn-abstain\' : \'btn-gray\'">\n    <i class="fa fa-circle-o fa-2x"></i>\n  </button>\n  <translate>Abstain</translate>\n</div>\n\n<div class="spacer-top-lg bold">\n  <translate>Your current choice:</translate>\n  <span ng-if="mpbVote.value === \'Y\'">\n    <translate>Yes</translate>\n  </span>\n  <span ng-if="mpbVote.value === \'N\'">\n    <translate>No</translate>\n  </span>\n  <span ng-if="mpbVote.value === \'A\'">\n    <translate>Abstain</translate>\n  </span>\n  <span ng-if="!mpbVote.value">&mdash;</span>\n</div>\n');
$templateCache.put('static/templates/openslides_voting/submit-motion-poll.html','<div class="header">\n  <div class="title">\n    <div class="submenu">\n      <a href="javascript:history.back()" class="btn btn-sm btn-default">\n        <i class="fa fa-angle-double-left fa-lg"></i>\n        <translate>Back</translate>\n      </a>\n    </div>\n    <h1>\n      <translate>Vote for</translate>\n      <span ng-if="motion.identifier">\n        {{ motion.identifier }} &mdash;\n      </span>\n      {{ motionPoll.motion.getTitle() }}\n    </h1>\n    <div class="row" ng-if="mpb">\n      <div class="col-sm-12">\n        <h2>\n          <translate>You have already voted for</translate>\n          <strong ng-if="mpb.vote == \'Y\'" translate>\n            Yes\n          </strong>\n          <strong ng-if="mpb.vote == \'N\'" translate>\n            No\n          </strong>\n          <strong ng-if="mpb.vote == \'A\'" translate>\n            Abstain\n          </strong>\n        </h2>\n      </div>\n    </div>\n  </div>\n</div>\n\n<div class="details">\n  <div uib-alert ng-show="alert.show" ng-class="\'alert-\' + (alert.type || \'warning\')" close="alert={}">\n    {{ alert.msg }}\n  </div>\n  <ng-include src="\'static/templates/openslides_voting/submit-motion-poll-buttons.html\'"></ng-include>\n  <button type="button" class="btn btn-primary spacer-top" ng-click="submit()"\n    ng-disabled="!mpbVote.value" translate>\n    Submit\n  </button>\n</div>\n');
$templateCache.put('static/templates/openslides_voting/submit-token.html','<style type="text/css">\n    #content .containerOS, #header .containerOS {\n        max-width: none;\n    }\n    #content {\n        margin-bottom: 30px;\n    }\n    .tokenvoting {\n        font-size: 22px;\n    }\n    .tokenvoting h1 {\n        font-size: 50px;\n    }\n    .tokenvoting .btn {\n        font-size: 22px;\n    }\n    .tokenvoting .btn-primary {\n        font-size: 18px;\n    }\n    .tokeninputform {\n        margin-top: 20px;\n        margin-bottom: 70px;\n    }\n    .tokeninputform label {\n        font-weight: normal;\n    }\n    .tokeninputform input {\n        font-size: 22px;\n        height: 40px;\n    }\n    .tokenvoting .spacer-top-lg {\n        margin-top: 45px;\n    }\n</style>\n\n<div class="header tokenvoting">\n  <div class="title">\n    <!-- no token voting -->\n    <h2 ng-if="!isTokenVoting" translate>\n      Voting is not yet running ...\n    </h2>\n    <!-- token voting -->\n    <div ng-if="isTokenVoting">\n      <div ng-if="av.motionPoll">\n        <h1><translate>Vote</translate>: <translate>Motion</translate>\n            {{ av.motionPoll.motion.identifier }}</h1>\n        <h2>{{ av.motionPoll.motion.getTitle() }}</h2>\n      </div>\n      <div ng-if="av.assignmentPoll">\n        <h1>{{ av.assignmentPoll.assignment.getAgendaTitle() }}</h1>\n      </div>\n    </div>\n\n  </div>\n</div>\n\n<div class="details tokenvoting" ng-show="isTokenVoting || alert.show">\n  <div uib-alert ng-show="alert.show" ng-class="\'alert-\' + alert.type" close="alert={}">\n    {{ alert.msg }}\n  </div>\n\n  <div ng-show="isTokenVoting">\n    <div ng-if="votingState === \'scan\'">\n      <form ng-submit="scan()" class="row" ng-if="av.motionPoll || av.assignmentPoll">\n        <div class="col-md-6">\n          <div class="form-group tokeninputform">\n            <label for="tokenInput" translate>Please enter your voting token:</label>\n            <input type="text" class="form-control" id="tokenInput"\n              ng-model="$parent.$parent.tokenInput" ng-disabled="tokenInputDisabled" autofocus>\n          </div>\n          <button type="submit" class="btn btn-sm btn-primary" translate>\n            Continue\n          </button>\n        </div>\n      </form>\n    </div>\n\n    <div ng-if="votingState === \'enter\'">\n      <div ng-if="av.motionPoll">\n        <ng-include src="\'static/templates/openslides_voting/submit-motion-poll-buttons.html\'"></ng-include>\n        <button type="button" class="btn btn-primary spacer-top-lg" ng-click="submitVote()"\n          ng-disabled="!mpbVote" translate>\n          Submit vote\n        </button>\n      </div>\n      <div ng-if="av.assignmentPoll" clas="spacer-top-lg">\n        <p>{{ av.assignmentPoll.description }}</p>\n        <ng-include src="\'static/templates/openslides_voting/submit-assignment-poll-buttons.html\'"></ng-include>\n\n        <button type="button" class="btn btn-primary spacer-top-lg" ng-click="submitVote()"\n          ng-disabled="!canSubmitAssignmentPoll()" translate>\n          Submit vote\n        </button>\n      </div>\n    </div>\n\n    <div ng-if="votingState === \'submitted\'">\n      <p class="bold" translate>Vote was submitted successfully!</p>\n      <p>\n        <translate>Your personal result number to validate your voting:</translate>\n        <br>\n        <strong style="font-size: 130%">{{ resultToken }}</strong>\n      </p>\n\n      <button type="button" class="btn btn-primary spacer-top-lg" ng-click="reset()">\n        <translate>Closed in</translate>\n        {{ timeout }}\n        <translate>seconds</translate> ...\n      </button>\n    </div>\n  </div>\n</div>\n');
$templateCache.put('static/templates/openslides_voting/tokens.html','<div class="header">\n  <div class="title">\n    <div class="submenu">\n      <a ui-sref="users.user.list" class="btn btn-sm btn-default">\n        <i class="fa fa-angle-double-left fa-lg"></i>\n        <translate>Back to overview</translate>\n      </a>\n      <a class="btn btn-default btn-sm"\n         ng-bootbox-prompt="{{ \'How much voting tokens should be generated?\' | translate }}"\n         ng-bootbox-prompt-action="generate(result)">\n        <i class="fa fa-magic fa-lg"></i>\n        <translate>Generate</translate>\n      </a>\n    </div>\n    <h1 translate>Voting tokens</h1>\n  </div>\n</div>\n\n<div class="details">\n  <div uib-alert ng-show="alert.show" ng-class="\'alert-\' + (alert.type || \'warning\')" close="alert={}">\n    {{ alert.msg }}\n  </div>\n\n  <form ng-submit="scan()" class="row">\n    <div class="col-md-6">\n      <div class="form-group">\n        <label for="tokenInput" translate>Enter new voting token:</label>\n        <input type="text" class="form-control" id="tokenInput"\n          ng-model="tokenInput" ng-disabled="tokenInputDisabled" autofocus>\n        <p class="help-block" translate>A minimum length of 10 characters is required.</p>\n      </div>\n      <button type="submit" class="btn btn-sm btn-primary"\n        ng-disabled="!tokenInput || tokenInput.length < 10" translate>\n        Activate\n      </button>\n    </div>\n  </form>\n\n  <h1><translate>Active voting tokens</translate>:</h1>\n  <div ng-repeat="token in tokens">\n    {{ token.token }}\n  </div>\n  <div ng-if="tokens.length === 0" translate>\n    No active voting tokens\n  </div>\n</div>\n');
$templateCache.put('static/templates/openslides_voting/user-list-extra-content-hook.html','<div ng-controller="UserListExtraContentCtrl">\n  <small>\n    <div ng-if="config(\'voting_enable_votecollector\')">\n      <div os-perms="openslides_voting.can_manage"\n           ng-style="{\'visibility\': (user.keypad.number || user.hover) ? \'visible\' : \'hidden\'}">\n        <div class="popover-wrapper"\n            uib-tooltip="{{ \'VoteCollector Keypad\' | translate }}"\n            tooltip-placement="bottom">\n          <i class="fa fa-calculator"></i>\n          <span editable-text="user.keypad.newNumber" onaftersave="saveKeypad(user)">\n            <span ng-if="!user.keypad.number" translate>Set keypad number ...</span>\n            <span ng-if="user.keypad.number">\n              {{ user.keypad.number }}\n            </span>\n          </span>\n        </div>\n      </div>\n    </div>\n    <div ng-if="d.isDelegate(user)">\n      <div os-perms="openslides_voting.can_manage">\n        <div ng-if="user.proxy && config(\'voting_enable_proxies\')"\n          uib-tooltip="{{ \'This user is represented by\' | translate}} {{ user.proxy.rep.full_name }}">\n          <i class="fa fa-share"></i>\n          {{ user.proxy.rep.full_name }}\n        </div>\n      </div>\n    </div>\n  </small>\n</div>\n');
$templateCache.put('static/templates/openslides_voting/user-list-menu-buttons-hook.html','<span class="dropdown" os-perms="openslides_voting.can_manage" uib-dropdown>\n  <button type="button" class="btn btn-default btn-sm"\n    id="votingMenu" uib-dropdown-toggle>\n    <i class="fa fa-bullseye fa-lg"></i>\n    OpenSlides-Voting\n    <span class="caret"></span>\n  </button>\n  <ul class="dropdown-menu" aria-labelledby="votingMenu">\n    <li>\n      <a ui-sref="openslides_voting.tokens">\n        <i class="fa fa-key"></i>\n        <translate>Voting tokens</translate>\n      </a>\n    </li><li ng-if="config(\'voting_enable_votecollector\')">\n      <a ui-sref="openslides_voting.keypad.list">\n        <i class="fa fa-calculator"></i>\n        <translate>Keypads</translate>\n      </a>\n    </li><li ng-if="config(\'voting_enable_votecollector\')">\n      <a ui-sref="openslides_voting.attendance">\n        <i class="fa fa-check-square-o"></i>\n        <translate>Attendance</translate>\n      </a>\n    </li><li ng-if="config(\'voting_enable_proxies\')">\n      <a ui-sref="openslides_voting.absenteeVote.list">\n        <i class="fa fa-file-text-o"></i>\n        <translate>Absentee votes</translate>\n      </a>\n    </li><li ng-if="config(\'voting_enable_principles\')">\n      <a ui-sref="openslides_voting.shares.list">\n        <i class="fa fa-pie-chart"></i>\n        <translate>Voting shares</translate>\n      </a>\n    </li>\n  </ul>\n</span>\n');
$templateCache.put('static/templates/openslides_voting/user-list-table-stats-hook.html','<span ng-if="filter.multiselectFilters.group.length === 1 && filter.multiselectFilters.group[0] === 2">\n  &mdash;\n  {{ attendingCount }} <translate>present</translate>,\n  {{ representedCount }} </translate>represented</translate>,\n  {{ absentCount }} <translate>absent</translate>\n</span>\n');}]);})();