!function(){angular.module("OpenSlidesApp-templates",[]).run(["$templateCache",function(n){n.put("static/templates/config-form-field.html",'<div class="form-group">\n  <label>{{ label | translate }}</label>\n\n  <div class="input-group">\n    <!-- text/number input, checkbox -->\n    <input ng-if="type == \'text\' || type == \'number\' || type == \'checkbox\'"\n           ng-model="$parent.value"\n           ng-model-options="{debounce: 1000}"\n           ng-change="save(configOption.key, $parent.value)"\n           ng-class="{ \'form-control\': type != \'checkbox\' }"\n           id="{{ key }}"\n           type="{{ type }}">\n\n    <!-- comments -->\n    <div class="input-comments" ng-if="type == \'comments\'">\n      <div ng-repeat="entry in $parent.value" class="input-group">\n        <input ng-model="entry.name"\n               ng-model-options="{debounce: 1000}"\n               ng-change="save(configOption.key, $parent.value)"\n               class="form-control"\n               id="{{ key }}"\n               type="text">\n        <span class="input-group-btn">\n          <button type=button" class="btn btn-default"\n            ng-click="entry.public = !entry.public; save(configOption.key, $parent.value);">\n            <i class="fa" ng-class="entry.public ? \'fa-unlock\' : \'fa-lock\'"></i>\n            {{ (entry.public ? \'Public\' : \'Private\') | translate }}\n          </button>\n          <button type="button" class="btn btn-default"\n            ng-click="removeComment(configOption.key, $parent, $index)">\n            <i class="fa fa-minus"></i>\n            <translate>Remove</translate>\n          </button>\n        </span>\n      </div>\n      <div>\n        <button type="button" ng-click="addComment(configOption.key, $parent)"\n          class="btn btn-default btn-sm">\n          <i class="fa fa-plus"></i>\n          <translate>Add new comment field</translate>\n        </button>\n      </div>\n    </div>\n\n    <!-- colorpicker -->\n    <input ng-if="type == \'colorpicker\'"\n           colorpicker\n           class="form-control"\n           ng-model="$parent.value"\n           ng-model-options="{debounce: 1000}"\n           ng-change="save(configOption.key, $parent.value)"\n           type="text">\n\n    <!-- datetimepicker -->\n    <input ng-if="type == \'datetimepicker\'"\n           class="form-control"\n           datetime-picker="dd.MM.yyyy HH:mm"\n           ng-model="$parent.value"\n           ng-change="save(configOption.key, $parent.value)"\n           is-open="datetimeOpen[key]"\n           ng-focus="datetimeOpen[key]=true;"\n           save-as="\'number\'"\n           button-bar="dateTimePickerTranslatedButtons"\n           default-time="10:00:00">\n\n    <!-- textarea -->\n    <textarea ng-if="type == \'textarea\'"\n              ng-model="$parent.value"\n              ng-model-options="{debounce: 1000}"\n              ng-change="save(configOption.key, $parent.value)"\n              id="{{ key }}" class="form-control">\n    </textarea>\n\n    <!-- select -->\n    <select ng-if="type == \'choice\'"\n            ng-model="$parent.value"\n            ng-model-options="{debounce: 500}"\n            ng-change="save(configOption.key, $parent.value)"\n            id="{{ key }}" class="form-control"\n            ng-options="option.value as option.display_name | translate for option in choices">\n    </select>\n\n    <span class="input-group-btn">\n      <button ng-click="reset()" class="btn btn-default" title="{{ default_value | translate }}">\n        <i class="fa fa-undo"></i>\n        <translate>Reset</translate>\n      </button>\n    </span>\n  </div>\n  <p ng-if="help_text" class="help-block">{{ help_text | translate }}</p>\n</div>\n'),n.put("static/templates/config.html",'<div class="header">\n  <div class="title">\n    <h1 translate>Settings</h1>\n  </div>\n</div>\n\n<div class="details">\n  <div os-perms="core.can_manage_config" class="panel-group" id="accordion"\n      role="tablist" aria-multiselectable="true">\n    <!-- generate config groups -->\n    <div ng-repeat="group in configGroups">\n      <div class="panel panel-default">\n        <div class="panel-heading" role="tab" id="heading-group{{ $index }}">\n          <h4 class="panel-title">\n            <a data-toggle="collapse" data-parent="#accordion" href="#group{{ $index }}"\n                aria-expanded="false" aria-controls="group{{ $index }}">\n              {{ group.name | translate }}\n            </a>\n          </h4>\n        </div> <!-- heading -->\n        <div id="group{{ $index }}" class="panel-collapse collapse" role="tabpanel" aria-labelledby="heading-group{{ $index }}">\n          <div class="panel-body">\n            <div ng-repeat="subgroup in group.subgroups">\n              <h3>{{ subgroup.name | translate }}</h3>\n              <div ng-repeat="configOption in subgroup.items">\n                <os-form-field field="configOption"></os-form-field>\n              </div>\n            </div>\n          </div>\n        </div> <!-- group.name -->\n      </div>\n    </div>\n  </div>\n</div>\n\n'),n.put("static/templates/home.html",'<div os-perms="core.can_see_frontpage" class="header">\n  <div class="title">\n    <h1>{{ config(\'general_event_welcome_title\') | translate }}</h1>\n  </div>\n</div>\n\n<div os-perms="core.can_see_frontpage" class="details"\n    ng-bind-html="config(\'general_event_welcome_text\') | translate">\n</div>\n'),n.put("static/templates/index.html",'<!DOCTYPE html>\n<html ng-controller="LanguageCtrl" lang="{{ selectedLanguage[0].code }}" class="no-js">\n<meta charset="utf-8">\n<meta http-equiv="X-UA-Compatible" content="IE=edge">\n<base href="/">\n<title ng-if="!activeAppTitle">OpenSlides</title> <!-- avoid {{ ... }} in title while angular is not loaded -->\n<title ng-if="activeAppTitle">OpenSlides &ndash; {{ activeAppTitle | translate }}</title>\n<meta name="description" content="">\n<meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=0">\n<link rel="stylesheet" href="static/css/openslides-libs.css">\n<link rel="stylesheet" href="static/css/app.css">\n<link rel="icon" href="/static/img/favicon.png">\n<!-- TODO (#2787): move into openslides-libs-->\n<script>\n  window.CKEDITOR_BASEPATH = \'/static/ckeditor/\';\n</script>\n<script src="static/js/openslides-libs.js"></script>\n<script src="static/js/openslides.js"></script>\n<script src="static/js/openslides-templates.js"></script>\n\n<div id="wrapper" ng-cloak>\n\n<!-- Header -->\n<div id="header">\n  <div ng-hide="connected" class="unconnected"></div>\n  <div class="containerOS">\n    <!-- Logo -->\n    <div class="title">\n      <a ui-sref="home">\n        <img src="/static/img/openslides-logo-dark.png" alt="Logo" height="35">\n      </a>\n    </div>\n\n    <!-- user specific header (chat, user settings / login, language)-->\n    <div class="user" ng-controller="userMenu">\n      <div class="btn-group">\n        <div ng-if="operator.isAuthenticated()">\n\n          <!-- chatbox -->\n          <div ng-controller="ChatMessageCtrl" os-perms="core.can_use_chat" class="inline">\n            <a href ng-click="openChatbox()" class="headerlink"\n                ng-class="{ \'active\': !chatboxIsCollapsed }" uib-dropdown-toggle>\n              <i class="fa fa-comment"></i>\n              <translate class="hide-sm">Chat</translate>\n              <span ng-if="unreadMessages > 0 && chatboxIsCollapsed" class="badge">\n                {{ unreadMessages }}\n              </span>\n            </a> |\n            <div id="chatbox" class="well" uib-collapse="chatboxIsCollapsed">\n              <div id="chatbox-text" scroll-glue>\n                <ul class="list-unstyled">\n                  <li ng-repeat="chatmessage in chatmessages">\n                    <small class="grey">{{ chatmessage.timestamp | date:\'HH:mm:ss\' }}</small>\n                    <small>{{ chatmessage.user.short_name }}:</small>\n                    {{ chatmessage.message }}\n                </ul>\n              </div>\n              <div id="chatbox-form">\n                <form ng-submit="sendMessage()">\n                  <div class="input-group">\n                    <input\n                      ng-model="newMessage"\n                      id="messageInput"\n                      class="form-control"\n                      type="text"\n                      autocomplete="off">\n                    <span class="input-group-btn">\n                      <button type="submit" class="btn btn-default" id="messageSendButton">\n                        <i class="fa fa-comment"></i>\n                      </button>\n                      <button os-perms="core.can_manage_chat" type="button"\n                        class="btn btn-default btn-danger" id="clearchatHistory"\n                        ng-bootbox-confirm="{{ \'Are you sure to delete the chat history?\' | translate }}"\n                        ng-bootbox-confirm-action="clearChatHistory()">\n                        <i class="fa fa-trash"></i>\n                      </button>\n                    </span>\n                  </div>\n                </form>\n              </div>\n            </div>\n          </div>\n\n          <!-- user settings / logout button -->\n          <span uib-dropdown>\n            <a href class="headerlink" uib-dropdown-toggle id="user-settings-dropdown">\n              <i class="fa fa-user"></i>\n              <span class="hide-sm">{{ operator.user.get_short_name() }}</span>\n            </a>\n            <ul class="dropdown-menu pull-right" uib-dropdown-menu aria-labelledby="user-settings-dropdown">\n              <li>\n                <a ui-sref="users.user.detail.profile({ id: operator.user.id })">\n                  <i class="fa fa-cog"></i>\n                  <translate>Edit profile</translate>\n                </a>\n              <li>\n                <a ui-sref="users.user.detail.password({ id: operator.user.id })">\n                  <i class="fa fa-key"></i>\n                  <translate>Change password</translate>\n                </a>\n              <li class="divider">\n              <li>\n                <a ng-click="logout()" href="">\n                  <i class="fa fa-sign-out"></i>\n                  <translate>Logout</translate>\n                </a>\n            </ul>\n          </span>\n        </div>\n        <!-- Login button -->\n        <div ng-if="!operator.isAuthenticated()">\n          <a href ui-sref="login({guest_enabled: true})" class="headerlink" uib-dropdown-toggle>\n            <i class="fa fa-sign-in"></i>\n            <translate>Login</translate>\n          </a>\n        </div>\n      </div>\n\n      <!-- language switcher -->\n      <span uib-dropdown> |\n        <a href="" class="headerlink" uib-dropdown-toggle id="language-dropdown">\n          <i class="fa fa-flag"></i>\n          <span class="hide-sm">{{ selectedLanguage[0].name | translate }}</span>\n        </a>\n        <ul class="dropdown-menu pull-right" uib-dropdown-menu aria-labelledby="language-dropdown">\n          <li ng-repeat="language in languages">\n            <a href="" ng-click="switchLanguage(language.code)">\n              <i ng-if="language.selected" class="fa fa-check"></i>\n              {{ language.name | translate }}\n            </a>\n      </span>\n\n    </div>\n  </div>\n</div><!--end header-->\n\n<!-- Navbar -->\n<div id="nav" ng-controller="MainMenuCtrl">\n  <div class="containerOS" >\n    <!-- mobile (vertical) main menu -->\n    <button class="navbar-toggle" ng-click="isMenuOpen = !isMenuOpen">\n      <i class="fa fa-bars"></i>\n    </button>\n    <div class="navbar navbar-collapse" ng-class="{collapse: !isMenuOpen}">\n      <!-- Main menu -->\n      <ul>\n        <li ng-repeat="element in elements" ui-sref-active="active" ng-click="closeMenu()">\n          <a ui-sref="{{ element.ui_sref }}">\n            <i class="fa fa-{{ element.img_class }}"></i>\n            {{ element.title | translate }}\n          </a>\n      </ul>\n      <!-- Search bar -->\n      <div class="searchbar pull-right" ng-controller="SearchBarCtrl">\n        <form ng-submit="search(); closeMenu()">\n          <div class="input-group">\n            <input ng-model="querybar" class="form-control" type="text" placeholder="{{ \'Search\' | translate}}">\n            <span class="input-group-btn">\n              <button type="submit" class="btn btn-default">\n                <i class="fa fa-search"></i>\n              </button>\n            </span>\n          </div>\n        </form>\n      </div>\n    </div>\n\n   </div>\n</div><!--end nav-->\n\n\n<!-- Content -->\n<div id="content" ng-controller="ProjectorSidebarCtrl">\n  <div class="containerOS">\n    <div class="col1" ng-class="isProjectorSidebar ? \'min\' : \'max\'">\n        <!-- dynamic views -->\n        <route-loading-indicator></route-loading-indicator>\n        <div ui-view ng-if="!isRouteLoading"></div>\n        <!-- footer -->\n        <div id="footer">\n          &copy; Copyright by <a href="http://www.openslides.org" target="_blank">OpenSlides</a> |\n          <a ui-sref="legalnotice" translate>Legal notice</a>\n        </div><!--end footer-->\n    </div>\n    <div id="sidebar" class="col2" os-perms="core.can_see_projector"\n        ng-class="isProjectorSidebar ? \'max\' : \'min\'"\n        ng-init="initSidebar()">\n      <!-- sidebar maximized -->\n      <div class="projector_full" ng-if="isProjectorSidebar">\n        <div class="title" ng-click="showProjectorSidebar(false)">\n          <div class="name">\n            <i class="fa fa-video-camera"></i>\n            <translate>Projector</translate>\n          </div>\n          <div class="icon">\n            <i class="fa fa-angle-right"></i>\n          </div>\n        </div>\n        <div ng-include src="\'static/templates/core/projector-controls.html\'"></div>\n      </div>\n      <!-- sidebar minimized -->\n      <div class="projector_min" ng-if="!isProjectorSidebar">\n        <div class="icon">\n          <a href="" ng-click="showProjectorSidebar(true)">\n            <i class="fa fa-video-camera"></i>\n          </a>\n        </div>\n      </div>\n    </div><!--end col2-->\n\n  </div><!--end content-container-->\n</div><!--end content-->\n\n</div><!--end wrapper-->\n\n<script src="/webclient/site/"></script>\n'),n.put("static/templates/legalnotice.html",'<div class="header">\n  <div class="title">\n    <h1 translate>Legal notice</h1>\n  </div>\n</div>\n\n<div class="details">\n  <div ng-bind-html="config(\'general_event_legal_notice\') | translate"></div>\n  <hr>\n  <p>OpenSlides {{ core_version }}\n  <div ng-show="plugins.length">\n    <p translate>Installed plugins:</p>\n    <ol>\n      <li ng-repeat="plugin in plugins">\n        {{ plugin.verbose_name }}: {{ plugin.version }}\n    </ol>\n  </div>\n</div>\n'),n.put("static/templates/projector-button.html",'<div class="btn-group" style="min-width:{{ projectors.length > 1 ? \'54\' : \'34\' }}px;" uib-dropdown\n  uib-tooltip="{{ \'Projector\' | translate }} {{ model.isProjected(arg)[0] || \'\' }}"\n  tooltip-enable="model.isProjected(arg).length"\n  os-perms="core.can_manage_projector">\n  <button type="button" class="btn btn-default btn-sm"\n    ng-click="model.project(defaultProjectorId, arg)"\n    ng-class="{ \'btn-primary\': inArray(model.isProjected(arg), defaultProjectorId) }">\n    <i class="fa fa-video-camera"></i>\n    {{ content }}\n  </button>\n  <button type="button" class="btn btn-default btn-sm slimDropDown"\n    ng-class="{ \'btn-primary\': (model.isProjected(arg).length && !inArray(model.isProjected(arg), defaultProjectorId)) }"\n    ng-if="projectors.length > 1"\n    uib-dropdown-toggle>\n    <span class="caret"></span>\n  </button>\n  <ul class="dropdown-menu" ng-if="projectors.length > 1">\n    <li role="menuitem" ng-repeat="projector in projectors">\n      <a href="" ng-click="model.project(projector.id, arg)"\n        ng-class="{ \'projected\': inArray(model.isProjected(arg), projector.id) }">\n        <i class="fa fa-video-camera" ng-show="inArray(model.isProjected(arg), projector.id)"></i>\n        {{ projector.name | translate }}\n        <span ng-if="defaultProjectorId == projector.id">(<translate>Default</translate>)</span>\n      </a>\n    </li>\n  </ul>\n</div>\n'),n.put("static/templates/projector-container.html",'<!DOCTYPE html>\n<html ng-controller="ProjectorContainerCtrl" lang="en" class="no-js">\n<meta charset="utf-8">\n<meta http-equiv="X-UA-Compatible" content="IE=edge">\n<base href="/">\n<title ng-if="projectorId===undefined">OpenSlides &ndash; Projector</title> <!-- avoid {{ ... }} in title while angular is not loaded -->\n<title ng-if="projectorId!==undefined">OpenSlides &ndash; {{ \'Projector\' | translate }} {{ projectorId }}</title>\n<meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=0">\n<link rel="stylesheet" href="static/css/openslides-libs.css">\n<link rel="stylesheet" href="static/css/projector.css">\n<link rel="icon" href="/static/img/favicon.png">\n<script src="static/js/openslides-libs.js"></script>\n<script src="static/js/openslides.js"></script>\n<script src="static/js/openslides-templates.js"></script>\n\n<div class="pContainer">\n  <div>\n    <style>\n      .pContainer #iframe {\n          width: {{ projectorWidth }}px;\n          height: {{ projectorHeight }}px;\n          -moz-transform: scale({{ scale }});\n          -webkit-transform: scale({{ scale }});\n          -o-transform: scale({{ scale }});\n          transform: scale({{ scale }});\n          /* IE8+ - must be on one line, unfortunately */\n          -ms-filter: "progid:DXImageTransform.Microsoft.Matrix(M11={{ scale }}, M12=0, M21=0, M22={{ scale }}, SizingMethod=\'auto expand\')";\n      }\n\n      .pContainer #iframewrapper {\n          width: {{ iframeWidth }}px;\n          height: {{ iframeHeight }}px;\n      }\n\n      .pContainer #iframeoverlay {\n        width: {{ iframeWidth }}px;\n        height: {{ iframeHeight }}px;\n      }\n    </style>\n\n    <div id="iframewrapper" ng-hide="error">\n      <iframe id="iframe" ng-src="{{ \'/real-projector/\' + projectorId }}" frameborder="0"></iframe>\n      <div id="iframeoverlay"></div>\n    </div>\n\n    <div class="error" ng-show="error">\n      <p>{{ error | translate }}</p>\n    </div>\n  </div>\n</div>\n\n<script src="/webclient/projector/"></script>\n'),n.put("static/templates/projector.html",'<!DOCTYPE html>\n<html lang="en" class="no-js">\n<meta charset="utf-8">\n<meta http-equiv="X-UA-Compatible" content="IE=edge">\n<base href="/">\n<title>OpenSlides &ndash; Projector</title>\n<link rel="stylesheet" href="static/css/openslides-libs.css">\n<link rel="stylesheet" href="static/css/projector.css">\n<link rel="icon" href="/static/img/favicon.png">\n<script src="static/js/openslides-libs.js"></script>\n<script src="static/js/openslides.js"></script>\n<script src="static/js/openslides-templates.js"></script>\n\n<div id="projectorContainer" ng-controller="ProjectorCtrl">\n  <style type="text/css">\n    #header, #footer {\n      background-color: {{ config(\'projector_header_backgroundcolor\') }};\n    }\n    #header, #footer, #currentTime {\n      color: {{ config(\'projector_header_fontcolor\') }};\n    }\n    #header, #footer, .contentContainer {\n      visibility: {{ blank ? \'hidden\' : \'visible\' }};\n    }\n    #projectorContainer {\n      background-color: {{ blank ? config(\'projector_blank_color\') : \'#fff\' }};\n      height: {{ blank ? \'100%\' : \'auto\' }};\n    }\n    h1 {\n      color: {{ config(\'projector_h1_fontcolor\') }};\n    }\n  </style>\n\n\n  <div id="header">\n    <img ng-if="config(\'projector_enable_logo\')" id="logo" src="/static/img/logo-projector.png" alt="OpenSlides" />\n    <div ng-if="config(\'projector_enable_title\')" id="eventdata">\n      <div class="title" ng-class="{ \'titleonly\': !config(\'general_event_description\') }"\n          ng-bind-html="config(\'general_event_name\')"></div>\n      <div ng-if="config(\'general_event_description\')" class="description"\n          ng-bind-html="config(\'general_event_description\')"></div>\n    </div>\n  </div>\n\n  <style type="text/css">\n    .scrollcontent {\n      margin-top: {{ -80 * projector.scroll }}px !important;\n      font-size: {{ 100 + 20 * projector.scale }}%;\n    }\n    .mediascrollcontent {\n      margin-top: {{scroll/2}}em !important;\n      -webkit-transform: scale({{scale/100}});\n      -ms-transform: scale({{scale/100}});\n      transform: scale({{scale/100}});\n    }\n  </style>\n  <div class="contentContainer" ng-repeat="element in elements | orderBy:\'index\'">\n    <div ng-include="element.template"></div>\n  </div>\n\n  <div id="footer">\n    <span ng-if="config(\'general_event_date\')">\n      {{ config(\'general_event_date\') }}\n    </span>\n    <span ng-if="config(\'general_event_date\') && config(\'general_event_location\')">\n      |\n    </span>\n    <span ng-if="config(\'general_event_location\')">\n      {{ config(\'general_event_location\') }}\n    </span>\n  </div>\n</div>\n\n<script src="/webclient/projector/"></script>\n'),n.put("static/templates/search.html",'<div class="header">\n  <div class="title">\n    <h1 translate>Search results</h1>\n  </div>\n</div>\n\n<div class="details">\n    <form class="input-group" ng-submit="search()">\n      <input type="text" ng-model="query" class="form-control">\n      <span class="input-group-btn">\n        <button type="submit" class="btn btn-default" translate>Search</button>\n      </span>\n    </form>\n    <div class="searchfilter spacer-top">\n      <label class="checkbox-inline">\n        <input type="checkbox" ng-model="filterAgenda">\n        <translate>Agenda items</translate>\n      </label>\n      <label class="checkbox-inline">\n        <input type="checkbox" ng-model="filterMotion">\n        <translate>Motions</translate>\n      </label>\n      <label class="checkbox-inline">\n        <input type="checkbox" ng-model="filterAssignment">\n        <translate>Elections</translate>\n      </label>\n      <label class="checkbox-inline">\n        <input type="checkbox" ng-model="filterUser">\n        <translate>Participants</translate>\n      </label>\n      <label class="checkbox-inline">\n        <input type="checkbox" ng-model="filterMedia">\n        <translate>Files</translate>\n      </label>\n      <div>\n        <label class="checkbox-inline">\n          <input type="checkbox" ng-model="fullword" ng-change="search()">\n          <translate>Only whole words</translate>\n        </label>\n      </div>\n    </div>\n  <div class="searchresults spacer-top-lg">\n    <ol ng-show="results">\n      <li ng-repeat="result in results | filter:filterresult()">\n        <a ng-if="!result.mediafileUrl" ui-sref="{{ result.urlState }}({{ result.urlParam }})">\n          {{ result.getSearchResultName() }}\n        </a>\n        <a ng-if="result.mediafileUrl" href="{{ result.mediafileUrl }}" target="_blank">\n          {{ result.getSearchResultName() }}\n        </a>\n        <br>\n        <span class="grey">{{ result.getSearchResultSubtitle() | translate }}</span>\n    </ol>\n    <p ng-show="!results || results.length == 0" translate>No results.</p>\n  </div>\n</div>\n'),n.put("static/templates/agenda/current-list-of-speakers.html",'<div class="header">\n  <div class="title">\n    <div class="submenu">\n      <a ui-sref="agenda.item.list" class="btn btn-sm btn-default">\n        <i class="fa fa-angle-double-left fa-lg"></i>\n        <translate>Back to overview</translate>\n      </a>\n      <!-- manage list of speakers -->\n      <button os-perms="agenda.can_manage"\n        ng-click="goToListOfSpeakers()"\n        class="btn btn-sm btn-default">\n        <i class="fa fa-microphone"></i>\n        <translate>Manage list</translate>\n      </button>\n      <!-- project -->\n      <div os-perms="core.can_manage_projector" class="btn-group" uib-dropdown\n        uib-tooltip="{{ \'Projector\' | translate }} {{ isCurrentLoSProjected()[0] || \'\' }}"\n        tooltip-enable="isCurrentLoSProjected().length">\n        <button type="button" class="btn btn-default btn-sm"\n            title="{{ \'Project current list of speakers\' | translate }}"\n            ng-click="projectCurrentLoS(defaultProjectorId)"\n            ng-class="{ \'btn-primary\': isCurrentLoSProjected().length && inArray(isCurrentLoSProjected(), defaultProjectorId) }">\n          <i class="fa fa-video-camera"></i>\n          <translate>Current list of speakers</translate>\n        </button>\n        <button type="button" class="btn btn-default btn-sm" uib-dropdown-toggle\n            ng-class="{ \'btn-primary\': isCurrentLoSProjected().length && !inArray(isCurrentLoSProjected(), defaultProjectorId) }">\n          <span class="caret"></span>\n        </button>\n        <ul class="dropdown-menu" role="menu" aria-labelledby="split-button">\n          <li role="menuitem" ng-repeat="projector in projectors">\n            <a href="" ng-click="projectCurrentLoS(projector.id)"\n              ng-class="{ \'projected\': inArray(isCurrentLoSProjected(), projector.id) }">\n              <i class="fa fa-video-camera" ng-show="inArray(isCurrentLoSProjected(), projector.id) "></i>\n              {{ projector.name | translate }}\n              <span ng-if="projector.id == defaultProjectorId">(<translate>Default</translate>)</span>\n            </a>\n          </li>\n        </ul>\n      </div>\n    </div>\n    <h1 translate>Current list of speakers</h1>\n    <h2> {{ AgendaItem.getTitle() }}\n      <span class="slimlabel label label-danger ng-scope" style="" ng-if="AgendaItem.speaker_list_closed" translate>\n        Closed\n      </span>\n    </h2>\n  </div>\n</div>\n\n<div class="details">\n  <!-- Last speakers -->\n  <p ng-repeat="speaker in lastSpeakers = (AgendaItem.speakers | filter: {end_time: \'!!\', begin_time: \'!!\'}) |\n    limitTo: config(\'agenda_show_last_speakers\') : (lastSpeakers.length - config(\'agenda_show_last_speakers\'))" class="lastSpeakers">\n    {{ speaker.user.get_full_name() }}\n  <!-- Current speaker -->\n  <p ng-repeat="speaker in currentspeakers = (AgendaItem.speakers| filter: {end_time: null, begin_time: \'!!\'})"\n    class="currentSpeaker">\n    <i class="fa fa-microphone fa-lg"></i> {{ speaker.user.get_full_name() }}\n  <!-- Next speakers -->\n  <ol class="nextSpeakers">\n    <li ng-repeat="speaker in AgendaItem.speakers | filter: {begin_time: null} | orderBy:\'weight\'">\n   {{ speaker.user.get_full_name() }}\n  </ol>\n</div>\n'),n.put("static/templates/agenda/item-detail.html",'<div ng-if="item" class="header">\n  <div class="title">\n    <div class="submenu">\n      <a ui-sref="agenda.item.list" class="btn btn-sm btn-default">\n        <i class="fa fa-angle-double-left fa-lg"></i>\n        <translate>Agenda</translate>\n      </a>\n      <a ui-sref="{{ item.content_object.collection.replace(\'/\',\'.\') }}.detail({id: item.content_object.id})" class="btn btn-sm btn-default">\n        <i class="fa fa-angle-double-left fa-lg"></i>\n        {{ item.getContentResource().verboseName | translate }}\n      </a>\n      <!-- project list of speakers -->\n      <span class="btn-group" style="min-width:54px;" uib-dropdown\n        uib-tooltip="{{ \'Projector\' | translate }} {{ item.isListOfSpeakersProjected()[0] || \'\' }}"\n        tooltip-enable="item.isListofSpeakersProjected().length"\n        os-perms="core.can_manage_projector">\n        <button type="button" class="btn btn-default btn-sm"\n          ng-click="item.projectListOfSpeakers(defaultProjectorListOfSpeakersId)"\n          ng-class="{ \'btn-primary\': inArray(item.isListOfSpeakersProjected(), defaultProjectorListOfSpeakersId)  }">\n          <i class="fa fa-video-camera"></i>\n          <translate>List of speakers</translate>\n        </button>\n        <button type="button" class="btn btn-default btn-sm slimDropDown"\n          ng-class="{ \'btn-primary\': (item.isListOfSpeakersProjected().length && !inArray(item.isListOfSpeakersProjected(), defaultProjectorListOfSpeakersId) ) }"\n          ng-if="projectors.length > 1"\n          uib-dropdown-toggle>\n          <span class="caret"></span>\n        </button>\n        <ul class="dropdown-menu" ng-if="projectors.length > 1">\n          <li role="menuitem" ng-repeat="projector in projectors">\n            <a href="" ng-click="item.projectListOfSpeakers(projector.id)"\n              ng-class="{ \'projected\': inArray(item.isListOfSpeakersProjected(), projector.id) }">\n              <i class="fa fa-video-camera" ng-show="inArray(item.isListOfSpeakersProjected(), projector.id) "></i>\n              {{ projector.name | translate }}\n              <span ng-if="defaultProjectorListOfSpeakersId == projector.id">(<translate>Default</translate>)</span>\n            </a>\n          </li>\n        </ul>\n      </span> \n      <!-- project -->\n      <projector-button model="item" default-projector-id="defaultProjectorItemId"\n        content="{{ item.getContentResource().verboseName | translate }}">\n      </projector-button>\n    </div>\n    <h1>{{ item.getTitle() }}</h1>\n    <h2>\n      <translate>List of speakers</translate>\n      <span ng-if="item.speaker_list_closed" class="slimlabel label label-danger"\n          translate>Closed</span>\n    </h2>\n  </div>\n</div>\n\n<div ng-if="item" class="details">\n<div class="speakers-toolbar">\n  <div class="pull-right">\n    <span os-perms="agenda.can_manage">\n      <button ng-if="isAllowed(\'removeAll\')" class="btn btn-sm btn-danger"\n          ng-bootbox-confirm="{{ \'Are you sure you want to remove all speakers from this list?\'| translate }}"\n          ng-bootbox-confirm-action="removeAllSpeakers()">\n          <i class="fa fa-trash fa-lg"></i>\n          <translate>Remove all speakers</translate>\n      </button>\n      <button ng-if="item.speaker_list_closed" ng-click="closeList(false)"\n          class="btn btn-sm btn-default">\n        <i class="fa fa-toggle-off"></i>\n        <translate>Closed</translate>\n      </button>\n      <button ng-if="!item.speaker_list_closed" ng-click="closeList(true)"\n          class="btn btn-sm btn-default">\n        <i class="fa fa-toggle-on"></i>\n        <translate>Open</translate>\n      </button>\n    </span>\n  </div>\n\n  <!-- Start/Stop controls -->\n  <button ng-if="isAllowed(\'endCurrentSpeech\')" ng-click="endSpeech()"\n      class="btn btn-sm btn-default">\n    <i class="fa fa-stop"></i>\n    <translate>End current speech</translate>\n  </button>\n  <button ng-if="isAllowed(\'beginNextSpeech\')" ng-click="beginSpeech()"\n      class="btn btn-sm btn-default">\n    <i class="fa fa-play"></i>\n    <translate>Begin next speech</translate>\n  </button>\n</div>\n\n  <!-- text for empty list -->\n  <p ng-if="speakers.length == 0" translate>\n    The list of speakers is empty.\n  </p>\n\n  <template-hook hook-name="itemDetailListOfSpeakersButtons"></template-hook>\n\n  <!-- Last speakers -->\n  <div class="spacer-top-lg">\n    <button ng-if="isAllowed(\'showLastSpeakers\')" ng-click="$parent.showOldSpeakers = !$parent.showOldSpeakers"\n        class="btn btn-xs btn-default">\n      <translate ng-if="!$parent.showOldSpeakers">Last speakers</translate>\n      <translate ng-if="$parent.showOldSpeakers">Hide</translate>\n    </button>\n    <div uib-collapse="!showOldSpeakers">\n      <ol class="indentation">\n        <li ng-repeat="speaker in lastSpeakers">\n          {{ speaker.user.get_full_name() }}\n          <small class="grey">\n            {{ getDuration(speaker) | osSecondsToTime }} <translate>minutes</translate>\n            (<translate>Start time</translate>:\n            {{ speaker.begin_time | date:\'yyyy-MM-dd HH:mm:ss\' }})\n          </small>\n          <button os-perms="agenda.can_manage" ng-click="removeSpeaker(speaker.id)"\n              class="btn btn-default btn-xs" title="{{ \'Remove\' | translate }}">\n            <i class="fa fa-times"></i>\n          </button>\n      </ol>\n    </div>\n  </div>\n\n  <!-- Current speaker -->\n  <p ng-repeat="speaker in currentSpeaker" class="currentSpeaker spacer indentation">\n    <i class="fa fa-microphone fa-lg"></i>\n    {{ speaker.user.get_full_name() }}\n    <button os-perms="agenda.can_manage" ng-click="endSpeech()"\n        class="btn btn-default btn-sm" title="{{ \'End speech\' | translate }}">\n      <i class="fa fa-microphone-slash"></i> <translate>Stop</translate>\n    </button>\n    <button os-perms="agenda.can_manage" ng-click="removeSpeaker(speaker.id)"\n        class="btn btn-default btn-sm" title="{{ \'Remove\' | translate }}">\n      <i class="fa fa-times"></i>\n    </button>\n  </p>\n\n  <!-- Next speakers -->\n  <div ng-show="nextSpeakers.length > 0">\n    <div ui-tree="treeOptions">\n      <ol ui-tree-nodes="" ng-model="speakers">\n        <li ng-repeat="speaker in nextSpeakers | orderBy:\'weight\'" ui-tree-node>\n          <i os-perms="agenda.can_manage" ui-tree-handle="" class="fa fa-arrows-v"></i>\n          {{ $index + 1 }}.\n          {{ speaker.user.get_full_name() }}\n          &nbsp;\n          <button os-perms="agenda.can_manage" ng-click="beginSpeech(speaker.id)"\n              class="btn btn-default btn-sm" title="{{ \'Begin speech\' | translate }}">\n            <i class="fa fa-microphone"></i> <translate>Start</translate>\n          </button>\n          <button os-perms="agenda.can_manage" ng-click="removeSpeaker(speaker.id)"\n              class="btn btn-default btn-sm" title="{{ \'Remove\' | translate }}">\n            <i class="fa fa-times"></i>\n          </button>\n      </ol>\n    </div>\n  </div>\n\n  <!-- Select speakers form -->\n  <div class="form-group spacer-top-lg">\n    <div uib-alert ng-show="alert.show" ng-class="\'alert-\' + (alert.type || \'warning\')" ng-click="alert={}" close="alert={}">\n      {{ alert.msg }}\n    </div>\n    <div os-perms="agenda.can_manage">\n      <select chosen\n          ng-model="speakerSelectBox.selected"\n          ng-change="addSpeaker(speakerSelectBox.selected)"\n          ng-options="user.id as user.get_full_name() for user in users"\n          search-contains="true"\n          placeholder-text-single="\'Select or search a participant ...\' | translate"\n          no-results-text="\'No results available ...\' | translate"\n          class="form-control">\n      <select>\n    </div>\n    <p class="spacer">\n      <button ng-if="isAllowed(\'add\')" ng-click="addSpeaker()" class="btn btn-default">\n        <i class="fa fa-plus"></i>\n        <translate>Add me</translate>\n      </button>\n      <button ng-if="isAllowed(\'remove\')" ng-click="removeSpeaker()" class="btn btn-default">\n        <i class="fa fa-minus"></i>\n        <translate>Remove me</translate>\n      </button>\n  </div>\n</div>\n'),
n.put("static/templates/agenda/item-list.html",'<div class="header">\n  <div class="title">\n    <div class="submenu">\n      <!-- new -->\n      <a ng-click="newDialog()" os-perms="agenda.can_manage"\n          class="btn btn-primary btn-sm">\n        <i class="fa fa-plus fa-lg"></i>\n        <translate>New</translate>\n      </a>\n      <!-- import -->\n      <a ui-sref="topics.topic.import" os-perms="agenda.can_manage"\n          class="btn btn-default btn-sm">\n        <i class="fa fa-download fa-lg"></i>\n        <translate>Import</translate>\n      </a>\n      <!-- current list of speakers -->\n      <a ui-sref="agenda.current-list-of-speakers" os-perms="users.can_see_name"\n          class="btn btn-default btn-sm">\n        <i class="fa fa-microphone"></i>\n        <translate>Current list of speakers</translate>\n      </a>\n      <!-- project agenda button -->\n      <div class="btn-group button" uib-dropdown\n        uib-tooltip="{{ \'Projector\' | translate }} {{ isAgendaProjected(mainListTree)[0] || \'\' }}"\n        tooltip-enable="isAgendaProjected(mainListTree).length"\n        os-perms="core.can_manage_projector">\n        <button type="button" class="btn btn-default btn-sm"\n            title="{{ \'Project agenda\' | translate }}"\n            ng-click="projectAgenda(defaultProjectorId_all_items, mainListTree)"\n            ng-class="{ \'btn-primary\': isAgendaProjected(mainListTree).length && inArray(isAgendaProjected(mainListTree), defaultProjectorId_all_items)}">\n          <i class="fa fa-video-camera"></i>\n          <translate>Agenda</translate>\n        </button>\n        <button type="button" class="btn btn-default btn-sm" uib-dropdown-toggle\n            ng-class="{ \'btn-primary\': isAgendaProjected(mainListTree).length && !inArray(isAgendaProjected(mainListTree), defaultProjectorId_all_items)}"\n            ng-if="agendaHasSubitems || projectors.length > 1">\n          <span class="caret"></span>\n        </button>\n        <ul class="dropdown-menu" role="menu" aria-labelledby="split-button" ng-if="agendaHasSubitems || projectors.length > 1">\n          <li role="menuitem" ng-show="agendaHasSubitems">\n            <a href="" ng-click="changeMainListTree(); $event.stopPropagation();">\n              <i class="fa" ng-class="mainListTree ? \'fa-square-o\' : \'fa-check-square-o\'"></i>\n              <translate>Only main agenda items</translate>\n            </a>\n          </li>\n          <li class="divider" ng-show="agendaHasSubitems && projectors.length > 1"></li>\n          <li role="menuitem" ng-repeat="projector in projectors" ng-show="projectors.length > 1">\n            <a href="" ng-click="projectAgenda(projectorId=projector.id, tree=mainListTree)"\n              ng-class="{ \'projected\': inArray(isAgendaProjected(mainListTree), projector.id) }">\n              <i class="fa fa-video-camera" ng-show="inArray(isAgendaProjected(mainListTree), projector.id) "></i>\n              {{ projector.name | translate }}\n              <span ng-if="projector.id == defaultProjectorId_all_items">(<translate>Default</translate>)</span>\n            </a>\n          </li>\n        </ul>\n      </div>\n    </div>\n    <h1 translate>Agenda</h1>\n  </div>\n</div>\n\n<div class="details">\n  <div class="row">\n    <div class="col-sm-12">\n      <!-- select mode -->\n      <button os-perms="agenda.can_manage" class="btn btn-sm"\n          ng-class="$parent.isSelectMode ? \'btn-primary\' : \'btn-default\'"\n          ng-click="$parent.isSelectMode = !$parent.isSelectMode; uncheckAll()">\n        <i class="fa fa-check-square-o"></i>\n        <translate>Select ...</translate>\n      </button>\n      <!-- sort button -->\n      <a ui-sref="agenda.item.sort" os-perms="agenda.can_manage" class="btn btn-default btn-sm">\n        <i class="fa fa-sitemap fa-lg"></i>\n        <translate>Sort ...</translate>\n      </a>\n      <!-- auto numbering button -->\n      <button os-perms="core.can_manage_projector" class="btn btn-default btn-sm"\n        ng-click="autoNumbering()">\n        <i class="fa fa-sort-numeric-asc"></i>\n        <translate>Numbering</translate>\n      </button>\n      <!-- pdf -->\n      <div class="pull-right" uib-dropdown>\n        <button type="button" class="btn btn-default" id="dropdownExport" uib-dropdown-toggle>\n          <i class="fa fa-upload"></i>\n          <span ng-if="itemsFiltered.length == items.length" translate>\n            Export all\n          </span>\n          <span ng-if="itemsFiltered.length != items.length" translate>\n            Export filtered\n          </span>\n          <span class="caret"></span>\n        </button>\n        <ul class="dropdown-menu dropdown-menu-right" aria-labelledby="dropdownExport">\n          <!-- PDF export -->\n          <li>\n            <a href="" ng-click="pdfExport()">\n              <i class="fa fa-file-pdf-o fa-lg"></i>\n              PDF\n            </a>\n          </li>\n          <!-- CSV export -->\n          <li>\n            <a href="" id="downloadLinkCSV"\n              ng-click="csvExport()">\n              <i class="fa fa-file-text-o fa-lg"></i>\n              CSV\n            </a>\n          </li>\n        </ul>\n      </div>\n    </div>\n  </div>\n  <div uib-collapse="!isSelectMode" class="row spacer">\n    <div class="col-sm-12 text-left">\n      <!-- delete button -->\n      <a ng-show="isSelectMode" os-perms="agenda.can_manage"\n        ng-bootbox-confirm="{{ \'Are you sure you want to delete all selected agenda items?\' | translate }}"\n        ng-bootbox-confirm-action="deleteMultiple()"\n        class="btn btn-primary">\n        <i class="fa fa-trash fa-lg"></i>\n        <translate>Delete selected items</translate>\n      </a>\n    </div>\n  </div>\n\n  <div class="spacer-top-lg italic">\n    <span os-perms="agenda.can_see_hidden_items">{{ itemsFiltered.length }} /</span>\n    {{ items.length }} {{ "items" | translate }}<span ng-if="(items|filter:{selected:true}).length > 0">,\n    {{(items|filter:{selected:true}).length}} {{ "selected" | translate }}</span>\n    <span os-perms="agenda.can_see_hidden_items" class="optional">\n      <span ng-if="sumDurations() > 0">&middot;\n        <translate>Duration</translate>:\n        {{ sumDurations() | osMinutesToTime }}h\n        <span ng-if="config(\'agenda_start_event_date_time\')">\n          (<translate>Estimated end:</translate> {{ calculateEndTime() }})\n        </span>\n      </span>\n  </div>\n\n  <div class="os-table container-fluid">\n    <div class="row header-row">\n      <div class="col-xs-1 centered" ng-show="isSelectMode">\n        <i class="fa text-danger pointer" ng-class="selectedAll ? \'fa-check-square-o\' : \'fa-square-o\'"\n          ng-click="checkAll()"></i>\n      </div>\n      <div class="col-xs-11 main-header">\n        <span class="form-inline text-right pull-right">\n          <!-- clear all filters -->\n          <span class="sort-spacer pointer" ng-click="filter.reset()"\n            ng-if="filter.areFiltersSet()" ng-disabled="isSelectMode"\n            ng-class="{\'disabled\': isSelectMode}">\n            <i class="fa fa-times-circle"></i>\n            <translate>Filter</translate>\n          </span>\n          <!-- boolean Filters -->\n          <span ng-repeat="(name, booleanFilter) in filter.booleanFilters" uib-dropdown>\n            <span class="pointer" id="dropdown{{ name }}" uib-dropdown-toggle\n              ng-class="{\'bold\': booleanFilter.value !== undefined, \'disabled\': isSelectMode}"\n              ng-disabled="isSelectMode">\n              {{ booleanFilter.displayName | translate }}\n              <span class="caret"></span>\n            </span>\n            <ul class="dropdown-menu dropdown-menu-right" aria-labelledby="dropdown{{ name }}">\n              <li>\n                <a href ng-click="booleanFilter.value = (booleanFilter.value ? undefined : true); filter.save();">\n                  <i class="fa" ng-class="{\'fa-check\': booleanFilter.value === true}"></i>\n                  {{ booleanFilter.choiceYes | translate }}\n                </a>\n              </li>\n              <li>\n                <a href ng-click="booleanFilter.value = (booleanFilter.value === false) ? undefined : false; filter.save();">\n                  <i class="fa" ng-class="{\'fa-check\': booleanFilter.value === false}"></i>\n                  {{ booleanFilter.choiceNo | translate }}\n                </a>\n              </li>\n            </ul>\n          </span>\n          <!-- search field -->\n          <span class="form-group">\n            <span class="input-group">\n              <span class="input-group-addon"><i class="fa fa-search"></i></span>\n              <input type="text" ng-model="filter.filterString" class="form-control"\n                 placeholder="{{ \'Search\' | translate}}" ng-disabled="isSelectMode"\n                 ng-change="filter.save()">\n            </span>\n          </span>\n        </span>\n        <!-- show all selected multiselectoptions -->\n        <span>\n          <!-- for all boolean Filters -->\n          <span ng-repeat="(name, booleanFilter) in filter.booleanFilters"\n            ng-hide="booleanFilter.value === undefined"\n            class="pointer spacer-left-lg"\n            ng-click="booleanFilter.value = undefined; filter.save();"\n            ng-class="{\'disabled\': isSelectMode}">\n            <span class="nobr">\n              <i class="fa fa-times-circle"></i>\n              {{ booleanFilter.value ? booleanFilter.choiceYes : booleanFilter.choiceNo | translate }}\n            </span>\n          </span>\n        </span>\n      </div>\n    </div>\n\n    <!-- main table -->\n    <div class="row data-row" ng-mouseover="item.hover=true"\n      ng-mouseleave="item.hover=false"\n      ng-class="{\'projected\': item.isProjected().length}"\n      ng-repeat="item in itemsFiltered = (items\n        | osFilter: filter.filterString : filter.getObjectQueryString\n        | filter: {closed: filter.booleanFilters.closed.value}\n        | filter: {is_hidden: filter.booleanFilters.is_hidden.value}\n        | limitTo : itemsPerPage : limitBegin)">\n\n      <!-- select column -->\n      <div ng-show="isSelectMode" os-perms="agenda.can_manage" class="col-xs-1 centered">\n        <i class="fa text-danger pointer" ng-click="item.selected=!item.selected"\n        ng-class="item.selected ? \'fa-check-square-o\' : \'fa-square-o\'"></i>\n      </div>\n      <!-- projector column -->\n      <div class="col-xs-1 centered projector" os-perms="core.can_manage_projector">\n        <div class="btn-group" style="min-width:{{ (item.hasSubitems(items) || projectors.length > 1) ? \'54\' : \'34\' }}px;" uib-dropdown\n          uib-tooltip="{{ \'Projector\' | translate }} {{ item.isProjected(item.tree)[0] || \'\' }}"\n          tooltip-enable="item.isProjected(item.tree).length">\n          <button class="btn btn-default btn-sm"\n              title="{{ \'Project item\' | translate }}"\n              ng-click="item.project(getProjectionDefault(item), item.tree)"\n              ng-class="{ \'btn-primary\': item.isProjected(item.tree).length && inArray(item.isProjected(item.tree), getProjectionDefault(item))}">\n            <i class="fa fa-video-camera"></i>\n          </button>\n          <button type="button" class="btn btn-default btn-sm slimDropDown"\n              ng-class="{ \'btn-primary\': item.isProjected(item.tree).length && !inArray(item.isProjected(item.tree), getProjectionDefault(item))}"\n              ng-if="item.hasSubitems(items) || projectors.length > 1"\n              uib-dropdown-toggle>\n            <span class="caret"></span>\n          </button>\n          <ul class="dropdown-menu" role="menu" aria-labelledby="split-button"\n            ng-if="item.hasSubitems(items) || projectors.length > 1">\n            <li role="menuitem" ng-show="item.hasSubitems(items)">\n              <a href="" ng-click="changeItemTree(item); $event.stopPropagation();">\n                <i class="fa" ng-class="item.tree ? \'fa-check-square-o\' : \'fa-square-o\'"></i>\n                <translate>Include all sub items</translate>\n              </a>\n            </li>\n            <li class="divider" ng-show="item.hasSubitems(items)"></li>\n            <li role="menuitem" ng-repeat="projector in projectors">\n              <a href="" ng-click="item.project(projector.id, item.tree)"\n                ng-class="{ \'projected\': inArray(item.isProjected(item.tree), projector.id) }">\n                <i class="fa fa-video-camera" ng-show="inArray(item.isProjected(item.tree), projector.id)"></i>\n                {{ projector.name | translate }}\n                <span ng-if="projector.id == getProjectionDefault(item)">(<translate>Default</translate>)</span>\n              </a>\n            </li>\n          </ul>\n        </div>\n      </div>\n      <div class="no-projector-spacer" os-perms="!core.can_manage_projector"></div>\n\n      <!-- main content column -->\n      <div class="col-xs-6 content" style="padding-left: calc({{ item.parentCount }}*15px)">\n        <div class="spacer-right">\n          <i class="fa fa-ban" ng-style="{\'visibility\': item.is_hidden ? \'visible\' : \'hidden\'}"\n            title="{{ \'Internal item\' | translate }}"></i>\n        </div>\n        <div>\n          <!-- ID and title -->\n          <div>\n            <a class="title" ui-sref="{{ getUpdateStatePrefix(item) }}.detail({id: item.content_object.id})" ng-show="isAllowedToSeeOpenLink(item)">\n              {{ item.getListViewTitle() }}\n            </a>\n            <span class="title" ng-hide="isAllowedToSeeOpenLink(item)">\n              {{ item.getListViewTitle() }}\n            </span>\n          </div>\n          <!-- hover menu -->\n          <div os-perms="agenda.can_see" ng-class="{\'hiddenDiv\': !item.hover}">\n            <small>\n              <a ui-sref="agenda.item.detail({id: item.id})" translate>List of speakers</a>\n              <span os-perms="agenda.can_manage"> &middot;\n                <a ui-sref="{{ getUpdateStatePrefix(item) }}.detail.update({id: item.content_object.id})"\n                    translate>Edit</a> &middot;\n                <a href="" class="text-danger"\n                  ng-bootbox-confirm="{{ \'Are you sure you want to delete this entry?\' | translate }}<br>\n                    <b>{{ item.getTitle() }}</b>"\n                  ng-bootbox-confirm-action="deleteRelatedItem(item)" translate>Delete</a>\n              </span>\n            </small>\n          </div>\n\n        </div>\n      </div>\n      <!-- additional content column -->\n      <div class="col-xs-4 content" ng-style="{\'width\': isSelectMode ? \'calc(50% - 120px)\' : \'calc(50% - 70px)\'}">\n        <div style="width: 60%;" class="optional">\n          <small>\n            <div ng-style="{\'visibility\': (item.duration || item.hover) ? \'visible\' : \'hidden\'}">\n              <div class="popover-wrapper">\n                <i class="fa fa-clock-o"></i>\n                <span editable-text="item.durationText" e-placeholder="hh:mm"\n                  onshow="generateDurationText(item)" onaftersave="setDurationText(item)">\n                  <span ng-if="!item.duration" translate>Set duration...</span>\n                  <span ng-if="item.duration">\n                    {{ (item.duration | osMinutesToTime)}}\n                    <translate translate-comment="\'h\' means time in hours">h</translate>\n                  </span>\n                </span>\n              </div>\n            </div>\n            <div ng-style="{\'visibility\': (item.comment || item.hover) ? \'visible\' : \'hidden\'}">\n              <div class="popover-wrapper">\n                <i class="fa fa-info-circle"></i>\n                <span editable-text="item.comment" onaftersave="save(item)">\n                  <span ng-if="!item.comment" translate>Set comment...</span>\n                  <span ng-if="item.comment">{{ item.comment}}</span>\n                </span>\n              </div>\n            </div>\n          </small>\n        </div>\n        <div style="width: 40%;" class="pull-right">\n          <div os-perms="agenda.can_manage">\n            <div class="pointer nobr" ng-click="item.type = (item.type == 1) ? 2 : 1; save(item);" ng-show="item.hover || item.is_hidden">\n              <i class="fa" ng-class="item.is_hidden ? \'fa-check-square-o\' : \'fa-square-o\'"></i>\n              <span class="spacer-left" translate>Internal item</span>\n            </div>\n            <div class="pointer nobr" ng-click="item.closed = !item.closed; save(item);" ng-show="item.hover || item.closed">\n              <i class="fa" ng-class="item.closed ? \'fa-check-square-o\' : \'fa-square-o\'"></i>\n              <span class="spacer-left" translate>Done</span>\n            </div>\n          </div>\n          <div os-perms="!agenda.can_manage" ng-if="item.closed">\n            <i class="fa fa-check-square-o"></i>\n            <span class="spacer-left" translate>Done</span>\n          </div>\n        </div>\n      </div>\n    </div> <!-- data row -->\n\n  </div> <!-- container -->\n\n  <ul uib-pagination\n      ng-show="itemsFiltered.length > itemsPerPage"\n      total-items="itemsFiltered.length"\n      items-per-page="itemsPerPage"\n      ng-model="currentPage"\n      ng-change="pageChanged()"\n      class="pagination-sm"\n      direction-links="false"\n      boundary-links="true"\n      first-text="&laquo;"\n      last-text="&raquo;">\n  </ul>\n</div> <!-- details -->\n'),n.put("static/templates/agenda/item-sort.html",'<div class="header">\n  <div class="title">\n    <div class="submenu">\n      <a ui-sref="agenda.item.list" class="btn btn-sm btn-default">\n        <i class="fa fa-angle-double-left fa-lg"></i>\n        <translate>Back to overview</translate>\n      </a>\n    </div>\n    <h1 translate>Sort agenda</h1>\n  </div>\n</div>\n\n<div class="details">\n  <p class="lead" translate>Drag and drop items to change the order of the agenda. Your modification will be saved immediately.</p>\n\n  <div ui-tree="treeOptions" id="tree-root">\n    <ol ui-tree-nodes ng-model="items">\n      <li ng-repeat="item in items" ui-tree-node ng-include="\'nodes_renderer.html\'">\n    </ol>\n  </div>\n  <p class="spacer">* <translate>Internal item</translate</p>\n</div>\n\n\n<!-- Nested node template -->\n<script type="text/ng-template" id="nodes_renderer.html">\n  <div ui-tree-handle>\n    <span ng-if="item.item.is_hidden">*</span>\n    {{ item.item.getListViewTitle() }}\n  </div>\n  <ol ui-tree-nodes="" ng-model="item.children">\n    <li ng-repeat="item in item.children" ui-tree-node ng-include="\'nodes_renderer.html\'">\n  </ol>\n</script>\n\n'),n.put("static/templates/agenda/slide-current-list-of-speakers-overlay.html",'<div ng-controller="SlideCurrentListOfSpeakersCtrl">\n  <div ng-if="agendaItem.speakers && agendaItem.speakers.length">\n    <div id="speakerbox">\n    <h3 translate>List of speakers</h3>\n    <p ng-repeat="speaker in lastSpeakers = (agendaItem.speakers | filter: {end_time: \'!!\', begin_time: \'!!\'}) |\n    limitTo: config(\'agenda_show_last_speakers\') : (lastSpeakers.length - config(\'agenda_show_last_speakers\'))"\n    class="lastSpeakers">\n    {{ speaker.user.get_full_name() }}\n    <p ng-repeat="speaker in agendaItem.speakers | filter: {end_time: null, begin_time: \'!!\'} "\n    class="currentSpeaker">\n    <i class="fa fa-microphone fa-lg"></i> {{ speaker.user.get_full_name() }}\n    <ol class="nextSpeakers">\n      <li ng-repeat="speaker in nextSpeakers = (agendaItem.speakers | filter: {begin_time: null}) | orderBy:\'weight\' | limitTo: 3">\n        {{ speaker.user.get_full_name() }}\n    </ol>\n      <p ng-if="nextSpeakers.length > 3" class="lastSpeakers">\n       <i>+ {{ nextSpeakers.length - 3 }}</i>\n  </div>\n</div>\n'),n.put("static/templates/agenda/slide-current-list-of-speakers.html",'<div ng-controller="SlideCurrentListOfSpeakersCtrl" class="content scrollcontent">\n  <div class="title">\n    <h1 translate>Current list of speakers</h1>\n    <h2> {{ agendaItem.getTitle() }}\n      <span class="slimlabel label label-danger ng-scope" style="" \n        ng-if="agendaItem.speaker_list_closed" translate>Closed</span>\n    </h2>\n  </div>\n\n  <!-- Last speakers -->\n  <p ng-repeat="speaker in lastSpeakers = (agendaItem.speakers | filter: {end_time: \'!!\', begin_time: \'!!\'}) |\n    limitTo: config(\'agenda_show_last_speakers\') : (lastSpeakers.length - config(\'agenda_show_last_speakers\'))" class="lastSpeakers">\n    {{ speaker.user.get_full_name() }}\n  <!-- Current speaker -->\n  <p ng-repeat="speaker in currentspeakers = (agendaItem.speakers| filter: {end_time: null, begin_time: \'!!\'})"\n    class="currentSpeaker">\n    <i class="fa fa-microphone fa-lg"></i> {{ speaker.user.get_full_name() }}\n  <!-- Next speakers -->\n  <ol class="nextSpeakers">\n    <li ng-repeat="speaker in agendaItem.speakers | filter: {begin_time: null} | orderBy:\'weight\'">\n   {{ speaker.user.get_full_name() }}\n  </ol>\n</div>\n'),n.put("static/templates/agenda/slide-item-list.html",'<div ng-controller="SlideItemListCtrl" class="content scrollcontent">\n  <h1 ng-if="!element.id" translate>Agenda</h1>\n  <h1 ng-if="element.id">{{ rootItem.getTitle() }}</h1>\n\n  <div class="agendalist">\n    <!-- item type: AGENDA_ITEM = 1, HIDDEN_ITEM = 2 -->\n    <p ng-repeat="item in items | filter: {type: 1}"\n        ng-class="{mainitem: item.parentCount == 0, subitem: item.parentCount != 0, done: item.closed}">\n      <span ng-repeat="n in [].constructor(item.parentCount) track by $index">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</span>\n      {{ item.getListViewTitle() }}\n    </p>\n  </div>\n</div>\n'),n.put("static/templates/agenda/slide-list-of-speakers.html",'<div ng-controller="SlideListOfSpeakersCtrl" class="content scrollcontent">\n\n  <!-- Title -->\n  <div id="title">\n    <h1>{{ item.getTitle() }}</h1>\n    <h2>\n      <span translate>List of speakers</span>\n      <span ng-if="(item.speakers | filter: {begin_time: null}).length > 0">\n      &ndash; {{ (item.speakers | filter: {begin_time: null}).length }} <translate>speakers</translate>\n      <span ng-if="item.speaker_list_closed" class="slimlabel label label-danger" translate>Closed</span>\n    </h2>\n  </div>\n\n  <!-- Last speakers -->\n  <p ng-repeat="speaker in lastSpeakers = (item.speakers | filter: {end_time: \'!!\', begin_time: \'!!\'}) |\n      limitTo: config(\'agenda_show_last_speakers\') : (lastSpeakers.length - config(\'agenda_show_last_speakers\'))" class="lastSpeakers">\n      {{ speaker.user.get_full_name() }}\n\n  <!-- Current speaker -->\n  <p ng-repeat="speaker in item.speakers | filter: {end_time: null, begin_time: \'!!\'}"\n      class="currentSpeaker">\n      <i class="fa fa-microphone fa-lg"></i> {{ speaker.user.get_full_name() }}\n\n  <!-- Next speakers -->\n  <ol class="nextSpeakers">\n    <li ng-repeat="speaker in item.speakers | filter: {begin_time: null} | orderBy:\'weight\'">\n      {{ speaker.user.get_full_name() }}\n  </ol>\n</div>\n'),n.put("static/templates/assignments/assignment-detail.html",'<div class="header">\n  <div class="title">\n    <div class="submenu">\n      <a ui-sref="assignments.assignment.list" class="btn btn-sm btn-default">\n        <i class="fa fa-angle-double-left fa-lg"></i>\n        <translate>Back to overview</translate>\n      </a>\n      <!-- List of speakers -->\n      <a ui-sref="agenda.item.detail({id: assignment.agenda_item_id})"\n          os-perms="agenda.can_see" class="btn btn-sm btn-default">\n        <i class="fa fa-microphone fa-lg"></i>\n        <translate>List of speakers</translate>\n      </a>\n      <!-- project -->\n      <projector-button model="assignment", default-projector-id="defaultProjectorId">\n      </projector-button>\n      <!-- edit -->\n      <a os-perms="assignments.can_manage" ng-click="openDialog(assignment)"\n          class="btn btn-default btn-sm"\n          title="{{ \'Edit\' | translate}}">\n        <i class="fa fa-pencil"></i>\n      </a>\n      <!-- pdf -->\n      <a ng-click="makePDF_singleAssignment()" target="_blank" class="btn btn-default btn-sm">\n        <i class="fa fa-file-pdf-o fa-lg"></i>\n        <translate>PDF</translate>\n      </a>\n    </div>\n    <h1>{{ assignment.agenda_item.getTitle() || assignment.title }}</h1>\n    <h2>\n      <translate>Election</translate>\n    </h2>\n  </div>\n</div>\n\n<div class="meta">\n  <div class="title" ng-click="isMeta = !isMeta">\n    <div class="name">\n      <i class="fa fa-info-circle"></i>\n      <translate>Meta information</translate>\n    </div>\n    <div class="icon">\n      <i class="fa fa-lg" ng-class="isMeta ? \'fa-angle-down\' : \'fa-angle-up\'"></i>\n    </div>\n  </div>\n  <div class="detail" uib-collapse="isMeta">\n    <div class="row">\n      <div class="col-md-6">\n          <!-- posts -->\n          <h3 translate>Number of persons to be elected</h3>\n          {{ assignment.open_posts }}<br>\n          <!-- Tags -->\n          <h3 ng-if="assignment.tags.length > 0" translate>Tags</h3>\n          <span ng-repeat="tag in assignment.tags">\n            {{ tag.name }}{{$last ? \'\' : \', \'}}\n          </span>\n      </div>\n      <div class="col-md-6">\n          <!-- phase -->\n          <h3 translate>Phase</h3>\n          <span class="label" ng-class="{\'label-primary\': assignment.phase == 0,\n                                         \'label-warning\': assignment.phase == 1,\n                                         \'label-success\': assignment.phase == 2 }">\n            {{ phases[assignment.phase].display_name | translate }}\n          </span>\n          <div os-perms="assignments.can_manage" class="spacer">\n            <select ng-model="phaseSelect" class="form-control" ng-change="updatePhase(phaseSelect)">\n              <option value="" translate>--- Set phase ---</option>\n              <option ng-repeat="phase in phases" value="{{ phase.value }}">{{ phase.display_name | translate }}</option>\n            </select>\n          </div>\n      </div>\n    </div>\n  </div>\n</div>\n\n<div class="details">\n  <div ng-if="assignment.description">\n    <h3 translate>Description</h3>\n    <div class="white-space-pre-line">{{ assignment.description }}</div>\n  </div>\n\n  <div ng-if="assignment.phase != 2">\n    <h3 translate>Candidates</h3>\n    <ul>\n      <li ng-repeat="related_user in assignment.assignment_related_users">\n        <a ui-sref="users.user.detail({id: related_user.user_id})">{{ related_user.user.get_full_name() }}</a>\n        <i ng-if="related_user.elected" class="fa fa-star" title="{{ \'is elected\' | translate }}"></i>\n        <button os-perms="assignments.can_manage" ng-click="removeCandidate(related_user.user_id)"\n            class="btn btn-default btn-xs">\n          <i class="fa fa-times"></i>\n        </button>\n    </ul>\n\n    <div class="form-group">\n      <div uib-alert ng-show="alert.show" ng-class="\'alert-\' + (alert.type || \'warning\')" ng-click="alert={}" close="alert={}">\n        {{ alert.msg }}\n      </div>\n      <div os-perms="assignments.can_nominate_other">\n        <select chosen ng-model="candidateSelectBox.selected" ng-change="addCandidate(candidateSelectBox.selected)"\n            ng-options="user.id as user.get_full_name() for user in users"\n            search-contains="true"\n            placeholder-text-single="\'Select or search a participant ...\' | translate"\n            no-results-text="\'No results available ...\' | translate"\n            class="form-control">\n        <select>\n      </div>\n      <p os-perms="assignments.can_nominate_self" class="spacer">\n        <button ng-if="!isCandidate()" ng-click="addMe()" class="btn btn-default">\n          <i class="fa fa-plus"></i>\n          <translate>Add me</translate>\n        </button>\n        <button ng-if="isCandidate()" ng-click="removeMe()" class="btn btn-default">\n          <i class="fa fa-minus"></i>\n          <translate>Remove me</translate>\n        </button>\n    </div>\n  </div>\n\n  <h3 translate>Election result</h3>\n  <button os-perms="assignments.can_manage" ng-show="assignment.polls.length == 0"\n      ng-click="createBallot()" class="btn btn-default btn-sm">\n    <i class="fa fa-bar-chart fa-lg"></i>\n    <translate>New ballot</translate>\n  </button>\n\n  <uib-tabset ng-if="assignment.polls.length > 0" class="spacer ballot-tabs" active="activeTab">\n    <uib-tab ng-repeat="poll in assignment.polls | orderBy:\'-id\'"\n        index="$index" heading="{{ \'Ballot\' | translate }} {{ assignment.polls.length - $index }}">\n      <div ng-controller="AssignmentPollDetailCtrl">\n        <!-- action buttons -->\n        <div class="pull-right">\n          <!-- delete -->\n          <a class="btn btn-danger btn-xs"\n              ng-bootbox-confirm="{{ \'Are you sure you want to delete this ballot?\' | translate }}"\n              ng-bootbox-confirm-action="deleteBallot(poll)">\n            <i class="fa fa-trash"></i>\n            <translate>Delete</translate>\n          </a>\n        </div>\n        <div os-perms="assignments.can_manage" class="spacer " role="group">\n          <!-- angular requires to open the link in new tab with "target=\'_blank\'".\n          Otherwise the pdf url can\'t be open in same window; angular redirects to "/". -->\n          <!-- PDF -->\n          <a ng-click="makePDF_assignmentpoll(poll.id)" target="_blank" class="btn btn-default btn-sm">\n            <i class="fa fa-file-pdf-o"></i>\n            <translate>Print ballot paper</translate>\n          </a>\n          <!-- Edit -->\n          <button ng-click="editPollDialog(poll, $index+1)"\n              class="btn btn-default btn-sm">\n            <i class="fa fa-pencil"></i>\n            <translate>Enter votes</translate>\n          </button>\n          <!-- Publish -->\n          <button ng-click="togglePublishBallot(poll)"\n              ng-class="poll.published ? \'btn-primary\' : \'btn-default\'"\n              class="btn btn-sm">\n            <i class="fa fa-eye"></i>\n            <translate>Publish</translate>\n          </button>\n          <!-- Project -->\n          <projector-button model="assignment" default-projector-id="defaultProjectorId"\n            arg="poll.id" content="{{ \'Project\' | translate }}">\n          </projector-button>\n        </div>\n\n        <!-- template hook for assignment poll small buttons -->\n        <template-hook hook-name="assignmentPollSmallButtons"></template-hook>\n\n        <div class="results spacer-top-lg">\n\n          <!-- list of candidates of selected poll (without election result) -->\n          <div ng-if="!poll.has_votes">\n            <strong translate>Candidates</strong>\n            <ul class="list-unstyled">\n              <li ng-repeat="option in poll.options">\n                <a ui-sref="users.user.detail({id: option.candidate.id})">\n                  {{ option.candidate.get_full_name() }}\n                </a>\n            </ul>\n            <strong translate>Election method</strong><br>\n            <span ng-if="poll.pollmethod == \'votes\'" translate>One vote per candidate</span>\n            <span ng-if="poll.pollmethod == \'yna\'" translate>Yes/No/Abstain per candidate</span>\n            <span ng-if="poll.pollmethod == \'yn\'" translate>Yes/No per candidate</span>\n          </div>\n\n          <!-- Settings for majority calculations -->\n          <div os-perms="assignments.can_manage" ng-show="poll.has_votes" ng-cloak>\n            <div class="input-group">\n              <span><translate>Required majority</translate>: </span>\n              <select ng-model="method"\n                      ng-change="recalculateMajorities(method)"\n                      ng-options="option.value as option.display_name | translate for option in methodChoices" />\n            </div>\n          </div>\n          <!-- election result of poll -->\n          <table ng-if="poll.has_votes" class="table table-bordered table-striped minimumTable spacer">\n          <tr>\n            <th translate>Candidates\n            <th translate>Votes\n            <th translate ng-hide="method === \'disabled\'">Quorum\n            </th>\n            <!-- candidates (poll options) -->\n            <tr ng-repeat="option in poll.options">\n              <!-- candidate name -->\n              <td>\n                <span os-perms="assignments.can_manage">\n                  <i ng-if="option.is_elected" class="fa fa-check-square-o"\n                    ng-click="markElected(option.candidate_id, option.is_elected)"\n                      title="{{ \'is elected\' | translate }}"></i>\n                  <i ng-if="!option.is_elected" class="fa fa-square-o"\n                    ng-click="markElected(option.candidate_id, option.is_elected)"\n                      title="{{ \'is not elected\' | translate }}"></i>\n                  &nbsp;\n                </span>\n                <a ui-sref="users.user.detail({id: option.candidate.id})">{{ option.candidate.get_full_name() }}</a>\n\n              <!-- votes -->\n              <td>\n                <div ng-init="votes = option.getVotes()">\n                  <div ng-repeat="vote in votes">\n                    <span ng-if="poll.pollmethod == \'yna\' || poll.pollmethod == \'yn\'">{{ vote.label }}:</span>\n                    {{ vote.value }} {{ vote.percentStr }}\n                    <div ng-if="vote.percentNumber >= 0">\n                      <uib-progressbar value="vote.percentNumber" type="success"></uib-progressbar>\n                    </div>\n                  </div>\n                </div>\n              <td ng-hide="method === \'disabled\'">\n                <span ng-if="option.majorityReached >= 0" class="text-success" translate>\n                    Quorum ({{ option.getVoteYes() - option.majorityReached }}) reached.\n                </span>\n                <span ng-if="option.majorityReached < 0" class="text-danger" translate>\n                    Quorum ({{ option.getVoteYes() - option.majorityReached }}) not reached.\n                </span>\n\n            <!-- total votes (valid/invalid/casts) -->\n            <tr>\n              <td>\n                <translate>Valid ballots</translate>\n              <td>\n                {{ poll.getVote(\'votesvalid\').value }}\n                {{ poll.getVote(\'votesvalid\').percentStr }}\n            <tr>\n              <td>\n                <translate>Invalid ballots</translate>\n              <td>\n                {{ poll.getVote(\'votesinvalid\').value }}\n                {{ poll.getVote(\'votesinvalid\').percentStr }}\n            <tr class="total bg-info">\n              <td>\n                <translate>Casted ballots</translate>\n              <td>\n                {{ poll.getVote(\'votescast\').value }}\n                {{ poll.getVote(\'votescast\').percentStr }}\n          </table>\n        </div>\n      </div>\n    </uib-tab>\n\n    <!-- new ballot tab -->\n    <uib-tab select="createBallot()" index="assignment.polls.length">\n      <uib-tab-heading>\n        <i class="fa fa-plus"></i>\n        <translate>New ballot</translate>\n      </uib-tab-heading>\n    </uib-tab>\n  </uib-tabset>\n</div>\n'),
n.put("static/templates/assignments/assignment-form.html",'<h1 ng-if="model.id" translate>Edit election</h1>\n<h1 ng-if="!model.id" translate>New election</h1>\n\n<div uib-alert ng-show="alert.show" ng-class="\'alert-\' + (alert.type || \'warning\')" ng-click="alert={}" close="alert={}">\n  {{ alert.msg }}\n</div>\n\n<form name="assignmentForm" ng-submit="save(model)">\n  <formly-form model="model" fields="formFields">\n    <button type="submit" ng-disabled="assignmentForm.$invalid" class="btn btn-primary" translate>\n      Save\n    </button>\n    <button type="button" ng-click="closeThisDialog()" class="btn btn-default" translate>\n      Cancel\n    </button>\n  </formly-form>\n</form>\n'),n.put("static/templates/assignments/assignment-list.html",'<div class="header">\n  <div class="title">\n    <div class="submenu">\n      <a ng-click="openDialog()" os-perms="assignments.can_manage" class="btn btn-primary btn-sm">\n        <i class="fa fa-plus fa-lg"></i>\n        <translate>New</translate>\n      </a>\n      <a ui-sref="core.tag.list" os-perms="core.can_manage_tags" class="btn btn-default btn-sm">\n        <i class="fa fa-tags fa-lg"></i>\n        <translate>Tags</translate>\n      </a>\n    </div>\n    <h1 translate>Elections</h1>\n  </div>\n</div>\n\n<div class="details">\n  <div class="row form-group">\n    <div class="col-sm-12">\n      <!-- delete mode -->\n      <button os-perms="assignments.can_manage" class="btn"\n          ng-class="$parent.isSelectMode ? \'btn-primary\' : \'btn-default\'"\n          ng-click="$parent.isSelectMode = !$parent.isSelectMode; uncheckAll()">\n        <i class="fa fa-check-square-o"></i>\n        <translate>Select ...</translate>\n      </button>\n      <!-- export dropdown -->\n      <div class="dropdown pull-right" uib-dropdown>\n        <button type="button" class="btn btn-default" id="dropdownExport" uib-dropdown-toggle>\n          <i class="fa fa-upload"></i>\n          <span ng-if="assignmentsFiltered.length == assignments.length" translate>\n            Export all\n          </span>\n          <span ng-if="assignmentsFiltered.length != assignments.length" translate>\n            Export filtered\n          </span>\n          <span class="caret"></span>\n        </button>\n        <ul class="dropdown-menu dropdown-menu-right" aria-labelledby="dropdownExport">\n          <!-- PDF export -->\n          <li>\n            <a href="" ng-click="makePDF_assignmentList()">\n              <i class="fa fa-file-pdf-o fa-lg"></i>\n              <translate>PDF</translate>\n            </a>\n          </li>\n        </ul>\n      </div>\n    </div>\n  </div>\n  <div uib-collapse="!isFilterOpen" class="row">\n    <div class="col-sm-6 text-right"></div>\n    <div class="col-sm-6 text-right">\n      <!-- phase filter -->\n      <select ng-model="phaseFilter" class="form-control" id="phaseFilter">\n        <option value="" translate>--- Select phase ---</option>\n        <option ng-repeat="phase in phases" value="{{ phase.value }}">{{ phase.display_name | translate }}</option>\n      </select>\n    </div>\n  </div>\n  <div uib-collapse="!isSelectMode" class="row spacer">\n    <div class="col-sm-12 text-left">\n      <!-- delete button -->\n      <a ng-show="isSelectMode" os-perms="assignments.can_manage"\n        ng-bootbox-confirm="{{ \'Are you sure you want to delete all selected elections?\' | translate }}"\n        ng-bootbox-confirm-action="deleteMultiple()"\n        class="btn btn-primary">\n        <i class="fa fa-trash fa-lg"></i>\n        <translate>Delete selected elections</translate>\n      </a>\n    </div>\n  </div>\n\n  <div class="spacer-top-lg italic">\n    {{ assignmentsFiltered.length }} /\n    {{ assignments.length }} {{ "elections" | translate }}<span ng-if="(assignments|filter:{selected:true}).length > 0">,\n    {{(assignments|filter:{selected:true}).length}} {{ "selected" | translate }}</span>\n  </div>\n\n  <div class="os-table container-fluid">\n    <div class="row header-row">\n      <div class="col-xs-1 centered" ng-show="isSelectMode">\n        <i class="fa text-danger pointer" ng-class=" selectedAll ? \'fa-check-square-o\' : \'fa-square-o\'"\n          ng-click="checkAll()"></i>\n      </div>\n      <div class="col-xs-11 main-header">\n        <span class="form-inline text-right pull-right">\n          <!-- clear all filters -->\n          <span class="sort-spacer pointer" ng-click="filter.reset()"\n            ng-if="filter.areFiltersSet()" ng-disabled="isSelectMode"\n            ng-class="{\'disabled\': isSelectMode}">\n            <i class="fa fa-times-circle"></i>\n            <translate>Filter</translate>\n          </span>\n          <!-- Tag filter -->\n          <span uib-dropdown ng-if="tags.length > 0">\n            <span class="pointer" id="dropdownTag" uib-dropdown-toggle\n              ng-class="{\'bold\': filter.multiselectFilters.tag.length > 0, \'disabled\': isSelectMode}"\n              ng-disabled="isSelectMode">\n              <translate>Tag</translate>\n              <span class="caret"></span>\n            </span>\n            <ul class="dropdown-menu dropdown-menu-right"\n              aria-labelledby="dropdownTag">\n              <li ng-repeat="tag in tags">\n                <a href ng-click="filter.operateMultiselectFilter(\'tag\', tag.id, isSelectMode)">\n                  <i class="fa fa-check" ng-if="filter.MultiselectFilters.tag.indexOf(tag.id) > -1"></i>\n                  {{ tag.name }}\n                </a>\n              </li>\n              <li class="divider"></li>\n              <li>\n                <a href ng-click="filter.operateMultiselectFilter(\'tag\', -1, isSelectMode)">\n                  <i class="fa fa-check" ng-if="filter.multiselectFilters.tag.indexOf(-1) > -1"></i>\n                  <translate>No tag set</translate>\n                </a>\n              </li>\n            </ul>\n          </span>\n          <!-- Phase filter -->\n          <span uib-dropdown>\n            <span class="pointer" id="dropdownPhase" uib-dropdown-toggle\n              ng-class="{\'bold\': filter.multiselectFilters.phase.length > 0, \'disabled\': isSelectMode}"\n              ng-disabled="isSelectMode">\n              <translate>Phase</translate>\n              <span class="caret"></span>\n            </span>\n            <ul class="dropdown-menu dropdown-menu-right"\n              aria-labelledby="dropdownPhase">\n              <li ng-repeat="phase in phases">\n                <a href ng-click="filter.operateMultiselectFilter(\'phase\', phase.value, isSelectMode)">\n                  <i class="fa fa-check" ng-if="filter.multiselectFilters.phase.indexOf(phase.value) > -1"></i>\n                  {{ phase.display_name | translate }}\n                </a>\n              </li>\n            </ul>\n          </span>\n          <!-- dropdown sort -->\n          <span uib-dropdown>\n            <span class="pointer" id="dropdownSort" uib-dropdown-toggle\n              ng-class="{\'disabled\': isSelectMode}"\n              ng-disabled="isSelectMode">\n              <translate>Sort</translate>\n              <span class="caret"></span>\n            </span>\n            <ul class="dropdown-menu dropdown-menu-right" aria-labelledby="dropdownSort">\n              <!-- all sortOptions -->\n              <li ng-repeat="option in sortOptions">\n                <a ng-click="sort.toggle(option.name)">\n                {{ option.display_name | translate }}\n                <span class="spacer-right pull-right"></span>\n                  <i class="pull-right fa"\n                    ng-style="{\'visibility\': sort.column === option.name ? \'visible\' : \'hidden\'}"\n                    ng-class="sort.reverse ? \'fa-sort-desc\' : \'fa-sort-asc\'">\n                  </i>\n                </a>\n              </li>\n            </ul>\n          </span>\n          <!-- search field -->\n          <span class="form-group">\n            <span class="input-group">\n              <span class="input-group-addon"><i class="fa fa-search"></i></span>\n              <input type="text" ng-model="filter.filterString" class="form-control"\n                 placeholder="{{ \'Search\' | translate}}" ng-disable="isSelectMode"\n                 ng-change="filter.save()">\n            </span>\n          </span>\n\n        </span>\n          <!-- show all selected multiselectoptions -->\n          <span ng-repeat="tag in tags" class="pointer spacer-left-lg"\n            ng-if="filter.multiselectFilters.tag.indexOf(tag.id) > -1"\n            ng-click="filter.operateMultiselectFilter(\'tag\', tag.id, isSelectMode)"\n            ng-class="{\'disabled\': isSelectMode}">\n            <span class="nobr">\n              <i class="fa fa-times-circle"></i>\n              {{ tag.name }}\n            </span>\n          </span>\n          <span ng-if="filter.multiselectFilters.tag.indexOf(-1) > -1" class="pointer spacer-left-lg"\n            ng-click="filter.operateMultiselectFilter(\'tag\', -1, isSelectMode)"\n            ng-class="{\'disabled\': isSelectMode}">\n            <i class="fa fa-times-circle"></i>\n            <translate>No tag set</translate>\n          </span>\n          <span ng-repeat="phase in phases" class="pointer spacer-left-lg"\n            ng-if="filter.multiselectFilters.phase.indexOf(phase.value) > -1"\n            ng-click="filter.operateMultiselectFilter(\'phase\', phase.value, isSelectMode)"\n            ng-class="{\'disabled\': isSelectMode}">\n            <span class="nobr">\n              <i class="fa fa-times-circle"></i>\n              {{ phase.display_name | translate }}\n            </span>\n          </span>\n        <span>\n        </span>\n\n      </div>\n    </div>\n\n    <!-- main table -->\n    <div class="row data-row" ng-mouseover="assignment.hover=true"\n      ng-mouseleave="assignment.hover=false"\n      ng-class="{\'projected\': assignment.isProjected().length}"\n      ng-repeat="assignment in assignmentsFiltered = (assignments\n        | osFilter: filter.filterString : filter.getObjectQueryString\n        | MultiselectFilter: filter.multiselectFilters.tag : getItemId.tag\n        | MultiselectFilter: filter.multiselectFilters.phase : getItemId.phase\n        | orderBy: sort.column : sort.reverse)">\n      \n      <!-- select column -->\n      <div ng-show="isSelectMode" os-perms="assignments.can_manage" class="col-xs-1 centered">\n        <i class="fa text-danger pointer" ng-click="assignment.selected=!assignment.selected"\n        ng-class="assignment.selected ? \'fa-check-square-o\' : \'fa-square-o\'"></i>\n      </div>\n      <!-- projector column -->\n      <div class="col-xs-1 centered projector" os-perms="core.can_manage_projector">\n        <projector-button model="assignment", default-projector-id="defaultProjectorId">\n        </projector-button>\n      </div>\n      <div class="no-projector-spacer" os-perms="!core.can_manage_projector"></div>\n      <!-- main contant column -->\n      <div class="col-xs-6 content">\n        <div class="title-col">\n          <!-- title and phase -->\n          <div>\n            <a class="title" ui-sref="assignments.assignment.detail({id: assignment.id})">\n              {{ assignment.title }}\n            </a>\n            <span style="padding: 5px;" ng-mouseover="assignment.phaseHover=true" ng-mouseleave="assignment.phaseHover=false">\n              <span class="label" ng-class="{\'label-primary\': assignment.phase == 0,\n                                             \'label-warning\': assignment.phase == 1,\n                                             \'label-success\': assignment.phase == 2 }">\n                {{ phases[assignment.phase].display_name | translate }}\n              </span>\n              <span os-perms="assignments.can_manage" ng-class="{\'hiddenDiv\': !assignment.phaseHover}" uib-dropdown>\n                <i class="fa fa-cog pointer" uib-dropdown-toggle id="phaseDropdown{{ assignment.id }}"></i>\n                <ul uib-dropdown-menu aria-labelledby="phaseDropdown{{ assignment.id }}"\n                  class="dropdown-menu">\n                  <li ng-repeat="phase in phases">\n                    <a href>\n                      <i class="fa fa-check" ng-if="assignment.phase == phase.value"></i>\n                      <span class="pointer" ng-click="updatePhase(assignment, phase.value)">{{ phase.display_name | translate }}</a>\n                    </a>\n                  </li>\n                </ul>\n              </span>\n            </span>\n          </div>\n          <!-- hover menu -->\n          <div os-perms="assignments.can_manage" ng-class="{\'hiddenDiv\': !assignment.hover}">\n            <small>\n              <a href="" ng-click="openDialog(assignment)" translate>Edit</a> &middot;\n              <a href="" class="text-danger"\n                ng-bootbox-confirm="{{ \'Are you sure you want to delete this entry?\' | translate }}<br>\n                <b>{{ assignment.title }}</b>"\n                ng-bootbox-confirm-action="delete(assignment)" translate>Delete</a>\n            </small>\n          </div>\n        </div>\n      </div>\n\n      <!-- additional content column -->\n      <div class="col-xs-4 content" ng-style="{\'width\': isSelectMode ? \'calc(50% - 120px)\' : \'calc(50% - 70px)\'}">\n        <div style="width: 60%;" class="optional">\n          <small>\n            <!-- Tag dropdown for manage user -->\n            <div os-perms="assignments.can_manage" ng-show="tags.length > 0"\n                ng-mouseover="assignment.tagHover=true"\n                ng-mouseleave="assignment.tagHover=false">\n              <span uib-dropdown>\n                <span id="dropdownTags{{ assignment.id }}" class="pointer"\n                  uib-dropdown-toggle uib-tooltip="{{ \'Add a tag\' | translate }}"\n                  tooltip-class="nobr">\n                  <span ng-if="assignment.tags.length == 0" ng-show="assignment.hover">\n                    <i class="fa fa-tags"></i>\n                    <i class="fa fa-plus"></i>\n                  </span>\n                  <span ng-if="assignment.tags.length > 0">\n                    <i class="fa fa-tags"></i>\n                    <span ng-repeat="tag in assignment.tags">\n                      {{ tag.name }}<span ng-if="!$last">,</span>\n                    </span>\n                    <i class="fa fa-cog fa-lg spacer-left" ng-show="assignment.tagHover"></i>\n                  </span>\n                </span>\n                <ul class="dropdown-menu" aria-labelledby="dropdownTags{{ assignment.id }}">\n                  <li ng-repeat="tag in tags">\n                    <a href ng-click="toggleTag(assignment, tag)">\n                      <i class="fa fa-check" ng-if="hasTag(assignment, tag)"></i>\n                      {{ tag.name }}\n                    </a>\n                  </li>\n                </ul>\n              </span>\n            </div>\n            <!-- Tag string for normal user -->\n            <div os-perms="!assignments.can_manage" ng-show="assignment.tags.length > 0">\n              <i class="fa fa-tags spacer-right"></i>\n              <span ng-repeat="tag in assignment.tags">\n                {{ tag.name }}<span ng-if="!$last">,</span>\n              </span>\n            </div>\n          </small>\n        </div>\n\n        <div style="width: 20%;" class="pull-right nobr optional centered">\n          <span class="badge"\n            uib-tooltip="{{ assignment.assignment_related_users.length }} {{ \'Candidates\' | translate }}\n            {{ (assignment.open_posts - assignment.assignment_related_users.length) > 0 ? \'(\' +  (assignment.open_posts - assignment.assignment_related_users.length) + \' \' + (\'needed\' | translate) + \')\' : \'\' }}"\n            tooltip-class="nobr"\n            ng-class="{\'badge-info\': assignment.assignment_related_users.length < assignment.open_posts}">\n            {{ assignment.assignment_related_users.length }}\n          </span>\n        </div>\n        <div style="width: 20%;" class="pull-right nobr">\n          <div class="centered">{{ assignment.agenda_item.getItemNumberWithAncestors() }}</div>\n        </div>\n      </div>\n    </div> <!-- main table -->\n  </div> <!-- end container -->\n\n</div>\n'),n.put("static/templates/assignments/assignmentpoll-form.html",'<h1><translate>Ballot</translate> {{ ballot }}</h1>\n\n<div uib-alert ng-show="alert.show" ng-class="\'alert-\' + (alert.type || \'warning\')" ng-click="alert={}" close="alert={}">\n  {{ alert.msg }}\n</div>\n\n<p>\n  <translate>Special values</translate>:\n  <span class="badge badge-success">-1</span> = <translate>majority</translate>\n  <span class="badge">-2</span> = <translate>undocumented</translate>\n\n<form name="assignmentPollForm" ng-submit="save(model)">\n  <formly-form model="model" fields="formFields">\n    <template-hook hook-name="assignmentPollFormButtons"></template-hook>\n    <button type="submit" ng-disabled="assignmentPollForm.$invalid" class="btn btn-primary" translate>\n      Save\n    </button>\n    <button ng-click="closeThisDialog()" class="btn btn-default" translate>\n      Cancel\n    </button>\n  </formly-form>\n</form>\n'),n.put("static/templates/assignments/slide_assignment.html",'<div ng-controller="SlideAssignmentCtrl" class="content scrollcontent">\n\n  <!-- Title -->\n  <div id="title">\n    <h1>{{ assignment.agenda_item.getTitle() || assignment.title }}</h1>\n    <h2>\n      <translate>Election</translate>\n    </h2>\n  </div>\n\n  <!-- Description -->\n  <div ng-if="!showResult && assignment.description !== \'\'" class="white-space-pre-line">\n    {{ assignment.description }}\n  </div>\n\n  <!-- Candidates -->\n  <div ng-if="!showResult">\n    <h3 translate>Candidates</h3>\n    <ul>\n      <li ng-repeat="related_user in assignment.assignment_related_users">\n        {{ related_user.user.get_full_name() }}\n        <i ng-if="related_user.elected" class="fa fa-star" title="{{ \'is elected\' | translate }}"></i>\n    </ul>\n  </div>\n\n  <!-- vote results -->\n  <div ng-show="showResult" class="electionresults spacer" ng-repeat="poll in assignment.polls | filter: {id: element.poll}">\n    <table class="table table-bordered table-striped minimumTable">\n    <tr>\n      <th translate>Candidates\n      <th ng-if="poll.has_votes" class="col-sm-6" translate>Votes</th>\n\n    <!-- candidates (poll options) -->\n    <tr ng-repeat="option in poll.options">\n\n      <!-- candidate name -->\n      <td>\n        <i ng-if="option.is_elected" class="fa fa-star" title="{{ \'is elected\' | translate }}"></i>\n        <strong>{{ option.candidate.get_full_name() }}</strong>\n\n      <!-- votes -->\n      <td ng-if="poll.has_votes">\n        <div ng-init="votes = option.getVotes()">\n          <div ng-show="poll.pollmethod == \'yna\' || poll.pollmethod == \'yn\'">\n            <span ng-show="poll.pollmethod == \'yna\'">\n              {{ votes[0].label }}: <strong>{{ votes[0].value }}</strong> ·\n              {{ votes[1].label }}: {{ votes[1].value }} ·\n              {{ votes[2].label }}: {{ votes[2].value }} </span>\n            <span ng-show="poll.pollmethod == \'yn\'">\n              {{ votes[0].label }}: <strong>{{ votes[0].value }}</strong> ·\n              {{ votes[1].label }}: {{ votes[1].value }}</span>\n            <uib-progress ng-if="votes[0].percentNumber>=0">\n              <uib-bar value="votes[0].percentNumber" type="success">\n                <span ng-hide="votes[0].percentNumber < 5">{{votes[0].percentNumber}} %</span>\n              </uib-bar>\n              <uib-bar value="votes[1].percentNumber" type="danger">\n                <span ng-hide="votes[1].percentNumber < 5">{{votes[1].percentNumber}} %</span>\n              </uib-bar>\n              <uib-bar value="votes[2].percentNumber" type="warning">\n                <span ng-hide="votes[2].percentNumber < 5">{{votes[2].percentNumber}} %</span>\n              </uib-bar>\n            </uib-progress>\n          </div>\n          <div ng-show="poll.pollmethod == \'votes\'">\n            <div ng-repeat="vote in votes">\n              {{ vote.value }} {{ vote.percentStr }}\n              <div ng-if="vote.percentNumber >= 0">\n                <uib-progressbar value="vote.percentNumber" type="success"></uib-progressbar>\n              </div>\n            </div>\n          </div>\n        </div>\n\n    <!-- total votes (valid/invalid/casts) -->\n    <tr class="total">\n      <td>\n        <translate>Valid ballots</translate>\n      <td ng-if="poll.has_votes" ng-init="vote = poll.getVote(\'votesvalid\')">\n        {{ vote.value }} {{ vote.percentStr }}\n    <tr class="total">\n      <td>\n        <translate>Invalid ballots</translate>\n      <td ng-if="poll.has_votes" ng-init="vote = poll.getVote(\'votesinvalid\')">\n        {{ vote.value }} {{ vote.percentStr }}\n    <tr class="total bg-info">\n      <td>\n        <translate>Casted ballots</translate>\n      <td ng-if="poll.has_votes" ng-init="vote = poll.getVote(\'votescast\')">\n        {{ vote.value }} {{ vote.percentStr }}\n    </table>\n  </div>\n</div>\n'),n.put("static/templates/core/editor.html",'<!-- custom angular formly template for ckeditor textarea field -->\n<textarea ckeditor="options.data.ckeditorOptions" ng-model="model[options.key]" class="form-control"></textarea>'),n.put("static/templates/core/login-form.html",'<form ng-submit="login(username, password)">\n  <div class="modal-header">\n    <img src="/static/img/openslides-logo.png" alt="OpenSlides" class="login-logo center-block">\n  </div>\n  <div class="modal-body loginForm">\n    <div uib-alert ng-repeat="alert in alerts" ng-class="\'alert-\' + (alert.type || \'warning\')" close="closeAlert($index)">\n      <span ng-bind-html="alert.msg | translate"><span>\n    </div>\n    <div class="input-group form-group">\n      <div class="input-group-addon"><i class="fa fa-user"></i></div>\n      <input os-focus-me type="text" ng-model="username" class="form-control input-lg"\n          placeholder="{{ \'Username\' | translate }}">\n    </div>\n    <div class="input-group form-group">\n      <div class="input-group-addon"><i class="fa fa-key"></i></div>\n      <input type="password" ng-model="password" class="form-control input-lg"\n          placeholder="{{ \'Password\' | translate }}">\n    </div>\n    <div class="form-group">\n      <button type="submit" class="btn btn-primary" translate>\n        Login\n      </button>\n      <button ng-if="guestAllowed" ng-click="guestLogin()" class="btn btn-default" translate>\n        Continue as guest\n      </button>\n    </div>\n  </div>\n</form>\n'),n.put("static/templates/core/manage-projectors.html",'<div class="header">\n  <div class="title">\n    <div class="submenu">\n      <!-- New -->\n      <button class="btn btn-primary" ng-bootbox-prompt="{{ \'Please enter a name for the new projector\' | translate }}"\n        ng-bootbox-prompt-action="createProjector(result)">\n        <i class="fa fa-plus"></i>\n        <translate>New</translate>\n      </button>\n      <!-- Reference for current list of speakers -->\n      <div class="btn-group" uib-dropdown>\n        <button class="btn btn-default" id="menuListofSpeakers" uib-dropdown-toggle\n            uib-tooltip="{{ \'Select the projector to which the current list of speakers refers to.\' | translate }}"\n            aria-haspopup="true" aria-expanded="true">\n          <i class="fa fa-microphone"></i>\n          <translate>Reference for current list of speakers</translate>\n          <span class="caret"></span>\n        </button>\n        <ul class="dropdown-menu" uib-dropdown-menu aria-labelledby="menuListOfSpeakers">\n          <li ng-repeat="projector in projectors">\n            <a href ng-click="setListOfSpeakers(projector)">\n              <i class="fa fa-check" ng-if="projector.id == currentListOfSpeakers"></i>\n              {{ projector.name | translate }}\n            </a>\n          </li>\n        </ul>\n      </div>\n      <!-- Identity -->\n      <button class="btn" ng-click="identifyProjectors()" ng-class="identifyPromise ? \'btn-primary\' : \'btn-default\'"\n        uib-tooltip="{{ \'Display an identifier message on all projectors with the id and the name.\' | translate }}">\n        <i class="fa fa-binoculars"></i>\n        <translate>Identify</translate>\n      </button>\n    </div>\n    <h1 translate>Manage projectors</h1>\n  </div>\n</div>\n\n<div class="details">\n  <div class="projectorContainer">\n\n    <div ng-repeat="projector in projectors | orderBy: \'id\'">\n      <div>\n        <a ui-sref="projector({id: projector.id})">\n          {{ projector.id }}:\n          <strong>{{ projector.name | translate }}</strong>\n        </a>\n        <a href="" class="pull-right" ng-click="edit[projector.id] = !edit[projector.id]"><i class="fa" ng-class="edit[projector.id] ? \'fa-times\' : \'fa-pencil\'"></i></a>\n      </div>\n\n      <div ng-show="edit[projector.id]" style="margin-bottom: -20px;">\n        <div>\n          <div class="dropdown" uib-dropdown>\n            <button class="btn btn-default btn-sm" id="menuProjector{{ pr.id }}" uib-dropdown-toggle>\n              <translate>Projection defaults</translate>\n              <span class="caret"></span>\n            </button>\n            <ul class="dropdown-menu dropdown-entries" aria-labelledby="menuProjector{{ pr.id }}">\n              <li ng-repeat="projectiondefault in projectiondefaults | orderBy:\'id\'"\n                  ng-click="setProjectionDefault(projector, projectiondefault)">\n                <i class="fa fa-check" ng-if="projectiondefault.projector_id === projector.id"></i>\n                {{ projectiondefault.display_name | translate }}\n              </li>\n            </ul>\n          </div>\n          <button type="button" class="btn btn-danger btn-sm"\n            ng-hide="projector.id==1"\n            ng-bootbox-confirm="{{ \'Are you sure you want to delete this entry?\' | translate }}<br>\n            <b>{{ projector.name | translate }}</b>"\n            ng-bootbox-confirm-action="deleteProjector(projector)">\n            <i class="fa fa-trash"></i>\n            <translate>Delete</translate>\n          </button>\n          <div ng-show="projector.id==1" style="height: 30px"><!-- Placeholder --></div>\n        </div>\n        <div>\n          <label for="name{{ projector.id }}" class="control-label"><translate>Name</translate>:</label>\n          <input type="text" class="form-control" id="name{{ projector.id }}"\n            ng-model="projector.name" ng-change="editName(projector)"\n            ng-model-options="{debounce: 2000}"></input>\n        </div>\n        <div>\n          <label for="resolution{{ projector.id }}" class="control-label"><translate>Resolution</translate>:</label>\n          <div id="resolution{{ projector.id }}">\n            <input ng-model="resolutions[projector.id].width"\n                   ng-model-option="{debounce: 2000}"\n                   ng-change="changeResolution(projector.id)"\n                   class="form-control resolution"\n                   id="{{ projector.id }}_width"\n                   type="number">\n            x\n            <input ng-model="resolutions[projector.id].height"\n                   ng-model-option="{debounce: 2000}"\n                   ng-change="changeResolution(projector.id)"\n                   class="form-control resolution"\n                   id="{{ projector.id }}_height"\n                   type="number">\n          </div>\n          <p class="help-block">\n            {{ resolutions[projector.id].error }}\n          </p>\n        </div>\n      </div>\n\n      <style>\n        #iframe_{{ projector.id }} {\n            width: {{ projector.width }}px;\n            height: {{ projector.height }}px;\n            -moz-transform: scale({{ projector.iframeScale }});\n            -webkit-transform: scale({{ projector.iframeScale }});\n            -o-transform: scale({{ projector.iframeScale }});\n            transform: scale({{ projector.iframeScale }});\n            /* IE8+ - must be on one line, unfortunately */\n            -ms-filter: "progid:DXImageTransform.Microsoft.Matrix(M11={{ projector.iframeScale }}, M12=0, M21=0, M22={{ projector.iframeScale }}, SizingMethod=\'auto expand\')";\n        }\n\n        #iframewrapper_{{ projector.id }} {\n            height: {{ projector.iframeHeight }}px;\n        }\n\n        #iframeoverlay_{{ projector.id }} {\n          height: {{ projector.iframeHeight }}px;\n        }\n      </style>\n\n      <a ui-sref="projector({id: projector.id})" target="_blank">\n        <div class="iframewrapper" id="iframewrapper_{{ projector.id }}">\n          <iframe class="iframe" id="iframe_{{ projector.id }}" ng-src="{{ \'/real-projector/\' + projector.id }}" frameborder="0"></iframe>\n          <div class="iframeoverlay" id="iframeoverlay_{{ projector.id }}"></div>\n        </div>\n      </a>\n      <!-- projector control buttons -->\n      <div os-perms="core.can_manage_projector" class="nobr">\n        <!-- edit -->\n        <a ng-click="editCurrentSlide(projector)"\n            class="btn btn-default btn-sm"\n            title="{{ \'Edit current slide\' | translate}}">\n          <i class="fa fa-pencil"></i>\n        </a>\n\n        <!-- scale -->\n        <div class="btn-group">\n          <a ng-click="projector.controlProjector(\'scale\', \'down\')"\n              class="btn btn-default btn-sm"\n              title="{{ \'Smaller\' | translate}}">\n            <i class="fa fa-search-minus"></i>\n          </a>\n          <a ng-click="projector.controlProjector(\'scale\', \'up\')"\n              class="btn btn-default btn-sm"\n              title="{{ \'Bigger\' | translate}}">\n            <i class="fa fa-search-plus"></i>\n          </a>\n          <a ng-click="projector.controlProjector(\'scale\', \'reset\')"\n              class="btn btn-default btn-sm"\n              title="{{ \'Reset scaling\' | translate}}">\n            <i class="fa fa-undo"></i>\n          </a>\n        </div>\n        <span ng-class="{\'notNull\': projector.scale != 0}">{{ projector.scale }}</span>\n\n        <!-- scroll -->\n        <div class="btn-group">\n          <a ng-click="projector.controlProjector(\'scroll\', \'down\')"\n              class="btn btn-default btn-sm"\n              title="{{ \'Scroll up\' | translate}}">\n            <i class="fa fa-arrow-up"></i>\n          </a>\n          <a ng-click="projector.controlProjector(\'scroll\', \'up\')"\n              class="btn btn-default btn-sm"\n              title="{{ \'Scroll down\' | translate}}">\n            <i class="fa fa-arrow-down"></i>\n          </a>\n          <a ng-click="projector.controlProjector(\'scroll\', \'reset\')"\n              class="btn btn-default btn-sm"\n              title="{{ \'Reset scrolling\' | translate}}">\n            <i class="fa fa-undo"></i>\n          </a>\n        </div>\n        <span ng-class="{\'notNull\': projector.scroll != 0}">{{ projector.scroll }}</span>\n      </div>\n\n      <!-- Default, BC, Blank -->\n      <div class="middle">\n        <div class="btn-group">\n          <button class="btn btn-sm" ng-class="broadcast == projector.id ? \'btn-primary\' : \'btn-default\'"\n            ng-click="projector.toggleBroadcast(projector)"\n            ng-disabled="broadcast > 0 && broadcast != projector.id"\n            uib-tooltip="{{ \'Broadcast the content of this projector to all other projectors.\' | translate }}">\n            <i class="fa" ng-class="broadcast == projector.id ? \'fa-star\' : \'fa-star-o\'"></i>\n            <translate>Broadcast</translate>\n          </button>\n          <button class="btn btn-sm" ng-class="projector.blank ? \'btn-primary\' : \'btn-default\'"\n            ng-click="projector.toggleBlank(projector)"\n            ng-disabled="broadcast > 0 && broadcast != projector.id">\n            <i class="fa" ng-class="projector.blank ? \'fa-square\' : \'fa-square-o\'"></i>\n            <translate>Blank</translate>\n          </button>\n        </div>\n      </div>\n\n    </div>\n  </div>\n</div>\n'),
n.put("static/templates/core/projector-controls.html",'\n<div class="details">\n\n  <div ng-controller="ProjectorControlCtrl">\n    <!-- live view -->\n    <div class="section" os-perms="core.can_see_projector">\n      <a href="#" ng-click="isLiveViewClosed = !isLiveViewClosed">\n        <i class="fa toggle-icon" ng-class="isLiveViewClosed ? \'fa-angle-down\' : \'fa-angle-up\'"></i>\n        <h4 translate>Live view</h4>\n      </a>\n      <div uib-collapse="isLiveViewClosed" ng-cloak>\n        <style>\n          .col2 #iframe_sidebar {\n              width: {{ active_projector.width }}px;\n              height: {{ active_projector.height }}px;\n              -moz-transform: scale({{ scale }});\n              -webkit-transform: scale({{ scale }});\n              -o-transform: scale({{ scale }});\n              transform: scale({{ scale }});\n              /* IE8+ - must be on one line, unfortunately */\n              -ms-filter: "progid:DXImageTransform.Microsoft.Matrix(M11={{ scale }}, M12=0, M21=0, M22={{ scale }}, SizingMethod=\'auto expand\')";\n          }\n\n          .col2 #iframewrapper_sidebar {\n              height: {{ iframeHeight }}px;\n          }\n\n          .col2 #iframeoverlay_sidebar {\n            height: {{ iframeHeight }}px;\n          }\n        </style>\n        <div class="projectorSelector">\n          <div>\n            <div ng-show="projectors.length > 1" uib-dropdown>\n              <button class="btn btn-default btn-sm dropdown-toggle" id="menuProjector" data-toggle="dropdown"\n                aria-haspopup="true" aria-expanded="true">\n                {{ active_projector.name | translate }}\n                <span class="caret"></span>\n              </button>\n              <ul class="dropdown-menu dropdown-entries" aria-labelledby="menuProjector">\n                <li ng-repeat="projector in projectors">\n                  <a href ng-class="{\'projected\': projector === active_projector}"\n                    ng-click="changeProjector(projector)">\n                    <i ng-show="projector === active_projector" class="fa fa-check"></i>\n                    {{ projector.name | translate }}\n                    <i ng-show="projector.id == broadcast" class="fa fa-star-o spacer-left"></i>\n                  </a>\n                </li>\n              </ul>\n            </div>\n            <div>\n              <button class="btn btn-sm" ng-click="active_projector.toggleBlank()" ng-hide="projectors.length > 1"\n                ng-class="active_projector.blank ? \'btn-primary\' : \'btn-default\'">\n                <i class="fa" ng-class="active_projector.blank ? \'fa-square\' : \'fa-square-o\'"></i>\n                <translate>Blank</translate>\n              </button>\n            </div>\n            <a class="btn btn-primary btn-sm manageBtn" ui-sref="manage-projectors">\n              <i class="fa fa-cog fa-lg"></i>\n              <translate>Manage</translate>\n            </a>\n          </div>\n\n          <div class="btn-group" ng-show="projectors.length > 1">\n            <button class="btn btn-sm" ng-class="broadcast == active_projector.id ? \'btn-primary\' : \'btn-default\'"\n              ng-click="active_projector.toggleBroadcast()" ng-disabled="broadcast > 0 && broadcast != active_projector.id">\n              <i class="fa" ng-class="broadcast == active_projector.id ? \'fa-star\' : \'fa-star-o\'"></i>\n              <translate>Broadcast</translate>\n            </button>\n            <button class="btn btn-sm" ng-click="active_projector.toggleBlank()"\n              ng-class="active_projector.blank ? \'btn-primary\' : \'btn-default\'"\n              ng-disabled="broadcast > 0 && broadcast != active_projector.id">\n              <i class="fa" ng-class="active_projector.blank ? \'fa-square\' : \'fa-square-o\'"></i>\n              <translate>Blank</translate>\n            </button>\n          </div>\n        </div>\n\n        <a ui-sref="projector({id: active_projector.id })" target="_blank">\n          <div class="iframewrapper" id="iframewrapper_sidebar">\n            <iframe class="iframe" id="iframe_sidebar" ng-src="{{ \'/real-projector/\' + active_projector.id }}" frameborder="0"></iframe>\n            <div class="iframeoverlay" id="iframeoverlay_sidebar"></div>\n          </div>\n        </a>\n        <!-- projector control buttons -->\n        <div os-perms="core.can_manage_projector" class="nobr">\n          <!-- edit -->\n          <a ng-click="editCurrentSlide(active_projector)"\n              class="btn btn-default btn-sm"\n              title="{{ \'Edit current slide\' | translate}}">\n            <i class="fa fa-pencil"></i>\n          </a>\n\n          <!-- scale -->\n          <div class="btn-group">\n            <a ng-click="active_projector.controlProjector(\'scale\', \'down\')"\n                class="btn btn-default btn-sm"\n                title="{{ \'Smaller\' | translate}}">\n              <i class="fa fa-search-minus"></i>\n            </a>\n            <a ng-click="active_projector.controlProjector(\'scale\', \'up\')"\n                class="btn btn-default btn-sm"\n                title="{{ \'Bigger\' | translate}}">\n              <i class="fa fa-search-plus"></i>\n            </a>\n            <a ng-click="active_projector.controlProjector(\'scale\', \'reset\')"\n                class="btn btn-default btn-sm"\n                title="{{ \'Reset scaling\' | translate}}">\n              <i class="fa fa-undo"></i>\n            </a>\n          </div>\n          <span ng-class="{ \'notNull\': active_projector.scale != 0 }">{{ active_projector.scale }}</span>\n\n          <!-- scroll -->\n          <div class="btn-group">\n            <a ng-click="active_projector.controlProjector(\'scroll\', \'down\')"\n                class="btn btn-default btn-sm"\n                title="{{ \'Scroll up\' | translate}}">\n              <i class="fa fa-arrow-up"></i>\n            </a>\n            <a ng-click="active_projector.controlProjector(\'scroll\', \'up\')"\n                class="btn btn-default btn-sm"\n                title="{{ \'Scroll down\' | translate}}">\n              <i class="fa fa-arrow-down"></i>\n            </a>\n            <a ng-click="active_projector.controlProjector(\'scroll\', \'reset\')"\n                class="btn btn-default btn-sm"\n                title="{{ \'Reset scrolling\' | translate}}">\n              <i class="fa fa-undo"></i>\n            </a>\n          </div>\n          <span ng-class="{ \'notNull\': active_projector.scroll != 0 }">{{ active_projector.scroll }}</span>\n        </div>\n      </div>\n    </div>\n\n    <!-- countdowns -->\n    <div class="section" os-perms="core.can_manage_projector">\n      <a href="#" ng-click="isCountdowns = !isCountdowns">\n        <i class="fa toggle-icon" ng-class="isCountdowns ? \'fa-angle-up\' : \'fa-angle-down\'"></i>\n        <h4 translate>Countdowns</h4>\n      </a>\n      <div uib-collapse="!isCountdowns" ng-cloak>\n        <div ng-repeat="countdown in countdowns | orderBy: \'index\'" id="countdown{{countdown.id}}" class="countdown panel panel-default">\n          <div class="panel-heading">\n            <span ng-if="countdown.description">{{ countdown.description }}</span>\n            <span ng-if="!countdown.description">Countdown {{ $index +1 }}</span>\n            <!-- remove countdown button -->\n            <button type="button" class="close"\n                ng-click="removeCountdown(countdown)"\n                title="{{ \'Remove countdown\' | translate}}">\n                <i class="fa fa-times"></i>\n            </button>\n            <!-- edit countdown button -->\n            <button type="button" class="close editicon"\n                ng-click="countdown.editFlag=true; countdown.new_description = countdown.description;"\n                title="{{ \'Edit countdown\' | translate}}">\n                <i class="fa fa-pencil"></i>\n            </button>\n          </div>\n          <div class="panel-body"\n            ng-class="{ \'projected\': isProjected(countdown).length }">\n            <projector-button model="countdown" default-projector-id="countdownDefaultProjectorId"></projector-button>\n            &nbsp;&nbsp;\n            <!-- countdown controls -->\n            <a class="btn btn-default vcenter"\n                ng-click="countdown.reset()"\n                ng-class="{ \'disabled\': !countdown.running && countdown.default_time == countdown.countdown_time }"\n                title="{{ \'Reset countdown\' | translate}}">\n              <i class="fa fa-stop"></i>\n            </a>\n            <a ng-if="!countdown.running" class="btn btn-default vcenter"\n                ng-click="countdown.start()"\n                title="{{ \'Start\' | translate}}">\n              <i  class="fa fa-play"></i>\n              <i ng-if="countdown.running" class="fa fa-pause"></i>\n            </a>\n            <a ng-if="countdown.running" class="btn btn-default vcenter"\n                ng-click="countdown.stop()"\n                title="{{ \'Pause\' | translate}}">\n              <i  class="fa fa-pause"></i>\n            </a>\n            <span ng-if="!countdown.editTime" class="countdown_timer vcenter"\n                  ng-class="{\n                    \'negative\': countdown.seconds <= 0,\n                    \'warning\': countdown.seconds <= config(\'agenda_countdown_warning_time\') && countdown.seconds > 0 }">\n                {{ countdown.seconds | osSecondsToTime }}\n            </span>\n            <!-- edit countdown form -->\n            <form ng-show="countdown.editFlag"\n              ng-submit="editCountdown(countdown)">\n              <div class="form-group">\n                <label translate>Description</label>\n                <input ng-model="countdown.new_description" type="text" class="form-control input-sm">\n              </div>\n              <div class="form-group">\n                <label translate>Start time</label>\n                <div class="input-group">\n                  <input data-ng-model="countdown.default_time" min-sec-format\n                    type="text" placeholder="mm:ss" class="form-control input-sm">\n                </div>\n              </div>\n              <button type="submit" title="{{ \'Save\' | translate}}"\n                  class="btn btn-sm btn-primary">\n                <i class="fa fa-check"></i>\n              </button>\n              <button ng-click="countdown.editFlag=false;"\n                  title="{{ \'Cancel\' | translate}}"\n                  class="btn btn-default btn-sm">\n                <i class="fa fa-times"></i>\n              </button>\n            </form>\n          </div>\n        </div>\n        <!-- Add countdown button -->\n        <a ng-click="addCountdown()"\n            class="btn btn-default btn-sm"\n            title="{{ \'Add countdown\' | translate}}">\n          <i class="fa fa-plus"></i> <translate>Add new countdown</translate>\n        </a>\n      </div>\n    </div>\n\n    <!-- messages -->\n    <div class="section" os-perms="core.can_manage_projector">\n      <a href="#" ng-click="isMessages = !isMessages">\n        <i class="fa toggle-icon" ng-class="isMessages ? \'fa-angle-up\' : \'fa-angle-down\'"></i>\n        <h4 translate>Messages</h4>\n      </a>\n      <div uib-collapse="!isMessages" ng-cloak>\n        <div ng-repeat="message in messages" id="message{{message.id}}" class="message panel panel-default">\n\n          <div class="panel-heading">\n              <span>{{ \'Message\' | translate }} {{ $index + 1 }}</span>\n            <!-- remove message button -->\n            <button type="button" class="close"\n              ng-click="removeMessage(message)"\n              title="{{ \'Remove message\' | translate}}">\n              <i class="fa fa-times"></i>\n            </button>\n            <button type="button" class="close editicon"\n              ng-click="message.editFlag=true"\n              title="{{ \'Edit message\' | translate}}">\n              <i class="fa fa-pencil"></i>\n            </button>\n          </div>\n\n          <div class="panel-body"\n              ng-class="{ \'projected\': isProjected(message).length }">\n            <projector-button model="message" default-projector-id="messageDefaultProjectorId"></projector-button>\n            &nbsp;&nbsp;\n            <div class="innermessage" ng-bind-html="message.message"> </div>\n\n            <div class="panel-input">\n              <div ng-if="message.editFlag" class="input-group">\n                <input ng-model="message.message" type="text" class="form-control input-sm">\n                <a ng-click="editMessage(message)"\n                  title="{{ \'Save\' | translate}}"\n                  class="btn btn-sm btn-primary input-group-addon">\n                  <i class="fa fa-check"></i>\n                </a>\n              </div>\n            </div>\n          </div>\n        </div>\n        <!-- Add message button -->\n        <a ng-click="addMessage()"\n            class="btn btn-default btn-sm"\n            title="{{ \'Add message\' | translate}}">\n          <i class="fa fa-plus"></i> <translate>Add new message</translate>\n        </a>\n      </div>\n    </div>\n    <!-- list of speakers overlay -->\n    <div class="section" os-perms="core.can_manage_projector">\n      <a href="#" ng-click="isSpeakerList = !isSpeakerList">\n        <i class="fa toggle-icon" ng-class="isSpeakerList ? \'fa-angle-up\' : \'fa-angle-down\'"></i>\n        <h4 translate>List of speakers</h4>\n      </a>\n      <div uib-collapse="!isSpeakerList" ng-cloak>\n        <projector-button model="listofspeakers" default-projector-id="listOfSpeakersDefaultProjectorId">\n        </projector-button>\n        <div class="btn-group" os-perms="agenda.can_manage">\n          <a ng-click="goToListOfSpeakers()" class="btn btn-default btn-sm"\n            title="{{ \'Manage current list of speakers\' | translate}}">\n            <i class="fa fa-microphone"></i>\n          </a>\n        </div>\n      </div>\n    </div>\n  </div><!-- end div ProjectorControlCtrl -->\n\n</div>\n'),n.put("static/templates/core/radio-buttons.html",'<div class="btn-group" data-toggle="buttons">\n    <label ng-repeat="(key, option) in to.options" ng-click="model[options.key] = option.value;"\n           class="btn btn-default btn-sm" ng-class="{active: (model[options.key] == option.value)}">\n        <input type="radio" tabindex="0" ng-value="option.value" ng-model="model[options.key]">{{option.name}}\n    </label>\n</div>\n'),n.put("static/templates/core/select-multiple.html",'<!-- custom angular formly template for angular-chosen multiple form field -->\n<select multiple chosen\n    data-ng-model="model[options.key]"\n    ng-required="{{ to.required }}"\n    ng-options="{{ to.ngOptions }}"\n    search-contains="true"\n    placeholder-text-multiple="\'{{ to.placeholder }}\'"\n    no-results-text="\'No results available ...\' | translate"\n    class="form-control">\n</select>\n'),n.put("static/templates/core/select-single.html",'<!-- custom angular formly template for angular-chosen single form field -->\n<select chosen\n    data-ng-model="model[options.key]"\n    ng-required="{{ to.required }}"\n    ng-options="{{ to.ngOptions }}"\n    allow-single-deselect="true"\n    search-contains="true"\n    placeholder-text-single="\'{{ to.placeholder }}\'"\n    no-results-text="\'No results available ...\' | translate"\n    class="form-control">\n  <option value=""></option>\n</select>\n'),n.put("static/templates/core/slide_clock.html",'<div ng-controller="SlideClockCtrl" id="currentTime">\n  <i class="fa fa-clock-o"></i>\n  {{ servertime | date:\'HH:mm\' }}\n</div>\n'),n.put("static/templates/core/slide_countdown.html",'<div ng-controller="SlideCountdownCtrl">\n  <div class="countdown well pull-right"\n      ng-class="{\n        \'negative\': countdown.seconds <= 0,\n        \'warning\': countdown.seconds <= config(\'agenda_countdown_warning_time\') && countdown.seconds > 0 }">\n    {{ countdown.seconds | osSecondsToTime}}\n    <div class="description">{{ countdown.description }}</div>\n  </div>\n</div>\n'),n.put("static/templates/core/slide_message.html",'<div ng-controller="SlideMessageCtrl">\n  <div class="message_background"></div>\n  <div class="message well" ng-class="{\'identify\': element.identify}" ng-bind-html="element.identify ? identifyMessage : message.message"></div>\n</div>\n'),n.put("static/templates/core/tag-detail.html",'<div class="header">\n  <div class="title">\n    <div class="submenu">\n      <a ui-sref="core.tag.list" class="btn btn-sm btn-default">\n        <i class="fa fa-angle-double-left fa-lg"></i>\n        <translate>Back to overview</translate>\n      </a>\n    </div>\n    <h1>{{ tag.name }}</h1>\n    <h2 translate>Tag</h2>\n  </div>\n</div>\n\n<div class="details"></div>\n'),n.put("static/templates/core/tag-form.html",'<div class="header">\n  <div class="title">\n    <div class="submenu">\n      <a ui-sref="core.tag.list" class="btn btn-sm btn-default">\n        <i class="fa fa-angle-double-left fa-lg"></i>\n        <translate>Back to overview</translate>\n      </a>\n    </div>\n    <h1 ng-if="tag.id" translate>Edit tag</h1>\n    <h1 ng-if="!tag.id" translate>New tag</h1>\n  </div>\n</div>\n\n<div class="details">\n<form name="tagForm">\n  <div class="form-group">\n    <label for="inputName" translate>Name</label>\n    <input type="text" ng-model="tag.name" class="form-control" name="inputName" required>\n  </div>\n\n  <button type="submit" ng-click="save(tag)" class="btn btn-primary" translate>\n    Save\n  </button>\n  <button ui-sref="core.tag.list" class="btn btn-default" translate>\n    Cancel\n  </button>\n</form>\n</div>\n'),n.put("static/templates/core/tag-list.html",'<div class="header">\n  <div class="title">\n    <div class="submenu">\n      <a href="javascript:history.back()" class="btn btn-sm btn-default">\n        <i class="fa fa-angle-double-left fa-lg"></i>\n        <translate>Back to overview</translate>\n      </a>\n      <a ui-sref="core.tag.create" os-perms="core.can_manage_tags" class="btn btn-primary btn-sm">\n        <i class="fa fa-plus fa-lg"></i>\n        <translate>New</translate>\n      </a>\n    </div>\n    <h1 translate>Tags</h1>\n  </div>\n</div>\n\n<div class="details">\n  <div class="row form-group">\n    <div class="col-sm-8"></div>\n    <div class="col-sm-4">\n      <input type="text" ng-model="filter.search" class="form-control"\n          placeholder="{{ \'Filter\' | translate}}">\n    </div>\n  </div>\n\n  <table os-perms="core.can_manage_tags" class="table table-striped table-bordered table-hover">\n    <thead>\n      <tr>\n        <th ng-click="toggleSort(\'name\')" class="sortable">\n          <translate>Name</translate>\n          <i class="pull-right fa" ng-show="sortColumn === \'name\' && header.sortable != false"\n              ng-class="reverse ? \'fa-sort-desc\' : \'fa-sort-asc\'">\n          </i>\n    <tbody>\n      <tr ng-repeat="tag in tags | filter: filter.search |\n          orderBy: sortColumn:reverse">\n        <td ng-mouseover="tag.hover=true" ng-mouseleave="tag.hover=false">\n          <strong>{{ tag.name }}</strong>\n          <div class="hoverActions" ng-class="{\'hiddenDiv\': !tag.hover}">\n            <a ui-sref="core.tag.detail.update({id: tag.id })" translate>Edit</a> |\n            <a href="" class="text-danger"\n              ng-bootbox-confirm="{{ \'Are you sure you want to delete this entry?\' | translate }}<br>\n              <b>{{ tag.name }}</b>"\n              ng-bootbox-confirm-action="delete(tag)" translate>Delete</a>\n          </div>\n  </table>\n</div>\n'),n.put("static/templates/mediafiles/mediafile-form.html",'<h1 ng-if="mediafile.id" translate>Edit file</h1>\n<h1 ng-if="!mediafile.id" translate>New file</h1>\n\n<div uib-alert ng-show="alert.show" ng-class="\'alert-\' + (alert.type || \'warning\')" ng-click="alert={}" close="alert={}">\n  {{ alert.msg }}\n</div>\n\n<form name="mediafileForm" ng-submit="save(mediafile)">\n  <!-- file -->\n  <div class="form-group">\n    <label for="inputTitle"><translate>File</translate>*</label>\n    <!-- create view: show file select field -->\n    <input ng-if="!mediafile.id" type="file" ngf-select ng-model="mediafile.newFile" required>\n    <!-- update view: show filename only -->\n    <div ng-if="mediafile.id">{{ mediafile.filename }}</div>\n  </div>\n\n  <!-- title -->\n  <div class="form-group">\n    <label for="inputTitle" translate>Title</label>\n    <input type="text" ng-model="mediafile.title" class="form-control" name="inputTitle">\n  </div>\n\n  <!-- hidden -->\n  <div class="checkbox" os-perms="mediafiles.can_see_hidden">\n    <label>\n      <input class="formly-field-chackbox" type="checkbox" ng-model="mediafile.hidden" name="inputHidden">\n      <translate>Hidden</translate>\n    </label>\n    <p class="help-block" translate>\n      This does not protect the file but hides it for non authorized users.\n    </p>\n  </div>\n\n  <!-- uploader -->\n  <div os-perms="mediafiles.can_manage" class="form-group">\n    <label for="inputTitle" translate>Uploaded by</label>\n    <select chosen\n        ng-model="mediafile.uploader_id"\n        ng-options="user.id as user.get_full_name() for user in users"\n        allow-single-deselect="true"\n        search-contains="true"\n        placeholder-text-single="\'Select or search a participant ...\' | translate"\n        no-results-text="\'No results available ...\' | translate"\n        class="form-control">\n      <option value=""></option>\n    <select>\n  </div>\n\n  <i ng-if="mediafile.file.$error.maxSize">File too large\n    {{ picFile.size / 1000000|number:1}}MB: max {{ mediafile.mediafile.$errorParam}}</i>\n\n  <button type="submit" ng-disabled="mediafileForm.$invalid" class="btn btn-primary" translate>\n    Save\n  </button>\n  <button type="button" ng-click="closeThisDialog()" class="btn btn-default" translate>\n    Cancel\n  </button>\n</form>\n'),n.put("static/templates/mediafiles/mediafile-list.html",'<div class="header">\n  <div class="title">\n    <div class="submenu">\n      <a  ng-click="openDialog()" os-perms="mediafiles.can_upload" class="btn btn-primary btn-sm">\n        <i class="fa fa-plus fa-lg"></i>\n        <translate>New</translate>\n      </a>\n    </div>\n    <h1 translate>Files</h1>\n  </div>\n</div>\n\n<div class="meta" os-perms="core.can_manage_projector">\n  <div class="title" ng-click="isMeta = !isMeta">\n    <div class="name">\n      <i class="fa fa-play-circle"></i>\n      <translate>Presentation control elements</translate>\n    </div>\n    <div class="icon">\n      <i class="fa fa-lg" ng-class="isMeta ? \'fa-angle-down\' : \'fa-angle-up\'"></i>\n    </div>\n  </div>\n  <div class="detail" uib-collapse="isMeta">\n    <!-- mediafile pdf controls -->\n    <div class="row">\n      <div class="col-md-12">\n        <div ng-repeat="presentedMediafile in presentedMediafiles">\n          <h3>{{ getTitle(presentedMediafile) }}</h3>\n          <!-- PDF -->\n          <nav ng-show="getType(presentedMediafile) === \'pdf\'" ng-class="getNavStyle(scroll)" class="form-inline">\n            <div class="btn-group">\n              <button class="btn btn-default" ng-click="mediafileGoToPage(presentedMediafile, presentedMediafile.page - 1)"\n                  ng-class="{ \'disabled\': (presentedMediafile.page - 1) < 1 }"\n                  title="{{ \'Previous page\' | translate }}">\n                <i class="fa fa-backward"></i>\n              </button>\n              <button class="btn btn-default" ng-click="mediafileGoToPage(presentedMediafile, presentedMediafile.page + 1)"\n                  ng-class="{ \'disabled\': (presentedMediafile.page + 1) > presentedMediafile.numPages }"\n                  title="{{ \'Next page\' | translate }}">\n                <i class="fa fa-forward"></i>\n              </button>\n            </div>\n            <div class="input-group">\n              <span class="input-group-addon" translate>Page</span>\n              <input type="number" min=1 ng-model="presentedMediafile.page" class="form-control" style="width: 80px"\n                  ng-change="mediafileGoToPage(presentedMediafile, presentedMediafile.page)">\n              <span class="input-group-addon"><translate>of</translate> {{presentedMediafile.numPages}}</span>\n            </div>\n            <div class="btn-group">\n              <button class="btn btn-default" ng-click="mediafileRotate(presentedMediafile)"\n                  title="{{ \'Rotate clockwise\' | translate }}">\n                <i class="fa fa-repeat"></i>\n              </button>\n            </div>\n            <div class="btn-group">\n              <button class="btn btn-default" ng-click="mediafileZoomOut(presentedMediafile)"\n                  title="{{ \'Zoom out\' | translate }}">\n                <i class="fa fa-search-minus"></i>\n              </button>\n              <button class="btn" ng-click="mediafileFit(presentedMediafile)"\n                  title="{{ \'Reset zoom\' | translate }}"\n                  ng-class="presentedMediafile.scale==\'page-fit\' ? \'btn-primary\' : \'btn-default\'">\n                <i class="fa fa-arrows-alt"></i>\n              </button>\n              <button class="btn btn-default" ng-click="mediafileZoomIn(presentedMediafile)"\n                  title="{{ \'Zoom in\' | translate }}">\n                <i class="fa fa-search-plus"></i>\n              </button>\n            </div>\n          </nav>\n\n          <!-- Image -->\n          <nav ng-show="getType(presentedMediafile) === \'image\'" ng-class="getNavStyle(scroll)" class="form-inline">\n            <div class="btn-group">\n              <button class="btn btn-default" ng-click="mediafileToggleFullscreen(presentedMediafile)"\n                  title="{{ \'Toggle fullscreen\' | translate }}"\n                  ng-class="presentedMediafile.fullscreen ? \'btn-primary\' : \'btn-default\'">\n                <i class="fa fa-arrows-alt"></i>\n              </button>\n            </div>\n            <div class="btn-group">\n              <button class="btn btn-default" ng-click="mediafileRotate(presentedMediafile)"\n                  title="{{ \'Rotate clockwise\' | translate }}">\n                <i class="fa fa-repeat"></i>\n              </button>\n            </div>\n          </nav>\n\n          <!-- Video -->\n          <nav ng-show="getType(presentedMediafile) === \'video\'" ng-class="getNavStyle(scroll)" class="form-inline">\n            <div class="btn-group">\n              <button class="btn btn-default" ng-click="mediafileToggleFullscreen(presentedMediafile)"\n                  title="{{ \'Toggle fullscreen\' | translate }}"\n                  ng-class="presentedMediafile.fullscreen ? \'btn-primary\' : \'btn-default\'">\n                <i class="fa fa-arrows-alt"></i>\n              </button>\n            </div>\n            <div class="btn-group">\n              <button class="btn btn-default" ng-click="mediafileTogglePlaying(presentedMediafile)"\n                  title="{{ \'Start/stop video\' | translate }}">\n                <i class="fa" ng-class="presentedMediafile.playing ? \'fa-stop\' : \'fa-play\'"></i>\n              </button>\n            </div>\n          </nav>\n        </div>\n        <div ng-show="!presentedMediafiles.length" class="spacer">\n          <i translate>No media file projected.</i>\n        </div>\n      </div>\n    </div>\n  </div>\n</div>\n\n<div class="details">\n  <div class="row form-group">\n    <div class="col-sm-6">\n      <form class="form-inline">\n        <!-- select mode -->\n        <button os-perms="mediafiles.can_manage" class="btn"\n            ng-class="$parent.isSelectMode ? \'btn-primary\' : \'btn-default\'"\n            ng-click="$parent.isSelectMode = !$parent.isSelectMode; uncheckAll()">\n          <i class="fa fa-check-square-o"></i>\n          <translate>Select ...</translate>\n        </button>\n      </form>\n    </div>\n    <div class="col-sm-6"></div>\n  </div>\n  <div uib-collapse="!isSelectMode" class="row spacer">\n    <div class="col-sm-12 text-left">\n      <!-- delete button -->\n      <a ng-show="isSelectMode"\n          os-perms="mediafiles.can_manage" ng-click="deleteMultiple()"\n          class="btn btn-primary">\n        <i class="fa fa-trash fa-lg"></i>\n        <translate>Delete selected mediafiles</translate>\n      </a>\n    </div>\n  </div>\n\n  <div class="spacer-top-lg italic">\n    {{ mediafilesFiltered.length }} /\n    {{ mediafiles.length }} {{ "files" | translate }}<span ng-if="(mediafiles|filter:{selected:true}).length > 0">,\n    {{(mediafiles|filter:{selected:true}).length}} {{ "selected" | translate }}</span>\n  </div>\n\n  <div class="os-table container-fluid">\n    <div class="row header-row">\n      <div class="col-xs-1 centered" ng-show="isSelectMode" os-perms="mediafiles.can_manage">\n        <i class="fa text-danger pointer" ng-class="selectedAll ? \'fa-check-square-o\' : \'fa-square-o\'"\n          ng-click="checkAll()"></i>\n      </div>\n      <div class="col-xs-11 main-header">\n        <span class="form-inline text-right pull-right">\n          <!-- reset Filters -->\n          <span class="sort-spacer pointer" ng-click="filter.reset()"\n            ng-if="filter.areFiltersSet()" ng-disabled="isSelectMode"\n            ng-class="{\'disabled\': isSelectMode}">\n            <i class="fa fa-times-circle"></i>\n            <translate>Filter</translate>\n          </span>\n          <!-- boolean Filters -->\n          <span ng-repeat="(name, booleanFilter) in filter.booleanFilters"\n            ng-if="!booleanFilter.needExtraPermission || operator.hasPerms(\'mediafiles.can_see_hidden\')" uib-dropdown>\n            <span class="pointer" id="dropdown{{ name }}" uib-dropdown-toggle\n              ng-class="{\'bold\': booleanFilter.value !== undefined, \'disabled\': isSelectMode}"\n              ng-disabled="isSelectMode">\n              {{ booleanFilter.displayName | translate }}\n              <span class="caret"></span>\n            </span>\n            <ul class="dropdown-menu dropdown-menu-right" aria-labelledby="dropdown{{ name }}">\n              <li>\n                <a href ng-click="booleanFilter.value = (booleanFilter.value ? undefined : true); filter.save();">\n                  <i class="fa" ng-class="{\'fa-check\': booleanFilter.value === true}"></i>\n                  {{ booleanFilter.choiceYes | translate }}\n                </a>\n              </li>\n              <li>\n                <a href ng-click="booleanFilter.value = (booleanFilter.value === false) ? undefined : false; filter.save();">\n                  <i class="fa" ng-class="{\'fa-check\': booleanFilter.value === false}"></i>\n                  {{ booleanFilter.choiceNo | translate }}\n                </a>\n              </li>\n            </ul>\n          </span>\n          <!-- dropdown sort -->\n          <span uib-dropdown>\n            <span class="pointer" id="dropdownSort" uib-dropdown-toggle\n              ng-class="{\'disabled\': isSelectMode}"\n              ng-disabled="isSelectMode">\n              <translate>Sort</translate>\n              <span class="caret"></span>\n            </span>\n            <ul class="dropdown-menu dropdown-menu-right" aria-labelledby="dropdownSort">\n              <li ng-repeat="option in sortOptions">\n                <a href ng-click="sort.toggle(option.name)">\n                  {{ option.display_name | translate }}\n                  <span class="spacer-right pull-right"></span>\n                  <i class="pull-right fa"\n                    ng-style="{\'visibility\': sort.column === option.name ? \'visible\' : \'hidden\'}"\n                    ng-class="sort.reverse ? \'fa-sort-desc\' : \'fa-sort-asc\'">\n                  </i>\n                </a>\n              </li>\n            </ul>\n          </span>\n          <!-- search field -->\n          <span class="form-group">\n            <span class="input-group">\n              <span class="input-group-addon"><i class="fa fa-search"></i></span>\n              <input type="text" ng-model="filter.filterString" class="form-control"\n                 placeholder="{{ \'Search\' | translate}}" ng-disabled="isSelectMode"\n                 ng-change="filter.save()">\n            </span>\n          </span>\n        </span>\n        <!-- show all selected multiselectoptions -->\n        <span>\n          <!-- for all boolean Filters -->\n          <span ng-repeat="(name, booleanFilter) in filter.booleanFilters"\n            ng-hide="booleanFilter.value === undefined"\n            class="pointer spacer-left-lg"\n            ng-click="booleanFilter.value = undefined; filter.save();"\n            ng-class="{\'disabled\': isSelectMode}">\n            <span class="nobr">\n              <i class="fa fa-times-circle"></i>\n              {{ booleanFilter.value ? booleanFilter.choiceYes : booleanFilter.choiceNo | translate }}\n            </span>\n          </span>\n        </span>\n      </div>\n    </div>\n\n    <!-- main table -->\n    <div class="row data-row" ng-mouseover="mediafile.hover=true"\n      ng-mouseleave="mediafile.hover=false"\n      ng-class="{\'projected\': mediafile.isProjected().length}"\n      ng-repeat="mediafile in mediafilesFiltered = (mediafiles\n      | hiddenFilter\n      | osFilter: filter.filterString : filter.getObjectQueryString\n      | filter: {filetype: (filter.booleanFilters.isPdf.value ? \'application/pdf\' : (filter.booleanFilters.isPdf.value === false ? \'!application/pdf\' : \'\'))}\n      | filter: {hidden: filter.booleanFilters.isHidden.value}\n      | orderBy: sort.column : sort.reverse )">\n\n      <!-- select column -->\n      <div ng-show="isSelectMode" os-perms="mediafiles.can_manage" class="col-xs-1 centered">\n        <i class="fa text-danger pointer" ng-click="mediafile.selected=!mediafile.selected"\n        ng-class="mediafile.selected ? \'fa-check-square-o\' : \'fa-square-o\'"></i>\n      </div>\n      <!-- projector column -->\n      <div class="col-xs-1 centered projector" os-perms="core.can_manage_projector">\n        <div class="btn-group" style="min-width:{{ projectors.length > 1 ? \'54\' : \'34\' }}px;" uib-dropdown\n          ng-if="mediafile.is_presentable"\n          uib-tooltip="{{ \'Projector\' | translate }} {{ mediafile.isProjected()[0] || \'\' }}"\n          tooltip-enable="mediafile.isProjected().length">\n          <button type="button" class="btn btn-default btn-sm"\n            ng-click="showMediafile(defaultProjectorId, mediafile)"\n            ng-class="{ \'btn-primary\': inArray(mediafile.isProjected(), defaultProjectorId)  }">\n            <i class="fa fa-video-camera"></i>\n          </button>\n          <button type="button" class="btn btn-default btn-sm slimDropDown"\n            ng-class="{ \'btn-primary\': (mediafile.isProjected().length && !inArray(mediafile.isProjected(), defaultProjectorId) ) }"\n            ng-if="projectors.length > 1"\n            uib-dropdown-toggle>\n            <span class="caret"></span>\n          </button>\n          <ul class="dropdown-menu" ng-if="projectors.length > 1">\n            <li role="menuitem" ng-repeat="projector in projectors">\n              <a href="" ng-click="showMediafile(projector.id, mediafile)"\n                ng-class="{ \'projected\': inArray(mediafile.isProjected(), projector.id)  }">\n                <i class="fa fa-video-camera" ng-show="inArray(mediafile.isProjected(), projector.id) "></i>\n                {{ projector.name | translate }}\n                <span ng-if="defaultProjectorId == projector.id">(<translate>Default</translate>)</span>\n              </a>\n            </li>\n          </ul>\n        </div>\n      </div>\n      <div class="no-projector-spacer" os-perms="!core.can_manage_projector"></div>\n      <!-- main content column -->\n      <div class="col-xs-6 content">\n        <div class="spacer-right"> <!-- horizontal block -->\n          <i ng-style="{\'visibility\': mediafile.hidden ? \'visible\' : \'hidden\'}" class="fa fa-lock fa-lg"\n              title="{{ \'Is hidden\' | translate }}"></i>\n        </div>\n        <div>\n          <div> <!-- vertical block -->\n            <a ng-href="{{ mediafile.mediafileUrl }}" class="title" target="_blank">{{ mediafile.title_or_filename }}</a>\n          </div>\n          <div><small>{{ mediafile.uploader.get_full_name() }}</small></div>\n          <div os-perms="mediafiles.can_manage" ng-class="{\'hiddenDiv\': !mediafile.hover}">\n            <small>\n              <a href="" ng-click="openDialog(mediafile)" translate>Edit</a> &middot;\n              <a href="" class="text-danger"\n                ng-bootbox-confirm="{{ \'Are you sure you want to delete this file?\' | translate }}<br>\n                <b>{{ mediafile.title }} [{{ mediafile.mediafile.name }}]</b>"\n                ng-bootbox-confirm-action="delete(mediafile)" translate>Delete</a>\n            </small>\n          </div>\n        </div>\n      </div>\n\n      <!-- additional content column -->\n      <div class="col-xs-4 content" ng-style="{\'width\': isSelectMode ? \'calc(50% - 120px)\' : \'calc(50% - 70px)\'}">\n        <div style="width: 60%;" class="optional">\n          <small>\n            <div>\n              <i class="fa fa-file"></i> {{ mediafile.filetype }}\n              <span ng-if="mediafile.mediafile.encrypted">(<translate>Encrypted</translate>)</span>\n            </div>\n            <div><i class="fa fa-database"></i> {{ mediafile.filesize }}</div>\n            <div><i class="fa fa-upload"></i> {{ mediafile.timestamp | date:\'yyyy-MM-dd HH:mm:ss\' }}</div>\n          </small>\n        </div>\n        <div style="width: 40%;" class="pull-right optional"></div>\n      </div>\n\n    </div><!-- end data row -->\n  </div><!-- end os-table -->\n</div>\n'),
n.put("static/templates/mediafiles/slide_mediafile.html",'<div ng-controller="SlideMediafileCtrl" class="content" ng-class="{\'fullscreen\': element.fullscreen, \'video-container\': element.is_video}">\n    <!-- PDF -->\n    <ng-pdf ng-if="mediafile.is_pdf" template-url="/static/templates/mediafiles/slide_mediafile_partial.html"\n         ng-attr-scale="{{ element.scale }}"\n         ng-attr-page="{{ element.page }}">\n    </ng-pdf>\n\n    <!-- Image -->\n    <img ng-if="mediafile.is_image && !element.fullscreen" class=\'projector-image rotate{{element.rotate}}\'\n        ng-src=\'{{mediafile.mediafileUrl}}\'></img>\n    <div ng-if="mediafile.is_image && element.fullscreen" class=\'projector-image rotate{{element.rotate}}\'\n        style=\'background-image: url("{{mediafile.mediafileUrl}}")\'></div>\n\n    <!-- Video -->\n    <div ng-if="mediafile.is_video" class=\'video-container\'>\n        <video id=\'video-player\' ng-src="{{mediafile.mediafileUrl}}"></video>\n    </div>\n</div>\n'),n.put("static/templates/mediafiles/slide_mediafile_partial.html",'<canvas id="pdf-canvas" class="rotate{{element.rotate}} scrollcontent"></canvas>\n'),n.put("static/templates/motions/category-detail.html",'<div class="header">\n  <div class="title">\n    <div class="submenu">\n      <a ui-sref="motions.category.list" class="btn btn-sm btn-default">\n        <i class="fa fa-angle-double-left fa-lg"></i>\n        <translate>Back to overview</translate>\n      </a>\n    </div>\n    <h1>{{ category.name }}</h1>\n    <h2 translate>Category</h2>\n  </div>\n</div>\n\n<div class="details">\n  <strong translate>Prefix:</strong>\n  {{ category.prefix }}\n</div>\n'),n.put("static/templates/motions/category-form.html",'<div class="header">\n  <div class="title">\n    <div class="submenu">\n      <a ui-sref="motions.category.list" class="btn btn-sm btn-default">\n        <i class="fa fa-angle-double-left fa-lg"></i>\n        <translate>Back to overview</translate>\n      </a>\n    </div>\n    <h1 ng-if="category.id" translate>Edit category</h1>\n    <h1 ng-if="!category.id" translate>New category</h1>\n  </div>\n</div>\n\n<div class="details">\n  <form name="groupForm">\n    <div class="form-group">\n      <label for="inputPrefix" translate>Prefix</label>\n      <input type="text" ng-model="category.prefix" class="form-control" name="inputPrefix">\n    </div>\n    <div class="form-group">\n      <label for="inputName" translate>Name</label>\n      <input type="text" ng-model="category.name" class="form-control" name="inputName" ng-required="true">\n    </div>\n\n    <button type="submit" ng-click="save(category)" class="btn btn-primary" translate>\n      Save\n    </button>\n    <button ui-sref="motions.category.list" class="btn btn-default" translate>\n      Cancel\n    </button>\n  </form>\n</div>\n'),n.put("static/templates/motions/category-list.html",'<div class="header">\n  <div class="title">\n    <div class="submenu">\n      <a ui-sref="motions.motion.list" class="btn btn-sm btn-default">\n        <i class="fa fa-angle-double-left fa-lg"></i>\n        <translate>Back to overview</translate>\n      </a>\n      <a ui-sref="motions.category.create" os-perms="motions.can_manage" class="btn btn-primary btn-sm">\n        <i class="fa fa-plus fa-lg"></i>\n        <translate>New</translate>\n      </a>\n    </div>\n    <h1 translate>Categories</h1>\n  </div>\n</div>\n\n<div class="details">\n  <div class="row form-group">\n    <div class="col-sm-4 pull-right">\n      <input type="text" ng-model="filter.search" class="form-control"\n          placeholder="{{ \'Filter\' | translate }}">\n    </div>\n  </div>\n\n  <table class="table table-striped table-bordered table-hover">\n    <thead>\n      <tr>\n        <th ng-click="toggleSort(\'name\')" class="sortable">\n          <translate>Name</translate>\n          <i class="pull-right fa" ng-show="sortColumn === \'name\' && header.sortable != false"\n              ng-class="reverse ? \'fa-sort-desc\' : \'fa-sort-asc\'">\n          </i>\n        <th ng-click="toggleSort(\'prefix\')" class="sortable">\n          <translate>Prefix</translate>\n          <i class="pull-right fa" ng-show="sortColumn === \'prefix\' && header.sortable != false"\n              ng-class="reverse ? \'fa-sort-desc\' : \'fa-sort-asc\'">\n          </i>\n    <tbody>\n      <tr ng-repeat="category in categories | filter: filter.search | orderBy: sortColumn:reverse">\n        <td ng-mouseover="category.hover=true" ng-mouseleave="category.hover=false">\n          <strong>{{ category.name }}</strong>\n          <div class="hoverActions" ng-class="{\'hiddenDiv\': !category.hover}">\n            <!-- sort -->\n            <a ui-sref="motions.category.sort({ id: category.id })" translate>Sort</a> |\n            <!-- edit -->\n            <a ui-sref="motions.category.detail.update({id: category.id })" translate>Edit</a> |\n            <!-- delete -->\n            <a href="" class="text-danger"\n              ng-bootbox-confirm="{{ \'Are you sure you want to delete this entry?\' | translate }}<br>\n                <b>{{ category.name }}</b>"\n              ng-bootbox-confirm-action="delete(category)" translate>Delete</a>\n          </div>\n        <td>{{ category.prefix }}\n  </table>\n</div>\n'),n.put("static/templates/motions/category-sort.html",'<div class="header">\n  <div class="title">\n    <div class="submenu">\n      <a ui-sref="motions.category.list" class="btn btn-sm btn-default">\n        <i class="fa fa-angle-double-left fa-lg"></i>\n        <translate>Back to categories</translate>\n      </a>\n    </div>\n    <h1><translate>Category</translate> {{ category.name }}</h1>\n  </div>\n</div>\n\n<div class="details">\n  <div class="lead-div">\n    <p class="lead" translate>\n      Drag and drop motions to reorder the category. Then click the button to renumber.\n    </p>\n    <a os-perms="motions.can_manage" class="btn btn-primary btn-sm" ng-click="numbering()">\n      <i class="fa fa-sort-numeric-asc fa-lg"></i>\n      <translate>Numbering</translate>\n    </a>\n  </div>\n  <div uib-alert ng-show="alert.show" ng-class="\'alert-\' + (alert.type || \'warning\')" ng-click="alert={}" close="alert={}">\n    {{ alert.msg }}\n  </div>\n  <div ui-tree="treeOptions" data-max-depth="1" data-empty-placeholder-enabled="false">\n    <ol ui-tree-nodes ng-model="items">\n      <li ui-tree-node ng-repeat="item in items">\n        <div ui-tree-handle bg-color="#FF0000">\n            {{ item.item.identifier }}: {{ item.item.getTitle() }}\n        </div>\n    </ol>\n  </div>\n</div>\n'),n.put("static/templates/motions/change-recommendation-form.html",'<h1 ng-if="model.id" translate>Edit change recommendation</h1>\n<h1 ng-if="!model.id" translate>New change recommendation</h1>\n\n<uib-alert ng-show="alert.show" type="{{ alert.type }}" ng-click="alert={}" close="alert={}">\n  {{ alert.msg }}\n</uib-alert>\n\n<form name="changeRecommendationForm" ng-submit="save(model)">\n  <formly-form model="model" fields="formFields">\n    <button type="submit" ng-disabled="changeRecommendation.$invalid" class="btn btn-primary" translate>\n      Save\n    </button>\n    <button ng-click="closeThisDialog()" class="btn btn-default" translate>\n      Cancel\n    </button>\n  </formly-form>\n</form>\n'),n.put("static/templates/motions/motion-block-detail.html",'<div class="header">\n  <div class="title">\n    <div class="submenu">\n      <a ui-sref="motions.motionBlock.list" class="btn btn-sm btn-default">\n        <i class="fa fa-angle-double-left fa-lg"></i>\n        <translate>Back to overview</translate>\n      </a>\n      <!-- List of speakers -->\n      <a ui-sref="agenda.item.detail({id: motionBlock.agenda_item_id})" class="btn btn-sm btn-default">\n        <i class="fa fa-microphone fa-lg"></i>\n        <translate>List of speakers</translate>\n      </a>\n      <!-- project -->\n      <projector-button model="motionBlock" default-projector-id="defaultProjectorId">\n      </projector-button>\n      <!-- edit -->\n      <a ng-click="openDialog(motionBlock)"\n          class="btn btn-default btn-sm"\n          title="{{ \'Edit\' | translate}}">\n        <i class="fa fa-pencil"></i>\n      </a>\n    </div>\n    <h1>{{ motionBlock.agenda_item.getTitle() }}</h1>\n    <h2 translate>Motion block</h2>\n  </div>\n</div>\n\n<div class="details">\n  <a os-perms="motions.can_manage" class="btn btn-default btn"\n      ng-bootbox-confirm="{{ \'Are you sure you want to override the state of all motions of this motion block?\' | translate }}"\n      ng-bootbox-confirm-action="followRecommendations()">\n    <i class="fa fa-magic fa-lg"></i>\n    <translate>Follow recommendations for all motions</translate>\n  </a>\n\n  <div class="row spacer form-group">\n    <div class="col-sm-4 pull-right">\n      <input type="text" ng-model="filter.search" class="form-control"\n          placeholder="{{ \'Filter\' | translate }}">\n    </div>\n    <div class="col-sm-4 italic">\n      {{ motionsFiltered.length }} /\n      {{ motionBlock.motions.length }} {{ "motions" | translate }}\n    </div>\n  </div>\n\n  <table class="table table-striped table-bordered table-hover">\n    <thead>\n      <tr>\n        <th><translate>Motion</translate>\n        <th><translate>State</translate>\n        <th><translate>Recommendation</translate>\n    <tbody>\n      <tr ng-repeat="motion in motionsFiltered = (motionBlock.motions | filter: filter.search | orderBy: \'identifier\')">\n        <td ng-mouseover="motion.hover=true" ng-mouseleave="motion.hover=false">\n          <strong>\n            <a ui-sref="motions.motion.detail({id: motion.id})">{{ motion.identifier }} {{ motion.getTitle() }}</a>\n          </strong>\n          <div os-perms="motions.can_manage" class="hoverActions" ng-class="{\'hiddenDiv\': !motion.hover}">\n            <!-- delete -->\n            <a href="" class="text-danger"\n              ng-bootbox-confirm="{{ \'Are you sure you want to remove this motion from motion block?\' | translate }}<br>\n                <b>{{ motion.getTitle() }}</b>"\n              ng-bootbox-confirm-action="delete(motion)" translate>Remove from motion block</a>\n          </div>\n        <td>\n          <div class="label" ng-class="\'label-\'+motion.state.css_class">\n            {{ motion.getStateName() }}\n          </div>\n        <td>\n          <div class="label" ng-class="\'label-\'+motion.recommendation.css_class">\n            {{ motion.getRecommendationName() }}\n          </div>\n  </table>\n</div>\n'),n.put("static/templates/motions/motion-block-form.html",'<h1 ng-if="model.id" translate>Edit motion block</h1>\n<h1 ng-if="!model.id" translate>New motion block</h1>\n\n<div uib-alert ng-show="alert.show" ng-class="\'alert-\' + (alert.type || \'warning\')" ng-click="alert={}" close="alert={}">\n  {{ alert.msg }}\n</div>\n\n<form name="motionBlockForm" ng-submit="save(model)">\n  <formly-form model="model" fields="formFields">\n    <button type="submit" ng-disabled="motionBlockForm.$invalid" class="btn btn-primary" translate>\n      Save\n    </button>\n    <button ng-click="closeThisDialog()" class="btn btn-default" translate>\n      Cancel\n    </button>\n  </formly-form>\n</form>\n'),n.put("static/templates/motions/motion-block-list.html",'<div class="header">\n  <div class="title">\n    <div class="submenu">\n      <a ng-click="openFormDialog()" os-perms="motions.can_manage" class="btn btn-primary btn-sm">\n        <i class="fa fa-plus fa-lg"></i>\n        <translate>New</translate>\n      </a>\n      <a ui-sref="motions.motion.list" class="btn btn-sm btn-default">\n        <i class="fa fa-angle-double-left fa-lg"></i>\n        <translate>Back to overview</translate>\n      </a>\n    </div>\n    <h1 translate>Motion blocks</h1>\n  </div>\n</div>\n\n<div class="details">\n  <div class="row form-group">\n    <div class="col-sm-4 pull-right">\n      <input type="text" ng-model="filter.search" class="form-control"\n          placeholder="{{ \'Filter\' | translate }}">\n    </div>\n  </div>\n\n  <table class="table table-striped table-bordered table-hover">\n    <thead>\n      <tr>\n        <th><translate>Name</translate>\n        <th><translate>Motions</translate>\n    <tbody>\n      <tr ng-repeat="motionBlock in motionBlocks | filter: filter.search | orderBy: \'title\'">\n        <td ng-mouseover="motionBlock.hover=true" ng-mouseleave="motionBlock.hover=false">\n          <strong>\n            <a ui-sref="motions.motionBlock.detail({id: motionBlock.id})">{{ motionBlock.title }}</a>\n          </strong>\n          <div os-perms="motions.can_manage"  class="hoverActions" ng-class="{\'hiddenDiv\': !motionBlock.hover}">\n            <!-- edit -->\n            <a href="" ng-click="openFormDialog(motionBlock)" translate>Edit</a> |\n            <!-- delete -->\n            <a href="" class="text-danger"\n              ng-bootbox-confirm="{{ \'Are you sure you want to delete this entry?\' | translate }}<br>\n                <b>{{ motionBlock.name }}</b>"\n              ng-bootbox-confirm-action="delete(motionBlock)" translate>Delete</a>\n          </div>\n        <td>\n          {{ motionBlock.motions.length }}\n  </table>\n</div>\n'),n.put("static/templates/motions/motion-detail.html",'<div class="header">\n  <div class="title">\n    <div class="submenu">\n      <a ui-sref="motions.motion.list" class="btn btn-sm btn-default">\n        <i class="fa fa-angle-double-left fa-lg"></i>\n        <translate>Back to overview</translate>\n      </a>\n      <!-- List of speakers -->\n      <a ui-sref="agenda.item.detail({id: motion.agenda_item_id})"\n          os-perms="agenda.can_see" class="btn btn-sm btn-default">\n        <i class="fa fa-microphone fa-lg"></i>\n        <translate>List of speakers</translate>\n      </a>\n      <!-- project -->\n      <projector-button model="motion" default-projector-id="defaultProjectorId">\n      </projector-button>\n      <!-- edit -->\n      <a ng-if="motion.isAllowed(\'update\')" ng-click="openDialog(motion)"\n          class="btn btn-default btn-sm"\n          title="{{ \'Edit\' | translate}}">\n        <i class="fa fa-pencil"></i>\n      </a>\n      <!-- pdf -->\n      <a ng-click="pdfExport.createMotion()" class="btn btn-default btn-sm">\n        <i class="fa fa-file-pdf-o fa-lg"></i>\n        <translate>PDF</translate>\n      </a>\n    </div>\n    <h1>{{ motion.agenda_item.getTitle() || motion.getTitle() }}</h1>\n    <h2>\n        <translate>Motion</translate> {{ motion.identifier }}\n        <span ng-if="parent">\n          (<translate>Amendment of motion</translate>\n          <a ui-sref="motions.motion.detail({id: parent.id})">{{ parent.identifier || parent.getTitle() }}</a>)\n        </span>\n        <span ng-if="motion.versions.length > 1" >| Version {{ motion.getVersion(version).version_number }}</span>\n        <span ng-if="motion.active_version != version" class="label label-warning">\n          <i class="fa fa-exclamation-triangle"></i>\n          <translate>This version is not permitted.</translate>\n        </span>\n    </h2>\n  </div>\n</div>\n\n<div class="meta motion-detail">\n  <div class="title" ng-click="isMeta = !isMeta">\n    <div class="name">\n      <i class="fa fa-info-circle"></i>\n      <translate>Meta information</translate>\n    </div>\n    <div class="icon">\n      <i class="fa fa-lg" ng-class="isMeta ? \'fa-angle-down\' : \'fa-angle-up\'"></i>\n    </div>\n  </div>\n  <div class="detail" uib-collapse="isMeta">\n    <div class="row">\n      <div class="col-md-4">\n          <!-- submitters -->\n          <h3 translate>Submitters</h3>\n          <div ng-repeat="submitter in motion.submitters">\n            {{ submitter.get_full_name() }}\n          </div>\n\n          <!-- supporters -->\n          <div ng-if="config(\'motions_min_supporters\') > 0">\n            <h3 translate>Supporters</h3>\n            <ol>\n              <li ng-repeat="supporters in motion.supporters">\n                {{ supporters.get_full_name() }}\n            </ol>\n            <!-- support button -->\n            <button ng-if="motion.isAllowed(\'support\')" ng-click="support()" class="btn btn-default btn-sm">\n              <i class="fa fa-heart"></i>\n              <translate>Support motion</translate>\n            </button>\n            <!-- unsupport button -->\n            <button ng-if="motion.isAllowed(\'unsupport\')" ng-click="unsupport()" class="btn btn-default btn-sm">\n              <i class="fa fa-heart-o"></i>\n              <translate>Unsupport motion</translate>\n            </button>\n          </div>\n          <!-- Amendments -->\n          <div ng-if="config(\'motions_amendments_enabled\')">\n            <h3 translate>Amendments</h3>\n            <div ng-repeat="amendment in amendments">\n              <a ui-sref="motions.motion.detail({id: amendment.id})">\n                <translate>Motion</translate> {{ amendment.identifier || amendment.getTitle() }}\n              </a>\n            </div>\n            <button os-perms="motions.can_create" ng-click="newAmendment()" class="btn btn-default btn-sm">\n              <i class="fa fa-plus"></i>\n              <translate>New amendment</translate>\n            </button>\n          </div>\n      </div>\n      <div class="col-md-4">\n          <!-- State -->\n          <h3 ng-if="!motion.isAllowed(\'change_state\')" class="heading" translate>State</h3>\n          <div ng-if="motion.isAllowed(\'change_state\')" class="heading">\n            <span uib-dropdown>\n              <a href id="state-dropdown" class="drop-down-name" uib-dropdown-toggle>\n                <translate>State</translate>\n                <i class="fa fa-cog"></i>\n              </a>\n              <ul uib-dropdown-menu class="dropdown-menu" aria-labelledby="state-dropdown">\n                <li ng-repeat="state in motion.state.getNextStates()">\n                  <a href ng-click="updateState(state.id)">{{ state.action_word | translate }}</a>\n                <li class="divider" ng-if="motion.state.getNextStates().length && motion.isAllowed(\'reset_state\')">\n                <li ng-if="motion.isAllowed(\'reset_state\')">\n                  <a href ng-click="reset_state()">\n                    <i class="fa fa-exclamation-triangle"></i>\n                    <translate>Reset state</translate>\n                  </a>\n              </ul>\n            </span>\n          </div>\n          <div class="label" ng-class="\'label-\'+motion.state.css_class">\n            {{ motion.getStateName() }}\n          </div>\n          <div os-perms="motions.can_manage" class="input-group spacer"\n              ng-show="motion.state.show_state_extension_field">\n            <label class="sr-only" for="stateExtensionField">{{ commentFieldForState }}</label>\n            <input type="text" ng-model="stateExtension"\n                id="stateNameExtensionField" class="form-control input-sm"\n                placeholder="{{ commentFieldForState }}">\n            <span class="input-group-btn">\n              <button ng-click="saveAdditionalStateField(stateExtension)" class="btn btn-default btn-sm">\n                <i class="fa fa-check"></i>\n              </button>\n            </span>\n          </div>\n\n          <!-- Recommendation -->\n          <div ng-if="config(\'motions_recommendations_by\') != \'\'">\n            <h3 ng-if="!motion.isAllowed(\'change_recommendation\')" class="heading">\n              {{ config(\'motions_recommendations_by\') }}\n            </h3>\n            <div ng-if="motion.isAllowed(\'change_recommendation\')" class="heading">\n              <span uib-dropdown>\n                <a href id="recommendation-dropdown" class="drop-down-name" uib-dropdown-toggle>\n                  {{ config(\'motions_recommendations_by\') }}\n                  <i class="fa fa-cog"></i>\n                </a>\n                <ul uib-dropdown-menu class="dropdown-menu" aria-labelledby="recommendation-dropdown">\n                  <li ng-repeat="recommendation in motion.state.getRecommendations()">\n                    <a href ng-click="updateRecommendation(recommendation.id)">\n                      {{ recommendation.recommendation_label | translate }}\n                    </a>\n                  <li class="divider" ng-if="motion.state.getRecommendations().length && motion.recommendation">\n                  <li ng-if="motion.recommendation">\n                    <a href ng-click="resetRecommendation()">\n                      <i class="fa fa-exclamation-triangle"></i>\n                      <translate>Reset recommendation</translate>\n                    </a>\n                </ul>\n              </span>\n            </div>\n            <div class="label" ng-class="\'label-\'+motion.recommendation.css_class">\n              {{ motion.getRecommendationName() }}\n            </div>\n            <div class="input-group spacer"\n                ng-show="motion.recommendation.show_recommendation_extension_field">\n              <label class="sr-only" for="recommendationExtensionField">{{ commentFieldForRecommendation }}</label>\n              <input type="text" ng-model="recommendationExtension"\n                  id="recommendationExtensionField" class="form-control input-sm"\n                  placeholder="{{ commentFieldForRecommendation }}">\n              <span class="input-group-btn">\n                <button ng-click="saveAdditionalRecommendationField(recommendationExtension)" class="btn btn-default btn-sm">\n                  <i class="fa fa-check"></i>\n                </button>\n              </span>\n            </div>\n            <button\n                ng-if="motion.recommendation &&\n                       motion.isAllowed(\'change_state\') &&\n                       motion.state.next_states_id.indexOf(motion.recommendation.id) !== -1"\n                ng-click="updateState(motion.recommendation.id)"\n                class="btn btn-default btn-sm">\n              <i class="fa fa-magic"></i>\n              <translate>Follow recommendation</translate>\n            </button>\n          </div>\n\n          <!-- Category -->\n          <h3 ng-if="motion.category" translate>Category</h3>\n          {{ motion.category.name }}\n\n          <!-- Motion block -->\n          <h3 ng-if="motion.motionBlock" translate>Motion block</h3>\n          <a ui-sref="motions.motionBlock.detail({id: motion.motionBlock.id})"\n              os-perms="motions.can_manage">{{ motion.motionBlock.title }}</a>\n          <span os-perms="!motions.can_manage">{{ motion.motionBlock.title }}</span>\n\n          <!-- Tags -->\n          <h3 ng-if="motion.tags.length > 0" translate>Tags</h3>\n          <span ng-repeat="tag in motion.tags">\n            {{ tag.name }}{{$last ? \'\' : \', \'}}\n          </span>\n\n          <!-- Origin -->\n          <h3 ng-if="motion.origin" translate>Origin</h3>\n          {{ motion.origin }}\n\n      </div>\n      <div class="col-md-4">\n          <h3 ng-if="motion.polls.length > 0" translate>Voting result</h3>\n          <ol>\n            <li ng-controller="MotionPollDetailCtrl" ng-repeat="poll in motion.polls" class="spacer"\n                ng-if="poll.has_votes || operator.hasPerms(\'motions.can_manage\')">\n              <strong translate-comment=\'ballot of a motion\' translate>Vote</strong>\n\n              <!-- Edit poll -->\n              <button os-perms="motions.can_manage" ng-click="openPollDialog(poll, $index+1)"\n                  class="btn btn-default btn-xs" title="{{ \'Edit\' | translate }}">\n                <i class="fa fa-pencil"></i>\n              </button>\n\n              <!-- Delete poll -->\n              <button os-perms="motions.can_manage" class="btn btn-default btn-xs"\n                  ng-bootbox-confirm="{{ \'Are you sure you want to delete this poll?\' | translate }}"\n                  ng-bootbox-confirm-action="delete_poll(poll)"\n                  title="{{ \'Delete\' | translate }}">\n                <i class="fa fa-times"></i>\n              </button>\n\n              <!-- Print poll PDF -->\n              <a os-perms="motions.can_manage" ng-click="pdfExport.createPoll()" class="btn btn-default btn-xs"\n                  title="{{ \'Print ballot paper\' | translate }}">\n                <i class="fa fa-file-pdf-o"></i>\n              </a>\n\n              <!-- Template hook for motion poll buttons -->\n              <template-hook hook-name="motionPollSmallButtons"></template-hook>\n\n              <!-- Poll results -->\n              <div ng-show="poll.has_votes" class="pollresults">\n                <table class="table">\n                  <!-- yes -->\n                  <tr>\n                    <td class="icon">\n                      <i class="fa fa-thumbs-up fa-2x"></i>\n                    <td ng-init="voteYes = poll.getVote(poll.yes, \'yes\')">\n                      <span class="result_label"><translate>Yes</translate>:</span>\n                      <span class="result_value">\n                        {{ voteYes.value }} {{ voteYes.percentStr }}\n                      </span>\n                      <div ng-if="voteYes.percentNumber">\n                        <uib-progressbar value="voteYes.percentNumber" type="success"></uib-progressbar>\n                      </div>\n                  <!-- no -->\n                  <tr>\n                    <td class="icon">\n                      <i class="fa fa-thumbs-down fa-2x"></i>\n                    <td ng-init="voteNo = poll.getVote(poll.no, \'no\')">\n                      <span class="result_label"><translate>No</translate>:</span>\n                      <span class="result_value" >\n                        {{ voteNo.value }} {{ voteNo.percentStr }}\n                      </span>\n                      <div ng-if="voteNo.percentNumber">\n                        <uib-progressbar value="voteNo.percentNumber" type="danger"></uib-progressbar>\n                      </div>\n                  <!-- abstain -->\n                  <tr>\n                    <td class="icon">\n                      <strong style="font-size: 26px">&empty;</strong>\n                    <td ng-init="voteAbstain = poll.getVote(poll.abstain, \'abstain\')">\n                      <span class="result_label"><translate>Abstain</translate>:</span>\n                      <span class="result_value">\n                        {{ voteAbstain.value }} {{ voteAbstain.percentStr }}\n                      </span>\n                      <div ng-if="voteAbstain.percentNumber">\n                        <uib-progressbar value="voteAbstain.percentNumber" type="warning"></uib-progressbar>\n                      </div>\n                  <!-- valid votes -->\n                  <tr ng-if="poll.votesvalid !== null">\n                    <td class="icon">\n                      <i class="fa fa-check fa-lg"></i>\n                    <td ng-init="votesValid = poll.getVote(poll.votesvalid, \'votesvalid\')">\n                      <span class="result_label"><translate>Valid ballots</translate>:</span>\n                      <span class="result_value">\n                        {{ votesValid.value }} {{ votesValid.percentStr }}\n                      </span>\n                  <!-- invalid votes -->\n                  <tr ng-if="poll.votesinvalid !== null">\n                    <td class="icon">\n                      <i class="fa fa-ban fa-lg"></i>\n                    <td ng-init="votesInvalid = poll.getVote(poll.votesinvalid, \'votesinvalid\')">\n                      <span class="result_label"><translate>Invalid ballots</translate>:</span>\n                      <span class="result_value">\n                        {{ votesInvalid.value }} {{ votesInvalid.percentStr }}\n                      </span>\n                  <!-- votes cast -->\n                  <tr class="total" ng-if="poll.votescast !== null">\n                    <td class="icon">\n                      <strong style="font-size: 16px">&sum;</strong>\n                    <td ng-init="votesCast = poll.getVote(poll.votescast, \'votescast\')">\n                      <span class="result_label"><translate>Casted ballots</translate>:</span>\n                      <span class="result_value">\n                        {{ votesCast.value }} {{ votesCast.percentStr }}\n                      </span>\n\n                  <!-- majority calculation -->\n                  <tr>\n                    <td>\n                    <td>\n                      <div os-perms="motions.can_manage"\n                           ng-hide="hideMajorityCalculation()"\n                           ng-cloak>\n                        <div class="input-group">\n                          <span><translate>Required majority</translate>: </span>\n                          <select ng-model="$parent.method"\n                                  ng-options="option.value as option.display_name | translate for option in methodChoices">\n                        </div>\n                      </div>\n                  <tr>\n                    <td>\n                    <td>\n                      <div os-perms="motions.can_manage">\n                        <span class="text-success" ng-if="isReached() >= 0" translate>\n                          Quorum ({{ voteYes.value - isReached() }}) reached.\n                        </span>\n                        <span class="text-danger" ng-if="isReached() < 0" translate>\n                          Quorum ({{ voteYes.value - isReached() }}) not reached.\n                       </span>\n                      </div>\n\n                </table>\n          </ol>\n\n          <button ng-if="motion.isAllowed(\'create_poll\')" ng-click="create_poll()" class="btn btn-default btn-sm">\n            <i class="fa fa-bar-chart fa-lg"></i>\n            <translate>New vote</translate>\n          </button>\n      </div>\n    </div>\n  </div>\n</div>\n\n<div class="details">\n  <div class="row">\n\n    <!-- Motion toolbar -->\n    <ng-include src="\'static/templates/motions/motion-detail/toolbar.html\'"></ng-include>\n\n    <div ng-class="{\'col-sm-8\': (lineNumberMode != \'outside\'), \'col-sm-12\': (lineNumberMode == \'outside\')}">\n\n      <div><p>{{ config(\'motions_preamble\') | translate }}</p></div>\n\n      <div class="motion-text-holder">\n\n        <!-- Original view -->\n        <ng-include src="\'static/templates/motions/motion-detail/view-original.html\'"></ng-include>\n\n        <!-- Diff View -->\n        <ng-include src="\'static/templates/motions/motion-detail/view-diff.html\'"></ng-include>\n\n        <!-- Changed View -->\n        <div ng-if="viewChangeRecommendations.mode == \'changed\'">\n          <div ng-bind-html="motion.getTextByMode(\'changed\', version, highlight) | trusted"\n               class="motion-text motion-text-changed line-numbers-{{ lineNumberMode }}"></div>\n\n          <div style="text-align: right;" ng-if="motion.state.versioning && (change_recommendations | filter:{motion_version_id:version}:true).length > 0">\n            <button class="btn btn-default"\n                    ng-bootbox-confirm="{{ \'Do you want to create a new version of this motion based on this changes?\' | translate }}"\n                    ng-bootbox-confirm-action="viewChangeRecommendations.newVersionIncludingChanges(motion, version, true)">\n              <i class="fa fa-file-text"></i>\n              <translate>New version on these changes</translate>\n            </button>\n          </div>\n        </div>\n\n        <!-- Agreed View -->\n        <div ng-if="viewChangeRecommendations.mode == \'agreed\'">\n          <div ng-bind-html="motion.getTextByMode(\'agreed\', version, highlight) | trusted"\n               class="motion-text motion-text-changed line-numbers-{{ lineNumberMode }}"></div>\n\n          <div style="text-align: right;" ng-if="motion.state.versioning && (change_recommendations | filter:{motion_version_id:version}:true).length > 0">\n            <button class="btn btn-default"\n                    ng-bootbox-confirm="{{ \'Do you want to create a new version of this motion based on this changes?\' | translate }}"\n                    ng-bootbox-confirm-action="viewChangeRecommendations.newVersionIncludingChanges(motion, version, false)">\n              <i class="fa fa-file-text"></i>\n              <translate>New version on these changes</translate>\n            </button>\n          </div>\n        </div>\n      </div>\n\n      <!-- reason -->\n      <div ng-if="motion.getReason(version) != \'\'">\n        <h3 translate>Reason</h3>\n        <div ng-bind-html="motion.getReason() | trusted"></div>\n      </div>\n\n      <!-- attachments -->\n      <h3 ng-if="motion.attachments.length > 0" translate>Attachments</h3>\n      <ul>\n        <li ng-repeat="attachment in motion.attachments">\n          <a href="{{ attachment.mediafileUrl }}" target="_blank">{{ attachment.title_or_filename }}</a>\n      </ul>\n\n      <!-- version history -->\n      <div ng-if="motion.versions.length > 1">\n        <h3 translate>Version history</h3>\n        <ul>\n          <li ng-repeat="version in motion.versions">\n              <span ng-if="$parent.version == version.id">\n                <strong><translate>Version</translate> {{ version.version_number }}</strong>\n              </span>\n              <a ng-if="$parent.version != version.id" ng-click="showVersion(version)">\n                <translate>Version</translate> {{ version.version_number }}\n              </a>\n              <!-- active version -->\n              <i ng-if="motion.active_version == version.id" class="fa fa-star"\n                  title="{{ \'This is the last active version.\' | translate }}"></i>\n              <!-- permit version -->\n              <button os-perms="motions.can_manage" ng-show="motion.active_version != version.id"\n                  ng-click="permitVersion(version)"\n                  class="btn btn-default btn-xs" title="{{ \'Permit and activate\' | translate }}">\n                <i class="fa fa-check"></i>\n              </button>\n              <!-- delete version -->\n              <button os-perms="motions.can_manage" ng-show="motion.active_version != version.id"\n                  class="btn btn-default btn-xs"\n                  ng-bootbox-confirm="{{ \'Are you sure you want to delete this version?\' | translate }}<br>\n                      <strong><translate>Version</translate> {{ version.version_number }}</strong>"\n                  ng-bootbox-confirm-action="deleteVersion(version)"\n                  title="{{ \'Delete\' | translate }}">\n                <i class="fa fa-times"></i>\n              </button>\n            <br><translate>Last modified</translate>: {{ version.creation_time | date:\'yyyy-MM-dd HH:mm:ss\' }}\n        </ul>\n      </div>\n\n      <!-- log -->\n      <div os-perms="motions.can_manage">\n        <button type="button" class="btn btn-sm btn-default spacer" ng-click="isCollapsed = !isCollapsed" translate>\n          Show history\n        </button>\n        <div uib-collapse="isCollapsed">\n          <div class="well well-sm">\n            <ul class="list-unstyled">\n              <li ng-repeat="message in motion.log_messages">\n                <small>{{ message.message }}</small>\n              </li>\n            </ul>\n          </div>\n        </div>\n      </div>\n    </div>\n\n  </div>\n</div>\n\n<div class="details" ng-if="isAllowedToSeeCommentField()">\n  <h3 translate>Comments</h3>\n  <div ng-repeat="field in commentsFields">\n    <div ng-if="(field.public && !field.forState && !field.forRecommendation) ||\n        (operator.hasPerms(\'motions.can_see_and_manage_comments\') && !field.forState && !field.forRecommendation)">\n      <h4>\n        {{ field.name }}\n        <span ng-if="!field.public" class="label label-warning" translate>internal</span>\n      </h4>\n      <div ng-bind-html="motion.comments[$index]"></div>\n    </div>\n  </div>\n</div>\n'),
n.put("static/templates/motions/motion-form.html",'<h1 ng-if="model.id" translate>Edit motion</h1>\n<h1 ng-if="!model.id && !parent" translate>New motion</h1>\n<h1 ng-if="parent"><translate>New amendment of motion</translate> {{ parent.identifier || parent.getTitle() }}</h1>\n\n<div uib-alert ng-show="alert.show" ng-class="\'alert-\' + (alert.type || \'warning\')" ng-click="alert={}" close="alert={}">\n  {{ alert.msg }}\n</div>\n\n<form name="motionForm" ng-submit="save(model)" novalidate>\n  <formly-form model="model" fields="formFields">\n    <button type="submit" ng-disabled="motionForm.$invalid" class="btn btn-primary" translate>\n      Save\n    </button>\n    <button type="button" ng-click="closeThisDialog()" class="btn btn-default" translate>\n      Cancel\n    </button>\n  </formly-form>\n</form>\n'),n.put("static/templates/motions/motion-import.html",'<div class="header">\n  <div class="title">\n    <div class="submenu">\n      <a ui-sref="motions.motion.list" class="btn btn-sm btn-default">\n        <i class="fa fa-angle-double-left fa-lg"></i>\n        <translate>Back to overview</translate>\n      </a>\n    </div>\n    <h1 translate>Import motions</h1>\n  </div>\n</div>\n\n<div class="details">\n\n  <div class="block row">\n    <div class="title">\n      <h3 translate>Select a CSV file\n    </div>\n    <div class="block right import">\n      <label class="label" for="inputSeparator" translate>Separator</label>\n      <input type="text" ng-model="separator" ng-change="setSeparator()" ng-init="separator=separator" id="inputSeparator">\n      <br>\n      <label class="label" for="selectEncoding" translate>Encoding</label>\n      <select ng-model="encoding" ng-options="enc as enc for enc in encodingOptions"\n          ng-selected="setEncoding()" ng-init="encoding=encoding" id="selectEncoding"></select>\n      <ng-csv-import\n          content="csv.content"\n          header="csv.header"\n          header-visible="csv.headerVisible"\n          separator="csv.separator"\n          separator-visible="csv.separatorVisible"\n          result="csv.result"\n          encoding="csv.encoding"\n          accept="csv.accept"\n          encoding-visible="csv.encodingVisible"></ng-csv-import>\n    </div>\n  </div>\n\n  <h4 translate>Please note:</h4>\n  <ul class="indentation">\n      <li><translate>Required comma or semicolon separated values with these column header names in the first row</translate>:<br>\n          <code>identifier, title, text, reason, submitter, category, origin</code>\n      <li translate>Identifier, reason, submitter, category and origin are optional and may be empty.\n      <li translate>Only double quotes are accepted as text delimiter (no single quotes).\n      <li><a id="downloadLink" href="" ng-click="downloadCSVExample()" translate>Download CSV example file</a>\n  </ul>\n\n  <div ng-if="csv.result">\n    <h3 translate>Preview</h3>\n    <table class="table table-striped table-bordered table-condensed">\n      <thead>\n        <tr>\n          <th>\n          <th>#\n          <th translate>Identifier\n          <th translate>Title\n          <th translate>Text\n          <th translate>Reason\n          <th translate>Submitter\n          <th translate>Category\n          <th translate>Origin</th>\n      <tbody ng-repeat="motion in motions">\n        <tr>\n          <td class="minimum"\n              ng-class="{ \'text-danger\': motion.importerror, \'text-success\': motion.imported }">\n            <span ng-if="motion.importerror">\n              <i class="fa fa-exclamation-triangle fa-lg"></i>\n            </span>\n            <span ng-if="!motion.importerror && !motion.imported">\n              <i class="fa fa-check-circle-o fa-lg"></i>\n            </span>\n            <span ng-if="motion.imported">\n              <i class="fa fa-check-circle fa-lg"></i>\n            </span>\n          <td>\n            {{ $index + 1 }}\n          <td ng-class="{ \'text-danger\': motion.identifier_error }">\n            <span ng-if="motion.identifier_error" title="{{ motion.identifier_error | translate }}">\n              <i class="fa fa-exclamation-triangle pointer"></i>\n            </span>\n            {{ motion.identifier }}\n          <td ng-class="{ \'text-danger\': motion.title_error }">\n            <span ng-if="motion.title_error" title="{{ motion.title_error | translate }}">\n              <i class="fa fa-exclamation-triangle"></i>\n            </span>\n            {{ motion.title }}\n          <td ng-class="{ \'text-danger\': motion.text_error }">\n            <span ng-if="motion.text_error" title="{{ motion.text_error | translate }}">\n              <i class="fa fa-exclamation-triangle"></i>\n            </span>\n            {{ motion.text | limitTo:80 }}{{ motion.text.length > 80 ? \'...\' : \'\' }}\n          <td>{{ motion.reason | limitTo:80 }}{{ motion.reason.length > 80 ? \'...\' : \'\' }}\n          <td ng-class="{ \'text-warning\': motion.submitter_create }">\n            <span ng-if="motion.submitter_create" title="{{ motion.submitter_create | translate }}">\n              <i class="fa fa-plus-circle"></i>\n            </span>\n            {{ motion.submitter }}\n          <td ng-class="{ \'text-warning\': motion.category_create }">\n            <span ng-if="motion.category_create" title="{{ motion.category_create | translate }}">\n              <i class="fa fa-plus-circle"></i>\n            </span>\n            {{ motion.category }}\n          <td>{{ motion.origin | limitTo:30 }}{{ motion.origin.length > 30 ? \'...\' : \'\' }}\n    </table>\n\n    <div class="text-danger">\n      <div ng-repeat="motion in motionsFailed = (motions | filter:{importerror:true})"></div>\n      <i class="fa fa-exclamation-triangle"></i>\n      {{ motionsFailed.length }}\n      <translate>motions will be not imported.</translate>\n    </div>\n    <div>\n      <div ng-repeat="motion in motionsPassed = (motions | filter:{importerror:false})"></div>\n      <i class="fa fa-check-circle-o fa-lg"></i>\n      {{ motions.length - motionsFailed.length }}\n      <translate>motions will be imported.</translate>\n    </div>\n    <div ng-repeat="motion in motionsImported = (motions | filter:{imported:true})"></div>\n    <div ng-if="motionsImported.length > 0" class="text-success">\n      <hr class="smallhr">\n      <i class="fa fa-check-circle fa-lg"></i>\n      {{ motionsImported.length }}\n      <translate>motions were successfully imported.</translate>\n      (<translate>Users created</translate>: {{ usersCreated }},\n      <translate>Categories created</translate>: {{ categoriesCreated }})\n    </div>\n\n    <div class="spacer">\n      <button ng-click="clear()" class="btn btn-default" translate>\n        Clear preview\n      </button>\n      <button ng-if="!csvImporting && (motions.length - motionsFailed.length) > 0" ng-click="import()" class="btn btn-primary" translate>\n        Import {{ motions.length - motionsFailed.length }} motions\n      </button>\n    </div>\n    <div class="spacer">\n      <a ng-if="csvimported" ui-sref="motions.motion.list" class="btn btn-default">\n        <i class="fa fa-angle-double-left fa-lg"></i>\n        <translate>Back to motions overview</translate>\n      </a>\n    </div>\n  </div>\n</div>\n'),n.put("static/templates/motions/motion-list.html",'<div class="header">\n  <div class="title">\n    <div class="submenu">\n      <a ng-click="openDialog()" os-perms="motions.can_create" class="btn btn-primary btn-sm">\n        <i class="fa fa-plus fa-lg"></i>\n        <translate>New</translate>\n      </a>\n      <a ui-sref="motions.category.list" os-perms="motions.can_manage" class="btn btn-default btn-sm">\n        <i class="fa fa-sitemap fa-lg"></i>\n        <translate>Categories</translate>\n      </a>\n      <a ui-sref="motions.motionBlock.list" os-perms="motions.can_manage" class="btn btn-default btn-sm">\n        <i class="fa fa-th-large fa-lg"></i>\n        <translate>Motion blocks</translate>\n      </a>\n      <a ui-sref="core.tag.list" os-perms="core.can_manage_tags" class="btn btn-default btn-sm">\n        <i class="fa fa-tags fa-lg"></i>\n        <translate>Tags</translate>\n      </a>\n      <a ui-sref="motions.motion.import" os-perms="motions.can_manage" class="btn btn-default btn-sm">\n        <i class="fa fa-download fa-lg"></i>\n        <translate>Import</translate>\n      </a>\n    </div>\n    <h1 translate>Motions</h1>\n  </div>\n</div>\n\n<div class="details">\n  <div class="row">\n    <div class="col-sm-12">\n      <!-- select mode -->\n      <button os-perms="motions.can_manage" class="btn"\n          ng-class="$parent.isSelectMode ? \'btn-primary\' : \'btn-default\'"\n          ng-click="$parent.isSelectMode = !$parent.isSelectMode; uncheckAll()">\n        <i class="fa fa-check-square-o"></i>\n        <translate>Select ...</translate>\n      </button>\n      <!-- Export dropdown -->\n      <div class="dropdown pull-right" uib-dropdown>\n        <button type="button" class="btn btn-default" id="dropdownExport" uib-dropdown-toggle>\n          <i class="fa fa-upload"></i>\n          <span ng-if="motionsFiltered.length == motions.length" translate>\n            Export all\n          </span>\n          <span ng-if="motionsFiltered.length != motions.length" translate>\n            Export filtered\n          </span>\n          <span class="caret"></span>\n        </button>\n        <ul class="dropdown-menu dropdown-menu-right" aria-labelledby="dropdownExport">\n          <!-- PDF export -->\n          <li>\n            <a href="" ng-click="pdfExport()">\n              <i class="fa fa-file-pdf-o fa-lg"></i>\n              PDF\n            </a>\n          </li>\n          <!-- CSV export -->\n          <li>\n            <a href="" id="downloadLinkCSV"\n              ng-click="csvExport()">\n              <i class="fa fa-file-text-o fa-lg"></i>\n              CSV\n            </a>\n          </li>\n          <!-- DOCX export -->\n          <li>\n            <a href="" ng-click="docxExport()">\n              <i class="fa fa-file-word-o fa-lg"></i>\n              DOCX\n            </a>\n          </li>\n        </ul>\n      </div>\n    </div>\n  </div>\n\n  <div uib-collapse="!isSelectMode" class="row spacer">\n    <div class="col-sm-12 text-left form-inline" ng-show="isSelectMode" os-perms="motions.can_manage">\n      <!-- actions -->\n      <select ng-model="selectedAction" class="form-control">\n        <option value="" translate>--- Select action ---</option>\n        <option value="delete" translate>Delete</option>\n        <option value="setStatus" translate>Set status</option>\n        <option value="setCategory" ng-if="categories.length" translate>Set category</option>\n        <option value="setMotionBlock" ng-if="motionBlocks.length" translate>Set motion block</option>\n      </select>\n      <!-- state select -->\n      <select ng-show="selectedAction == \'setStatus\'" ng-model="selectedState" class="form-control">\n        <option value="" translate>--- Select state ---</option>\n        <option ng-repeat="state in states" ng-disabled="state.workflowHeader" value="{{ state.id }}">\n          {{ (state.workflowHeader ? state.headername : state.name) | translate }}\n        </option>\n      </select>\n      <!-- set state button -->\n      <a ng-show="selectedAction == \'setStatus\' && selectedState"\n          ng-click="setStatusMultiple(selectedState)" class="btn btn-default">\n        <translate>Set status</translate>\n      </a>\n      <!-- category select -->\n      <select ng-show="selectedAction == \'setCategory\'" ng-model="selectedCategory" class="form-control">\n        <option value="" translate>--- Select category ---</option>\n        <option ng-repeat="category in categories" value="{{ category.id }}">\n          {{ category.name }}\n        </option>\n        <option value="no_category_selected" translate>No category</option>\n      </select>\n      <!-- set category button -->\n      <a ng-show="selectedAction == \'setCategory\' && selectedCategory"\n          ng-click="setCategoryMultiple(selectedCategory)" class="btn btn-default">\n        <translate>Set category</translate>\n      </a>\n      <!-- motionBlock select -->\n      <select ng-show="selectedAction == \'setMotionBlock\'" ng-model="selectedMotionBlock" class="form-control">\n        <option value="" translate>--- Select motion block ---</option>\n        <option ng-repeat="motionBlock in motionBlocks" value="{{ motionBlock.id }}">\n          {{ motionBlock.title }}\n        </option>\n        <option value="no_motionBlock_selected" translate>No motion block</option>\n      </select>\n      <!-- set motion block button -->\n      <a ng-show="selectedAction == \'setMotionBlock\' && selectedMotionBlock"\n         ng-click="setMotionBlockMultiple(selectedMotionBlock)" class="btn btn-default">\n        <translate>Set motion block</translate>\n      </a>\n      <!-- delete button -->\n      <a ng-show="selectedAction == \'delete\'"\n        ng-bootbox-confirm="{{ \'Are you sure you want to delete all selected motions?\' | translate }}"\n        ng-bootbox-confirm-action="deleteMultiple()"\n        class="btn btn-danger">\n        <i class="fa fa-trash fa-lg"></i>\n        <translate>Delete selected motions</translate>\n      </a>\n    </div>\n  </div>\n\n  <div class="spacer-top-lg italic">\n    {{ motionsFiltered.length }} /\n    {{ motions.length }} {{ "motions" | translate }}<span ng-if="(motions|filter:{selected:true}).length > 0">,\n    {{(motions|filter:{selected:true}).length}} {{ "selected" | translate }}</span>\n  </div>\n\n  <div class="os-table container-fluid">\n    <div class="row header-row">\n      <div class="col-xs-1 centered" ng-show="isSelectMode">\n        <i class="fa text-danger pointer" ng-class=" selectedAll ? \'fa-check-square-o\' : \'fa-square-o\'"\n          ng-click="checkAll()"></i>\n      </div>\n      <div class="col-xs-11 main-header">\n        <span class="form-inline text-right pull-right">\n          <!-- clear all filters -->\n          <span class="sort-spacer pointer" ng-click="resetFilters()"\n            ng-if="filter.areFiltersSet()" ng-disabled="isSelectMode"\n            ng-class="{\'disabled\': isSelectMode}">\n            <i class="fa fa-times-circle"></i>\n            <translate>Filter</translate>\n          </span>\n          <!-- State filter -->\n          <span uib-dropdown>\n            <span class="pointer" id="dropdownState" uib-dropdown-toggle\n              ng-class="{\'bold\': filter.multiselectFilters.state.length > 0, \'disabled\': isSelectMode}"\n              ng-disabled="isSelectMode">\n              <translate>State</translate>\n              <span class="caret"></span>\n            </span>\n            <ul class="dropdown-menu dropdown-menu-right" aria-labelledby="dropdownState">\n              <li ng-repeat="state in states" ng-class="state.workflowHeader ? \'dropdown-header\' : \'\'">\n                <a ng-if="state.workflowHeader">\n                  {{ state.headername | translate }}\n                </a>\n                <a href ng-if="!state.workflowHeader"\n                  ng-click="operateStateFilter(state.id, isSelectMode)">\n                  <i class="fa fa-check" ng-if="filter.multiselectFilters.state.indexOf(state.id) > -1"></i>\n                  {{ state.name | translate }}\n                </a>\n              </li>\n              <li class="divider"></li>\n              <li>\n                <a href ng-click="operateStateFilter(-1, isSelectMode)">\n                  <i class="fa fa-check" ng-if="filter.multiselectFilters.category.indexOf(-1) > -1"></i>\n                  <translate>Done</translate>\n                </a>\n              </li>\n            </ul>\n          </span>\n          <!-- Category filter -->\n          <span uib-dropdown ng-if="categories.length > 0">\n            <span class="pointer" id="dropdownCategory" uib-dropdown-toggle\n              ng-class="{\'bold\': filter.multiselectFilters.category.length > 0, \'disabled\': isSelectMode}"\n              ng-disabled="isSelectMode">\n              <translate>Category</translate>\n              <span class="caret"></span>\n            </span>\n            <ul class="dropdown-menu dropdown-menu-right" aria-labelledby="dropdownCategory">\n              <li ng-repeat="category in categories">\n                <a href ng-click="filter.operateMultiselectFilter(\'category\', category.id, isSelectMode)">\n                  <i class="fa fa-check" ng-if="filter.multiselectFilters.category.indexOf(category.id) > -1"></i>\n                  {{ category.name }}\n                </a>\n              </li>\n              <li class="divider"></li>\n              <li>\n                <a href ng-click="filter.operateMultiselectFilter(\'category\', -1, isSelectMode)">\n                  <i class="fa fa-check" ng-if="filter.multiselectFilters.category.indexOf(-1) > -1"></i>\n                  <translate>No category set</translate>\n                </a>\n              </li>\n            </ul>\n          </span>\n          <!-- Motion block filter -->\n          <span uib-dropdown ng-if="motionBlocks.length > 0">\n            <span class="pointer" id="dropdownBlock" uib-dropdown-toggle\n              ng-class="{\'bold\': filter.multiselectFilters.motionBlock.length > 0, \'disabled\': isSelectMode}"\n              ng-disabled="isSelectMode">\n              <translate>Motion block</translate>\n              <span class="caret"></span>\n            </span>\n            <ul class="dropdown-menu dropdown-menu-right" aria-labelledby="dropdownBlock">\n              <li ng-repeat="block in motionBlocks">\n                <a href ng-click="filter.operateMultiselectFilter(\'motionBlock\', block.id, isSelectMode)">\n                  <i class="fa fa-check" ng-if="filter.multiselectFilters.motionBlock.indexOf(block.id) > -1"></i>\n                  {{ block.title }}\n                </a>\n              </li>\n              <li class="divider"></li>\n              <li>\n                <a href ng-click="filter.operateMultiselectFilter(\'motionBlock\', -1, isSelectMode)">\n                  <i class="fa fa-check" ng-if="filter.multiselectFilters.motionBlock.indexOf(-1) > -1"></i>\n                  <translate>No motion block set</translate>\n                </a>\n              </li>\n            </ul>\n          </span>\n          <!-- recommendation filter -->\n          <span uib-dropdown ng-if="config(\'motions_recommendations_by\') != \'\'">\n            <span class="pointer" id="dropdownRecommendation" uib-dropdown-toggle\n              ng-class="{\'bold\': filter.multiselectFilters.recommendation.length > 0, \'disabled\': isSelectMode}"\n              ng-disabled="isSelectMode">\n              <translate>Recommendation</translate>\n              <span class="caret"></span>\n            </span>\n            <ul class="dropdown-menu dropdown-menu-right" aria-labelledby="dropdownRecommentation">\n              <li ng-repeat="recommendation in recommendations" ng-class="recommendation.workflowHeader ? \'dropdown-header\' : \'\'">\n                <a ng-if="recommendation.workflowHeader">\n                  {{ recommendation.headername | translate }}\n                </a>\n                <a href ng-if="!recommendation.workflowHeader"\n                  ng-click="filter.operateMultiselectFilter(\'recommendation\', recommendation.id, isSelectMode)">\n                  <i class="fa fa-check" ng-if="filter.multiselectFilters.recommendation.indexOf(recommendation.id) > -1"></i>\n                  {{ recommendation.recommendation_label | translate }}\n                </a>\n              </li>\n              <li class="divider"></li>\n              <li>\n                <a href ng-click="filter.operateMultiselectFilter(\'recommendation\', -1, isSelectMode)">\n                  <i class="fa fa-check" ng-if="filter.multiselectFilters.recommendation.indexOf(-1) > -1"></i>\n                  <translate>No recommendation set</translate>\n                </a>\n              </li>\n            </ul>\n          </span>\n          <!-- Tag filter -->\n          <span uib-dropdown ng-if="tags.length > 0">\n            <span class="pointer" id="dropdownTag" uib-dropdown-toggle\n              ng-class="{\'bold\': filter.multiselectFilters.tag.length > 0, \'disabled\': isSelectMode}"\n              ng-disabled="isSelectMode">\n              <translate>Tag</translate>\n              <span class="caret"></span>\n            </span>\n            <ul class="dropdown-menu dropdown-menu-right" aria-labelledby="dropdownTag">\n              <li ng-repeat="tag in tags">\n                <a href ng-click="filter.operateMultiselectFilter(\'tag\', tag.id, isSelectMode)">\n                  <i class="fa fa-check" ng-if="filter.multiselectFilters.tag.indexOf(tag.id) > -1"></i>\n                  {{ tag.name }}\n                </a>\n              </li>\n              <li class="divider"></li>\n              <li>\n                <a href ng-click="filter.operateMultiselectFilter(\'tag\', -1, isSelectMode)">\n                  <i class="fa fa-check" ng-if="filter.multiselectFilters.tag.indexOf(-1) > -1"></i>\n                  <translate>No tag set</translate>\n                </a>\n              </li>\n            </ul>\n          </span>\n          <!-- dropdown sort -->\n          <span uib-dropdown>\n            <span class="pointer" id="dropdownSort" uib-dropdown-toggle\n              ng-class="{\'disabled\': isSelectMode}"\n              ng-disabled="isSelectMode">\n              <translate>Sort</translate>\n              <span class="caret"></span>\n            </span>\n            <ul class="dropdown-menu dropdown-menu-right" aria-labelledby="dropdownSort">\n              <!-- item -->\n              <li>\n                <a href ng-click="sort.toggle(\'agenda_item.getItemNumberWithAncestors()\')">\n                  <translate translate-comment="short form of agenda item">Item</translate>\n                  <span class="spacer-right pull-right"></span>\n                  <i class="pull-right fa"\n                    ng-style="{\'visibility\': sort.column === \'agenda_item.getItemNumberWithAncestors()\' ? \'visible\' : \'hidden\'}"\n                    ng-class="sort.reverse ? \'fa-sort-desc\' : \'fa-sort-asc\'">\n                  </i>\n                </a>\n              </li>\n              <!-- all other sortOptions -->\n              <li ng-repeat="option in sortOptions">\n                <a href ng-click="sort.toggle(option.name)">\n                {{ option.display_name | translate }}\n                <span class="spacer-right pull-right"></span>\n                  <i class="pull-right fa"\n                    ng-style="{\'visibility\': sort.column === option.name ? \'visible\' : \'hidden\'}"\n                    ng-class="sort.reverse ? \'fa-sort-desc\' : \'fa-sort-asc\'">\n                  </i>\n                </a>\n              </li>\n            </ul>\n          </span>\n          <!-- search field -->\n          <span class="form-group">\n            <span class="input-group">\n              <span class="input-group-addon"><i class="fa fa-search"></i></span>\n              <input type="text" ng-model="filter.filterString" class="form-control"\n                 placeholder="{{ \'Search\' | translate}}" ng-disabled="isSelectMode"\n                 ng-change="filter.save()">\n            </span>\n          </span>\n        </span>\n        <!-- show all selected multiselectoptions -->\n        <span>\n          <!-- state -->\n          <span ng-repeat="state in states" class="pointer spacer-left-lg"\n            ng-if="!state.workflowHeader && filter.multiselectFilters.state.indexOf(state.id) > -1"\n            ng-click="operateStateFilter(state.id, isSelectMode)"\n            ng-class="{\'disabled\': isSelectMode}">\n            <span class="nobr">\n              <i class="fa fa-times-circle"></i>\n              {{ state.name | translate }}\n            </span>\n          </span>\n          <span ng-if="filter.multiselectFilters.state.indexOf(-1) > -1" class="pointer spacer-left-lg"\n            ng-click="operateStateFilter(-1, isSelectMode)"\n            ng-class="{\'disabled\': isSelectMode}">\n            <i class="fa fa-times-circle"></i>\n            <translate>Done</translate>\n          </span>\n          <!-- category -->\n          <span ng-repeat="category in categories" class="pointer spacer-left-lg"\n            ng-if="filter.multiselectFilters.category.indexOf(category.id) > -1"\n            ng-click="filter.operateMultiselectFilter(\'category\', category.id, isSelectMode)"\n            ng-class="{\'disabled\': isSelectMode}">\n            <span class="nobr">\n              <i class="fa fa-times-circle"></i>\n              {{ category.name }}\n            </span>\n          </span>\n          <span ng-if="filter.multiselectFilters.category.indexOf(-1) > -1" class="pointer spacer-left-lg"\n            ng-click="filter.operateMultiselectFilter(\'category\', -1, isSelectMode)"\n            ng-class="{\'disabled\': isSelectMode}">\n            <i class="fa fa-times-circle"></i>\n            <translate>No category set</translate>\n          </span>\n          <!-- motion block -->\n          <span ng-repeat="motionBlock in motionBlocks" class="pointer spacer-left-lg"\n            ng-if="filter.multiselectFilters.motionBlock.indexOf(motionBlock.id) > -1"\n            ng-click="filter.operateMultiselectFilter(\'motionBlock\', motionBlock.id, isSelectMode)"\n            ng-class="{\'disabled\': isSelectMode}">\n            <span class="nobr">\n              <i class="fa fa-times-circle"></i>\n              {{ motionBlock.title }}\n            </span>\n          </span>\n          <!-- recommendation -->\n          <span ng-repeat="recommendation in recommendations" class="pointer spacer-left-lg"\n            ng-if="filter.multiselectFilters.recommendation.indexOf(recommendation.id) > -1"\n            ng-click="filter.operateMultiselectFilter(\'recommendation\', recommendation.id, isSelectMode)"\n            ng-class="{\'disabled\': isSelectMode}">\n            <span class="nobr">\n              <i class="fa fa-times-circle"></i>\n              {{ recommendation.recommendation_label | translate }}\n            </span>\n          </span>\n          <span ng-if="filter.multiselectFilters.motionBlock.indexOf(-1) > -1" class="pointer spacer-left-lg"\n            ng-click="filter.operateMultiselectFilter(\'motionBlock\', -1, isSelectMode)"\n            ng-class="{\'disabled\': isSelectMode}">\n            <i class="fa fa-times-circle"></i>\n            <translate>No motion block set</translate>\n          </span>\n          <!-- tags -->\n          <span ng-repeat="tag in tags" class="pointer spacer-left-lg"\n            ng-if="filter.multiselectFilters.tag.indexOf(tag.id) > -1"\n            ng-click="filter.operateMultiselectFilter(\'tag\', tag.id, isSelectMode)"\n            ng-class="{\'disabled\': isSelectMode}">\n            <span class="nobr">\n              <i class="fa fa-times-circle"></i>\n              {{ tag.name }}\n            </span>\n          </span>\n          <span ng-if="filter.multiselectFilters.tag.indexOf(-1) > -1" class="pointer spacer-left-lg"\n            ng-click="filter.operateMultiselectFilter(\'tag\', -1, isSelectMode)"\n            ng-class="{\'disabled\': isSelectMode}">\n            <i class="fa fa-times-circle"></i>\n            <translate>No tag set</translate>\n          </span>\n        </span>\n      </div>\n    </div>\n\n    <!-- main table -->\n    <div class="row data-row" ng-mouseover="motion.hover=true"\n      ng-mouseleave="motion.hover=false"\n      ng-class="{\'projected\': motion.isProjected().length}"\n      ng-repeat="motion in motionsFiltered = (motions\n        | osFilter: filter.filterString : filter.getObjectQueryString\n        | MultiselectFilter: stateFilter : getItemId.state\n        | MultiselectFilter: filter.multiselectFilters.category : getItemId.category\n        | MultiselectFilter: filter.multiselectFilters.motionBlock : getItemId.motionBlock\n        | MultiselectFilter: filter.multiselectFilters.recommendation : getItemId.recommendation\n        | MultiselectFilter: filter.multiselectFilters.tag : getItemId.tag\n        | toArray\n        | orderBy: sort.column : sort.reverse)">\n\n      <!-- select column -->\n      <div ng-show="isSelectMode" os-perms="motions.can_manage" class="col-xs-1 centered">\n        <i class="fa text-danger pointer" ng-click="motion.selected=!motion.selected"\n        ng-class="motion.selected ? \'fa-check-square-o\' : \'fa-square-o\'"></i>\n      </div>\n      <!-- projector column -->\n      <div class="col-xs-1 centered projector" os-perms="core.can_manage_projector">\n        <projector-button model="motion" default-projector-id="defaultProjectorId">\n        </projector-button>\n      </div>\n      <div class="no-projector-spacer" os-perms="!core.can_manage_projector"></div>\n      <!-- main content column -->\n      <div class="col-xs-6 content">\n        <div class="id-col">\n          <span ng-show="motion.identifier">\n            {{ motion.identifier }}\n          </span>\n        </div>\n        <div class="id-col-space">\n          <!-- ID and title -->\n          <div>\n              <a class="title" ui-sref="motions.motion.detail({id: motion.id})">{{ motion.getTitle() }}</a>\n            <i class="fa fa-paperclip" ng-if="motion.attachments_id.length > 0"></i>\n          </div>\n          <!-- state -->\n          <div>\n            <span ng-mouseover="motion.stateHover=true" ng-mouseleave="motion.stateHover=false"\n                class="dropdown-hover-space">\n              <span class="label" ng-class="\'label-\'+motion.state.css_class">\n                {{ motion.getStateName() }}\n              </span>\n              <span os-perms="motions.can_manage" ng-class="{\'hiddenDiv\': !motion.stateHover}" uib-dropdown>\n                <i class="fa fa-cog pointer" uib-dropdown-toggle id="stateDropdown{{ motion.id }}"></i>\n                <ul class="dropdown-menu" aria-labelledby="stateDropdown{{ motion.id }}">\n                  <li ng-repeat="state in motion.state.getNextStates()">\n                    <a href ng-click="updateState(motion, state.id)">{{ state.action_word | translate }}</a>\n                  </li>\n                  <li class="divider" ng-if="motion.state.getNextStates().length"></li>\n                  <li>\n                    <a href ng-if="motion.isAllowed(\'reset_state\')" ng-click="resetState(motion)">\n                      <i class="fa fa-exclamation-triangle"></i>\n                      <translate>Reset state</translate>\n                    </a>\n                  </li>\n                </ul>\n              </span>\n            </span>\n          </div>\n          <!-- recommendation -->\n          <div ng-if="motion.recommendation">\n            <span ng-mouseover="motion.recommendationHover=true" ng-mouseleave="motion.recommendationHover=false"\n                class="dropdown-hover-space">\n              <span class="label" ng-class="\'label-\'+motion.recommendation.css_class" uib-tooltip="{{ config(\'motions_recommendations_by\') }}">\n                {{ motion.getRecommendationName() }}\n              </span>\n              <span os-perms="motions.can_manage" ng-class="{\'hiddenDiv\': !motion.recommendationHover}" uib-dropdown>\n                <i class="fa fa-cog pointer" uib-dropdown-toggle id="recommendationDropdown{{ motion.id }}"></i>\n                <ul class="dropdown-menu" aria-labelledby="recommendationDropdown{{ motion.id }}">\n                  <li ng-repeat="recommendation in motion.state.getRecommendations()">\n                    <a href ng-click="updateRecommendation(motion, recommendation.id)">\n                      {{ recommendation.recommendation_label | translate }}\n                    </a>\n                  </li>\n                  <li class="divider" ng-if="motion.state.getRecommendations().length && motion.recommendation"></li>\n                  <li ng-if="motion.recommendation">\n                    <a href ng-click="resetRecommendation(motion)">\n                      <i class="fa fa-exclamation-triangle"></i>\n                      <translate>Reset recommendation</translate>\n                    </a>\n                  </li>\n                </ul>\n              </span>\n            </span>\n          </div>\n          <!-- Submitters -->\n          <div ng-if="motion.submitters.length">\n            <small>\n              <span class="optional" translate>by</span>\n              <span class="optional" ng-repeat="submitter in motion.submitters | limitTo:1">\n                {{ submitter.get_full_name() }}<span ng-if="!$last">,</span></span><span ng-if="motion.submitters.length > 1">,\n                ... [+{{ motion.submitters.length - 1 }}]</span>\n              <!-- sorry for merging them together, but otherwise there would be a whitespace because of the new line -->\n            </small>\n          </div>\n          <!-- hover menu -->\n          <div ng-if="motion.isAllowed(\'update\')" ng-class="{\'hiddenDiv\': !motion.hover}">\n            <small>\n              <span ng-if="motion.isAllowed(\'update\')">\n                <a href="" ng-click="openDialog(motion)" translate>Edit</a>\n              </span>\n              <span ng-if="motion.isAllowed(\'delete\')"> &middot;\n                <a href="" class="text-danger"\n                    ng-bootbox-confirm="{{ \'Are you sure you want to delete this entry?\' | translate }}<br><b>{{ motion.getTitle() }}</b>"\n                    ng-bootbox-confirm-action="delete(motion)" translate>Delete</a>\n              </span>\n            </small>\n          </div>\n\n        </div>\n      </div>\n      <!-- additional content column -->\n      <div class="col-xs-4 content" ng-style="{\'width\': isSelectMode ? \'calc(50% - 120px)\' : \'calc(50% - 70px)\'}">\n        <div style="width: 60%;" class="optional">\n          <small>\n            <!-- Category dropdown for manage user -->\n            <div os-perms="motions.can_manage" ng-show="categories.length > 0"\n                ng-mouseover="motion.categoryHover=true"\n                ng-mouseleave="motion.categoryHover=false">\n              <span uib-dropdown>\n                <span id="dropdownCategory{{ motion.id }}" class="pointer"\n                  uib-dropdown-toggle uib-tooltip="{{ \'Set a category\' | translate }}"\n                  tooltip-class="nobr">\n                  <span ng-if="motion.category == null" ng-show="motion.hover">\n                    <i class="fa fa-sitemap"></i>\n                    <i class="fa fa-plus"></i>\n                  </span>\n                  <span ng-if="motion.category != null">\n                    <i class="fa fa-sitemap spacer-right"></i>\n                    {{ motion.category.name }}\n                    <i class="fa fa-cog fa-lg spacer-left" ng-show="motion.categoryHover"></i>\n                  </span>\n                </span>\n                <ul class="dropdown-menu" aria-labelledby="dropdownCategory{{ motion.id }}">\n                  <li ng-repeat="category in categories">\n                    <a href ng-click="toggleCategory(motion, category)">\n                      <i class="fa fa-check" ng-if="category.id == motion.category.id"></i>\n                      {{ category.name }}\n                    </a>\n                  </li>\n                </ul>\n              </span>\n            </div>\n            <!-- Category string for normal user -->\n            <div os-perms="!motions.can_manage" ng-show="motion.category != null">\n              <i class="fa fa-sitemap spacer-right"></i>\n              {{ motion.category.name }}\n            </div>\n\n            <!-- Motion block dropdown for manage user -->\n            <div os-perms="motions.can_manage" ng-show="motionBlocks.length > 0"\n                ng-mouseover="motion.motionBlockHover=true"\n                ng-mouseleave="motion.motionBlockHover=false">\n              <span uib-dropdown>\n                <span id="dropdownMotionBlock{{ motion.id }}" class="pointer"\n                  uib-dropdown-toggle uib-tooltip="{{ \'Set a motion block\' | translate }}"\n                  tooltip-class="nobr">\n                  <span ng-if="motion.motionBlock == null" ng-show="motion.hover">\n                    <i class="fa fa-th-large"></i>\n                    <i class="fa fa-plus"></i>\n                  </span>\n                  <span ng-if="motion.motionBlock != null">\n                    <i class="fa fa-th-large spacer-right"></i>\n                    {{ motion.motionBlock.title }}\n                    <i class="fa fa-cog fa-lg spacer-left" ng-show="motion.motionBlockHover"></i>\n                  </span>\n                </span>\n                <ul class="dropdown-menu" aria-labelledby="dropdownMotionBlock{{ motion.id }}">\n                  <li ng-repeat="motionBlock in motionBlocks">\n                    <a href ng-click="toggleMotionBlock(motion, motionBlock)">\n                      <i class="fa fa-check" ng-if="motionBlock.id == motion.motionBlock.id"></i>\n                      {{ motionBlock.title }}\n                    </a>\n                  </li>\n                </ul>\n              </span>\n            </div>\n            <!-- Motion block string for normal user -->\n            <div os-perms="!motions.can_manage" ng-show="motion.motionBlock != null">\n              <i class="fa fa-sitemap spacer-right"></i>\n              {{ motion.motionBlock.title }}\n            </div>\n\n            <!-- Tag dropdown for manage user -->\n            <div os-perms="motions.can_manage" ng-show="tags.length > 0"\n                ng-mouseover="motion.tagHover=true"\n                ng-mouseleave="motion.tagHover=false">\n              <span uib-dropdown>\n                <span id="dropdownTags{{ motion.id }}" class="pointer"\n                  uib-dropdown-toggle uib-tooltip="{{ \'Add a tag\' | translate }}"\n                  tooltip-class="nobr">\n                  <span ng-if="motion.tags.length == 0" ng-show="motion.hover">\n                    <i class="fa fa-tags"></i>\n                    <i class="fa fa-plus"></i>\n                  </span>\n                  <span ng-if="motion.tags.length > 0">\n                    <i class="fa fa-tags spacer-right"></i>\n                    <span ng-repeat="tag in motion.tags">\n                      {{ tag.name }}<span ng-if="!$last">,</span>\n                    </span>\n                    <i class="fa fa-cog fa-lg spacer-left" ng-show="motion.tagHover"></i>\n                  </span>\n                </span>\n                <ul class="dropdown-menu" aria-labelledby="dropdownTags{{ motion.id }}">\n                  <li ng-repeat="tag in tags">\n                    <a href ng-click="toggleTag(motion, tag)">\n                      <i class="fa fa-check" ng-if="hasTag(motion, tag)"></i>\n                      {{ tag.name }}\n                    </a>\n                  </li>\n                </ul>\n              </span>\n            </div>\n            <!-- Tag string for normal user -->\n            <div os-perms="!motions.can_manage" ng-show="motion.tags.length > 0">\n              <i class="fa fa-tags spacer-right"></i>\n              <span ng-repeat="tag in motion.tags">\n                {{ tag.name }}<span ng-if="!$last">,</span>\n              </span>\n            </div>\n\n            <!-- Origin -->\n            <div ng-if="motion.origin">\n              <i class="fa fa-share spacer-right" uib-tooltip="{{ \'Origin\' | translate }}"></i>\n                <div class="popover-wrapper">\n                  <span editable-text="motion.origin" onaftersave="save(motion)">\n                    {{ motion.origin | limitTo:25 }}{{ motion.origin.length > 25 ? \'...\' : \'\' }}\n                  </span>\n                </div>\n            </div>\n          </small>\n        </div>\n        <div style="width: 10%;" class="pull-right optional">\n          <div class="centered" ng-if="config(\'motions_min_supporters\') != 0"\n            uib-tooltip="{{ motion.supporters.length }} {{ \'Supporters\' | translate }}\n            {{ (config(\'motions_min_supporters\') - motion.supporters.length) > 0 ? \'(\' +  (config(\'motions_min_supporters\') - motion.supporters.length) + \' \' + (\'needed\' | translate) + \')\': \'\' }}"\n            tooltip-class="nobr">\n            <span class="badge"\n              ng-class="{\'badge-info\': motion.supporters.length < config(\'motions_min_supporters\')}">\n              {{ motion.supporters.length }}\n            </span>\n          </div>\n        </div>\n        <div style="width: 30%;" class="pull-right">\n          <div class="centered">{{ motion.agenda_item.getItemNumberWithAncestors() }}</div>\n        </div>\n      </div>\n    </div> <!-- data row -->\n\n  </div> <!-- container -->\n</div> <!-- details -->\n'),
n.put("static/templates/motions/motionpoll-form.html",'<h1><translate>Vote</translate> {{ voteNumber }}</h1>\n\n<div uib-alert ng-show="alert.show" ng-class="\'alert-\' + (alert.type || \'warning\')" ng-click="alert={}" close="alert={}">\n  {{ alert.msg }}\n</div>\n\n<p>\n  <translate>Special values</translate>:\n  <span class="badge badge-success">-1</span> = <translate>majority</translate>\n  <span class="badge">-2</span> = <translate>undocumented</translate>\n\n<form name="motionPollForm" ng-submit="save(model)">\n  <formly-form model="model" fields="formFields">\n    <template-hook hook-name="motionPollFormButtons"></template-hook>\n    <button type="submit" ng-disabled="motionPollForm.$invalid" class="btn btn-primary" translate>\n      Save\n    </button>\n    <button ng-click="closeThisDialog()" class="btn btn-default" translate>\n      Cancel\n    </button>\n  </formly-form>\n</form>\n'),n.put("static/templates/motions/slide_motion.html",'<div ng-controller="SlideMotionCtrl" class="content scrollcontent">\n\n  <div id="sidebox">\n    <!-- State -->\n    <h3 translate>State</h3>\n    {{ motion.getStateName() }}\n\n    <!-- Recommendation -->\n    <div ng-if="motion.getRecommendationName() != \'\'">\n      <h3>{{ config(\'motions_recommendations_by\') }}</h3>\n      {{ motion.getRecommendationName() }}\n    </div>\n\n    <!-- Submitters -->\n    <h3 ng-if="motion.submitters.length > 0" translate>Submitters</h3>\n    <div ng-repeat="submitter in motion.submitters">\n      {{ submitter.get_full_name() }}<br>\n    </div>\n\n    <!-- Poll results -->\n    <h3 ng-if="motion.polls.length > 0 && motion.polls[0].has_votes" translate>Voting result</h3>\n      <div ng-repeat="poll in motion.polls | orderBy:\'-id\'" class="spacer">\n        <div ng-show="poll.has_votes" class="pollresults">\n          <strong ng-if="motion.polls.length > 1">\n            <translate>Vote</translate> {{ motion.polls.length - $index }}:\n          </strong>\n          <table class="transparentTable spacer">\n            <!-- yes -->\n            <tr>\n              <td class="icon">\n                <i class="fa fa-thumbs-up fa-2x"></i>\n              <td ng-init="voteYes = poll.getVote(poll.yes, \'yes\')">\n                <span class="result_label"><translate>Yes</translate>:</span>\n                <span class="result_value">\n                  {{ voteYes.value }} {{ voteYes.percentStr }}\n                </span>\n                <div ng-if="voteYes.percentNumber">\n                  <uib-progressbar value="voteYes.percentNumber" type="success"></uib-progressbar>\n                </div>\n            <!-- no -->\n            <tr>\n              <td class="icon">\n                <i class="fa fa-thumbs-down fa-2x"></i>\n              <td ng-init="voteNo = poll.getVote(poll.no, \'no\')">\n                <span class="result_label"><translate>No</translate>:</span>\n                <span class="result_value" >\n                  {{ voteNo.value }} {{ voteNo.percentStr }}\n                </span>\n                <div ng-if="voteNo.percentNumber">\n                  <uib-progressbar value="voteNo.percentNumber" type="danger"></uib-progressbar>\n                </div>\n            <!-- abstain -->\n            <tr>\n              <td class="icon">\n                <strong style="font-size: 26px">&empty;</strong>\n              <td ng-init="voteAbstain = poll.getVote(poll.abstain, \'abstain\')">\n                <span class="result_label"><translate>Abstain</translate>:</span>\n                <span class="result_value">\n                  {{ voteAbstain.value }} {{ voteAbstain.percentStr }}\n                </span>\n                <div ng-if="voteAbstain.percentNumber">\n                  <uib-progressbar value="voteAbstain.percentNumber" type="warning"></uib-progressbar>\n                </div>\n          </table>\n        </div>\n      </div>\n  </div>\n\n  <!-- Title -->\n  <div id="title">\n    <h1>{{  motion.agenda_item.getTitle() || motion.getTitle() }}</h1>\n    <h2>\n      <translate>Motion</translate> {{ motion.identifier }}\n      <span ng-if="motion.versions.length > 1" >| Version {{ motion.getVersion().version_number }}</span>\n    </h2>\n  </div>\n\n  <!-- Preamble -->\n  <div><p>{{ config(\'motions_preamble\') | translate }}</p></div>\n\n  <!-- Text -->\n  <div ng-bind-html="motion.getTextWithLineBreaks(null, line, scroll) | trusted"\n       class="motion-text line-numbers-{{ config(\'motions_default_line_numbering\') }}"></div>\n\n  <!-- Reason -->\n  <h3 ng-if="motion.getReason()" translate>Reason</h3>\n  <div ng-bind-html="motion.getReason() | trusted"></div>\n</div>\n'),n.put("static/templates/motions/slide_motion_block.html",'<div ng-controller="SlideMotionBlockCtrl" class="content scrollcontent">\n  <!-- Title -->\n  <div id="title">\n    <h1>{{ motionBlock.agenda_item.getTitle() }}</h1>\n    <h2 translate>Motion block</h2>\n  </div>\n\n  <!-- motion list -->\n  <div style="display: flex; flex-wrap: wrap;">\n    <div ng-repeat="motion in motionBlock.motions" style="width: 33%;">\n      {{ motion.identifier }}\n      <small>\n        <span class="label" ng-class="\'label-\'+motion.recommendation.css_class">\n              {{ motion.getRecommendationName() }}\n        </span>\n      </small>\n    </div>\n  </div>\n</div>\n'),n.put("static/templates/topics/slide_topic.html",'<div ng-controller="SlideTopicCtrl" class="content scrollcontent">\n  <h1>{{ topic.agenda_item.getTitle() }}</h1>\n  <div ng-bind-html="topic.text | trusted"></div>\n</div>\n'),n.put("static/templates/topics/topic-detail.html",'<div class="header">\n  <div class="title">\n    <div class="submenu">\n      <a ui-sref="agenda.item.list" class="btn btn-sm btn-default">\n        <i class="fa fa-angle-double-left fa-lg"></i>\n        <translate>Back to overview</translate>\n      </a>\n      <!-- List of speakers -->\n      <a ui-sref="agenda.item.detail({id: topic.agenda_item_id})" class="btn btn-sm btn-default">\n        <i class="fa fa-microphone fa-lg"></i>\n        <translate>List of speakers</translate>\n      </a>\n      <!-- project -->\n      <projector-button model="topic" default-projector-id="defaultProjectorId">\n      </projector-button>\n      <!-- edit -->\n      <a os-perms="agenda.can_manage" ng-click="openDialog(topic)"\n          class="btn btn-default btn-sm"\n          title="{{ \'Edit\' | translate}}">\n        <i class="fa fa-pencil"></i>\n      </a>\n    </div>\n    <h1>{{ topic.agenda_item.getTitle() }}</h1>\n    <h2 translate>Topic</h2>\n  </div>\n</div>\n\n<div class="details">\n  <div ng-bind-html="topic.text | trusted"></div>\n  <h3 ng-if="topic.attachments.length > 0" translate>Attachments</h3>\n  <ul>\n    <li ng-repeat="attachment in topic.attachments">\n      <a href="{{ attachment.mediafileUrl }}" target="_blank">\n        {{ attachment.title_or_filename }}\n      </a>\n  </ul>\n</div>\n'),n.put("static/templates/topics/topic-form.html",'<h1 ng-if="model.id" translate>Edit topic</h1>\n<h1 ng-if="!model.id" translate>New topic</h1>\n\n<div uib-alert ng-show="alert.show" ng-class="\'alert-\' + (alert.type || \'warning\')" ng-click="alert={}" close="alert={}">\n  {{ alert.msg }}\n</div>\n\n<form name="topicForm" ng-submit="save(model)">\n  <formly-form model="model" fields="formFields">\n    <button type="submit" ng-disabled="topicForm.$invalid" class="btn btn-primary" translate>\n      Save\n    </button>\n    <button type="button" ng-click="closeThisDialog()" class="btn btn-default" translate>\n      Cancel\n    </button>\n  </formly-form>\n</form>\n'),n.put("static/templates/topics/topic-import.html",'<div class="header">\n  <div class="title">\n    <div class="submenu">\n      <a ui-sref="agenda.item.list" class="btn btn-sm btn-default">\n        <i class="fa fa-angle-double-left fa-lg"></i>\n        <translate>Back to overview</translate>\n      </a>\n    </div>\n    <h1 translate>Import topics</h1>\n  </div>\n</div>\n\n<div class="details">\n<h2 translate>Import by copy/paste</h2>\n<p translate>Copy and paste your topic titles in this textbox. Keep each item in a single line.</p>\n\n<div class="row">\n  <div class="form-group col-sm-6">\n    <textarea ng-model="itemlist" rows="5" class="form-control" ng-list="/\\n/"></textarea>\n  </div>\n</div>\n\n<div class="clearfix">\n  <button ng-click="importByLine()" class="btn btn-primary pull-left" translate>Import</button>\n  <div class="col-xs-5" ng-if="titleItems">\n    <progressbar animate="false" type="success" max="titleItems.length" value="importcounter">\n      <i>{{ importcounter }} / {{ titleItems.length }} {{ "imported" | translate }}</i>\n    </progressbar>\n  </div>\n</div>\n<div class="spacer">\n  <a ng-if="importcounter > 0 && importcounter == titleItems.length" ui-sref="agenda.item.list"\n      class="btn btn-default">\n    <i class="fa fa-angle-double-left fa-lg"></i>\n    <translate>Back to agenda</translate>\n  </a>\n</div>\n\n<hr>\n\n<h2 translate>Import by CSV file</h2>\n  <div class="block row">\n    <div class="title">\n      <h3 translate>Select a CSV file\n    </div>\n    <div class="block right import">\n      <label class="label" for="inputSeparator" translate>Separator</label>\n      <input type="text" ng-model="separator" ng-change="setSeparator()" ng-init="separator=separator" id="inputSeparator">\n      <br>\n      <label class="label" for="selectEncoding" translate>Encoding</label>\n      <select ng-model="encoding" ng-options="enc as enc for enc in encodingOptions"\n          ng-selected="setEncoding()" ng-init="encoding=encoding" id="selectEncoding"></select>\n      <ng-csv-import\n          content="csv.content"\n          header="csv.header"\n          header-visible="csv.headerVisible"\n          separator="csv.separator"\n          separator-visible="csv.separatorVisible"\n          result="csv.result"\n          encoding="csv.encoding"\n          accept="csv.accept"\n          encoding-visible="csv.encodingVisible"></ng-csv-import>\n    </div>\n  </div>\n\n  <h4 translate>Please note:</h4>\n  <ul class="indentation">\n      <li><translate>Required comma or semicolon separated values with these column header names in the first row</translate>:<br>\n          <code>title, text, duration, comment, is_hidden</code>\n      <li translate>Title is required. All other fields are optional and may be empty.\n      <li translate>Only double quotes are accepted as text delimiter (no single quotes).\n      <li><a id="downloadLink" href="" ng-click="downloadCSVExample()" translate>Download CSV example file</a>\n  </ul>\n\n  <div ng-if="csv.result">\n    <h3 translate>Preview</h3>\n    <table ng-if="!csvImporting" class="table table-striped table-bordered table-condensed">\n      <thead>\n        <tr>\n          <th>\n          <th>#\n          <th translate>Title\n          <th translate>Text\n          <th translate>Duration\n          <th translate>Comment\n          <th translate>Is hidden</th>\n      <tbody ng-repeat="item in items">\n        <tr>\n          <td class="minimum"\n              ng-class="{ \'text-danger\': item.importerror, \'text-success\': item.imported }">\n            <span ng-if="item.importerror">\n              <i class="fa fa-exclamation-triangle fa-lg"></i>\n            </span>\n            <span ng-if="!item.importerror && !item.imported">\n              <i class="fa fa-check-circle-o fa-lg"></i>\n            </span>\n            <span ng-if="item.imported">\n              <i class="fa fa-check-circle fa-lg"></i>\n            </span>\n          <td class="minimum">{{ $index + 1 }}\n          <td ng-class="{ \'text-danger\': item.title_error }">\n            <span ng-if="item.title_error" title="{{ item.title_error | translate }}">\n              <i class="fa fa-exclamation-triangle"></i>\n            </span>\n            {{ item.title }}\n          <td>{{ item.text | limitTo:80 }}{{ item.text.length > 80 ? \'...\' : \'\' }}\n          <td>{{ item.duration | osMinutesToTime }}\n          <td>{{ item.comment }}\n          <td>{{ item.is_hidden }}\n    </table>\n\n    <div class="text-danger">\n      <div ng-repeat="item in itemsFailed = (items | filter:{importerror:true})"></div>\n      <i class="fa fa-exclamation-triangle"></i>\n      {{ itemsFailed.length }}\n      <translate>topics will be not imported.</translate>\n    </div>\n    <div>\n      <div ng-repeat="item in itemsPassed = (items | filter:{importerror:false})"></div>\n      <i class="fa fa-check-circle-o fa-lg"></i>\n      {{ items.length - itemsFailed.length }}\n      <translate>topics will be imported.</translate>\n    </div>\n    <div ng-repeat="item in itemsImported = (items | filter:{imported:true})"></div>\n    <div ng-if="itemsImported.length > 0" class="text-success">\n      <hr class="smallhr">\n      <i class="fa fa-check-circle fa-lg"></i>\n      {{ itemsImported.length }}\n      <translate>topics were successfully imported.</translate>\n    </div>\n\n    <div class="spacer">\n      <button ng-click="clear()" class="btn btn-default" translate>\n        Clear preview\n      </button>\n      <button ng-if="!csvImporting && (items.length - itemdFailed.length) > 0" ng-click="import()" class="btn btn-primary" translate>\n        Import {{ items.length - itemsFailed.length }} topics\n      </button>\n    </div>\n    <div class="spacer">\n      <a ng-if="csvimported" ui-sref="agenda.item.list" class="btn btn-default">\n        <i class="fa fa-angle-double-left fa-lg"></i>\n        <translate>Back to agenda</translate>\n      </a>\n    </div>\n  </div>\n</div>\n'),n.put("static/templates/users/group-edit.html",'<h1 ng-if="group" translate>Edit name</h1>\n<h1 ng-if="!group" translate>Create new group</h1>\n<div uib-alert ng-show="alert.show" class="alert-danger" ng-click="alert={}" close="alert={}">\n  {{ alert.msg }}\n</div>\n<label for="name_1">\n  <span ng-if="group">\n    <translate>Please enter a new name for {{ group.name }}:</translate>\n  </span>\n  <span ng-if="!group" translate>\n    Please enter a name for the new group:\n  </span>\n</label>\n<div>\n  <div>\n    <input class="form-control" id="name_1" type="text" ng-model="new_name">\n  </div>\n  <div class="spacer-top-lg">\n    <button ng-click="save()" ng-disabled="new_name == \'\'" class="btn btn-primary" translate>\n      Save\n    </button>\n    <button ng-click="closeThisDialog()" class="btn btn-default" translate>\n      Cancel\n    </button>\n  </div>\n</div>\n'),n.put("static/templates/users/group-list.html",'<div class="header">\n  <div class="title">\n    <div class="submenu">\n      <a ui-sref="users.user.list" class="btn btn-sm btn-default">\n        <i class="fa fa-angle-double-left fa-lg"></i>\n        <translate>Back to overview</translate>\n      </a>\n      <a os-perms="users.can_manage" class="btn btn-primary btn-sm"\n        ng-click="openDialog()" title="add new group">\n        <i class="fa fa-plus fa-lg"></i>\n        <translate>New</translate>\n      </a>\n    </div>\n    <h1 translate>Groups</h1>\n  </div>\n</div>\n\n<div class="details">\n  <p translate>\n    All your changes are saved immediately. Changes you make are only effective once you (or the users concerned) reload the page.\n  </p>\n  <table id="groups-table" class="table table-bordered">\n    <thead>\n      <tr>\n        <th class="perm-head">\n          <h4 translate>Permissions</h4>\n        <th ng-repeat="group in groups" ng-mouseover="group.hover=true" ng-mouseleave="group.hover=false">\n          <span class="optional">\n            {{ group.name | translate }}\n          </span>\n          <span class="optional-show" uib-tooltip="{{ group.name | translate }}">\n            {{ group.name | translate | limitTo: 1 }}...\n          </span>\n          <i class="fa fa-info-circle" ng-if="group.id == 1"\n            uib-tooltip="{{ \'Users without any assigned group gain the permissions from this group.\' | translate }}"></i>\n          <div os-perms="users.can_manage" ng-hide="group.id == 1" class="hoverActions"\n            ng-class="{\'hiddenDiv\': !group.hover}">\n            <!--edit name-->\n            <a href="" ng-click="openDialog(group)">\n              <i class="fa fa-pencil fa-lg"></i></a>\n                &nbsp;\n            <!--delete-->\n            <a href="" class="text-danger"\n              ng-if="group_danger.id != group.id"\n              ng-bootbox-confirm="{{ \'Are you sure you want to delete this entry?\' | translate }}<br>\n              <b>{{ group.name | translate }}</b>"\n              ng-bootbox-confirm-action="delete(group)">\n                <i class="fa fa-trash fa-lg"></i>\n            </a>\n          </div>\n      <tbody ng-repeat="app in apps" os-perms="users.can_manage">\n          <tr class="pointer" ng-click="app.app_visible=!app.app_visible">\n            <td>\n              <b>{{ app.app_name | translate}}</b>\n              <i class="fa" ng-class="app.app_visible ? \'fa-minus-square\' : \'fa-plus-square\'">\n            <td ng-repeat="group in groups">\n              <!-- empty, just filling the table -->\n          <tr ng-repeat="permission in app.permissions" ng-class="{\'collapse\': !app.app_visible}">\n            <td>\n              {{ permission.display_name | translate }}\n            <td class="pointer" ng-repeat="group in groups"\n              ng-click="changePermission(group, permission)">\n              <!-- Simulating a checkbox with FontAwesome icons. -->\n              <i class="fa"\n                ng-if="!danger(group, permission)"\n                ng-class="hasPerm(group, permission) ? \'fa-check-square-o\' : \'fa-square-o\'"></i>\n              <span class="fa fa-stack"\n                 ng-if="danger(group, permission)"\n                 uib-tooltip="{{ \'You are not allowed to lock yourself out of the configuration!\' | translate }}">\n                <i class="fa fa-check-square-o fa-stack-1x"></i>\n                <i class="fa fa-ban fa-stack-2x text-danger"></i>\n              </span>\n  </table>\n</div>\n'),n.put("static/templates/users/slide_user.html",'<div ng-controller="SlideUserCtrl" class="content scrollcontent">\n    <h1>{{ user.get_full_name() }}</h1>\n</div>\n'),n.put("static/templates/users/user-change-password.html",'<div class="header">\n  <div class="title">\n    <div class="submenu">\n      <a ui-sref="users.user.list" class="btn btn-sm btn-default">\n        <i class="fa fa-angle-double-left fa-lg"></i>\n        <translate>Back to overview</translate>\n      </a>\n    </div>\n    <h1 translate>Change password for {{ user.get_short_name() }}</h1>\n  </div>\n</div>\n\n<div class="details">\n  <form name="userForm">\n    <h3 class="text-danger" style="margin-top: 0;">\n      <i class="fa fa-exclamation-triangle"></i>\n      <translate>You override the personally set password of</translate> {{ user.get_short_name() }}!\n    </h3>\n    <div uib-alert ng-show="alert.show" ng-class="\'alert-\' + (alert.type || \'warning\')" ng-click="alert={}" close="alert={}">\n      {{ alert.msg }}\n    </div>\n    <div class="form-group">\n      <label for="inputOldPassword" translate>New password</label>\n      <div class="input-group">\n        <input type="text"\n           ng-model="new_password"\n           class="form-control"\n           name="inputNewPassword"\n           required>\n        </input>\n        <div class="input-group-addon pointer" ng-click="generatePassword()">\n          <i class="fa fa-magic"></i>\n          <translate>Generate</translate>\n        </div>\n      </div>\n      <div class="spacer-top">\n        <span uib-tooltip="{{ \'Initial password can not be changed.\' | translate }}">\n          <i class="fa fa-info-circle"></i>\n          <translate>Initial password</translate>: {{ user.default_password }}\n        </span>\n      </div>\n    </div>\n    <button type="submit" ng-click="save(user)" class="btn btn-primary" translate>\n      Change password\n    </button>\n    <button ui-sref="users.user.list" class="btn btn-default" translate>\n      Cancel\n    </button>\n  </form>\n</div>\n'),n.put("static/templates/users/user-detail-password.html",'<div class="header">\n  <div class="title">\n    <h1 translate>Change password</h1>\n  </div>\n</div>\n\n<div class="details">\n  <p ng-if=\'formError\' class="text-danger">\n    <strong>{{ formError }}</strong>\n  </p>\n  <form name="userForm" >\n    <div class="form-group">\n      <label for="inputOldPassword" translate>Old password</label>\n      <input type="password"\n             ng-model="oldPassword"\n             class="form-control"\n             name="inputOldPassword"\n             required>\n    </div>\n    <div class="form-group">\n      <label for="inputNewPassword" translate>New password</label>\n      <input type="password"\n             ng-model="newPassword"\n             class="form-control"\n             name="inputNewPassword"\n             required>\n    </div>\n    <div class="form-group">\n      <label for="inputNewPassword2" translate>Confirm new password</label>\n      <input type="password"\n             ng-model="newPassword2"\n             class="form-control"\n             name="inputNewPassword2"\n             required>\n    </div>\n    <button type="submit" ng-click="save(user)" class="btn btn-primary" translate>\n      Save\n    </button>\n    <button ui-sref="users.user.list" class="btn btn-default" translate>\n      Cancel\n    </button>\n  </form>\n</div>\n'),n.put("static/templates/users/user-detail-profile.html",'<div class="header">\n  <div class="title">\n    <h1 translate>Edit profile</h1>\n  </div>\n</div>\n\n<div class="details">\n  <p ng-if=\'formError\' class="text-danger">\n    <strong>{{ formError }}</strong>\n  </p>\n  <form name="userForm" >\n    <div class="form-group">\n      <label for="inputUsername" translate>Username</label>\n      <input type="text"\n             ng-model="user.username"\n             class="form-control"\n             name="inputUsername"\n             required>\n    </div>\n    <div class="form-group row">\n      <div class="col-xs-2">\n        <label for="inputTitle" translate-comment="academic degree" translate>Title</label>\n        <input type="text" ng-model="user.title" class="form-control" name="inputTitle">\n      </div>\n      <div class="col-xs-5">\n        <label for="inputFirstName" translate>Given name</label>\n        <input type="text" ng-model="user.first_name" class="form-control" name="inputFirstName">\n      </div>\n      <div class="col-xs-5">\n        <label for="inputLastName" translate>Surname</label>\n        <input type="text" ng-model="user.last_name" class="form-control" name="inputLastName">\n      </div>\n    </div>\n    <div class="form-group">\n      <label for="inputStructureLevel" translate>Structure level</label>\n      <input type="text" ng-model="user.structure_level" class="form-control" name="inputStructureLevel">\n    </div>\n    <div class="form-group">\n      <label for="textAbout" translate>About me</label>\n      <textarea ng-model="user.about_me" class="form-control" name="textAbout" />\n    </div>\n\n    <button type="submit" ng-click="save(user)" class="btn btn-primary" translate>\n      Save\n    </button>\n    <button ui-sref="users.user.list" class="btn btn-default" translate>\n      Cancel\n    </button>\n  </form>\n</div>\n'),n.put("static/templates/users/user-detail.html",'<div class="header">\n  <div class="title">\n    <div class="submenu">\n      <a ui-sref="users.user.list" class="btn btn-sm btn-default">\n        <i class="fa fa-angle-double-left fa-lg"></i>\n        <translate>Back to overview</translate>\n      </a>\n      <!-- project -->\n      <projector-button model="user" default-projector-id="defaultProjectorId">\n      </projector-button>\n      <!-- edit -->\n      <a os-perms="users.can_manage" ng-click="openDialog(user)"\n          class="btn btn-default btn-sm"\n          title="{{ \'Edit\' | translate}}">\n        <i class="fa fa-pencil"></i>\n      </a>\n    </div>\n    <h1>{{ user.get_short_name() }}</h1>\n    <h2 translate>Participant</h2>\n  </div>\n</div>\n\n<div class="details">\n  <div class="user_details form-group">\n    <fieldset>\n      <legend translate>Personal data</legend>\n      <label translate>Structure level</label>\n        {{ user.structure_level }}\n      <label translate>Groups</label>\n        <div ng-repeat="group in user.groups_id">\n          {{ (groups | filter: {id: group})[0].name | translate }}\n        </div>\n      <label translate>Participant number</label>\n        {{ user.number }}\n      <label translate>About me</label>\n        <div ng-bind-html="user.about_me"></div>\n    </fieldset>\n\n    <fieldset os-perms="users.can_manage">\n      <legend translate>Administrative data</legend>\n      <label translate>Username</label>\n        {{ user.username }}\n      <label translate>Comment</label>\n        <div class="white-space-pre-line">{{ user.comment }}</div>\n    </fieldset>\n  </div>\n</div>\n'),n.put("static/templates/users/user-form.html",'<h1 ng-if="model.id" translate>Edit participant</h1>\n<h1 ng-if="!model.id" translate>New participant</h1>\n\n<div uib-alert ng-show="alert.show" ng-class="\'alert-\' + (alert.type || \'warning\')" ng-click="alert={}" close="alert={}">\n  {{ alert.msg }}\n</div>\n\n<form name="userForm" ng-submit="save(model)">\n  <formly-form model="model" fields="formFields">\n    <button type="submit" ng-disabled="userForm.$invalid" class="btn btn-primary" translate>\n      Save\n    </button>\n    <button ng-click="closeThisDialog()" class="btn btn-default" translate>\n      Cancel\n    </button>\n  </formly-form>\n</form>\n'),n.put("static/templates/users/user-import.html",'<div class="header">\n  <div class="title">\n    <div class="submenu">\n      <a ui-sref="users.user.list" class="btn btn-sm btn-default">\n        <i class="fa fa-angle-double-left fa-lg"></i>\n        <translate>Back to overview</translate>\n      </a>\n    </div>\n    <h1 translate>Import participants</h1>\n  </div>\n</div>\n\n<div class="details">\n  <h2 translate>Import by copy/paste</h2>\n  <p translate>Copy and paste your participant names in this textbox.\n  Keep each person in a single line.</p>\n\n  <div class="row">\n    <div class="form-group col-sm-6">\n      <textarea ng-model="userlist" rows="5" class="form-control" ng-list="/\\n/"></textarea>\n    </div>\n  </div>\n\n  <div class="clearfix">\n    <button ng-click="importByLine()" class="btn btn-primary pull-left" translate>Import</button>\n    <div class="col-xs-5" ng-if="usernames">\n      <progressbar animate="false" type="success" max="usernames.length" value="importcounter">\n        <i>{{ importcounter }} / {{ usernames.length }} {{ "imported" | translate }}</i>\n      </progressbar>\n    </div>\n  </div>\n  <div class="spacer">\n    <a ng-if="importcounter > 0 && importcounter == usernames.length" ui-sref="users.user.list"\n        class="btn btn-default">\n      <i class="fa fa-angle-double-left fa-lg"></i>\n      <translate>Back to users overview</translate>\n    </a>\n  </div>\n\n  <hr>\n\n  <h2 translate>Import by CSV file</h2>\n\n  <div class="block row">\n    <div class="title">\n      <h3 translate>Select a CSV file\n    </div>\n    <div class="block right import">\n      <label class="label" for="inputSeparator" translate>Separator</label>\n      <input type="text" ng-model="separator" ng-change="setSeparator()" ng-init="separator=separator" id="inputSeparator">\n      <br>\n      <label class="label" for="selectEncoding" translate>Encoding</label>\n      <select ng-model="encoding" ng-options="enc as enc for enc in encodingOptions"\n          ng-selected="setEncoding()" ng-init="encoding=encoding" id="selectEncoding"></select>\n      <ng-csv-import\n          content="csv.content"\n          header="csv.header"\n          header-visible="csv.headerVisible"\n          separator="csv.separator"\n          separator-visible="csv.separatorVisible"\n          result="csv.result"\n          accept="csv.accept"\n          encoding="csv.encoding"\n          encoding-visible="csv.encodingVisible"></ng-csv-import>\n    </div>\n  </div>\n\n  <h4 translate>Please note:</h4>\n  <ul class="indentation">\n      <li><translate>Required comma or semicolon separated values with these column header names in the first row</translate>:<br>\n          <code>title, first_name, last_name, structure_level, number, groups, comment, is_active, is_present, is_committee</code>\n      <li translate>At least given name or surname have to be filled in. All\n        other fields are optional and may be empty.\n      <li translate>Only double quotes are accepted as text delimiter (no single quotes).\n      <li><a id="downloadLink" href="" ng-click="downloadCSVExample()" translate>Download CSV example file</a>\n  </ul>\n\n  <div ng-show="csv.result">\n    <h3 translate>Preview</h3>\n    <table class="table table-striped table-bordered table-condensed">\n      <thead>\n        <tr>\n          <th>\n          <th>#\n          <th translate>Title\n          <th translate>Given name\n          <th translate>Surname\n          <th translate>Structure level\n          <th translate>Participant number\n          <th translate>Groups\n          <th translate>Comment\n          <th translate>Is active\n          <th translate>Is present\n          <th translate>Is committee</th>\n          <th ng-if="duplicates > 0">\n            <i class="fa fa-exclamation-triangle text-danger"></i>\n            <strong class="text-danger" ng-if="duplicates == 1">1 <translate>duplicate</translate></strong>\n            <strong class="text-danger" ng-if="duplicates > 1">{{ duplicates }} <translate>duplicates</translate></strong>\n\n              <div uib-dropdown>\n                <button id="GlobalAction" type="button" class="btn btn-default btn-danger btn-sm" uib-dropdown-toggle>\n                  <translate>Set global action</translate>\n                  <span class="caret"></span>\n                </button>\n                <ul class="dropdown-menu" aria-labelledby="GlobalAction">\n                  <li ng-repeat="action in duplicateActions">\n                    <a href ng-click="setGlobalAction(action)">\n                      {{ action | translate }}\n                    </a>\n                  </li>\n                </ul>\n              </div>\n          </th>\n      <tbody>\n        <tr ng-repeat="user in users | limitTo : itemsPerPage : limitBegin">\n          <td class="minimum"\n              ng-class="{ \'text-danger\': (user.importerror || user.duplicateAction == duplicateActions[0]), \'text-success\': user.imported }">\n            <span ng-if="user.importerror || user.duplicateAction == duplicateActions[0]">\n              <i class="fa fa-exclamation-triangle fa-lg"></i>\n            </span>\n            <span ng-if="!user.importerror && !user.imported && user.duplicateAction != duplicateActions[0]">\n              <i class="fa fa-check-circle-o fa-lg"></i>\n            </span>\n            <span ng-if="user.imported">\n              <i class="fa fa-check-circle fa-lg"></i>\n            </span>\n          <td>\n            {{ (currentPage - 1) * itemsPerPage + $index + 1 }}\n          <td>\n            {{ user.title }}\n          <td ng-class="{ \'text-danger\': user.name_error }">\n            <span ng-if="!user.first_name && user.name_error" title="{{ user.name_error | translate }}">\n              <i class="fa fa-exclamation-triangle"></i>\n            </span>\n            {{ user.first_name }}\n          <td ng-class="{ \'text-danger\': user.name_error }">\n            <span ng-if="!user.last_name && user.name_error" title="{{ user.name_error | translate }}">\n              <i class="fa fa-exclamation-triangle"></i>\n            </span>\n            {{ user.last_name }}\n          <td>\n            {{ user.structure_level }}\n          <td>\n            {{ user.number }}\n          <td>\n            <div ng-repeat="groupname in user.groupsNotToCreate">\n              {{ groupname | translate }}\n            </div>\n            <div ng-repeat="groupname in user.groupsToCreate" class="text-warning">\n              <i class="fa fa-plus-circle"></i>\n              {{ groupname | translate }}\n            </div>\n          <td style="max-width: 130px;">\n            <span uib-tooltip="{{ user.comment }}">\n              {{ user.comment | limitTo: 30 }}{{ user.comment.length > 30 ? \'...\' : \'\' }}\n            </span>\n          <td>\n            <i class="fa pointer" ng-class="user.is_active ? \'fa-check-square-o\' : \'fa-square-o\'"\n              ng-click="user.is_active = !user.is_active"></i>\n          <td>\n            <i class="fa pointer" ng-class="user.is_present ? \'fa-check-square-o\' : \'fa-square-o\'"\n              ng-click="user.is_present = !user.is_present"></i>\n          <td>\n            <i class="fa pointer" ng-class="user.is_committee ? \'fa-check-square-o\' : \'fa-square-o\'"\n              ng-click="user.is_committee = !user.is_committee"></i>\n          <td ng-if="duplicates > 0">\n              <div ng-if="user.duplicate" uib-tooltip="{{ user.duplicate_info }}" uib-dropdown>\n                <button id="UserAction{{ $index }}" type="button" class="btn btn-default btn-sm"\n                  uib-dropdown-toggle ng-class="user.duplicateAction == duplicateActions[0] ? \'btn-warning\' : (user.duplicateAction == duplicateActions[1] ? \'btn-danger\' : \'btn-success\')">\n                  {{ user.duplicateAction | translate }}\n                  <span class="caret"></span>\n                </button>\n                <ul class="dropdown-menu" aria-labelledby="UserAction{{ $index }}">\n                  <li ng-repeat="action in duplicateActions">\n                      <a href ng-click="user.duplicateAction = action; calcStats()">\n                        <i class="fa fa-check" ng-if="user.duplicateAction == action"></i>\n                        {{ action | translate }}\n                      </a>\n                  </li>\n                </ul>\n    </table>\n    <ul uib-pagination\n        ng-show="users.length > itemsPerPage"\n        total-items="users.length"\n        items-per-page="itemsPerPage"\n        ng-model="currentPage"\n        ng-change="pageChanged()"\n        class="pagination-sm"\n        direction-links="false"\n        boundary-links="true"\n        first-text="&laquo;"\n        last-text="&raquo;">\n    </ul>\n\n    <div class="text-danger">\n      <i class="fa fa-exclamation-triangle"></i>\n      {{ usersWillNotBeImported }}\n      <translate>participants will be not imported.</translate>\n    </div>\n    <div>\n      <i class="fa fa-check-circle-o fa-lg"></i>\n      {{ usersWillBeImported }}\n      <translate>participants will be imported.</translate>\n    </div>\n    <div ng-repeat="user in usersImported = (users | filter:{imported:true})"></div>\n    <div ng-if="usersImported.length > 0" class="text-success">\n      <hr class="smallhr">\n      <i class="fa fa-check-circle fa-lg"></i>\n      {{ usersImported.length }}\n      <translate>participants were successfully imported.</translate>\n      (<translate>Groups created</translate>: {{ groupsCreated }})\n    </div>\n\n    <div class="spacer">\n      <button ng-click="clear()" class="btn btn-default" translate>\n        Clear preview\n      </button>\n      <button ng-if="!csvImporting && usersWillBeImported > 0" ng-click="import()" class="btn btn-primary" translate>\n        Import {{ usersWillBeImported }} participants\n      </button>\n    </div>\n    <div class="spacer">\n      <a ng-if="csvimported" ui-sref="users.user.list" class="btn btn-default">\n        <i class="fa fa-angle-double-left fa-lg"></i>\n        <translate>Back to users overview</translate>\n      </a>\n    </div>\n  </div>\n</div>\n'),
n.put("static/templates/users/user-list.html",'<div class="header">\n  <div class="title">\n    <div class="submenu">\n      <a ng-click="openDialog()" os-perms="users.can_manage" class="btn btn-primary btn-sm">\n        <i class="fa fa-plus fa-lg"></i>\n        <translate>New</translate>\n      </a>\n      <a ui-sref="users.group.list" os-perms="users.can_manage" class="btn btn-default btn-sm">\n        <i class="fa fa-group fa-lg"></i>\n        <translate>Groups</translate>\n      </a>\n      <a ui-sref="users.user.import" os-perms="users.can_manage" class="btn btn-default btn-sm">\n        <i class="fa fa-download fa-lg"></i>\n        <translate>Import</translate>\n      </a>\n    </div>\n    <h1 translate>Participants</h1>\n  </div>\n</div>\n\n<div class="details">\n  <div class="row">\n    <div class="col-sm-6">\n      <!-- select mode -->\n      <button os-perms="users.can_manage" class="btn"\n          ng-class="$parent.isSelectMode ? \'btn-primary\' : \'btn-default\'"\n          ng-click="$parent.isSelectMode = !$parent.isSelectMode; uncheckAll()">\n        <i class="fa fa-check-square-o"></i>\n        <translate>Select ...</translate>\n      </button>\n    </div>\n    <div class="col-sm-6">\n      <div class="dropdown pull-right" uib-dropdown>\n        <button os-perms="users.can_manage" class="btn btn-default" uib-dropdown-toggle\n            id="user-pdf-dropdown">\n          <i class="fa fa-upload"></i>\n          <span ng-if="usersFiltered.length == users.length" translate>\n            Export all\n          </span>\n          <span ng-if="usersFiltered.length != users.length" translate>\n            Export filtered\n          </span>\n          <span class="caret"></span>\n        </button>\n        <ul class="dropdown-menu" dropdown-menu-right aria-labelledby="user-pdf-dropdown">\n          <li>\n              <a href="" ng-click="pdfExportUserList()">\n                <i class="fa fa-list fa-fw"></i>\n                <translate>List of participants</translate> (PDF)\n              </a>\n          <li os-perms="users.can_manage">\n              <a href="" ng-click="pdfExportUserAccessDataList()">\n                <i class="fa fa-qrcode fa-fw"></i>\n                <translate>List of access data</translate> (PDF)\n              </a>\n          <li>\n              <a href="" id="downloadLinkCSV" ng-click="csvExport()">\n                <i class="fa fa-file-text-o fa-fw"></i>\n                CSV\n              </a>\n        </ul>\n      </div>\n    </div>\n  </div>\n  <div uib-collapse="!isSelectMode" class="row spacer">\n    <div os-perms="users.can_manage" ng-show="isSelectMode" class="col-sm-12 text-left form-inline">\n      <!-- actions -->\n      <select ng-model="selectedAction" class="form-control">\n        <option value="" translate>--- Select action ---</option>\n        <option value="delete" translate>Delete</option>\n        <option value="addGroup" translate>Add group</option>\n        <option value="removeGroup" translate>Remove group</option>\n        <option value="generatePasswords" translate>Generate new passwords</option>\n      </select>\n      <!-- delete button -->\n      <a ng-show="selectedAction == \'delete\'"\n        ng-bootbox-confirm="{{ \'Are you sure you want to delete all selected users?\' | translate }}"\n        ng-bootbox-confirm-action="deleteMultiple()"\n        class="btn btn-default">\n        <i class="fa fa-trash fa-lg"></i>\n        <translate>Delete selected participants</translate>\n      </a>\n      <!-- group select -->\n      <select ng-show="selectedAction == \'addGroup\' || selectedAction == \'removeGroup\'"\n          ng-model="selectedGroup" class="form-control">\n        <option value="" translate>--- Select group ---</option>\n        <option ng-repeat="group in groups" value="{{ group.id }}">{{ group.name | translate }}</option>\n      </select>\n      <!-- add group button -->\n      <a ng-show="selectedAction == \'addGroup\'"\n          ng-click="addGroupMultiple(selectedGroup)" class="btn btn-default">\n        <i class="fa fa-plus fa-lg"></i>\n        <translate>Add group</translate>\n      </a>\n      <!-- remove group button -->\n      <a ng-show="selectedAction == \'removeGroup\'"\n          ng-click="removeGroupMultiple(selectedGroup)" class="btn btn-default">\n        <i class="fa fa-minus fa-lg"></i>\n        <translate>Remove group</translate>\n      </a>\n      <!-- generate new password button -->\n      <a ng-show="selectedAction == \'generatePasswords\'" class="btn btn-default"\n        ng-click="generateNewPasswordsMultiple()">\n        <i class="fa fa-magic"></i>\n        <translate>Generate new passwords</translate>\n      </a>\n    </div>\n  </div>\n\n  <div class="spacer-top-lg italic">\n    {{ usersFiltered.length }} /\n    {{ users.length }} {{ "participants" | translate }}<span ng-if="(users|filter:{selected:true}).length > 0">,\n    {{(users|filter:{selected:true}).length}} {{ "selected" | translate }}</span>\n  </div>\n\n  <!-- filter users (for user with \'can_see_extra_data\' permission) - consider present filter -->\n  <div os-perms="users.can_see_extra_data">\n    <span ng-repeat="user in $parent.usersFiltered = (users\n      | osFilter: filter.filterString : filter.getObjectQueryString\n      | filter: {is_present: filter.booleanFilters.isPresent.value}\n      | filter: {is_active: filter.booleanFilters.isActive.value}\n      | filter: {is_committee: filter.booleanFilters.isCommittee.value}\n      | MultiselectFilter: filter.multiselectFilters.group : getItemId.group\n      | orderBy: sort.column: sort.reverse)"></span>\n  </div>\n  <!-- filter users (for user without \'can_see_extra_data\' permission) -->\n  <div os-perms="!users.can_see_extra_data"\n      ng-repeat="user in $parent.usersFiltered = (users\n      | osFilter: filter.filterString : filter.getObjectQueryString\n      | filter: {is_committee: filter.booleanFilters.isCommittee.value}\n      | MultiselectFilter: filter.multiselectFilters.group : getItemId.group\n      | orderBy: sort.column: sort.reverse)"></div>\n\n  <div class="os-table container-fluid">\n    <div class="row header-row">\n      <div class="col-xs-1 centered" ng-show="isSelectMode" os-perms="users.can_manage">\n        <i class="fa text-danger pointer" ng-class="selectedAll ? \'fa-check-square-o\' : \'fa-square-o\'"\n          ng-click="checkAll()"></i>\n      </div>\n      <div class="col-xs-11 main-header">\n        <span class="form-inline text-right pull-right">\n          <!-- reset Filters -->\n          <span class="sort-spacer pointer" ng-click="filter.reset()"\n            ng-if="filter.areFiltersSet()" ng-disabled="isSelectMode"\n            ng-class="{\'disabled\': isSelectMode}">\n            <i class="fa fa-times-circle"></i>\n            <translate>Filter</translate>\n          </span>\n          <!-- Group filter -->\n          <span uib-dropdown>\n            <span class="pointer" id="dropdownGroup" uib-dropdown-toggle\n              ng-class="{\'bold\': filter.multiselectFilters.group.length > 0, \'disabled\': isSelectMode}"\n              ng-disabled="isSelectMode">\n              <translate>Groups</translate>\n              <span class="caret"></span>\n            </span>\n            <ul class="dropdown-menu dropdown-menu-right" aria-labelledby="dropdownGroup">\n              <li ng-repeat="group in groups">\n                <a href ng-click="filter.operateMultiselectFilter(\'group\', group.id, isSelectMode)">\n                  <i class="fa fa-check" ng-if="filter.multiselectFilters.group.indexOf(group.id) > -1"></i>\n                  {{ group.name | translate }}\n                </a>\n              </li>\n              <li class="divider"></li>\n              <li>\n                <a href ng-click="filter.operateMultiselectFilter(\'group\', -1, isSelectMode)">\n                  <i class="fa fa-check" ng-if="filter.multiselectFilters.group.indexOf(-1) > -1"></i>\n                  <translate>No group set</translate>\n                </a>\n              </li>\n            </ul>\n          </span>\n          <!-- boolean Filters -->\n          <span ng-repeat="(name, booleanFilter) in filter.booleanFilters"\n            ng-if="!booleanFilter.needExtraPermission || operator.hasPerms(\'users.can_see_extra_data\')" uib-dropdown>\n            <span class="pointer" id="dropdown{{ name }}" uib-dropdown-toggle\n              ng-class="{\'bold\': booleanFilter.value !== undefined, \'disabled\': isSelectMode}"\n              ng-disabled="isSelectMode">\n              {{ booleanFilter.displayName | translate }}\n              <span class="caret"></span>\n            </span>\n            <ul class="dropdown-menu dropdown-menu-right" aria-labelledby="dropdown{{ name }}">\n              <li>\n                <a href ng-click="booleanFilter.value = (booleanFilter.value ? undefined : true); filter.save();">\n                  <i class="fa" ng-class="{\'fa-check\': booleanFilter.value === true}"></i>\n                  {{ booleanFilter.choiceYes | translate }}\n                </a>\n              </li>\n              <li>\n                <a href ng-click="booleanFilter.value = (booleanFilter.value === false) ? undefined : false; filter.save();">\n                  <i class="fa" ng-class="{\'fa-check\': booleanFilter.value === false}"></i>\n                  {{ booleanFilter.choiceNo | translate }}\n                </a>\n              </li>\n            </ul>\n          </span>\n          <!-- dropdown sort -->\n          <span uib-dropdown>\n            <span class="pointer" id="dropdownSort" uib-dropdown-toggle\n              ng-class="{\'disabled\': isSelectMode}"\n              ng-disabled="isSelectMode">\n              <translate>Sort</translate>\n              <span class="caret"></span>\n            </span>\n            <ul class="dropdown-menu dropdown-menu-right dropdown-entries" aria-labelledby="dropdownSort">\n              <li ng-repeat="option in sortOptions">\n                <a href ng-click="sort.toggle(option.name)">\n                  {{ option.display_name | translate }}\n                  <span class="spacer-right pull-right"></span>\n                  <i class="pull-right fa"\n                    ng-style="{\'visibility\': sort.column === option.name ? \'visible\' : \'hidden\'}"\n                    ng-class="sort.reverse ? \'fa-sort-desc\' : \'fa-sort-asc\'">\n                  </i>\n                </a>\n              </li>\n            </ul>\n          </span>\n          <!-- search field -->\n          <span class="form-group">\n            <span class="input-group">\n              <span class="input-group-addon"><i class="fa fa-search"></i></span>\n              <input type="text" ng-model="filter.filterString" class="form-control" ng-model-options="{debounce: 500}" \n                 placeholder="{{ \'Search\' | translate}}" ng-disabled="isSelectMode"\n                 ng-change="filter.save()">\n            </span>\n          </span>\n        </span>\n        <!-- show all selected multiselectoptions -->\n        <span>\n          <span ng-repeat="group in groups" class="pointer spacer-left-lg"\n            ng-if="filter.multiselectFilters.group.indexOf(group.id) > -1"\n            ng-click="filter.operateMultiselectFilter(\'group\', group.id, isSelectMode)"\n            ng-class="{\'disabled\': isSelectMode}">\n            <span class="nobr">\n              <i class="fa fa-times-circle"></i>\n              {{ group.name | translate }}\n            </span>\n          </span>\n          <span ng-if="filter.multiselectFilters.group.indexOf(-1) > -1" class="pointer spacer-left-lg"\n            ng-click="filter.operateMultiselectFilter(\'group\', -1, isSelectMode)"\n            ng-class="{\'disabled\': isSelectMode}">\n            <i class="fa fa-times-circle"></i>\n            <translate>No group set</translate>\n          </span>\n          <!-- for all boolean Filters -->\n          <span ng-repeat="(name, booleanFilter) in filter.booleanFilters"\n            ng-hide="booleanFilter.value === undefined"\n            class="pointer spacer-left-lg"\n            ng-click="booleanFilter.value = undefined; filter.save();"\n            ng-class="{\'disabled\': isSelectMode}">\n            <span class="nobr">\n              <i class="fa fa-times-circle"></i>\n              {{ booleanFilter.value ? booleanFilter.choiceYes : booleanFilter.choiceNo | translate }}\n            </span>\n          </span>\n        </span>\n      </div>\n    </div>\n\n    <!-- main table -->\n    <div class="row data-row" ng-mouseover="user.hover=true"\n      ng-mouseleave="user.hover=false"\n      ng-class="{\'projected\': user.isProjected().length}"\n      ng-repeat="user in usersFiltered\n      | limitTo : itemsPerPage : limitBegin">\n\n      <!-- select column -->\n      <div ng-show="isSelectMode" os-perms="users.can_manage" class="col-xs-1 centered">\n        <i class="fa text-danger pointer" ng-click="user.selected=!user.selected"\n        ng-class="user.selected ? \'fa-check-square-o\' : \'fa-square-o\'"></i>\n      </div>\n      <!-- projector column -->\n      <div class="col-xs-1 centered projector" os-perms="core.can_manage_projector">\n        <projector-button model="user" default-projector-id="defaultProjectorId">\n        </projector-button>\n      </div>\n      <div class="no-projector-spacer" os-perms="!core.can_manage_projector"></div>\n      <!-- main content column -->\n      <div class="col-xs-6 content">\n        <div class="spacer-right"> <!-- horizontal block -->\n          <i ng-style="{\'visibility\': user.is_active === false ? \'visible\' : \'hidden\'}" class="fa fa-ban"\n            title="{{ \'Is inactive\' | translate }}"></i>\n          <i ng-style="{\'visibility\': user.is_committee ? \'visible\' : \'hidden\'}" class="fa fa-university"\n            title="{{ \'Is a committee\' | translate }}"></i>\n        </div>\n        <div>\n          <div> <!-- vertical block -->\n            <a ui-sref="users.user.detail({id: user.id})" class="title">{{ user.get_short_name() }}</a>\n          </div>\n          <div os-perms="users.can_manage"> <!-- user number -->\n            <div ng-if="user.number" editable-text="user.number" onaftersave="save(user)">\n              <translate translate-comment="abbreviation for number">No.</translate> {{ user.number }}\n            </div>\n          </div>\n          <div os-perms="!users.can_manage" ng-if="user.number">\n              <translate translate-comment="abbreviation for number">No.</translate> {{ user.number }}\n          </div>\n          <div os-perms="users.can_manage" ng-class="{\'hiddenDiv\': !user.hover}">\n            <small>\n              <a href="" ng-click="openDialog(user)" translate>Edit</a> &middot;\n              <a ui-sref="users.user.change-password({id: user.id})" translate>Change password</a> &middot;\n              <a href="" class="text-danger"\n                  ng-bootbox-confirm="{{ \'Are you sure you want to delete this entry?\' | translate }}<br>\n                  <b>{{ user.get_short_name() }}</b>"\n                  ng-bootbox-confirm-action="delete(user)" translate>Delete</a>\n            </small>\n          </div>\n        </div>\n      </div>\n\n      <!-- additional content column -->\n      <div class="col-xs-4 content" ng-style="{\'width\': isSelectMode ? \'calc(50% - 120px)\' : \'calc(50% - 70px)\'}">\n        <div style="width: 60%;" class="optional">\n          <small>\n            <!-- Group dropdown for manage user -->\n            <div os-perms="users.can_manage" ng-show="groups.length > 0"\n              uib-tooltip="{{ \'Groups\' | translate }}" tooltip-placement="top-left"\n              ng-mouseover="user.groupHover=true"\n              ng-mouseleave="user.groupHover=false">\n              <span uib-dropdown>\n                <span id="dropdown-group{{ user.id }}" class="pointer" uib-dropdown-toggle>\n                  <span ng-if="!user.groups_id.length" ng-show="user.hover">\n                    <i class="fa fa-users"></i>\n                    <i class="fa fa-plus"></i>\n                  </span>\n                  <span ng-if="user.groups_id.length">\n                    <i class="fa fa-users"></i>\n                    <span ng-repeat="group in user.groups_id | limitTo:2">\n                      {{ (groups | filter: {id: group})[0].name | translate }}<span ng-if="!$last">,</span></span><span ng-if="user.groups_id.length > 2">,\n                      ... [+{{ user.groups_id.length - 2}}]</span>\n                    <i class="fa fa-cog fa-lg spcaer-left" ng-show="user.groupHover"></i>\n                  </span>\n                </span>\n                <ul class="dropdown-menu" aria-labelledby="dropdown-group{{ user.id }}">\n                  <li ng-repeat="group in groups">\n                    <a href ng-click="toggleGroup(user, group)">\n                      <i class="fa fa-check" ng-if="inArray(user.groups_id, group.id)"></i>\n                      {{ group.name | translate }}\n                    </a>\n                  </li>\n                </ul>\n              </span>\n            </div>\n            <!-- Group dropdown for normal user -->\n            <div os-perms="!users.can_manage" ng-show="user.groups_id.length"\n              uib-tooltip="{{ \'Groups\' | translate }}" tooltip-placement="top-left">\n              <i class="fa fa-users"></i>\n              <span ng-repeat="group in user.groups_id | limitTo:2">\n                {{ (groups | filter: {id: group})[0].name | translate }}<span ng-if="!$last">,</span></span><span ng-if="user.groups_id.length > 2">,\n                ... [+{{ user.groups_id.length - 2}}]</span>\n              <!-- sorry for merging them together, but otherwise there would be a whitespace because of the new line -->\n            </div>\n\n            <div os-perms="users.can_manage" ng-show="user.structure_level || user.hover">\n              <div class="popover-wrapper" uib-tooltip="{{ \'Structure level\' | translate }}" tooltip-placement="top-left">\n                <i class="fa fa-flag"></i>\n                <span editable-text="user.structure_level" onaftersave="save(user)">\n                  {{ user.structure_level || (\'Set structure level...\' | translate)}}\n                </span>\n              </div>\n            </div>\n            <div os-perms="!users.can_manage">\n              <div ng-if="user.structure_level" uib-tooltip="{{ \'Structure level\' | translate }}" tooltip-placement="top-left">\n                <i class="fa fa-flag"></i>\n                {{ user.structure_level }}\n              </div>\n            </div>\n\n            <div os-perms="users.can_manage" ng-show="user.comment || user.hover">\n              <div class="popover-wrapper" uib-tooltip="{{ \'Comment\' | translate }}" tooltip-placement="top-left">\n                <i class="fa fa-info-circle"></i>\n                <span editable-text="user.comment" onaftersave="save(user)">\n                  {{ user.comment || (\'Set comment...\' | translate)}}\n                </span>\n              </div>\n            </div>\n            <div os-perms="!users.can_manage">\n              <div ng-if="user.comment" uib-tooltip="{{ \'Comment\' | translate }}" tooltip-placement="top-left">\n                <i class="fa fa-info-circle"></i>\n                {{ user.comment | limitTo:25}}{{ user.comment.length > 25 ? \'...\' : \'\' }}\n              </div>\n            </div>\n          </small>\n        </div>\n        <div style="width: 40%;" class="pull-right" os-perms="users.can_see_extra_data">\n          <div os-perms="users.can_manage">\n            <span class="pointer nobr" ng-click="user.is_present = !user.is_present; save(user);" ng-show="user.hover || user.is_present">\n              <i class="fa" ng-class="user.is_present ? \'fa-check-square-o\' : \'fa-square-o\'"></i>\n              <span class="spacer-left" translate>Present</span>\n            </span>\n          </div>\n        </div>\n      </div>\n\n    </div><!-- end data row -->\n  </div><!-- end os-table -->\n\n  <ul uib-pagination\n      total-items="usersFiltered.length"\n      items-per-page="itemsPerPage"\n      ng-model="currentPage"\n      ng-change="pageChanged()"\n      class="pagination-sm"\n      direction-links="false"\n      boundary-links="true"\n      first-text="&laquo;"\n      last-text="&raquo;">\n  </ul>\n</div>\n'),n.put("static/templates/motions/motion-detail/change-summary.html",'<!-- A summary of all changes -->\n<section class="change-recommendation-overview">\n    <h2>\n        <translate>Summary of change recommendations</translate>\n    </h2>\n    <ul ng-if="change_recommendations.length > 0">\n        <li ng-repeat="change in (changes = (change_recommendations | filter:{motion_version_id:version}:true | orderBy: \'line_from\')) "\n            ng-click="viewChangeRecommendations.scrollToDiffBox(change.id)">\n            <span ng-if="change.line_from >= change.line_to - 1" class="line-number">\n                <translate>Line</translate> {{ change.line_from }}:\n            </span>\n            <span ng-if="change.line_from < change.line_to - 1" class="line-number">\n                <translate>Line</translate> {{ change.line_from }} - {{ change.line_to - 1 }}:\n            </span>\n            <span class="operation">\n                <translate ng-if="change.getType(motion.getVersion(version).text) == 0">Replacement</translate>\n                <translate ng-if="change.getType(motion.getVersion(version).text) == 1">Insertion</translate>\n                <translate ng-if="change.getType(motion.getVersion(version).text) == 2">Deletion</translate>\n            </span>\n            <span class="status">\n                <translate ng-if="change.rejected">Rejected</translate>\n            </span>\n        </li>\n    </ul>\n    <div ng-if="change_recommendations.length == 0" class="no-changes">\n        <translate>No change recommendations yet</translate>\n    </div>\n</section>\n'),n.put("static/templates/motions/motion-detail/toolbar.html",'<div class="motion-toolbar">\n    <!-- inline editing -->\n    <div class="pull-right inline-editing-activator"\n         ng-if="motion.isAllowed(\'update\') && version == motion.getVersion(-1).id && viewChangeRecommendations.mode == \'original\'">\n        <button ng-if="!inlineEditing.active && change_recommendations.length == 0" ng-click="inlineEditing.enable()"\n                class="btn btn-sm btn-default">\n            <i class="fa fa-pencil-square-o"></i>\n            <translate>Inline editing</translate>\n        </button>\n        <button ng-if="inlineEditing.active && change_recommendations.length == 0" ng-click="inlineEditing.disable()"\n                class="btn btn-sm btn-default">\n            <i class="fa fa-times-circle"></i>\n            <translate>Inline editing</translate>\n        </button>\n        <button ng-if="change_recommendations.length > 0" class="btn btn-sm btn-default" disabled\n                title="{{ \'Editing the text is not possible anymore once there are change recommendations.\' | translate }}">\n            <i class="fa fa-pencil-square-o"></i>\n            <translate>Inline editing</translate>\n        </button>\n    </div>\n\n    <div class="toolbar-left {{ lineNumberMode }}">\n\n        <!-- line number mode -->\n        <div class="btn-group" data-toggle="buttons">\n            <span class="btn btn-sm btn-default disabled">\n                <i class="fa fa-list-ol" aria-hidden="true"></i>\n                <translate>Line numbering</translate>:\n            </span>\n            <label class="btn btn-sm btn-default" ng-class="{active: (lineNumberMode == \'none\')}"\n                   ng-click="setLineNumberMode(\'none\')">\n                <input type="radio" name="lineNumberMode" value="none" ng-model="lineNumberMode"\n                       ng-checked="lineNumberMode == \'none\'">\n                <translate>none</translate>\n            </label>\n            <label class="btn btn-sm btn-default" ng-class="{active: (lineNumberMode == \'inline\')}"\n                   ng-click="setLineNumberMode(\'inline\')">\n                <input type="radio" name="lineNumberMode" value="inline" ng-model="lineNumberMode"\n                       ng-checked="lineNumberMode == \'inline\'">\n                <translate>inline</translate>\n            </label>\n            <label class="btn btn-sm btn-default" ng-class="{active: (lineNumberMode == \'outside\')}"\n                   ng-click="setLineNumberMode(\'outside\')">\n                <input type="radio" name="lineNumberMode" value="outside" ng-model="lineNumberMode"\n                       ng-checked="lineNumberMode == \'outside\'">\n                <translate>outside</translate>\n            </label>\n        </div>\n\n        <!-- go to line number -->\n        <div class="goto-line-number">\n            <form class="input-group" ng-if="lineNumberMode != \'none\'" ng-submit="scrollToAndHighlight(gotoLinenumber)">\n                <input type="number" class="form-control input-sm" ng-model="gotoLinenumber"\n                       placeholder="{{ \'Line\' | translate }}"/>\n                <div class="input-group-btn">\n                    <button type="button" class="btn btn-sm btn-default btn-slim" ng-show="gotoLinenumber"\n                            ng-click="gotoLinenumber = \'\'; scrollToAndHighlight(0);">\n                        <i class="fa fa-times text-danger"></i>\n                    </button>\n                    <button type="submit" class="btn btn-sm btn-default">\n                        <i class="fa fa-share"></i>\n                        <translate>go</translate>\n                    </button>\n                    <button type="button" class="btn btn-sm btn-default" os-perms="core.can_manage_projector"\n                            ng-show="lineNumberMode != \'none\' && motion.isProjected().length"\n                            ng-click="toggleLinesForProjector()"\n                            uib-tooltip="{{ \'Show highlighted line also on projector.\' | translate }}">\n                        <i class="fa" ng-class="linesForProjector ? \'fa-check-square-o\' : \'fa-square-o\'"></i>&nbsp;\n                        <i class="fa fa-video-camera"></i>\n                    </button>\n                </div>\n            </form>\n        </div>\n    </div>\n</div>\n\n<!-- View Modes (Original, Diff, Changed) -->\n<div class="motion-toolbar" ng-if="change_recommendations.length > 0">\n    <div class="toolbar-left">\n        <div class="btn-group" data-toggle="buttons">\n            <span class="btn btn-sm btn-default disabled">\n                <i class="fa fa-edit" aria-hidden="true"></i>\n                <translate>Change recommendations</translate>:\n            </span>\n            <label class="btn btn-sm btn-default" ng-class="{active: (viewChangeRecommendations.mode == \'original\')}"\n                   ng-click="viewChangeRecommendations.mode = \'original\';">\n                <input type="radio" name="viewChangeRecommendations.mode" value="none"\n                       ng-model="viewChangeRecommendations.mode"\n                       ng-checked="viewChangeRecommendations.mode == \'original\'">\n                <translate>Original version</translate>\n\n            </label>\n            <label class="btn btn-sm btn-default" ng-class="{active: (viewChangeRecommendations.mode == \'changed\')}"\n                   ng-click="viewChangeRecommendations.mode = \'changed\'">\n                <input type="radio" name="viewChangeRecommendations.mode" value="changed"\n                       ng-model="viewChangeRecommendations.mode"\n                       ng-checked="viewChangeRecommendations.mode == \'changed\'">\n                <translate>Changed version</translate>\n            </label>\n            <label class="btn btn-sm btn-default" ng-class="{active: (viewChangeRecommendations.mode == \'diff\')}"\n                   ng-click="viewChangeRecommendations.mode = \'diff\'">\n                <input type="radio" name="viewChangeRecommendations.mode" value="diff" ng-model="lineNumberMode"\n                       ng-checked="viewChangeRecommendations.mode == \'diff\'">\n                <translate>Diff version</translate>\n            </label>\n            <label class="btn btn-sm btn-default" ng-class="{active: (viewChangeRecommendations.mode == \'agreed\')}"\n                   ng-click="viewChangeRecommendations.mode = \'agreed\'">\n                <input type="radio" name="viewChangeRecommendations.mode" value="agreed"\n                       ng-model="viewChangeRecommendations.mode"\n                       ng-checked="viewChangeRecommendations.mode == \'agreed\'">\n                <translate translate-context="decision making">Resolution</translate>\n            </label>\n        </div>\n    </div>\n</div>\n'),n.put("static/templates/motions/motion-detail/view-diff.html",'<div ng-if="viewChangeRecommendations.mode == \'diff\'">\n    <ng-include src="\'static/templates/motions/motion-detail/change-summary.html\'"></ng-include>\n\n    <!-- The actual diff view -->\n    <div class="motion-text-with-diffs line-numbers-{{ lineNumberMode }}">\n        <div ng-repeat="change in (changes = (change_recommendations | filter:{motion_version_id:version}:true | orderBy: \'line_from\')) ">\n            <div class="motion-text original-text line-numbers-{{ lineNumberMode }}"\n                 ng-bind-html="motion.getTextBetweenChangeRecommendations(version, changes[$index - 1], change, highlight) | trusted"></div>\n\n            <div class="diff-box diff-box-{{ change.id }} clearfix">\n                <div class="action-row" ng-if="motion.isAllowed(\'can_manage\')">\n                    <div class="btn-group" data-toggle="buttons">\n                        <label class="btn btn-sm btn-default" ng-class="{active: !change.rejected}"\n                               title="{{ \'Not rejected\' | translate }}" ng-click="change.rejected = false; change.saveStatus();">\n                            <input type="radio" name="changeRecommendationRejected[{{ change.id }}]" value="0"\n                               ng-change="change.saveStatus()" ng-model="change.rejected" ng-checked="change.rejected == false">\n                            <i class="fa fa-thumbs-up"></i>\n                        </label>\n                        <label class="btn btn-sm btn-default" ng-class="{active: change.rejected}"\n                               title="{{ \'Rejected\' | translate }}" ng-click="change.rejected = true; change.saveStatus();">\n                            <input type="radio" name="changeRecommendationRejected[{{ change.id }}]" value="1"\n                               ng-change="change.saveStatus()" ng-model="change.rejected" ng-checked="change.rejected == true">\n                            <i class="fa fa-thumbs-down"></i>\n                        </label>\n                    </div>\n\n                    <button class="btn btn-default btn-sm pull-right btn-delete"\n                            ng-bootbox-confirm="{{ \'Are you sure you want to delete this change recommendation?\' | translate }}"\n                            ng-bootbox-confirm-action="viewChangeRecommendations.delete(change.id)"\n                            title="{{ \'Delete\' | translate }}">\n                        <i class="fa fa-trash"></i>\n                    </button>\n\n                    <button class="btn btn-default btn-sm pull-right btn-edit" ng-click="createChangeRecommendation.editDialog(change)"\n                            title="{{ \'Edit\' | translate }}">\n                        <i class="fa fa-pencil"></i>\n                    </button>\n                </div>\n                <div class="status-row" ng-if="!motion.isAllowed(\'can_manage\') && change.rejected">\n                    <translate>Rejected</translate>\n                </div>\n\n                <div class="motion-text motion-text-diff line-numbers-{{ lineNumberMode }}"\n                     ng-bind-html="change.getDiff(motion, version, highlight) | trusted"></div>\n            </div>\n        </div>\n\n        <div class="motion-text original-text line-numbers-{{ lineNumberMode }}"\n             ng-bind-html="motion.getTextRemainderAfterLastChangeRecommendation(version, changes, highlight) | trusted"></div>\n    </div>\n</div>\n'),
n.put("static/templates/motions/motion-detail/view-original.html",'<!-- Original view -->\n<div ng-if="viewChangeRecommendations.mode == \'original\' && version == motion.getVersion(-1).id">\n    <div id="view-original-inline-editor" ng-bind-html="motion.getTextWithLineBreaks(version, highlight) | trusted"\n      class="motion-text motion-text-original line-numbers-{{ lineNumberMode }}"\n      contenteditable= "{{ inlineEditing.isEditable }}">\n    </div>\n    <div class="motion-save-toolbar" ng-class="{ \'visible\': (inlineEditing.changed && inlineEditing.active) }">\n        <div class="changed-hint" translate>The text has been changed.</div>\n        <button type="button" ng-click="inlineEditing.save()" class="btn btn-primary" translate>\n            Save\n        </button>\n        <button type="button" ng-click="inlineEditing.revert()" class="btn btn-primary" translate>\n            Revert\n        </button>\n        <label ng-if="motion.state.versioning && config(\'motions_allow_disable_versioning\')">\n            <input type="checkbox" ng-model="inlineEditing.trivialChange" value="1">\n            <span translate>Trivial change</span>\n        </label>\n    </div>\n</div>\n<!-- Original view, Change list -->\n<ul ng-if="viewChangeRecommendations.mode == \'original\'" ng-show="lineNumberMode != \'none\'"\n    class="change-recommendation-list">\n    <li ng-repeat="change in change_recommendations | filter:{motion_version_id:version}:true"\n        ng-class="[\'replace\', \'insert\', \'delete\'][change.getType(motion.getVersion(version).text)]"\n        ng-click="viewChangeRecommendations.scrollToDiffBox(change.id)"\n        data-line-from="{{ change.line_from }}" data-line-to="{{ change.line_to}}"\n        title="{{ change.getTitle(motion.getVersion(version).text) }}">\n        <div class="tooltip">\n            <div class="text" ng-bind-html="change.text || trusted"></div>\n\n            <!-- delete change recommendation -->\n            <button class="btn btn-default btn-xs"\n                    ng-bootbox-confirm="{{ \'Are you sure you want to delete this change recommendation?\' | translate }}"\n                    ng-bootbox-confirm-action="viewChangeRecommendations.delete(change.id)"\n                    title="{{ \'Delete\' | translate }}">\n                <i class="fa fa-times"></i>\n            </button>\n        </div>\n    </li>\n</ul>\n\n<div class="tooltip top tt_change_recommendation_create_help" role="tooltip">\n    <div class="tooltip-arrow"></div>\n    <div class="tooltip-inner" translate>Now choose the last line to be changed</div>\n</div>\n')}])}();