!function(){angular.module("OpenSlidesApp-templates",[]).run(["$templateCache",function(n){n.put("core/static/templates/config-form-field.html",'<div class="form-group">\n  <label>{{ label | translate }}</label>\n\n  <div class="input-group">\n    \x3c!-- text/number input --\x3e\n    <input ng-if="type === \'text\' || type === \'number\'"\n           ng-model="$parent.value"\n           ng-model-options="{debounce: 1000}"\n           ng-change="save(configOption, $parent.value)"\n           ng-class="{ \'form-control\': type != \'checkbox\' }"\n           id="{{ key }}"\n           type="{{ type }}">\n\n    \x3c!-- checkbox --\x3e\n    <div ng-if="type === \'checkbox\'" class="config-checkbox">\n      <i class="fa pointer" id="{{ key }}"\n        ng-click="$parent.value = !$parent.value; save(configOption, $parent.value)"\n        ng-class="$parent.value ? \'fa-check-square-o\' : \'fa-square-o\'"></i>\n    </div>\n\n    \x3c!-- comments --\x3e\n    <div class="comments" ng-if="type === \'comments\'">\n      <div ng-repeat="(id, field) in ($parent.value\n        | excludeSpecialCommentsFields\n        | excludeDeletedAndForbiddenCommentsFields)"\n        class="input-group">\n        <input ng-model="field.name"\n               ng-model-options="{debounce: 1000}"\n               ng-change="save(configOption, $parent.value)"\n               class="form-control"\n               id="{{ key }}"\n               type="text">\n        <span class="input-group-btn">\n          <button type=button" class="btn btn-default"\n            ng-click="field.public = !field.public; save(configOption, $parent.value);">\n            <i class="fa" ng-class="field.public ? \'fa-unlock\' : \'fa-lock\'"></i>\n            {{ (field.public ? \'Public\' : \'Private\') | translate }}\n          </button>\n          <button type="button" class="btn btn-default"\n            ng-click="removeComment(configOption, $parent, id)">\n            <i class="fa fa-minus"></i>\n            <translate>Remove</translate>\n          </button>\n        </span>\n      </div>\n      <div>\n        <button type="button" ng-click="addComment(configOption, $parent)"\n          class="btn btn-default btn-sm">\n          <i class="fa fa-plus"></i>\n          <translate>Add new comment field</translate>\n        </button>\n      </div>\n    </div>\n\n    \x3c!-- colorpicker --\x3e\n    <input ng-if="type === \'colorpicker\'"\n           colorpicker\n           class="form-control"\n           ng-model="$parent.value"\n           ng-model-options="{debounce: 1000}"\n           ng-change="save(configOption, $parent.value)"\n           type="text">\n\n    \x3c!-- datetimepicker --\x3e\n    <input ng-if="type === \'datetimepicker\'"\n           class="form-control"\n           datetime-picker="dd.MM.yyyy HH:mm"\n           ng-model="$parent.value"\n           ng-change="save(configOption, $parent.value)"\n           is-open="datetimeOpen[key]"\n           ng-focus="datetimeOpen[key]=true;"\n           save-as="\'number\'"\n           button-bar="dateTimePickerTranslatedButtons"\n           default-time="10:00:00">\n\n    \x3c!-- textarea --\x3e\n    <textarea ng-if="type === \'textarea\'"\n              ng-model="$parent.value"\n              ng-model-options="{debounce: 1000}"\n              ng-change="save(configOption, $parent.value)"\n              id="{{ key }}" class="form-control">\n    </textarea>\n\n    \x3c!-- editor --\x3e\n    <textarea ng-if="type === \'editor\'"\n              id="{{ configOption.key }}"\n              ckeditor="ckeditorOptions"\n              ng-model="$parent.value" class="form-control"\n              ng-model-options="{debounce: 1000}">\n    </textarea>\n\n    \x3c!-- select --\x3e\n    <select ng-if="type === \'choice\'"\n            ng-model="$parent.value"\n            ng-model-options="{debounce: 500}"\n            ng-change="save(configOption, $parent.value)"\n            id="{{ key }}" class="form-control"\n            ng-options="option.value as option.display_name | translate for option in choices">\n    </select>\n\n    \x3c!-- custom trnaslations --\x3e\n    <div class="custom-translations" ng-if="type === \'translations\'">\n      <div ng-repeat="entry in $parent.value" class="input-group">\n        <div class="inputs">\n          <input ng-model="entry.original"\n                 ng-model-options="{debounce: 1000}"\n                 ng-change="save(configOption, $parent.value)"\n                 class="form-control"\n                 id="{{ key }}_original"\n                 type="text">\n          <span class="arrow form-control"><i class="fa fa-arrow-right"></i></span>\n          <input ng-model="entry.translation"\n                 ng-model-options="{debounce: 1000}"\n                 ng-change="save(configOption, $parent.value)"\n                 class="form-control"\n                 id="{{ key }}_translated"\n                 type="text">\n        </div>\n        <span class="input-group-btn">\n          <button type="button" class="btn btn-default"\n            ng-click="removeTranslation(configOption, $parent, $index)">\n            <i class="fa fa-minus"></i>\n            <translate>Remove</translate>\n          </button>\n        </span>\n      </div>\n      <div>\n        <button type="button" ng-click="addTranslation(configOption, $parent)"\n          class="btn btn-default btn-sm">\n          <i class="fa fa-plus"></i>\n          <translate>Add new custom translation</translate>\n        </button>\n      </div>\n    </div>\n\n    <span id="success-{{ key }}" class="input-group-addon" ng-if="configOption.success !== undefined">\n      <i class="fa fa-lg fa-check-circle text-success"\n        ng-if="configOption.success === true"></i>\n      <i class="fa fa-lg fa-exclamation-triangle text-danger"\n        ng-if="configOption.success === false"\n        uib-tooltip="{{ configOption.errorMessage | translate }}"></i>\n    </span>\n\n    <span class="input-group-btn">\n      <button ng-click="reset()" class="btn btn-default" title="{{ default_value | translate }}">\n        <i class="fa fa-undo"></i>\n        <translate>Reset</translate>\n      </button>\n    </span>\n  </div>\n  <p ng-if="help_text" class="help-block">{{ help_text | translate }}</p>\n</div>\n'),n.put("core/static/templates/config.html",'<div class="header">\n  <div class="title">\n    <h1 translate>Settings</h1>\n  </div>\n</div>\n\n<div id="config" class="details">\n  <div os-perms="core.can_manage_config" class="panel-group" id="accordion"\n      role="tablist" aria-multiselectable="true">\n    \x3c!-- generate config groups --\x3e\n    <div ng-repeat="group in configGroups">\n      <div class="panel panel-default">\n        <div class="panel-heading" role="tab" id="heading-group{{ $index }}">\n          <h4 class="panel-title">\n            <a data-toggle="collapse" data-parent="#accordion" href="#group{{ $index }}"\n                aria-expanded="false" aria-controls="group{{ $index }}">\n              {{ group.name | translate }}\n            </a>\n          </h4>\n        </div> \x3c!-- heading --\x3e\n        <div id="group{{ $index }}" class="panel-collapse collapse" role="tabpanel" aria-labelledby="heading-group{{ $index }}">\n          <div class="panel-body">\n            <div ng-repeat="subgroup in group.subgroups">\n              <h3>{{ subgroup.name | translate }}</h3>\n              <div ng-repeat="configOption in subgroup.items">\n                <os-form-field field="configOption"></os-form-field>\n              </div>\n            </div>\n          </div>\n        </div> \x3c!-- group.name --\x3e\n      </div>\n    </div>\n  </div>\n</div>\n\n'),n.put("core/static/templates/csv-import.html",'<form id="csv-import">\n  <label for="fileInput" translate>CSV file</label>\n  <div id="fileInput" class="file-select">\n    <div class="form-control">\n      <label for="csvFileSelector">\n        <i class="fa fa-upload"></i>\n        <span ng-if="selectedFile">{{ selectedFile }}</span>\n        <span ng-if="!selectedFile" translate>Select a file</span>\n      </label>\n      <a href class="pull-right clear-file" ng-if="selectedFile" ng-click="clearFile()">\n        <i class="fa fa-times" title="{{ \'Deselect file\' | translate }}"></i>\n      </a>\n    </div>\n    <input id="csvFileSelector" type="file" value="" accept="{{ accept }}">\n    <p class="help-block">\n      <translate translate-context="special filetypes in a file open dialog">Accepted file types</translate>:\n      {{ accept }}\n    </p>\n  </div>\n\n  <div class="form-group">\n    <label for="selectEncoding" translate>Encoding</label>\n    <select class="form-control" ng-model="$parent.encoding" ng-if="encodingOptions.length > 1" ng-change="parse()"\n      id="selectEncoding" ng-options="enc for enc in encodingOptions"></select>\n  </div>\n  <div class="form-group">\n    <label for="inputDelimiter" translate>Separator</label>\n    <input type="text" class="form-control" ng-model="delimiter" ng-change="parse()" id="inputDelimiter">\n    <p class="help-block help-block-big" ng-if="autodelimiter">\n      <translate>Autodetection</translate>:\n      {{ autodelimiter }}\n    </p>\n    <p class="help-block" ng-if="!autodelimiter" translate>Leave empty for autodetection of the separator.</p>\n  </div>\n</form>\n'),n.put("core/static/templates/home.html",'<div os-perms="core.can_see_frontpage" class="header">\n  <div class="title">\n    <h1>{{ config(\'general_event_welcome_title\') | translate }}</h1>\n  </div>\n</div>\n\n<div os-perms="core.can_see_frontpage" class="details"\n    ng-bind-html="config(\'general_event_welcome_text\') | translate">\n</div>\n'),n.put("core/static/templates/index.html",'<!DOCTYPE html>\n<html ng-controller="LanguageCtrl" lang="{{ selectedLanguage[0].code }}" class="no-js">\n<meta charset="utf-8">\n<meta http-equiv="X-UA-Compatible" content="IE=edge">\n<base href="/">\n<title ng-if="!activeAppTitle">OpenSlides</title> \x3c!-- avoid {{ ... }} in title while angular is not loaded --\x3e\n<title ng-if="activeAppTitle">{{ activeAppTitle | translate }} &ndash; OpenSlides</title>\n<meta name="description" content="">\n<meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=0">\n<link rel="stylesheet" href="static/css/openslides-libs.css">\n<link rel="stylesheet" href="static/css/openslides-site.css">\n<link rel="icon" href="/static/img/favicon.png">\n\n<script src="static/js/openslides-libs.js"><\/script>\n<script src="static/js/openslides.js"><\/script>\n<script src="static/js/openslides-templates.js"><\/script>\n\n<div id="wrapper" ng-cloak>\n\n\x3c!-- please wait --\x3e\n<div id="spinner-container" ng-if="!openslidesBootstrapDone">\n  <div><i class="fa fa-spinner fa-pulse"></i></div>\n</div>\n<div id="startup-overlay" ng-if="!openslidesBootstrapDone"></div>\n\n\x3c!-- Header --\x3e\n<div id="header">\n  <div class="containerOS">\n    \x3c!-- Logo --\x3e\n    <div class="title">\n      <a ui-sref="home">\n        <img src="/static/img/openslides-logo-dark.png" alt="OpenSlides Logo" height="35">\n        <img ng-if="config(\'logo_web_header\').path" ng-src="{{ config(\'logo_web_header\').path }}" alt="OpenSlides Logo" height="35">\n      </a>\n      <span ng-bind-html="config(\'general_event_name\')"></span>\n    </div>\n\n    \x3c!-- user specific header (chat, user settings / login, language)--\x3e\n    <div class="user" ng-controller="userMenu">\n      <div class="btn-group">\n        <div ng-if="operator.isAuthenticated()">\n\n          <template-hook hook-name="indexHeaderAdditionalOptions"></template-hook>\n\n          \x3c!-- chatbox --\x3e\n          <div ng-controller="ChatMessageCtrl" os-perms="core.can_use_chat" class="inline">\n            <a href ng-click="openChatbox()" class="headerlink"\n                ng-class="{ \'active\': !chatboxIsCollapsed }" uib-dropdown-toggle>\n              <i class="fa fa-comment"></i>\n              <translate class="hide-sm">Chat</translate>\n              <span ng-if="unreadMessages > 0 && chatboxIsCollapsed" class="badge">\n                {{ unreadMessages }}\n              </span>\n            </a> |\n            <div id="chatbox" class="well" uib-collapse="chatboxIsCollapsed">\n              <div id="chatbox-text" scroll-glue>\n                <ul class="list-unstyled">\n                  <li ng-repeat="chatmessage in chatmessages">\n                    <small class="grey">{{ chatmessage.timestamp | date:\'HH:mm:ss\' }}</small>\n                    <small>{{ chatmessage.user.short_name }}:</small>\n                    {{ chatmessage.message }}\n                </ul>\n              </div>\n              <div id="chatbox-form">\n                <form ng-submit="sendMessage()">\n                  <div class="input-group">\n                    <input\n                      ng-model="newMessage"\n                      id="messageInput"\n                      class="form-control"\n                      type="text"\n                      autocomplete="off">\n                    <span class="input-group-btn">\n                      <button type="submit" class="btn btn-default" id="messageSendButton">\n                        <i class="fa fa-comment"></i>\n                      </button>\n                      <button os-perms="core.can_manage_chat" type="button"\n                        class="btn btn-default btn-danger" id="clearchatHistory"\n                        ng-bootbox-confirm="{{ \'Are you sure to delete the chat history?\' | translate }}"\n                        ng-bootbox-confirm-action="clearChatHistory()">\n                        <i class="fa fa-trash"></i>\n                      </button>\n                    </span>\n                  </div>\n                </form>\n              </div>\n            </div>\n          </div>\n\n          \x3c!-- user settings / logout button --\x3e\n          <span uib-dropdown>\n            <a href class="headerlink" uib-dropdown-toggle id="user-settings-dropdown">\n              <i class="fa fa-user"></i>\n              <span class="hide-sm">{{ operator.user.get_short_name() }}</span>\n            </a>\n            <ul class="dropdown-menu pull-right" uib-dropdown-menu aria-labelledby="user-settings-dropdown">\n              <li>\n                \x3c!--<a ui-sref="users.user.detail.profile({ id: operator.user.id })">--\x3e\n                <a href="" ng-click="editProfile()">\n                  <i class="fa fa-cog"></i>\n                  <translate>Edit profile</translate>\n                </a>\n              <li>\n                <a href="" ng-click="changePassword()">\n                  <i class="fa fa-key"></i>\n                  <translate>Change password</translate>\n                </a>\n              <li class="divider">\n              <li>\n                <a ng-click="logout()" href="">\n                  <i class="fa fa-sign-out"></i>\n                  <translate>Logout</translate>\n                </a>\n            </ul>\n          </span>\n        </div>\n        \x3c!-- Login button --\x3e\n        <div ng-if="!operator.isAuthenticated()">\n          <a href ui-sref="login({guest_enabled: true})" class="headerlink" uib-dropdown-toggle>\n            <i class="fa fa-sign-in"></i>\n            <translate>Login</translate>\n          </a>\n        </div>\n      </div>\n\n      \x3c!-- language switcher --\x3e\n      <span uib-dropdown> |\n        <a href="" class="headerlink" uib-dropdown-toggle id="language-dropdown">\n          <i class="fa fa-globe"></i>\n          <span class="hide-sm">{{ selectedLanguage[0].name | translate }}</span>\n        </a>\n        <ul class="dropdown-menu pull-right" uib-dropdown-menu aria-labelledby="language-dropdown">\n          <li ng-repeat="language in languages">\n            <a href="" ng-click="switchLanguage(language.code)">\n              <i ng-if="language.selected" class="fa fa-check"></i>\n              {{ language.name | translate }}\n            </a>\n      </span>\n\n    </div>\n  </div>\n</div>\x3c!--end header--\x3e\n\n\x3c!-- Navbar --\x3e\n<div id="nav" ng-controller="MainMenuCtrl">\n  <div class="containerOS" >\n    \x3c!-- mobile (vertical) main menu --\x3e\n    <button class="navbar-toggle" ng-click="isMenuOpen = !isMenuOpen">\n      <i class="fa fa-bars"></i>\n    </button>\n    <div class="navbar navbar-collapse" ng-class="{collapse: !isMenuOpen}">\n      \x3c!-- Main menu --\x3e\n      <ul>\n        <li ng-repeat="element in elements" ui-sref-active="active" ng-click="closeMenu()">\n          <a ui-sref="{{ element.ui_sref }}">\n            <i class="fa fa-{{ element.img_class }}"></i>\n            {{ element.title | translate }}\n          </a>\n      </ul>\n      \x3c!-- Search bar --\x3e\n      <div class="searchbar pull-right" ng-controller="SearchBarCtrl">\n        <form ng-submit="search(); closeMenu()">\n          <div class="input-group">\n            <input ng-model="querybar" class="form-control" type="text" placeholder="{{ \'Search\' | translate}}">\n            <span class="input-group-btn">\n              <button type="submit" class="btn btn-default">\n                <i class="fa fa-search"></i>\n              </button>\n            </span>\n          </div>\n        </form>\n      </div>\n    </div>\n\n   </div>\n</div>\x3c!--end nav--\x3e\n\n\n\x3c!-- Content --\x3e\n<div id="content" ng-controller="ProjectorSidebarCtrl">\n  <div ng-class="expandContent ? \'containerOSExpanded\' : \'containerOS\'">\n\n    \x3c!-- col2 sidebar-xs (for small devices)--\x3e\n    <div ng-if="!expandContent">\n      <div id="sidebar-xs" class="col2" os-perms="core.can_see_projector" ng-class="{\n          \'sidebar-max\': isProjectorSidebar && operator.hasPerms(\'core.can_see_projector\'),\n          \'sidebar-min\': !isProjectorSidebar && operator.hasPerms(\'core.can_see_projector\'),\n          \'sidebar-none\': !operator.hasPerms(\'core.can_see_projector\') }">\n        \x3c!-- sidebar maximized --\x3e\n        <div class="projector_full" ng-if="isProjectorSidebar">\n          <div class="title" ng-click="showProjectorSidebar(false)">\n            <div class="name">\n              <i class="fa fa-video-camera"></i>\n              <translate>Projector</translate>\n            </div>\n            <div class="icon">\n              <i class="fa fa-angle-up"></i>\n            </div>\n          </div>\n          <div ng-include src="\'static/templates/core/projector-controls.html\'"></div>\n        </div>\n        \x3c!-- sidebar minimized --\x3e\n        <div class="projector_full" ng-if="!isProjectorSidebar">\n          <div class="title" ng-click="showProjectorSidebar(true)">\n            <div class="name">\n              <i class="fa fa-video-camera"></i>\n              <translate>Projector</translate>\n            </div>\n            <div class="icon">\n              <i class="fa fa-angle-down"></i>\n            </div>\n          </div>\n        </div>\n      </div>\n    </div>\n\n    \x3c!-- col1 --\x3e\n    <div id="main-column" class="col1" ng-class="{\n        \'sidebar-max\': isProjectorSidebar && operator.hasPerms(\'core.can_see_projector\') && !expandContent,\n        \'sidebar-min\': !isProjectorSidebar && operator.hasPerms(\'core.can_see_projector\') && !expandContent,\n        \'sidebar-none\': !operator.hasPerms(\'core.can_see_projector\') || expandContent}">\n        \x3c!-- dynamic views --\x3e\n        <div ui-view ng-if="openslidesBootstrapDone && baseViewPermissionsGranted"></div>\n        \x3c!-- footer --\x3e\n        <div id="footer">\n          &copy; Copyright by <a href="http://www.openslides.org" target="_blank">OpenSlides</a> |\n          <a ui-sref="legalnotice" translate>Legal notice</a> |\n          <a ui-sref="privacypolicy" translate>Privacy policy</a>\n        </div>\x3c!--end footer--\x3e\n    </div>\n\n    \x3c!-- col2 normal sidebar --\x3e\n    <div ng-if="!expandContent">\n      <div id="sidebar" class="col2" os-perms="core.can_see_projector" ng-class="{\n          \'sidebar-max\': isProjectorSidebar && operator.hasPerms(\'core.can_see_projector\'),\n          \'sidebar-min\': !isProjectorSidebar && operator.hasPerms(\'core.can_see_projector\'),\n          \'sidebar-none\': !operator.hasPerms(\'core.can_see_projector\') }"\n          ng-init="initSidebar()">\n        \x3c!-- sidebar maximized --\x3e\n        <div class="projector_full" ng-if="isProjectorSidebar">\n          <div class="title" ng-click="showProjectorSidebar(false)">\n            <div class="name">\n              <i class="fa fa-video-camera"></i>\n              <translate>Projector</translate>\n            </div>\n            <div class="icon">\n              <i class="fa fa-angle-right"></i>\n            </div>\n          </div>\n          <div ng-include src="\'static/templates/core/projector-controls.html\'"></div>\n        </div>\n        \x3c!-- sidebar minimized --\x3e\n        <div class="projector_min" ng-if="!isProjectorSidebar">\n          <div class="icon">\n            <a href="" ng-click="showProjectorSidebar(true)">\n              <i class="fa fa-video-camera"></i>\n            </a>\n          </div>\n        </div>\n      </div>\n    </div>\n\n\n  </div>\x3c!--end content-container--\x3e\n</div>\x3c!--end content--\x3e\n\n<messaging></messaging>\n\n<div ng-controller="GotoTopCtrl">\n  <div id="goto-top" class="pointer" ng-click="gotoTop()" ng-if="show">\n    <a>\n      <i class="fa fa-lg fa-arrow-up"></i>\n    </a>\n  </div>\n</div>\n\n</div>\x3c!--end wrapper--\x3e\n\n<script src="/webclient/site/"><\/script>\n'),n.put("core/static/templates/legalnotice.html",'<div class="header">\n  <div class="title">\n    <h1 translate>Legal notice</h1>\n  </div>\n</div>\n\n<div class="details">\n  <div ng-bind-html="config(\'general_event_legal_notice\') | translate"></div>\n  <hr>\n  <p>\n    <a ng-href="{{ core_url }}" target="_blank">\n      <strong>OpenSlides {{ core_version }}</strong>\n    </a>\n    (<translate>License</translate>: {{ core_license }})\n  </p>\n  <div ng-show="plugins.length">\n    <p translate>Installed plugins:</p>\n    <ul>\n      <li ng-repeat="plugin in plugins">\n        <a ng-if="plugin.url" ng-href="{{ plugin.url }}" target="_blank">\n          {{ plugin.verbose_name }} {{ plugin.version }}\n        </a>\n        <span ng-if="!plugin.url">\n          {{ plugin.verbose_name }} {{ plugin.version }}\n        </span>\n        <span ng-if="plugin.license">\n          (<translate>License</translate>: {{ plugin.license}})\n        </span>\n      </li>\n    </ul>\n  </div>\n</div>\n'),n.put("core/static/templates/messaging.html",'<div id="messaging">\n  <div id="messaging-container">\n    <div ng-repeat="(id, message) in messages" ng-class="message.type">\n\n      <span class="close fa fa-times fa-lg" ng-click="close(id)" ng-if="!message.args.noClose"></span>\n      <span ng-bind-html="message.text | trusted"></span>\n\n    </div>\n  </div>\n</div>\n'),n.put("core/static/templates/privacypolicy.html",'<div class="header">\n  <div class="title">\n    <h1 translate>Privacy policy</h1>\n  </div>\n</div>\n\n<div class="details">\n  <div ng-bind-html="config(\'general_event_privacy_policy\') | translate"></div>\n</div>\n'),n.put("core/static/templates/privacypolicydialog.html",'<h1 translate>Privacy policy</h1>\n<div ng-if="privacyPolicy" ng-bind-html="privacyPolicy | translate"></div>\n<div ng-if="!privacyPolicy" translate>\n  The event manager hasn\'t set up a privacy policy yet.\n</div>\n\n<button ng-click="closeThisDialog()" class="btn btn-default spacer-top" translate>\n  Close\n</button>\n'),n.put("core/static/templates/projector-button.html",'<div class="btn-group" style="min-width:{{ projectors.length > 1 ? \'54\' : \'34\' }}px;" uib-dropdown\n  uib-tooltip="{{ \'Projector\' | translate }} {{ model.isProjected(arg)[0] || \'\' }}"\n  tooltip-enable="model.isProjected(arg).length"\n  os-perms="core.can_manage_projector">\n  <button type="button" class="btn btn-default btn-sm"\n    ng-click="model.project(defaultProjectorId, arg)"\n    ng-class="{ \'btn-primary\': inArray(model.isProjected(arg), defaultProjectorId) }">\n    <i class="fa fa-video-camera"></i>\n    {{ content | translate }}\n  </button>\n  <button type="button" class="btn btn-default btn-sm slimDropDown"\n    ng-class="{ \'btn-primary\': (model.isProjected(arg).length && !inArray(model.isProjected(arg), defaultProjectorId)) }"\n    ng-if="projectors.length > 1"\n    uib-dropdown-toggle>\n    <span class="caret"></span>\n  </button>\n  <ul class="dropdown-menu" ng-if="projectors.length > 1">\n    <li role="menuitem" ng-repeat="projector in projectors | orderBy:\'id\'">\n      <a href="" ng-click="model.project(projector.id, arg)"\n        ng-class="{ \'projected\': inArray(model.isProjected(arg), projector.id) }">\n        <i class="fa fa-video-camera" ng-show="inArray(model.isProjected(arg), projector.id)"></i>\n        {{ projector.name | translate }}\n        <span ng-if="defaultProjectorId == projector.id">(<translate>Default</translate>)</span>\n      </a>\n    </li>\n  </ul>\n</div>\n'),n.put("core/static/templates/projector-container.html",'<!DOCTYPE html>\n<html lang="{{ selectedLanguage }}" ng-controller="LanguageAndFontCtrl" class="no-js">\n<meta charset="utf-8">\n<meta http-equiv="X-UA-Compatible" content="IE=edge">\n<base href="/">\n<title ng-if="projectorId===undefined">Projector &ndash; OpenSlides</title> \x3c!-- avoid {{ ... }} in title while angular is not loaded --\x3e\n<title ng-if="projectorId!==undefined">{{ \'Projector\' | translate }} {{ projectorName }} &ndash; OpenSlides</title>\n<meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=0">\n<link rel="stylesheet" href="static/css/openslides-libs.css">\n<link rel="stylesheet" href="static/css/openslides-projector.css">\n<link rel="icon" href="/static/img/favicon.png">\n<script src="static/js/openslides-libs.js"><\/script>\n<script src="static/js/openslides.js"><\/script>\n<script src="static/js/openslides-templates.js"><\/script>\n\n<div class="pContainer" ng-controller="ProjectorContainerCtrl" ng-cloak>\n  <div>\n    <style>\n      .pContainer #iframe {\n          width: {{ projectorWidth }}px;\n          height: {{ projectorHeight }}px;\n          -moz-transform: scale({{ scale }});\n          -webkit-transform: scale({{ scale }});\n          -o-transform: scale({{ scale }});\n          transform: scale({{ scale }});\n          /* IE8+ - must be on one line, unfortunately */\n          -ms-filter: "progid:DXImageTransform.Microsoft.Matrix(M11={{ scale }}, M12=0, M21=0, M22={{ scale }}, SizingMethod=\'auto expand\')";\n      }\n\n      .pContainer #iframewrapper {\n          width: {{ iframeWidth }}px;\n          height: {{ iframeHeight }}px;\n      }\n\n      .pContainer #iframeoverlay {\n        width: {{ iframeWidth }}px;\n        height: {{ iframeHeight }}px;\n      }\n    </style>\n\n    <div id="iframewrapper" ng-hide="showError">\n      <iframe id="iframe" ng-src="{{ \'/real-projector/\' + projectorId + \'/\'}}" frameborder="0"></iframe>\n      <div id="iframeoverlay"></div>\n    </div>\n\n    <div class="error" ng-show="showError">\n      <p>{{ error | translate }}</p>\n    </div>\n  </div>\n</div>\n\n<script src="/webclient/projector/"><\/script>\n'),n.put("core/static/templates/projector.html",'<!DOCTYPE html>\n<html lang="{{ selectedLanguage }}" ng-controller="LanguageAndFontCtrl" class="no-js">\n<meta charset="utf-8">\n<meta http-equiv="X-UA-Compatible" content="IE=edge">\n<base href="/">\n<title>OpenSlides &ndash; Projector</title>\n<link rel="stylesheet" href="static/css/openslides-libs.css">\n<link rel="stylesheet" href="static/css/openslides-projector.css">\n<link rel="icon" href="/static/img/favicon.png">\n\n<style type="text/css">\n  @font-face {\n    font-family: \'OSFont\';\n    src: {{ font }};\n    font-weight: 400;\n    font-style: normal;\n  }\n  @font-face {\n    font-family: \'OSFont Medium\';\n    src: {{ font_medium }};\n    font-weight: 400;\n    font-style: normal;\n  }\n  @font-face {\n    font-family: \'OSFont Condensed\';\n    src: {{ font_condensed }};\n    font-weight: 100;\n    font-style: normal;\n  }\n  @font-face {\n    font-family: \'OSFont Condensed Light\';\n    src: {{ font_condensed_light }};\n    font-weight: 100;\n    font-style: normal;\n  }\n</style>\n\n<script src="static/js/openslides-libs.js"><\/script>\n<script src="static/js/openslides.js"><\/script>\n<script src="static/js/openslides-templates.js"><\/script>\n\n<div id="projectorContainer" ng-controller="ProjectorCtrl">\n  <style type="text/css">\n    #header, #footer {\n      background-color: {{ config(\'projector_header_backgroundcolor\') }};\n    }\n    #header, #footer, #currentTime {\n      color: {{ config(\'projector_header_fontcolor\') }};\n    }\n    #header, #footer, .contentContainer {\n      visibility: {{ blank ? \'hidden\' : \'visible\' }};\n    }\n    #projectorContainer {\n      background-color: {{ blank ? config(\'projector_blank_color\') : \'#fff\' }};\n      height: {{ blank ? \'100%\' : \'auto\' }};\n    }\n    h1 {\n      color: {{ config(\'projector_h1_fontcolor\') }};\n    }\n  </style>\n\n  <style ng-if="config(\'logo_projector_header\').path">\n    #header {\n      background-image: url({{ config(\'logo_projector_header\').path }});\n    }\n  </style>\n\n  <div id="header" ng-if="config(\'projector_enable_header_footer\')">\n    <img ng-if="config(\'projector_enable_logo\')" id="logo" alt="OpenSlides"\n      ng-src="{{ config(\'logo_projector_main\').path || \'/static/img/logo-projector.png\' }}"/>\n    <div ng-if="config(\'projector_enable_title\')" id="eventdata">\n      <div class="title" ng-class="{ \'titleonly\': !config(\'general_event_description\') }"\n          ng-bind-html="config(\'general_event_name\')"></div>\n      <div ng-if="config(\'general_event_description\')" class="description"\n          ng-bind-html="config(\'general_event_description\')"></div>\n    </div>\n  </div>\n\n  <style type="text/css">\n    .scrollcontent {\n      margin-top: {{ scroll }}px !important;\n    }\n    .zoomcontent {\n      font-size: {{ 100 + 20 * projector.scale }}%;\n    }\n    .mediascrollcontent {\n      margin-top: {{scroll/2}}em !important;\n      -webkit-transform: scale({{scale/100}});\n      -ms-transform: scale({{scale/100}});\n      transform: scale({{scale/100}});\n    }\n  </style>\n\n\n  <style type="text/css" ng-if="config(\'projector_enable_header_footer\')">\n    .content {\n      top: 100px;\n    }\n  </style>\n\n  <div class="contentContainer" ng-repeat="element in elements | orderBy:\'index\'">\n    <div ng-include="element.template"></div>\n  </div>\n\n  <div id="footer" ng-if="config(\'projector_enable_header_footer\')">\n    <span ng-if="config(\'general_event_date\')">\n      {{ config(\'general_event_date\') }}\n    </span>\n    <span ng-if="config(\'general_event_date\') && config(\'general_event_location\')">\n      |\n    </span>\n    <span ng-if="config(\'general_event_location\')">\n      {{ config(\'general_event_location\') }}\n    </span>\n  </div>\n</div>\n\n<script src="/webclient/projector/"><\/script>\n'),
n.put("core/static/templates/search.html",'<div class="header">\n  <div class="title">\n    <h1 translate>Search results</h1>\n  </div>\n</div>\n\n<div class="details">\n  <form class="input-group" ng-submit="search()">\n    <input type="text" ng-change="search()" ng-model="searchquery" class="form-control">\n    <span class="input-group-btn">\n      <button type="submit" class="btn btn-default" translate>Search</button>\n    </span>\n  </form>\n\n  <div class="searchfilter spacer-top">\n    <label ng-repeat="filter in results | orderBy: \'weight\'" class="checkbox-inline"\n      ng-click="filter.checked = !filter.checked">\n      <i class="fa" ng-class="filter.checked ? \'fa-check-square-o\' : \'fa-square-o\'"></i>\n      {{ filter.verboseName | translate }}\n    </label>\n  </div>\n\n  <div class="searchresults spacer-top-lg">\n    <div ng-show="results">\n      <div ng-repeat="result in results | orderBy: \'weight\'" ng-if="result.checked && result.elements.length">\n        <h3>{{ result.verboseName | translate }}</h3>\n        <div class="hits">\n          {{ result.elements.length}} <translate>results</translate>\n        </div>\n        <ol class="list-unstyled">\n          <li ng-repeat="element in result.elements">\n            <a ng-if="!element.mediafileUrl" ui-sref="{{ result.urlDetailState }}({id: {{element.id}}})">\n              {{ element.getSearchResultName() }}\n            </a>\n            <a ng-if="element.mediafileUrl" href="{{ element.mediafileUrl }}" target="_blank">\n              {{ element.getSearchResultName() }}\n            </a>\n        </ol>\n      </div>\n    </div>\n    <p ng-show="!results || results.length == 0" translate>No results.</p>\n\n</div>\n'),n.put("agenda/static/templates/agenda/current-list-of-speakers.html",'<div class="header">\n  <div class="title">\n    <div class="submenu">\n      <a ui-sref="agenda.item.list" class="btn btn-sm btn-default">\n        <i class="fa fa-angle-double-left fa-lg"></i>\n        <translate>Back to overview</translate>\n      </a>\n      \x3c!-- Current list of speakers projector button --\x3e\n      <div class="btn-group button" uib-dropdown\n        uib-tooltip="{{ \'Project the current list of speakers\' | translate }}"\n        os-perms="core.can_manage_projector">\n        <button type="button" class="btn btn-default btn-sm"\n            title="{{ \'Project current list of speakers\' | translate }}"\n            ng-click="currentListOfSpeakers.project(listOfSpeakersDefaultProjectorId, currentListOfSpeakersAsOverlay)"\n            ng-class="{ \'btn-primary\': currentListOfSpeakers.isProjected().length && inArray(currentListOfSpeakers.isProjected(), listOfSpeakersDefaultProjectorId)}">\n          <i class="fa fa-video-camera"></i>\n          <translate>Current list of speakers</translate>\n        </button>\n        <button type="button" class="btn btn-default btn-sm"\n          ng-if="projectors.length > 1"\n          uib-dropdown-toggle\n          ng-class="{ \'btn-primary\': currentListOfSpeakers.isProjected().length && !inArray(currentListOfSpeakers.isProjected(), listOfSpeakersDefaultProjectorId)}">\n          <span class="caret"></span>\n        </button>\n        <ul class="dropdown-menu" role="menu" aria-labelledby="split-button" ng-if="projectors.length > 1">\n          <li role="menuitem">\n            <a href="" ng-click="setOverlay(false); $event.stopPropagation();">\n              <i class="fa" ng-class="currentListOfSpeakersAsOverlay ? \'fa-circle-o\' : \'fa-check-circle-o\'"></i>\n              <translate>Project as slide</translate>\n            </a>\n          </li>\n          <li role="menuitem">\n            <a href="" ng-click="setOverlay(true); $event.stopPropagation();">\n              <i class="fa" ng-class="currentListOfSpeakersAsOverlay ? \'fa-check-circle-o\' : \'fa-circle-o\'"></i>\n              <translate>Project as overlay</translate>\n            </a>\n          </li>\n          <li class="divider"></li>\n          <li role="menuitem" ng-repeat="projector in projectors | orderBy:\'id\'">\n            <a href="" ng-click="currentListOfSpeakers.project(projector.id, currentListOfSpeakersAsOverlay)"\n              ng-class="{ \'projected\': inArray(currentListOfSpeakers.isProjected(), projector.id) }">\n              <i class="fa fa-video-camera" ng-show="inArray(currentListOfSpeakers.isProjected(), projector.id)"></i>\n              {{ projector.name | translate }}\n              <span ng-if="projector.id == listOfSpeakersDefaultProjectorId">(<translate>Default</translate>)</span>\n            </a>\n          </li>\n        </ul>\n      </div>\n    </div>\n\n    <h1 translate>Current list of speakers</h1>\n    <h2> {{ item.getTitle() }}\n      <span class="slimlabel label label-danger ng-scope" style="" ng-if="item.speaker_list_closed" translate>\n        Closed\n      </span>\n    </h2>\n  </div>\n</div>\n\n<ng-include src="\'static/templates/agenda/list-of-speakers-partial-management.html\'"></ng-include>\n'),n.put("agenda/static/templates/agenda/item-detail.html",'<div ng-if="item" class="header">\n  <div class="title">\n    <div class="submenu">\n      <a ui-sref="agenda.item.list" class="btn btn-sm btn-default">\n        <i class="fa fa-angle-double-left fa-lg"></i>\n        <translate>Agenda</translate>\n      </a>\n      <a ui-sref="{{ item.getContentObjectDetailState() }}" class="btn btn-sm btn-default">\n        <i class="fa fa-angle-double-left fa-lg"></i>\n        {{ item.getContentResource().verboseName | translate }}\n      </a>\n      \x3c!-- project list of speakers --\x3e\n      <span class="btn-group" style="min-width:54px;" uib-dropdown\n        uib-tooltip="{{ \'Projector\' | translate }} {{ item.isListOfSpeakersProjected()[0] || \'\' }}"\n        tooltip-enable="item.isListofSpeakersProjected().length"\n        os-perms="core.can_manage_projector">\n        <button type="button" class="btn btn-default btn-sm"\n          ng-click="item.projectListOfSpeakers(defaultProjectorListOfSpeakersId)"\n          ng-class="{ \'btn-primary\': inArray(item.isListOfSpeakersProjected(), defaultProjectorListOfSpeakersId)  }">\n          <i class="fa fa-video-camera"></i>\n          <translate>List of speakers</translate>\n        </button>\n        <button type="button" class="btn btn-default btn-sm slimDropDown"\n          ng-class="{ \'btn-primary\': (item.isListOfSpeakersProjected().length && !inArray(item.isListOfSpeakersProjected(), defaultProjectorListOfSpeakersId) ) }"\n          ng-if="projectors.length > 1"\n          uib-dropdown-toggle>\n          <span class="caret"></span>\n        </button>\n        <ul class="dropdown-menu" ng-if="projectors.length > 1">\n          <li role="menuitem" ng-repeat="projector in projectors | orderBy:\'id\'">\n            <a href="" ng-click="item.projectListOfSpeakers(projector.id)"\n              ng-class="{ \'projected\': inArray(item.isListOfSpeakersProjected(), projector.id) }">\n              <i class="fa fa-video-camera" ng-show="inArray(item.isListOfSpeakersProjected(), projector.id) "></i>\n              {{ projector.name | translate }}\n              <span ng-if="defaultProjectorListOfSpeakersId == projector.id">(<translate>Default</translate>)</span>\n            </a>\n          </li>\n        </ul>\n      </span> \n      \x3c!-- project --\x3e\n      <projector-button model="item" default-projector-id="defaultProjectorItemId"\n        content="{{ item.getContentResource().verboseName | translate }}">\n      </projector-button>\n    </div>\n    <h1>{{ item.getTitle() }}</h1>\n    <h2>\n      <translate>List of speakers</translate>\n      <span ng-if="item.speaker_list_closed" class="slimlabel label label-danger"\n          translate>Closed</span>\n    </h2>\n  </div>\n</div>\n\n<ng-include src="\'static/templates/agenda/list-of-speakers-partial-management.html\'"></ng-include>\n'),
n.put("agenda/static/templates/agenda/item-list.html",'<div class="header">\n  <div class="title">\n    <div class="submenu">\n      \x3c!-- new --\x3e\n      <a ng-click="newDialog()" os-perms="agenda.can_manage"\n          class="btn btn-primary btn-sm">\n        <i class="fa fa-plus fa-lg"></i>\n        <translate>New</translate>\n      </a>\n      \x3c!-- import --\x3e\n      <span os-perms="agenda.can_manage">\n        <a ui-sref="topics.topic.import"\n          os-perms="agenda.can_see_internal_items"\n          class="btn btn-default btn-sm">\n          <i class="fa fa-download fa-lg"></i>\n          <translate>Import</translate>\n        </a>\n      </span>\n      \x3c!-- current list of speakers --\x3e\n      <a ui-sref="agenda.current-list-of-speakers" os-perms="users.can_see_name"\n          class="btn btn-default btn-sm">\n        <i class="fa fa-microphone fa-lg"></i>\n        <translate>Current list of speakers</translate>\n      </a>\n      \x3c!-- project agenda button --\x3e\n      <div class="btn-group button" uib-dropdown\n        uib-tooltip="{{ \'Projector\' | translate }} {{ isAgendaProjected(mainListTree)[0] || \'\' }}"\n        tooltip-enable="isAgendaProjected(mainListTree).length"\n        os-perms="core.can_manage_projector">\n        <button type="button" class="btn btn-default btn-sm"\n            title="{{ \'Project agenda\' | translate }}"\n            ng-click="projectAgenda(defaultProjectorId_all_items, mainListTree)"\n            ng-class="{ \'btn-primary\': isAgendaProjected(mainListTree).length && inArray(isAgendaProjected(mainListTree), defaultProjectorId_all_items)}">\n          <i class="fa fa-video-camera"></i>\n          <translate>Agenda</translate>\n        </button>\n        <button type="button" class="btn btn-default btn-sm" uib-dropdown-toggle\n            ng-class="{ \'btn-primary\': isAgendaProjected(mainListTree).length && !inArray(isAgendaProjected(mainListTree), defaultProjectorId_all_items)}"\n            ng-if="agendaHasSubitems || projectors.length > 1">\n          <span class="caret"></span>\n        </button>\n        <ul class="dropdown-menu" role="menu" aria-labelledby="split-button" ng-if="agendaHasSubitems || projectors.length > 1">\n          <li role="menuitem" ng-show="agendaHasSubitems">\n            <a href="" ng-click="changeMainListTree(); $event.stopPropagation();">\n              <i class="fa" ng-class="mainListTree ? \'fa-square-o\' : \'fa-check-square-o\'"></i>\n              <translate>Only main agenda items</translate>\n            </a>\n          </li>\n          <li class="divider" ng-show="agendaHasSubitems && projectors.length > 1"></li>\n          <li role="menuitem" ng-repeat="projector in projectors | orderBy:\'id\'" ng-show="projectors.length > 1">\n            <a href="" ng-click="projectAgenda(projectorId=projector.id, tree=mainListTree)"\n              ng-class="{ \'projected\': inArray(isAgendaProjected(mainListTree), projector.id) }">\n              <i class="fa fa-video-camera" ng-show="inArray(isAgendaProjected(mainListTree), projector.id) "></i>\n              {{ projector.name | translate }}\n              <span ng-if="projector.id == defaultProjectorId_all_items">(<translate>Default</translate>)</span>\n            </a>\n          </li>\n        </ul>\n      </div>\n    </div>\n    <h1 translate>Agenda</h1>\n  </div>\n</div>\n\n<div class="details">\n  <div class="row">\n    <div class="col-sm-12">\n      \x3c!-- select mode --\x3e\n      <button os-perms="agenda.can_manage" class="btn btn-sm"\n          ng-class="$parent.isSelectMode ? \'btn-primary\' : \'btn-default\'"\n          ng-click="$parent.isSelectMode = !$parent.isSelectMode; uncheckAll()">\n        <i class="fa fa-check-square-o"></i>\n        <translate>Select ...</translate>\n      </button>\n      \x3c!-- sort button --\x3e\n      <span os-perms="agenda.can_see_internal_items">\n        <a ui-sref="agenda.item.sort" os-perms="agenda.can_manage" class="btn btn-default btn-sm">\n          <i class="fa fa-sitemap fa-lg"></i>\n          <translate>Sort ...</translate>\n        </a>\n      </span>\n      \x3c!-- auto numbering button --\x3e\n      <span ng-if="config(\'agenda_enable_numbering\')">\n        <button os-perms="agenda.can_manage" class="btn btn-default btn-sm"\n          ng-bootbox-confirm="{{ \'Are you sure you want to number all agenda items?\' | translate }}"\n          ng-bootbox-confirm-action="autoNumbering()">\n          <i class="fa fa-sort-numeric-asc"></i>\n          <translate>Numbering</translate>\n        </button>\n      </span>\n      \x3c!-- Export drop down list (for manager) --\x3e\n      <div os-perms="motions.can_manage" class="pull-right" uib-dropdown>\n        <button type="button" class="btn btn-default btn-sm" id="dropdownExport" uib-dropdown-toggle>\n          <i class="fa fa-upload"></i>\n          <span ng-if="itemsFiltered.length == items.length" translate>\n            Export all\n          </span>\n          <span ng-if="itemsFiltered.length != items.length" translate>\n            Export filtered\n          </span>\n          <span class="caret"></span>\n        </button>\n        <ul class="dropdown-menu dropdown-menu-right" aria-labelledby="dropdownExport">\n          \x3c!-- PDF export --\x3e\n          <li>\n            <a href="" ng-click="pdfExport()">\n              <i class="fa fa-file-pdf-o"></i>\n              PDF\n            </a>\n          </li>\n          \x3c!-- CSV export --\x3e\n          <li os-perms="agenda.can_manage">\n            <a href="" id="downloadLinkCSV"\n              ng-click="csvExport()">\n              <i class="fa fa-file-text-o"></i>\n              CSV\n            </a>\n          </li>\n          \x3c!-- DOCX export --\x3e\n          <li>\n            <a href="" ng-click="docxExport()">\n              <i class="fa fa-file-word-o"></i>\n              DOCX\n            </a>\n          </li>\n        </ul>\n      </div>\n      \x3c!-- Export button (for normal users) --\x3e\n      <button type="button" class="btn btn-default btn-sm pull-right"\n        os-perms="!motions.can_manage" ng-click="pdfExport()">\n        <i class="fa fa-file-pdf-o"></i>\n        <span ng-if="itemsFiltered.length == items.length" translate>\n          Export all\n        </span>\n        <span ng-if="itemsFiltered.length != items.length" translate>\n          Export filtered\n        </span>\n      </button>\n    </div>\n  </div>\n  <div uib-collapse="!isSelectMode" class="row spacer">\n    <div class="col-sm-12 text-left form-inline" os-perms="agenda.can_manage">\n      \x3c!-- actions --\x3e\n      <select ng-model="selectedAction" class="form-control input-sm">\n        <option value="" translate>--- Select action ---</option>\n        <option value="delete" translate>Delete</option>\n        <option value="setType" translate>Set visibility</option>\n        <option value="setState" translate>Set state</option>\n      </select>\n      \x3c!-- Type (visibility) --\x3e\n      <select ng-show="selectedAction == \'setType\'" ng-model="selectedType" class="form-control input-sm">\n        <option value="" translate>--- Select visibility ---</option>\n        <option value="{{ AGENDA_ITEM }}" translate>\n          Public\n        </option>\n        <option value="{{ INTERNAL_ITEM }}" translate>\n          Internal\n        </option>\n        <option value="{{ HIDDEN_ITEM }}" translate>\n          Hidden\n        </option>\n      </select>\n      \x3c!-- set type button --\x3e\n      <a ng-show="selectedAction == \'setType\' && selectedType"\n          ng-click="setTypeMultiple(selectedType)" class="btn btn-default btn-sm">\n        <translate>Set visibility</translate>\n      </a>\n      \x3c!-- set state buttons --\x3e\n      <a ng-show="selectedAction == \'setState\'"\n          ng-click="setStateMultiple(true)" class="btn btn-default btn-sm">\n        <i class="fa fa-check-square-o"></i>\n        <translate>Done</translate>\n      </a>\n      <a ng-show="selectedAction == \'setState\'"\n          ng-click="setStateMultiple(false)" class="btn btn-default btn-sm">\n        <i class="fa fa-square-o"></i>\n        <translate>Open</translate>\n      </a>\n      \x3c!-- delete button --\x3e\n      <a ng-if="selectedAction === \'delete\'"\n        ng-bootbox-confirm="{{ \'Are you sure you want to delete all selected agenda items?\' | translate }}"\n        ng-bootbox-confirm-action="deleteMultiple()"\n        class="btn btn-default btn-sm btn-danger">\n        <i class="fa fa-trash fa-lg"></i>\n        <translate>Delete selected items</translate>\n      </a>\n    </div>\n  </div>\n\n  <div class="spacer-top-lg italic row">\n    <div class="col-md-6">\n      <span os-perms="agenda.can_see_internal_items">{{ itemsFiltered.length }} /</span>\n      {{ (items|filter:{is_hidden:false}).length }} {{ "items" | translate }}<span ng-if="(items|filter:{selected:true}).length > 0">,\n      {{(items|filter:{selected:true}).length}} {{ "selected" | translate }}</span>\n      <span os-perms="agenda.can_see_internal_items" class="optional">\n        <span ng-if="sumDurations() > 0">&middot;\n          <translate>Duration</translate>:\n          {{ sumDurations() | osMinutesToTime }}h\n          <span ng-if="config(\'agenda_start_event_date_time\')">\n            (<translate>Estimated end:</translate> {{ calculateEndTime() }})\n          </span>\n        </span>\n      </span>\n      <span ng-if="agendaHasMultipleLayers() && items.length === itemsSearched.length">\n        &middot;\n        <a href="" ng-click="toggleCollapseState()">\n          <span ng-if="collapseState" translate>Expand all</span>\n          <span ng-if="!collapseState" translate>Collapse all</span>\n        </a>\n      </span>\n    </div>\n    <div class="col-md-6" ng-show="itemsFiltered.length > pagination.itemsPerPage">\n      <span class="pull-right">\n        <a href="" class="pagination-arrow" ng-click="pagination.prevPage()"\n          ng-if="pagination.showPrevPageArrow()">\n          &laquo;\n        </a>\n        <translate>Page</translate> {{ pagination.currentPage }} /\n        {{ pagination.getPageCount(itemsFiltered) }}\n        <a href="" class="pagination-arrow" ng-click="pagination.nextPage(itemsFiltered)"\n          ng-if="pagination.showNextPageArrow(itemsFiltered)">\n          &raquo;\n        </a>\n      </span>\n    </div>\n  </div>\n\n  <div id="agenda-table" class="os-table container-fluid">\n    <div class="row header-row">\n      <div class="col-xs-1 centered" ng-show="isSelectMode">\n        <i class="fa text-danger pointer" ng-class="selectedAll ? \'fa-check-square-o\' : \'fa-square-o\'"\n          ng-click="checkAll()"></i>\n      </div>\n      <div class="col-xs-11 main-header">\n        <span class="form-inline text-right pull-right">\n          \x3c!-- clear all filters --\x3e\n          <span class="sort-spacer pointer" ng-click="resetFilters(isSelectMode)"\n            ng-if="areFiltersSet()" ng-disabled="isSelectMode"\n            ng-class="{\'disabled\': isSelectMode}">\n            <i class="fa fa-window-close"></i>\n            <translate>Filter</translate>\n          </span>\n          \x3c!-- boolean Filters --\x3e\n          \x3c!-- State --\x3e\n          <span uib-dropdown>\n            <span class="sort-spacer pointer" id="dropdownItems" uib-dropdown-toggle\n              ng-class="{\'bold\': filter.booleanFilters.closed.value !== filter.booleanFilters.closed.defaultValue,\n                  \'disabled\': isSelectMode}"\n              ng-disabled="isSelectMode">\n              <translate>State</translate>\n              <span class="caret"></span>\n            </span>\n            <ul class="dropdown-menu dropdown-menu-right" aria-labelledby="dropdownItems">\n              <li>\n                <a href ng-click="filter.booleanFilters.closed.value = (filter.booleanFilters.closed.value ? undefined : true); filter.save();">\n                  <i class="fa" ng-class="{\'fa-check\': filter.booleanFilters.closed.value === true}"></i>\n                  {{ filter.booleanFilters.closed.choiceYes | translate }}\n                </a>\n              </li>\n              <li>\n                <a href ng-click="filter.booleanFilters.closed.value = (filter.booleanFilters.closed.value === false) ? undefined : false; filter.save();">\n                  <i class="fa" ng-class="{\'fa-check\': filter.booleanFilters.closed.value === false}"></i>\n                  {{ filter.booleanFilters.closed.choiceNo | translate }}\n                </a>\n              </li>\n            </ul>\n          </span>\n          \x3c!-- Visibility --\x3e\n          <span uib-dropdown>\n            <span class="sort-spacer pointer" id="dropdownItems" uib-dropdown-toggle\n              ng-class="{\'bold\': areVisibilityFiltersSet(),\n                  \'disabled\': isSelectMode}"\n              ng-disabled="isSelectMode">\n              <translate>Visibility</translate>\n              <span class="caret"></span>\n            </span>\n            <ul class="dropdown-menu dropdown-menu-right" aria-labelledby="dropdownItems">\n              <li>\n                <a href ng-click="filter.booleanFilters.is_public.value = !filter.booleanFilters.is_public.value; filter.save();">\n                  <i class="fa" ng-class="{\'fa-check\': filter.booleanFilters.is_public.value}"></i>\n                  <translate>Public items</translate>\n                </a>\n              </li>\n              <li os-perms="agenda.can_see_internal_items">\n                <a href ng-click="filter.booleanFilters.is_internal.value = !filter.booleanFilters.is_internal.value; filter.save();">\n                  <i class="fa" ng-class="{\'fa-check\': filter.booleanFilters.is_internal.value}"></i>\n                  <translate>Internal items</translate>\n                </a>\n              </li>\n              <li os-perms="agenda.can_see_internal_items agenda.can_manage">\n                <a href ng-click="filter.booleanFilters.is_hidden.value = !filter.booleanFilters.is_hidden.value; filter.save();">\n                  <i class="fa" ng-class="{\'fa-check\': filter.booleanFilters.is_hidden.value}"></i>\n                  <translate>Hidden items</translate>\n                </a>\n              </li>\n            </ul>\n          </span>\n          \x3c!-- search field --\x3e\n          <span class="form-group">\n            <span class="input-group">\n              <span class="input-group-addon"><i class="fa fa-search"></i></span>\n              <input type="text" ng-model="filter.filterString" class="form-control"\n                 placeholder="{{ \'Search\' | translate}}" ng-disabled="isSelectMode"\n                 ng-change="filter.save()">\n            </span>\n          </span>\n        </span>\n        \x3c!-- show all selected multiselectoptions --\x3e\n        <span>\n          \x3c!-- for all boolean Filters --\x3e\n          <span ng-repeat="(name, booleanFilter) in filter.booleanFilters"\n            ng-hide="booleanFilter.value === booleanFilter.defaultValue"\n            class="pointer spacer-left-lg"\n            ng-click="booleanFilter.value = booleanFilter.defaultValue; filter.save();"\n            ng-class="{\'disabled\': isSelectMode}">\n            <span class="nobr">\n              <i class="fa fa-times-circle"></i>\n              {{ booleanFilter.value ? booleanFilter.choiceYes : booleanFilter.choiceNo | translate }}\n            </span>\n          </span>\n        </span>\n      </div>\n    </div>\n\n    \x3c!-- main table --\x3e\n    <div class="row data-row" ng-mouseover="item.hover=true"\n      ng-mouseleave="item.hover=false"\n      ng-class="{\'projected\': item.isProjected().length,\n      \'related-projected\': item.isRelatedProjected().length}"\n      ng-repeat="item in itemsFiltered = (itemsSearched = (items\n        | osFilter : filter.filterString : filter.getObjectQueryString)\n        | filter : {closed: filter.booleanFilters.closed.value}\n        | itemTypeFilter : filter.booleanFilters)\n        | collapsedItemFilter\n        | limitTo : pagination.itemsPerPage : pagination.limitBegin">\n\n      \x3c!-- select column --\x3e\n      <div ng-show="isSelectMode" os-perms="agenda.can_manage" class="col-xs-1 centered">\n        <i class="fa text-danger pointer" ng-click="item.selected=!item.selected"\n        ng-class="item.selected ? \'fa-check-square-o\' : \'fa-square-o\'"></i>\n      </div>\n      \x3c!-- projector column --\x3e\n      <div class="col-xs-1 centered projector" os-perms="core.can_manage_projector">\n        <div class="btn-group" style="min-width:{{ (item.hasSubitems(items) || projectors.length > 1) ? \'54\' : \'34\' }}px;" uib-dropdown\n          uib-tooltip="{{ \'Projector\' | translate }} {{ item.isProjected(item.tree)[0] || \'\' }}"\n          tooltip-enable="item.isProjected(item.tree).length">\n          <button class="btn btn-default btn-sm"\n              ng-click="item.project(getProjectionDefault(item), item.tree)"\n              ng-class="{ \'btn-primary\': item.isProjected(item.tree).length && inArray(item.isProjected(item.tree), getProjectionDefault(item))}">\n            <i class="fa fa-video-camera"></i>\n          </button>\n          <button type="button" class="btn btn-default btn-sm slimDropDown"\n              ng-class="{ \'btn-primary\': item.isProjected(item.tree).length && !inArray(item.isProjected(item.tree), getProjectionDefault(item))}"\n              ng-if="item.hasSubitems(items) || projectors.length > 1"\n              uib-dropdown-toggle>\n            <span class="caret"></span>\n          </button>\n          <ul class="dropdown-menu" role="menu" aria-labelledby="split-button"\n            ng-if="item.hasSubitems(items) || projectors.length > 1">\n            <li role="menuitem" ng-show="item.hasSubitems(items)">\n              <a href="" ng-click="changeItemTree(item); $event.stopPropagation();">\n                <i class="fa" ng-class="item.tree ? \'fa-check-square-o\' : \'fa-square-o\'"></i>\n                <translate>Include all sub items</translate>\n              </a>\n            </li>\n            <li class="divider" ng-show="item.hasSubitems(items)"></li>\n            <li role="menuitem" ng-repeat="projector in projectors | orderBy:\'id\'">\n              <a href="" ng-click="item.project(projector.id, item.tree)"\n                ng-class="{ \'projected\': inArray(item.isProjected(item.tree), projector.id) }">\n                <i class="fa fa-video-camera" ng-show="inArray(item.isProjected(item.tree), projector.id)"></i>\n                {{ projector.name | translate }}\n                <span ng-if="projector.id == getProjectionDefault(item)">(<translate>Default</translate>)</span>\n              </a>\n            </li>\n          </ul>\n        </div>\n      </div>\n      <div class="no-projector-spacer" os-perms="!core.can_manage_projector"></div>\n\n      \x3c!-- main content column --\x3e\n      <div class="col-xs-6 content"\n        style="padding-left: calc({{ items.length === itemsSearched.length ? item.parentCount : 0 }}*25px)">\n        <div class="caret-spacer" ng-if="items.length === itemsSearched.length">\n          <i class="fa pointer"\n            ng-style="{visibility: hasChildren(item) ? \'visible\' : \'hidden\'}"\n            ng-class="item.hideChildren ? \'fa-caret-right\' : \'fa-caret-down\'"\n            ng-click="item.hideChildren = !item.hideChildren"></i>\n        </div>\n        <div class="title-column">\n          \x3c!-- ID and title --\x3e\n          <div>\n            <a class="title" ui-sref="{{ item.getContentObjectDetailState() }}" ng-show="isAllowedToSeeOpenLink(item)">\n              {{ item.getListViewTitle() }}\n            </a>\n            <span class="title" ng-hide="isAllowedToSeeOpenLink(item)">\n              {{ item.getListViewTitle() }}\n            </span>\n          </div>\n          \x3c!-- hover menu --\x3e\n          <div os-perms="agenda.can_see" ng-class="{\'hiddenDiv\': !item.hover}">\n            <small>\n              <a ui-sref="agenda.item.detail({id: item.id})" translate>List of speakers</a>\n              <span os-perms="agenda.can_manage"> &middot;\n                <a href="" ng-click="edit(item)" translate>Edit</a> &middot;\n                <a href="" class="text-danger"\n                  ng-bootbox-confirm="{{ \'Are you sure you want to delete this entry?\' | translate }}<br>\n                    <b>{{ item.getTitle() }}</b>"\n                  ng-bootbox-confirm-action="deleteRelatedItem(item)" translate>Delete</a>\n              </span>\n            </small>\n          </div>\n\n        </div>\n      </div>\n      \x3c!-- additional content column --\x3e\n      <div class="col-xs-4 content" ng-style="{\'width\': isSelectMode ? \'calc(50% - 120px)\' : \'calc(50% - 70px)\'}">\n        <div style="width: 60%;" class="optional">\n          <small>\n            \x3c!-- type dropdown for managers --\x3e\n            <div os-perms="agenda.can_manage">\n              <div ng-mouseover="typeHover=true" ng-mouseleave="typeHover=false">\n                <span uib-dropdown>\n                  <span id="dropdownType{{ item.id }}" class="pointer"\n                    uib-dropdown-toggle uib-tooltip="{{ \'Change visibility\' | translate }}"\n                    tooltip-class="nobr">\n                    <span ng-if="item.is_public && item.hover">\n                      <i class="fa fa-eye"></i>\n                      <translate>Public</translate>\n                    </span>\n                    <span ng-if="item.is_internal">\n                      <i class="fa fa-eye"></i>\n                      <translate>Internal</translate>\n                    </span>\n                    <span ng-if="item.is_hidden">\n                      <i class="fa fa-eye"></i>\n                      <translate>Hidden</translate>\n                    </span>\n                    <i class="fa fa-cog fa-lg spacer-left" ng-show="typeHover"></i>\n                  </span>\n                  <ul class="dropdown-menu" aria-labelledby="dropdownType{{ item.id }}">\n                    <li>\n                      <a href ng-click="item.type = AGENDA_ITEM; save(item);" translate>\n                        Public item\n                      </a>\n                    </li>\n                    <li>\n                      <a href ng-click="item.type = INTERNAL_ITEM; save(item);" translate>\n                        Internal item\n                      </a>\n                    </li>\n                    <li>\n                      <a href ng-click="item.type = HIDDEN_ITEM; save(item);" translate>\n                        Hidden item\n                      </a>\n                    </li>\n                  </ul>\n                </span>\n              </div>\n            </div>\n            \x3c!-- type for non-managers --\x3e\n            <div os-perms="!agenda.can_manage">\n              <span ng-if="item.is_public && item.hover">\n                <i class="fa fa-eye"></i>\n                <translate>Public</translate>\n              </span>\n              <span ng-if="item.is_internal">\n                <i class="fa fa-eye"></i>\n                <translate>Internal</translate>\n              </span>\n              <span ng-if="item.is_hidden">\n                <i class="fa fa-eye"></i>\n                <translate>Hidden</translate>\n              </span>\n            </div>\n            \x3c!-- Duration --\x3e\n            <div ng-style="{\'visibility\': (item.duration || item.hover) ? \'visible\' : \'hidden\'}">\n              <div class="popover-wrapper" os-perms="agenda.can_manage">\n                <i class="fa fa-clock-o"></i>\n                <span editable-text="item.durationText" e-placeholder="hh:mm"\n                  onshow="generateDurationText(item)" onaftersave="setDurationText(item)">\n                  <span ng-if="!item.duration" translate>Set duration ...</span>\n                  <span ng-if="item.duration">\n                    {{ (item.duration | osMinutesToTime)}}\n                    <translate translate-comment="\'h\' means time in hours">h</translate>\n                  </span>\n                </span>\n              </div>\n              <div os-perms="!agenda.can_manage">\n                <div os-perms="agenda.can_see_internal_items">\n                  <span ng-if="item.duration">\n                    <i class="fa fa-clock-o"></i> {{ item.duration | osMinutesToTime }}\n                      <translate translate-comment="\'h\' means time in hours">h</translate>\n                  </span>\n                </div>\n              </div>\n            </div>\n            \x3c!-- Comment --\x3e\n            <div ng-style="{\'visibility\': (item.comment || item.hover) ? \'visible\' : \'hidden\'}">\n              <div class="popover-wrapper" os-perms="agenda.can_manage">\n                <i class="fa fa-info-circle"></i>\n                <span editable-text="item.comment" onaftersave="save(item)">\n                  <span ng-if="!item.comment" translate>Set comment ...</span>\n                  <span ng-if="item.comment">{{ item.comment }}</span>\n                </span>\n              </div>\n            </div>\n            \x3c!-- Number --\x3e\n            <div ng-style="{\'visibility\': ((item.is_public) && item.hover) ? \'visible\' : \'hidden\'}" os-perms="agenda.can_manage">\n              <div class="popover-wrapper" os-perms="agenda.can_manage">\n                <i class="fa fa-info-circle"></i>\n                <span editable-text="item.item_number" onaftersave="save(item)">\n                  <span ng-if="!item.item_number" translate>Set item number ...</span>\n                  <span ng-if="item.item_number"><em translate>Change item number ...</em></span>\n                </span>\n              </div>\n            </div>\n            <template-hook hook-name="agendaListAdditionalContentColumn"></template-hook>\n          </small>\n        </div>\n        <div style="width: 40%;" class="pull-right">\n          <div os-perms="agenda.can_manage">\n            <div class="pointer nobr" ng-click="item.closed = !item.closed; save(item);" ng-show="item.hover || item.closed">\n              <i class="fa" ng-class="item.closed ? \'fa-check-square-o\' : \'fa-square-o\'"></i>\n              <span class="spacer-left" translate>Done</span>\n            </div>\n          </div>\n          <div os-perms="!agenda.can_manage" >\n            <div ng-show="item.closed">\n              <i class="fa fa-check-square-o"></i>\n              <span class="spacer-left" translate>Done</span>\n            </div>\n          </div>\n        </div>\n      </div>\n    </div> \x3c!-- data row --\x3e\n\n  </div> \x3c!-- container --\x3e\n\n  <ul uib-pagination\n      ng-show="itemsFiltered.length > pagination.itemsPerPage"\n      total-items="itemsFiltered.length"\n      items-per-page="pagination.itemsPerPage"\n      ng-model="pagination.currentPage"\n      ng-change="pagination.pageChanged()"\n      class="pagination-sm"\n      direction-links="false"\n      boundary-links="true"\n      first-text="&laquo;"\n      last-text="&raquo;">\n  </ul>\n</div> \x3c!-- details --\x3e\n'),n.put("agenda/static/templates/agenda/item-sort.html",'<div class="header">\n  <div class="title">\n    <div class="submenu">\n      <a ui-sref="agenda.item.list" class="btn btn-sm btn-default">\n        <i class="fa fa-angle-double-left fa-lg"></i>\n        <translate>Back to overview</translate>\n      </a>\n    </div>\n    <h1 translate>Sort agenda</h1>\n  </div>\n</div>\n\n<div class="details agenda-sort">\n  <p translate>Drag and drop items to change the order of the agenda. Your modification will be saved immediately.</p>\n\n  <p>\n    <button class="btn btn-default btn-sm" ng-click="showInternalItems=!showInternalItems">\n      <translate ng-if="showInternalItems">Hide internal items</translate>\n      <translate ng-if="!showInternalItems">Show internal items</translate>\n    </button>\n\n  <div uib-alert ng-show="alert.show" ng-class="\'alert-\' + (alert.type || \'warning\')" ng-click="alert={}" close="alert={}">\n    {{ alert.msg }}\n  </div>\n\n  <div ui-tree="treeOptions" id="tree-root" data-empty-placeholder-enabled="false">\n    <ol ui-tree-nodes ng-model="items">\n      <li ng-repeat="item in items" ui-tree-node ng-include="\'nodes_renderer.html\'">\n    </ol>\n  </div>\n</div>\n\n\n\x3c!-- Nested node template --\x3e\n<script type="text/ng-template" id="nodes_renderer.html">\n  <div ui-tree-handle ng-if="!item.item.is_hidden">\n    {{ item.item.getListViewTitle() }}\n  </div>\n  <div ui-tree-handle ng-if="item.item.is_hidden && showInternalItems" class="internal">\n    <i class="fa fa-ban"></i> &nbsp;\n    {{ item.item.getListViewTitle() }}\n  </div>\n\n  <ol ui-tree-nodes="" ng-model="item.children">\n    <li ng-repeat="item in item.children" ui-tree-node ng-include="\'nodes_renderer.html\'">\n  </ol>\n<\/script>\n\n'),
n.put("agenda/static/templates/agenda/list-of-speakers-partial-management.html",'<div ng-if="item" class="details" ng-controller="ListOfSpeakersManagementCtrl">\n  <div class="speakers-toolbar">\n    <div class="pull-right">\n      <span os-perms="agenda.can_manage">\n        <button ng-if="item.speaker_list_closed" ng-click="closeList(false)"\n          class="btn btn-sm btn-default">\n          <translate>Open list of speakers</translate>\n        </button>\n        <button ng-if="!item.speaker_list_closed" ng-click="closeList(true)"\n          class="btn btn-sm btn-default">\n          <translate>Close list of speakers</translate>\n        </button>\n      </span>\n      <span os-perms="agenda.can_manage_list_of_speakers">\n        <button ng-if="isAllowed(\'removeAll\')" class="btn btn-sm btn-danger"\n          ng-bootbox-confirm="{{ \'Are you sure you want to remove all speakers from this list?\'| translate }}"\n          ng-bootbox-confirm-action="removeAllSpeakers()">\n          <i class="fa fa-trash fa-lg"></i>\n          <translate>Remove all speakers</translate>\n        </button>\n      </span>\n    </div>\n  </div>\n\n  \x3c!-- text for empty list --\x3e\n  <p ng-if="speakers.length == 0" translate>\n    The list of speakers is empty.\n  </p>\n\n  <template-hook hook-name="itemDetailListOfSpeakersButtons"></template-hook>\n\n  \x3c!-- Last speakers --\x3e\n  <div class="spacer-top-lg spacer-bottom">\n    <button ng-if="isAllowed(\'showLastSpeakers\')" ng-click="$parent.showOldSpeakers = !$parent.showOldSpeakers"\n        class="btn btn-xs btn-default">\n      <translate ng-if="!$parent.showOldSpeakers">Last speakers</translate>\n      <translate ng-if="$parent.showOldSpeakers">Hide</translate>\n    </button>\n    <div uib-collapse="!showOldSpeakers">\n      <ol class="indentation">\n        <li ng-repeat="speaker in lastSpeakers">\n          {{ speaker.user.get_full_name() }}\n          <i class="fa fa-star" ng-if="speaker.marked" title="{{ \'Marked\' | translate }}"></i>\n          <small class="grey">\n            {{ getDuration(speaker) | osSecondsToTime }} <translate>minutes</translate>\n            (<translate>Start time</translate>:\n            {{ speaker.begin_time | date:\'yyyy-MM-dd HH:mm:ss\' }})\n          </small>\n          <button os-perms="agenda.can_manage_list_of_speakers" ng-click="removeSpeaker(speaker.id)"\n              class="btn btn-default btn-xs" title="{{ \'Remove\' | translate }}">\n            <i class="fa fa-times"></i>\n          </button>\n      </ol>\n    </div>\n  </div>\n\n  \x3c!-- Current speaker --\x3e\n  <p ng-repeat="speaker in currentSpeaker" class="currentSpeaker spacer indentation">\n    <i class="fa fa-microphone fa-lg"></i>\n    {{ speaker.user.get_full_name() }}\n    <span os-perms="!agenda.can_manage_list_of_speakers">\n      <i class="fa fa-star" ng-if="speaker.marked" title="{{ \'Marked\' | translate }}"></i>\n    </span>\n    <button os-perms="agenda.can_manage_list_of_speakers" ng-click="endSpeech()"\n        class="btn btn-default btn-sm" title="{{ \'End speech\' | translate }}">\n      <i class="fa fa-microphone-slash"></i> <translate>Stop</translate>\n    </button>\n    <button os-perms="agenda.can_manage_list_of_speakers" ng-click="toggleMarked(speaker)"\n        class="btn btn-default btn-sm" title="{{ \'Mark speaker\' | translate }}">\n      <i class="fa" ng-class="speaker.marked ? \'fa-star\' : \'fa-star-o\'"></i>\n    </button>\n    <button os-perms="agenda.can_manage_list_of_speakers" ng-click="removeSpeaker(speaker.id)"\n        class="btn btn-default btn-sm" title="{{ \'Remove\' | translate }}">\n      <i class="fa fa-times"></i>\n    </button>\n  </p>\n\n  \x3c!-- Next speakers --\x3e\n  <div ng-show="nextSpeakers.length > 0">\n    <div ui-tree="treeOptions" data-empty-placeholder-enabled="false">\n      <ol ui-tree-nodes="" ng-model="nextSpeakers">\n        <li ng-repeat="speaker in nextSpeakers | orderBy: \'weight\'" ui-tree-node>\n          <i os-perms="agenda.can_manage_list_of_speakers" ui-tree-handle="" class="fa fa-arrows-v"></i>\n          {{ $index + 1 }}.\n          {{ speaker.user.get_full_name() }}\n          <span os-perms="!agenda.can_manage_list_of_speakers">\n            <i class="fa fa-star" ng-if="speaker.marked" title="{{ \'Marked\' | translate }}"></i>\n          </span>\n          &nbsp;\n          <button os-perms="agenda.can_manage_list_of_speakers" ng-click="beginSpeech(speaker.id)"\n              class="btn btn-default btn-sm" title="{{ \'Begin speech\' | translate }}">\n            <i class="fa fa-microphone"></i> <translate>Start</translate>\n          </button>\n          <button os-perms="agenda.can_manage_list_of_speakers" ng-click="toggleMarked(speaker)"\n              class="btn btn-default btn-sm" title="{{ \'Mark speaker\' | translate }}">\n            <i class="fa" ng-class="speaker.marked ? \'fa-star\' : \'fa-star-o\'"></i>\n          </button>\n          <button os-perms="agenda.can_manage_list_of_speakers" ng-click="removeSpeaker(speaker.id)"\n              class="btn btn-default btn-sm" title="{{ \'Remove\' | translate }}">\n            <i class="fa fa-times"></i>\n          </button>\n      </ol>\n    </div>\n  </div>\n\n  \x3c!-- Select speakers form --\x3e\n  <div class="form-group spacer-top-lg">\n    <div uib-alert ng-show="alert.show" ng-class="\'alert-\' + (alert.type || \'warning\')" ng-click="alert={}" close="alert={}">\n      {{ alert.msg }}\n    </div>\n    <div os-perms="agenda.can_manage_list_of_speakers">\n      <select chosen\n          ng-model="speakerSelectBox.selected"\n          ng-change="addSpeaker(speakerSelectBox.selected)"\n          ng-options="user.id as user.get_full_name() for user in users"\n          search-contains="true"\n          placeholder-text-single="\'Select or search a participant ...\' | translate"\n          no-results-text="\'No results available ...\' | translate"\n          class="form-control">\n      <select>\n    </div>\n    <p class="spacer">\n      <button ng-if="isAllowed(\'add\')" ng-click="addSpeaker()" class="btn btn-default btn-sm">\n        <i class="fa fa-plus"></i>\n        <translate>Add me</translate>\n      </button>\n      <button ng-if="isAllowed(\'remove\')" ng-click="removeSpeaker()" class="btn btn-default btn-sm">\n        <i class="fa fa-minus"></i>\n        <translate>Remove me</translate>\n      </button>\n  </div>\n</div>\n'),n.put("agenda/static/templates/agenda/partial-slide-current-list-of-speakers-overlay.html",'<div id="speakerbox">\n  <h3 translate>List of speakers</h3>\n\n  \x3c!-- Last speakers --\x3e\n  <p ng-repeat="speaker in lastSpeakers = (agendaItem.speakers\n    | filter: {end_time: \'!!\', begin_time: \'!!\'})\n    | limitTo: config(\'agenda_show_last_speakers\') : (lastSpeakers.length - config(\'agenda_show_last_speakers\'))"\n    class="lastSpeakers">\n    {{ speaker.user.get_full_name() }}\n    <i class="fa fa-star" ng-if="speaker.marked" title="{{ \'Marked\' | translate }}"></i>\n  </p>\n\n  \x3c!-- Current speaker --\x3e\n  <div ng-repeat="speaker in agendaItem.speakers | filter: {end_time: null, begin_time: \'!!\'} "\n    class="currentSpeaker">\n    <i class="fa fa-microphone fa-lg"></i>\n    <span class="pull-right" style="width:calc(100% - 30px);">\n      {{ speaker.user.get_full_name() }}\n      <i class="fa fa-star" ng-if="speaker.marked" title="{{ \'Marked\' | translate }}"></i>\n    </span>\n  </div>\n\n  \x3c!-- Next speakers --\x3e\n  <ol class="nextSpeakers">\n    <li ng-repeat="speaker in nextSpeakers = (agendaItem.speakers\n      | filter: {begin_time: null})\n      | orderBy:\'weight\'\n      | limitTo: 3">\n      {{ speaker.user.get_full_name() }}\n      <i class="fa fa-star" ng-if="speaker.marked" title="{{ \'Marked\' | translate }}"></i>\n    </li>\n  </ol>\n  <p ng-if="nextSpeakers.length > 3" class="lastSpeakers">\n    <i>+ {{ nextSpeakers.length - 3 }}</i>\n  </p>\n</div>\n'),n.put("agenda/static/templates/agenda/partial-slide-current-list-of-speakers.html",'<div class="content scrollcontent">\n\n  \x3c!-- Title --\x3e\n  <div id="title">\n    <h1 translate>List of speakers</h1>\n    <h2>{{ agendaItem.getListOfSpeakersTitle() }}\n      <span ng-if="(agendaItem.speakers | filter: {begin_time: null}).length > 0">\n        &ndash; {{ (agendaItem.speakers | filter: {begin_time: null}).length }} <translate>speakers</translate>\n      </span>\n      <span ng-if="agendaItem.speaker_list_closed" class="slimlabel label label-danger" translate>Closed</span>\n    </h2>\n  </div>\n\n  <div class="zoomcontent">\n    \x3c!-- Last speakers --\x3e\n    <p ng-repeat="speaker in lastSpeakers = (agendaItem.speakers\n      | filter: {end_time: \'!!\', begin_time: \'!!\'})\n      | limitTo: config(\'agenda_show_last_speakers\') : (lastSpeakers.length - config(\'agenda_show_last_speakers\'))"\n      class="lastSpeakers">\n      {{ speaker.user.get_full_name() }}\n        <i class="fa fa-star" ng-if="speaker.marked" title="{{ \'Marked\' | translate }}"></i>\n    </p>\n\n    \x3c!-- Current speaker --\x3e\n    <p ng-repeat="speaker in currentspeakers = (agendaItem.speakers\n      | filter: {end_time: null, begin_time: \'!!\'})"\n      class="currentSpeaker nobr">\n      <i class="fa fa-microphone fa-lg"></i>\n      {{ speaker.user.get_full_name() }}\n      <i class="fa fa-star" ng-if="speaker.marked" title="{{ \'Marked\' | translate }}"></i>\n    </p>\n\n    \x3c!-- Next speakers --\x3e\n    <ol class="nextSpeakers">\n      <li ng-repeat="speaker in agendaItem.speakers\n        | filter: {begin_time: null}\n        | orderBy:\'weight\'">\n        {{ speaker.user.get_full_name() }}\n        <i class="fa fa-star" ng-if="speaker.marked" title="{{ \'Marked\' | translate }}"></i>\n      </li>\n    </ol>\n  </div>\n</div>\n'),n.put("agenda/static/templates/agenda/slide-current-list-of-speakers.html",'<div ng-controller="SlideCurrentListOfSpeakersCtrl">\n\n  <ng-include src="\'static/templates/agenda/partial-slide-current-list-of-speakers.html\'"\n    ng-if="!overlay"></ng-include>\n  <ng-include src="\'static/templates/agenda/partial-slide-current-list-of-speakers-overlay.html\'"\n    ng-if="overlay"></ng-include>\n\n</div>\n'),n.put("agenda/static/templates/agenda/slide-item-list.html",'<div ng-controller="SlideItemListCtrl" class="content scrollcontent">\n  <h1 ng-if="!element.id" translate>Agenda</h1>\n  <h1 ng-if="element.id">{{ rootItem.getTitle() }}</h1>\n\n  <div class="agendalist zoomcontent" ng-class="{\'spacer-left-lg\': element.id}">\n    <table class="agendalist-table">\n      <tr ng-repeat="node in tree" ng-include="\'projector_agenda_renderer.html\'"></tr>\n    </table>\n  </div>\n</div>\n\n\x3c!-- Nested node template --\x3e\n<script type="text/ng-template" id="projector_agenda_renderer.html">\n  <td class="number" ng-if="!node.item.closed">\n    <p ng-class="{mainitem: node.item.parent_id === null, subitem: node.item.parent_id !== null}">\n      {{ node.item.item_number }}\n    </p>\n  </td>\n  <td ng-if="!node.item.closed">\n    <p ng-class="{mainitem: node.item.parent_id === null, subitem: node.item.parent_id !== null}">\n      {{ node.item.getProjectorTitle() }}\n    </p>\n    <table ng-if="node.children.length" class="agendalist-table">\n      <tr ng-repeat="node in node.children" ng-include="\'projector_agenda_renderer.html\'"></tr>\n    </table>\n  </td>\n<\/script>\n'),n.put("agenda/static/templates/agenda/slide-list-of-speakers.html",'<div ng-controller="SlideListOfSpeakersCtrl" class="content scrollcontent">\n\n  \x3c!-- Title --\x3e\n  <div id="title">\n    <h1 translate>List of speakers</h1>\n    <h2>\n      {{ item.getListOfSpeakersTitle() }}\n      <span ng-if="(item.speakers | filter: {begin_time: null}).length > 0">\n        &ndash; {{ (item.speakers | filter: {begin_time: null}).length }} <translate>speakers</translate>\n      </span>\n      <span ng-if="item.speaker_list_closed" class="slimlabel label label-danger" translate>Closed</span>\n    </h2>\n  </div>\n\n  <div class="zoomcontent">\n    \x3c!-- Last speakers --\x3e\n    <p ng-repeat="speaker in lastSpeakers = (item.speakers | filter: {end_time: \'!!\', begin_time: \'!!\'}) |\n        limitTo: config(\'agenda_show_last_speakers\') : (lastSpeakers.length - config(\'agenda_show_last_speakers\'))" class="lastSpeakers">\n        {{ speaker.user.get_full_name() }}\n        <i class="fa fa-star" ng-if="speaker.marked" title="{{ \'Marked\' | translate }}"></i>\n\n    \x3c!-- Current speaker --\x3e\n    <p ng-repeat="speaker in item.speakers | filter: {end_time: null, begin_time: \'!!\'}"\n        class="currentSpeaker">\n        <i class="fa fa-microphone fa-lg"></i>\n        {{ speaker.user.get_full_name() }}\n        <i class="fa fa-star" ng-if="speaker.marked" title="{{ \'Marked\' | translate }}"></i>\n\n    \x3c!-- Next speakers --\x3e\n    <ol class="nextSpeakers">\n      <li ng-repeat="speaker in item.speakers | filter: {begin_time: null} | orderBy:\'weight\'">\n        {{ speaker.user.get_full_name() }}\n        <i class="fa fa-star" ng-if="speaker.marked" title="{{ \'Marked\' | translate }}"></i>\n    </ol>\n  </div>\n</div>\n'),n.put("assignments/static/templates/assignments/assignment-detail.html",'<div class="header">\n  <div class="title">\n    <div class="submenu">\n      <a ui-sref="assignments.assignment.list" class="btn btn-sm btn-default">\n        <i class="fa fa-angle-double-left fa-lg"></i>\n        <translate>Back to overview</translate>\n      </a>\n      \x3c!-- List of speakers --\x3e\n      <a ui-sref="agenda.item.detail({id: assignment.agenda_item_id})"\n          os-perms="agenda.can_see" class="btn btn-sm btn-default">\n        <i class="fa fa-microphone fa-lg"></i>\n        <translate>List of speakers</translate>\n      </a>\n      \x3c!-- project --\x3e\n      <projector-button model="assignment", default-projector-id="defaultProjectorId"\n        title="{{ \'Project\' | translate }}">\n      </projector-button>\n      \x3c!-- edit --\x3e\n      <a os-perms="assignments.can_manage" ng-click="openDialog()"\n          class="btn btn-default btn-sm"\n          title="{{ \'Edit\' | translate}}">\n        <i class="fa fa-pencil"></i>\n      </a>\n      \x3c!-- pdf --\x3e\n      <a ng-click="pdfExport()" target="_blank" class="btn btn-default btn-sm"\n          title="{{ \'Export as PDF\' | translate}}">\n        <i class="fa fa-file-pdf-o fa-lg"></i>\n        <translate>PDF</translate>\n      </a>\n    </div>\n    <h1>{{ assignment.agenda_item.getTitle() || assignment.title }}</h1>\n    <h2>\n      <translate>Election</translate>\n    </h2>\n  </div>\n</div>\n\n<div class="meta">\n  <div class="title" ng-click="isMeta = !isMeta">\n    <div class="name">\n      <i class="fa fa-info-circle"></i>\n      <translate>Meta information</translate>\n    </div>\n    <div class="icon">\n      <i class="fa fa-lg" ng-class="isMeta ? \'fa-angle-down\' : \'fa-angle-up\'"></i>\n    </div>\n  </div>\n  <div class="detail" uib-collapse="isMeta">\n    <div class="row">\n      <div class="col-md-6">\n          \x3c!-- posts --\x3e\n          <h3 translate>Number of persons to be elected</h3>\n          {{ assignment.open_posts }}<br>\n          \x3c!-- Tags --\x3e\n          <h3 ng-if="assignment.tags.length > 0" translate>Tags</h3>\n          <span ng-repeat="tag in assignment.tags">\n            {{ tag.name }}{{$last ? \'\' : \', \'}}\n          </span>\n      </div>\n      <div class="col-md-6">\n          \x3c!-- phase --\x3e\n          <h3 translate>Phase</h3>\n          <span class="label" ng-class="{\'label-primary\': assignment.phase == 0,\n                                         \'label-warning\': assignment.phase == 1,\n                                         \'label-success\': assignment.phase == 2 }">\n            {{ phases[assignment.phase].display_name | translate }}\n          </span>\n          <div os-perms="assignments.can_manage" class="spacer">\n            <select ng-model="phaseSelect" class="form-control" ng-change="updatePhase(phaseSelect)">\n              <option value="" translate>--- Set phase ---</option>\n              <option ng-repeat="phase in phases" value="{{ phase.value }}">{{ phase.display_name | translate }}</option>\n            </select>\n          </div>\n      </div>\n    </div>\n  </div>\n</div>\n\n<div class="details">\n  <div ng-if="assignment.description" class="clearfix">\n    <h3 translate>Description</h3>\n    <div ng-bind-html="assignment.description | trusted"></div>\n  </div>\n\n  <div ng-if="assignment.phase !== 2">\n    <h3 translate>Candidates</h3>\n    <div ui-tree="treeOptions" ng-if="assignment.assignment_related_users.length"\n        data-empty-placeholder-enabled="false">\n      <ol ui-tree-nodes="" ng-model="relatedUsersSorted">\n        <li ui-tree-node ng-repeat="related_user in assignment.assignment_related_users | orderBy:\'weight\'">\n          <i ui-tree-handle="" class="fa fa-arrows-v spacer-right" os-perms="assignments.can_manage"></i>\n          <a class="spacer-right" ui-sref="users.user.detail({id: related_user.user_id})">\n            {{ related_user.user.get_full_name() }}\n          </a>\n          <i ng-if="related_user.elected" class="fa fa-star" title="{{ \'is elected\' | translate }}"></i>\n          <a href os-perms="assignments.can_manage" ng-click="removeCandidate(related_user.user_id)" class="btn btn-default btn-xs">\n            <i class="fa fa-times"></i>\n          </a>\n      </ol>\n    </div>\n\n    <div class="form-group spacer-top-lg">\n      <div uib-alert ng-show="alert.show" ng-class="\'alert-\' + (alert.type || \'warning\')" ng-click="alert={}" close="alert={}">\n        {{ alert.msg }}\n      </div>\n      <div os-perms="assignments.can_nominate_other">\n        <select chosen ng-model="candidateSelectBox.selected" ng-change="addCandidate(candidateSelectBox.selected)"\n            ng-options="user.id as user.get_full_name() for user in users"\n            search-contains="true"\n            placeholder-text-single="\'Select or search a participant ...\' | translate"\n            no-results-text="\'No results available ...\' | translate"\n            class="form-control">\n        <select>\n      </div>\n      <p os-perms="assignments.can_nominate_self" class="spacer">\n        <button ng-if="!isCandidate()" ng-click="addMe()" class="btn btn-default btn-sm">\n          <i class="fa fa-plus"></i>\n          <translate>Add me</translate>\n        </button>\n        <button ng-if="isCandidate()" ng-click="removeMe()" class="btn btn-default btn-sm">\n          <i class="fa fa-minus"></i>\n          <translate>Remove me</translate>\n        </button>\n    </div>\n  </div>\n\n  <h3 translate>Election result</h3>\n  <template-hook hook-name="assignmentPollVotingHeader"></template-hook>\n  <template-hook hook-name="assignmentPollNewBallotButton">\n    <button os-perms="assignments.can_manage" ng-show="assignment.phase !== 2" ng-click="createBallot()"\n        class="btn btn-default btn-sm">\n      <i class="fa fa-bar-chart fa-lg"></i>\n      <translate>New ballot</translate>\n    </button>\n  </template-hook>\n\n  <uib-tabset ng-if="assignment.polls.length > 0" class="spacer ballot-tabs" active="$parent.activeTab">\n    <uib-tab ng-repeat="poll in assignment.polls | orderBy:\'id\'"\n        index="$index" heading="{{ \'Ballot\' | translate }} {{ $index + 1 }}">\n      <div ng-controller="AssignmentPollDetailCtrl">\n        \x3c!-- action buttons --\x3e\n        <div class="pull-right" os-perms="assignments.can_manage" ng-show="assignment.phase !== 2">\n          <span class="spacer-right" editable-text="poll.description" onaftersave="saveDescriptionChange(poll)"\n            uib-tooltip="{{ \'Hint on the ballot paper.\' | translate }}">\n            <span ng-if="!poll.description" translate>Set hint for ballot paper ...</span>\n            <span ng-if="poll.description">{{ poll.description }}</span>\n            <i class="fa fa-pencil"></i>\n          </span>\n          \x3c!-- delete --\x3e\n          <a class="btn btn-danger btn-xs"\n              ng-bootbox-confirm="{{ \'Are you sure you want to delete this ballot?\' | translate }}"\n              ng-bootbox-confirm-action="deleteBallot(poll)">\n            <i class="fa fa-trash"></i>\n            <translate>Delete</translate>\n          </a>\n        </div>\n        <div os-perms="assignments.can_manage" class="spacer" role="group">\n          \x3c!-- angular requires to open the link in new tab with "target=\'_blank\'".\n          Otherwise the pdf url can\'t be open in same window; angular redirects to "/". --\x3e\n          \x3c!-- PDF --\x3e\n          <a ng-click="ballotpaperExport(poll.id)" target="_blank" class="btn btn-default btn-sm">\n            <i class="fa fa-file-pdf-o"></i>\n            <translate>Print ballot paper</translate>\n          </a>\n          \x3c!-- Edit --\x3e\n          <button ng-click="assignment.phase !== 2 && editPollDialog(poll, $index+1)"\n              ng-class="{ \'disabled\': assignment.phase === 2 }"\n              class="btn btn-default btn-sm">\n            <i class="fa fa-pencil"></i>\n            <translate>Enter votes</translate>\n          </button>\n          \x3c!-- Publish --\x3e\n          <button ng-click="togglePublishBallot(poll)"\n              ng-class="poll.published ? \'btn-primary\' : \'btn-default\'"\n              class="btn btn-sm">\n            <i class="fa fa-eye"></i>\n            <translate>Publish</translate>\n          </button>\n          \x3c!-- Project --\x3e\n          <projector-button model="assignment" default-projector-id="defaultProjectorId"\n            arg="poll.id" content="{{ \'Project\' | translate }}">\n          </projector-button>\n        </div>\n\n        \x3c!-- template hook for assignment poll small buttons --\x3e\n        <template-hook hook-name="assignmentPollSmallButtons"></template-hook>\n\n        <div class="results spacer-top-lg">\n\n          \x3c!-- list of candidates of selected poll (without election result) --\x3e\n          <div ng-if="!poll.has_votes">\n            <strong translate>Candidates</strong>\n            <ul class="list-unstyled">\n              <li ng-repeat="option in poll.options | orderBy:\'weight\'">\n                <a ui-sref="users.user.detail({id: option.candidate.id})">\n                  {{ option.candidate.get_full_name() }}\n                </a>\n            </ul>\n          </div>\n\n          \x3c!-- Settings for majority calculations --\x3e\n          <div os-perms="assignments.can_manage" ng-show="poll.has_votes" ng-cloak>\n            <div class="input-group">\n              <span><translate>Required majority</translate>: </span>\n              <select ng-model="method"\n                      ng-change="recalculateMajorities(method)"\n                      ng-options="option.value as option.display_name | translate for option in methodChoices" />\n            </div>\n          </div>\n          \x3c!-- election result of poll --\x3e\n          <table ng-if="poll.has_votes" class="table table-bordered table-striped minimumTable spacer">\n          <tr>\n            <th translate>Candidates\n            <th translate>Votes\n            <th translate ng-hide="method === \'disabled\'">Quorum\n            </th>\n            \x3c!-- candidates (poll options) --\x3e\n            <tr ng-repeat="option in poll.options | orderBy:\'weight\'">\n              \x3c!-- candidate name --\x3e\n              <td>\n                <span os-perms="assignments.can_manage">\n                  <i ng-if="option.is_elected" class="fa fa-check-square-o"\n                    ng-click="markElected(option.candidate_id, option.is_elected)"\n                      title="{{ \'is elected\' | translate }}"></i>\n                  <i ng-if="!option.is_elected" class="fa fa-square-o"\n                    ng-click="markElected(option.candidate_id, option.is_elected)"\n                      title="{{ \'is not elected\' | translate }}"></i>\n                  &nbsp;\n                </span>\n                <a ui-sref="users.user.detail({id: option.candidate.id})">{{ option.candidate.get_full_name() }}</a>\n\n              \x3c!-- votes --\x3e\n              <td>\n                <div ng-init="votes = option.getVotes()">\n                  <div ng-repeat="vote in votes">\n                    <span ng-if="poll.pollmethod == \'yna\' || poll.pollmethod == \'yn\'">{{ vote.label }}:</span>\n                    {{ vote.value | number:votesPrecision }} {{ vote.percentStr }}\n                    <div ng-if="vote.percentNumber >= 0">\n                      <uib-progressbar ng-if="$index == 0" value="vote.percentNumber" type="success"></uib-progressbar>\n                      <uib-progressbar ng-if="$index == 1" value="vote.percentNumber" type="danger"></uib-progressbar>\n                      <uib-progressbar ng-if="$index == 2" value="vote.percentNumber" type="warning"></uib-progressbar>\n                    </div>\n                  </div>\n                </div>\n              <td ng-hide="method === \'disabled\'">\n                <span ng-if="option.majorityReached >= 0" class="text-success" translate>\n                    Quorum ({{ (option.getVoteYes() - option.majorityReached) | number:votesPrecision }}) reached.\n                </span>\n                <span ng-if="option.majorityReached < 0" class="text-danger" translate>\n                    Quorum ({{ (option.getVoteYes() - option.majorityReached) | number:votesPrecision }}) not reached.\n                </span>\n\n            \x3c!-- total votes (valid/invalid/casts) --\x3e\n            <tr ng-if="poll.pollmethod === \'votes\'">\n              <td>\n                <translate>Abstain</translate>\n              <td>\n                {{ poll.getVote(\'votesabstain\').value | number:votesPrecision }}\n                {{ poll.getVote(\'votesabstain\').percentStr }}\n            <tr ng-if="poll.pollmethod === \'votes\'">\n              <td>\n                <translate>No</translate>\n              <td>\n                {{ poll.getVote(\'votesno\').value | number:votesPrecision }}\n                {{ poll.getVote(\'votesno\').percentStr }}\n            <tr>\n              <td>\n                <translate>Valid ballots</translate>\n              <td>\n                {{ poll.getVote(\'votesvalid\').value | number:votesPrecision }}\n                {{ poll.getVote(\'votesvalid\').percentStr }}\n            <tr>\n              <td>\n                <translate>Invalid ballots</translate>\n              <td>\n                {{ poll.getVote(\'votesinvalid\').value | number:votesPrecision }}\n                {{ poll.getVote(\'votesinvalid\').percentStr }}\n            <tr class="total bg-info">\n              <td>\n                <translate>Casted ballots</translate>\n              <td>\n                {{ poll.getVote(\'votescast\').value | number:votesPrecision }}\n                {{ poll.getVote(\'votescast\').percentStr }}\n          </table>\n\n          <strong translate>Election method</strong><br>\n          <span ng-if="poll.pollmethod == \'votes\'" translate>One vote per candidate</span>\n          <span ng-if="poll.pollmethod == \'yna\'" translate>Yes/No/Abstain per candidate</span>\n          <span ng-if="poll.pollmethod == \'yn\'" translate>Yes/No per candidate</span>\n        </div>\n      </div>\n    </uib-tab>\n  </uib-tabset>\n\n  \x3c!-- Workaround to prevent page scrolling up after autoupdate. --\x3e\n  <div style="height: 700px"></div>\n</div>\n\n<template-hook hook-name="assignmentDetailViewDetailContainer"></template-hook>\n'),n.put("assignments/static/templates/assignments/assignment-form.html",'<h1 ng-if="model.id" translate>Edit election</h1>\n<h1 ng-if="!model.id" translate>New election</h1>\n\n<div uib-alert ng-show="alert.show" ng-class="\'alert-\' + (alert.type || \'warning\')" ng-click="alert={}" close="alert={}">\n  {{ alert.msg }}\n</div>\n\n<form name="assignmentForm" ng-submit="save(model, gotoDetailView)">\n  <formly-form model="model" fields="formFields">\n    <hr class="smallhr">\n    <div class="checkbox pointer" ng-click="$parent.$parent.gotoDetailView = !$parent.$parent.gotoDetailView">\n      <i class="fa" ng-class="$parent.$parent.gotoDetailView ? \'fa-check-square-o\' : \'fa-square-o\'"></i>\n      <translate>Open election detail view after save.</translate>\n    </div>\n    <button type="submit" ng-disabled="assignmentForm.$invalid" class="btn btn-primary" translate>\n      Save\n    </button>\n    <button type="button" ng-click="closeThisDialog()" class="btn btn-default" translate>\n      Cancel\n    </button>\n  </formly-form>\n</form>\n'),
n.put("assignments/static/templates/assignments/assignment-list.html",'<div class="header">\n  <div class="title">\n    <div class="submenu">\n      <a ng-click="openDialog()" os-perms="assignments.can_manage" class="btn btn-primary btn-sm">\n        <i class="fa fa-plus fa-lg"></i>\n        <translate>New</translate>\n      </a>\n      <a ui-sref="core.tag.list" os-perms="core.can_manage_tags" class="btn btn-default btn-sm">\n        <i class="fa fa-tags fa-lg"></i>\n        <translate>Tags</translate>\n      </a>\n      <template-hook hook-name="assignmentListMenuButton"></template-hook>\n    </div>\n    <h1 translate>Elections</h1>\n  </div>\n</div>\n\n<div class="details">\n  <div class="row form-group">\n    <div class="col-sm-12">\n      \x3c!-- select mode --\x3e\n      <button os-perms="assignments.can_manage" class="btn btn-sm"\n          ng-class="$parent.isSelectMode ? \'btn-primary\' : \'btn-default\'"\n          ng-click="$parent.isSelectMode = !$parent.isSelectMode; uncheckAll()">\n        <i class="fa fa-check-square-o"></i>\n        <translate>Select ...</translate>\n      </button>\n      \x3c!-- export button --\x3e\n      <button type="button" class="btn btn-default btn-sm pull-right" ng-click="pdfExport()">\n        <i class="fa fa-file-pdf-o"></i>\n        <span ng-if="assignmentsFiltered.length == assignments.length" translate>\n          Export all\n        </span>\n        <span ng-if="assignmentsFiltered.length != assignments.length" translate>\n          Export filtered\n        </span>\n      </button>\n    </div>\n  </div>\n  <div uib-collapse="!isFilterOpen" class="row">\n    <div class="col-sm-6 text-right"></div>\n    <div class="col-sm-6 text-right">\n      \x3c!-- phase filter --\x3e\n      <select ng-model="phaseFilter" class="form-control" id="phaseFilter">\n        <option value="" translate>--- Select phase ---</option>\n        <option ng-repeat="phase in phases" value="{{ phase.value }}">{{ phase.display_name | translate }}</option>\n      </select>\n    </div>\n  </div>\n  <div uib-collapse="!isSelectMode" class="row spacer">\n    <div class="col-sm-12 text-left">\n      \x3c!-- delete button --\x3e\n      <a ng-show="isSelectMode" os-perms="assignments.can_manage"\n        ng-bootbox-confirm="{{ \'Are you sure you want to delete all selected elections?\' | translate }}"\n        ng-bootbox-confirm-action="deleteMultiple()"\n        class="btn btn-default btn-sm btn-danger">\n        <i class="fa fa-trash fa-lg"></i>\n        <translate>Delete selected elections</translate>\n      </a>\n    </div>\n  </div>\n\n  <div class="spacer-top-lg italic row">\n    <div class="col-md-6">\n      {{ assignmentsFiltered.length }} /\n      {{ assignments.length }} {{ "elections" | translate }}<span ng-if="(assignments|filter:{selected:true}).length > 0">,\n      {{(assignments|filter:{selected:true}).length}} {{ "selected" | translate }}</span>\n    </div>\n    <div class="col-md-6" ng-show="assignmentsFiltered.length > pagination.itemsPerPage">\n      <span class="pull-right">\n        <a href="" class="pagination-arrow" ng-click="pagination.prevPage()"\n          ng-if="pagination.showPrevPageArrow()">\n          &laquo;\n        </a>\n        <translate>Page</translate> {{ pagination.currentPage }} /\n        {{ pagination.getPageCount(assignmentsFiltered) }}\n        <a href="" class="pagination-arrow" ng-click="pagination.nextPage(assignmentsFiltered)"\n          ng-if="pagination.showNextPageArrow(assignmentsFiltered)">\n          &raquo;\n        </a>\n      </span>\n    </div>\n  </div>\n\n  <div class="os-table container-fluid">\n    <div class="row header-row">\n      <div class="col-xs-1 centered" ng-show="isSelectMode">\n        <i class="fa text-danger pointer" ng-class="selectedAll ? \'fa-check-square-o\' : \'fa-square-o\'"\n          ng-click="checkAll()"></i>\n      </div>\n      <div class="col-xs-11 main-header">\n        <span class="form-inline text-right pull-right">\n          \x3c!-- clear all filters --\x3e\n          <span class="sort-spacer pointer" ng-click="filter.reset(isSelectMode)"\n            ng-if="filter.areFiltersSet()" ng-disabled="isSelectMode"\n            ng-class="{\'disabled\': isSelectMode}">\n            <i class="fa fa-window-close"></i>\n            <translate>Filter</translate>\n          </span>\n          \x3c!-- Tag filter --\x3e\n          <span uib-dropdown ng-if="tags.length > 0">\n            <span class="pointer" id="dropdownTag" uib-dropdown-toggle\n              ng-class="{\'bold\': filter.multiselectFilters.tag.length > 0, \'disabled\': isSelectMode}"\n              ng-disabled="isSelectMode">\n              <translate>Tag</translate>\n              <span class="caret"></span>\n            </span>\n            <ul class="dropdown-menu dropdown-menu-right"\n              aria-labelledby="dropdownTag">\n              <li ng-repeat="tag in tags">\n                <a href ng-click="filter.operateMultiselectFilter(\'tag\', tag.id, isSelectMode)">\n                  <i class="fa fa-check" ng-if="filter.MultiselectFilters.tag.indexOf(tag.id) > -1"></i>\n                  {{ tag.name }}\n                </a>\n              </li>\n              <li class="divider"></li>\n              <li>\n                <a href ng-click="filter.operateMultiselectFilter(\'tag\', -1, isSelectMode)">\n                  <i class="fa fa-check" ng-if="filter.multiselectFilters.tag.indexOf(-1) > -1"></i>\n                  <translate>No tag set</translate>\n                </a>\n              </li>\n            </ul>\n          </span>\n          \x3c!-- Phase filter --\x3e\n          <span uib-dropdown>\n            <span class="pointer" id="dropdownPhase" uib-dropdown-toggle\n              ng-class="{\'bold\': filter.multiselectFilters.phase.length > 0, \'disabled\': isSelectMode}"\n              ng-disabled="isSelectMode">\n              <translate>Phase</translate>\n              <span class="caret"></span>\n            </span>\n            <ul class="dropdown-menu dropdown-menu-right"\n              aria-labelledby="dropdownPhase">\n              <li ng-repeat="phase in phases">\n                <a href ng-click="filter.operateMultiselectFilter(\'phase\', phase.value, isSelectMode)">\n                  <i class="fa fa-check" ng-if="filter.multiselectFilters.phase.indexOf(phase.value) > -1"></i>\n                  {{ phase.display_name | translate }}\n                </a>\n              </li>\n            </ul>\n          </span>\n          \x3c!-- dropdown sort --\x3e\n          <span uib-dropdown>\n            <span class="pointer" id="dropdownSort" uib-dropdown-toggle\n              ng-class="{\'disabled\': isSelectMode}"\n              ng-disabled="isSelectMode">\n              <translate>Sort</translate>\n              <span class="caret"></span>\n            </span>\n            <ul class="dropdown-menu dropdown-menu-right" aria-labelledby="dropdownSort">\n              \x3c!-- all sortOptions --\x3e\n              <li ng-repeat="option in sortOptions">\n                <a ng-click="sort.toggle(option.name)">\n                  <span ng-style="{\'font-weight\': sort.column === option.name ? \'bold\' : \'normal\'}">\n                    {{ option.display_name | translate }}\n                  </span>\n                  <span class="spacer-right pull-right"></span>\n                  <i class="pull-right fa"\n                    ng-style="{\'visibility\': sort.column === option.name ? \'visible\' : \'hidden\'}"\n                    ng-class="sort.reverse ? \'fa-sort-amount-desc\' : \'fa-sort-amount-asc\'">\n                  </i>\n                </a>\n              </li>\n            </ul>\n          </span>\n          \x3c!-- search field --\x3e\n          <span class="form-group">\n            <span class="input-group">\n              <span class="input-group-addon"><i class="fa fa-search"></i></span>\n              <input type="text" ng-model="filter.filterString" class="form-control"\n                 placeholder="{{ \'Search\' | translate}}" ng-disable="isSelectMode"\n                 ng-change="filter.save()">\n            </span>\n          </span>\n\n        </span>\n          \x3c!-- show all selected multiselectoptions --\x3e\n          <span ng-repeat="tag in tags" class="pointer spacer-left-lg"\n            ng-if="filter.multiselectFilters.tag.indexOf(tag.id) > -1"\n            ng-click="filter.operateMultiselectFilter(\'tag\', tag.id, isSelectMode)"\n            ng-class="{\'disabled\': isSelectMode}">\n            <span class="nobr">\n              <i class="fa fa-times-circle"></i>\n              {{ tag.name }}\n            </span>\n          </span>\n          <span ng-if="filter.multiselectFilters.tag.indexOf(-1) > -1" class="pointer spacer-left-lg"\n            ng-click="filter.operateMultiselectFilter(\'tag\', -1, isSelectMode)"\n            ng-class="{\'disabled\': isSelectMode}">\n            <i class="fa fa-times-circle"></i>\n            <translate>No tag set</translate>\n          </span>\n          <span ng-repeat="phase in phases" class="pointer spacer-left-lg"\n            ng-if="filter.multiselectFilters.phase.indexOf(phase.value) > -1"\n            ng-click="filter.operateMultiselectFilter(\'phase\', phase.value, isSelectMode)"\n            ng-class="{\'disabled\': isSelectMode}">\n            <span class="nobr">\n              <i class="fa fa-times-circle"></i>\n              {{ phase.display_name | translate }}\n            </span>\n          </span>\n        <span>\n        </span>\n\n      </div>\n    </div>\n\n    \x3c!-- main table --\x3e\n    <div class="row data-row" ng-mouseover="assignment.hover=true"\n      ng-mouseleave="assignment.hover=false"\n      ng-class="{\'projected\': assignment.isProjected().length,\n        \'related-projected\': assignment.isRelatedProjected().length}"\n      ng-repeat="assignment in assignmentsFiltered = (assignments\n        | osFilter: filter.filterString : filter.getObjectQueryString\n        | MultiselectFilter: filter.multiselectFilters.tag : getItemId.tag\n        | MultiselectFilter: filter.multiselectFilters.phase : getItemId.phase\n        | orderByEmptyLast: sort.column : sort.reverse)\n        | limitTo : pagination.itemsPerPage : pagination.limitBegin">\n\n      \x3c!-- select column --\x3e\n      <div ng-show="isSelectMode" os-perms="assignments.can_manage" class="col-xs-1 centered">\n        <i class="fa text-danger pointer" ng-click="assignment.selected=!assignment.selected"\n        ng-class="assignment.selected ? \'fa-check-square-o\' : \'fa-square-o\'"></i>\n      </div>\n\n      \x3c!-- projector column --\x3e\n      <div class="col-xs-1 centered projector" os-perms="core.can_manage_projector">\n        <projector-button model="assignment", default-projector-id="defaultProjectorId">\n        </projector-button>\n      </div>\n      <div class="no-projector-spacer" os-perms="!core.can_manage_projector"></div>\n\n      \x3c!-- main content column --\x3e\n      <div class="col-xs-6 content">\n        <div class="title-col">\n          \x3c!-- title and phase --\x3e\n          <div>\n            <a class="title" ui-sref="assignments.assignment.detail({id: assignment.id})">\n              {{ assignment.title }}\n            </a>\n            <span style="padding: 5px;" ng-mouseover="assignment.phaseHover=true" ng-mouseleave="assignment.phaseHover=false">\n              <span class="label" ng-class="{\'label-primary\': assignment.phase == 0,\n                                             \'label-warning\': assignment.phase == 1,\n                                             \'label-success\': assignment.phase == 2 }">\n                {{ phases[assignment.phase].display_name | translate }}\n              </span>\n              <span os-perms="assignments.can_manage" ng-class="{\'hiddenDiv\': !assignment.phaseHover}" uib-dropdown>\n                <i class="fa fa-cog pointer" uib-dropdown-toggle id="phaseDropdown{{ assignment.id }}"></i>\n                <ul uib-dropdown-menu aria-labelledby="phaseDropdown{{ assignment.id }}"\n                  class="dropdown-menu">\n                  <li ng-repeat="phase in phases">\n                    <a href>\n                      <i class="fa fa-check" ng-if="assignment.phase == phase.value"></i>\n                      <span class="pointer" ng-click="updatePhase(assignment, phase.value)">{{ phase.display_name | translate }}</a>\n                    </a>\n                  </li>\n                </ul>\n              </span>\n            </span>\n          </div>\n          \x3c!-- hover menu --\x3e\n          <div os-perms="assignments.can_manage" ng-class="{\'hiddenDiv\': !assignment.hover}">\n            <small>\n              <a href="" ng-click="openDialog(assignment)" translate>Edit</a> &middot;\n              <a href="" class="text-danger"\n                ng-bootbox-confirm="{{ \'Are you sure you want to delete this entry?\' | translate }}<br>\n                <b>{{ assignment.title }}</b>"\n                ng-bootbox-confirm-action="delete(assignment)" translate>Delete</a>\n            </small>\n          </div>\n        </div>\n      </div>\n\n      \x3c!-- additional content column --\x3e\n      <div class="col-xs-4 content" ng-style="{\'width\': isSelectMode ? \'calc(50% - 120px)\' : \'calc(50% - 70px)\'}">\n        <div style="width: 60%;" class="optional">\n          <small>\n            \x3c!-- Tag dropdown for manage user --\x3e\n            <div os-perms="assignments.can_manage" ng-show="tags.length > 0"\n                ng-mouseover="assignment.tagHover=true"\n                ng-mouseleave="assignment.tagHover=false">\n              <span uib-dropdown>\n                <span id="dropdownTags{{ assignment.id }}" class="pointer"\n                  uib-dropdown-toggle uib-tooltip="{{ \'Add a tag\' | translate }}"\n                  tooltip-class="nobr">\n                  <span ng-if="assignment.tags.length == 0" ng-show="assignment.hover">\n                    <i class="fa fa-tags"></i>\n                    <i class="fa fa-plus"></i>\n                  </span>\n                  <span ng-if="assignment.tags.length > 0">\n                    <i class="fa fa-tags"></i>\n                    <span ng-repeat="tag in assignment.tags">\n                      {{ tag.name }}<span ng-if="!$last">,</span>\n                    </span>\n                    <i class="fa fa-cog fa-lg spacer-left" ng-show="assignment.tagHover"></i>\n                  </span>\n                </span>\n                <ul class="dropdown-menu" aria-labelledby="dropdownTags{{ assignment.id }}">\n                  <li ng-repeat="tag in tags">\n                    <a href ng-click="toggleTag(assignment, tag)">\n                      <i class="fa fa-check" ng-if="hasTag(assignment, tag)"></i>\n                      {{ tag.name }}\n                    </a>\n                  </li>\n                </ul>\n              </span>\n            </div>\n            \x3c!-- Tag string for normal user --\x3e\n            <div os-perms="!assignments.can_manage" ng-show="assignment.tags.length > 0">\n              <i class="fa fa-tags spacer-right"></i>\n              <span ng-repeat="tag in assignment.tags">\n                {{ tag.name }}<span ng-if="!$last">,</span>\n              </span>\n            </div>\n            <template-hook hook-name="assignmentListAdditionalContentColumn"></template-hook>\n          </small>\n        </div>\n\n        <div style="width: 20%;" class="pull-right nobr optional centered">\n          <span class="badge"\n            uib-tooltip="{{ assignment.assignment_related_users.length }} {{ \'Candidates\' | translate }}"\n            tooltip-class="nobr"\n            ng-class="{\'badge-info\': assignment.assignment_related_users.length < assignment.open_posts}">\n            {{ assignment.assignment_related_users.length }}\n          </span>\n        </div>\n        <div style="width: 20%;" class="pull-right nobr">\n          <div class="centered">{{ assignment.agenda_item.getItemNumberWithAncestors() }}</div>\n        </div>\n      </div>\n    </div> \x3c!-- main table --\x3e\n\n    <ul uib-pagination\n        ng-show="assignmentsFiltered.length > pagination.itemsPerPage"\n        total-items="assignmentsFiltered.length"\n        items-per-page="pagination.itemsPerPage"\n        ng-model="pagination.currentPage"\n        ng-change="pagination.pageChanged()"\n        class="pagination-sm"\n        direction-links="false"\n        boundary-links="true"\n        first-text="&laquo;"\n        last-text="&raquo;">\n    </ul>\n\n  </div> \x3c!-- end container --\x3e\n</div>\n'),n.put("assignments/static/templates/assignments/assignmentpoll-form.html",'<h1><translate>Ballot</translate> {{ ballot }}</h1>\n\n<div uib-alert ng-show="alert.show" ng-class="\'alert-\' + (alert.type || \'warning\')" ng-click="alert={}" close="alert={}">\n  {{ alert.msg }}\n</div>\n\n<p>\n  <translate>Special values</translate>:\n  <span class="badge badge-success">-1</span> = <translate>majority</translate>\n  <span class="badge">-2</span> = <translate>undocumented</translate>\n\n<form name="assignmentPollForm" ng-submit="save(model)">\n  <formly-form model="model" fields="formFields">\n    <template-hook hook-name="assignmentPollFormButtons"></template-hook>\n    <button type="submit" ng-disabled="assignmentPollForm.$invalid" class="btn btn-primary" translate>\n      Save\n    </button>\n    <button ng-click="closeThisDialog()" class="btn btn-default" translate>\n      Cancel\n    </button>\n  </formly-form>\n</form>\n'),n.put("assignments/static/templates/assignments/slide_assignment.html",'<div ng-controller="SlideAssignmentCtrl" class="content scrollcontent">\n\n  \x3c!-- Title --\x3e\n  <div id="title">\n    <h1>{{ assignment.agenda_item.getTitle() || assignment.title }}</h1>\n    <h2>\n      <translate>Election</translate>\n    </h2>\n  </div>\n\n  \x3c!-- Description --\x3e\n  <div ng-if="!showResult && assignment.description !== \'\'"\n    ng-bind-html="assignment.description | trusted"\n    class="zoomcontent clearfix">\n  </div>\n\n  \x3c!-- Candidates --\x3e\n  <div class="zoomcontent" ng-if="!showResult">\n    <h3 translate>Candidates</h3>\n    <ul>\n      <li ng-repeat="related_user in assignment.assignment_related_users | orderBy:\'weight\'">\n        {{ related_user.user.get_full_name() }}\n        <i ng-if="related_user.elected" class="fa fa-star" title="{{ \'is elected\' | translate }}"></i>\n    </ul>\n  </div>\n\n  \x3c!-- vote results --\x3e\n  <div class="zoomcontent" ng-show="showResult">\n    <div ng-if="(assignment.polls | filter: {id: element.poll}).length == 0" translate>\n        Waiting for results ...\n    </div>\n\n    <div ng-repeat="poll in assignment.polls | filter: {id: element.poll}" class="electionresults spacer">\n      <table class="table table-bordered table-striped minimumTable">\n      <tr>\n        <th translate>Candidates\n        <th ng-if="poll.has_votes" class="col-sm-5" translate>Votes</th>\n\n      \x3c!-- candidates (poll options) --\x3e\n      <tr ng-repeat="option in poll.options | orderBy:\'weight\'">\n\n        \x3c!-- candidate name --\x3e\n        <td class="bold">\n          <i ng-if="option.is_elected" class="fa fa-star" title="{{ \'is elected\' | translate }}"></i>\n          {{ option.candidate.get_full_name() }}\n\n        \x3c!-- votes --\x3e\n        <td ng-if="poll.has_votes" class="bold">\n          <div ng-init="votes = option.getVotes()">\n            <div ng-show="poll.pollmethod == \'yna\' || poll.pollmethod == \'yn\'">\n              <span ng-show="poll.pollmethod == \'yna\'">\n                {{ votes[0].label | translate }}: {{ votes[0].value | number:votesPrecision }} {{ votes[0].percentStr }}<br>\n                {{ votes[1].label | translate }}: {{ votes[1].value | number:votesPrecision }} {{ votes[1].percentStr }}<br>\n                {{ votes[2].label | translate }}: {{ votes[2].value | number:votesPrecision }} {{ votes[2].percentStr }}</span>\n              <span ng-show="poll.pollmethod == \'yn\'">\n                {{ votes[0].label | translate }}: {{ votes[0].value | number:votesPrecision }} {{ votes[0].percentStr }}<br>\n                {{ votes[1].label | translate }}: {{ votes[1].value | number:votesPrecision }} {{ votes[1].percentStr }}</span>\n            </div>\n            <div ng-show="poll.pollmethod == \'votes\'">\n              <div ng-repeat="vote in votes">\n                {{ vote.value | number:votesPrecision }} {{ vote.percentStr }}\n                <div style="float:right; width:200px;" ng-if="vote.percentNumber >= 0">\n                  <uib-progressbar value="vote.percentNumber" type="success"></uib-progressbar>\n                </div>\n              </div>\n            </div>\n          </div>\n\n      \x3c!-- total votes (abstain/no/valid/invalid/casts) --\x3e\n      <tr class="total" ng-if="poll.has_votes && poll.pollmethod === \'votes\' && poll.getVote(\'votesabstain\').value !== null">\n        <td>\n          <translate>Abstain</translate>\n        <td ng-init="vote = poll.getVote(\'votesabstain\')">\n          {{ vote.value | number:votesPrecision }} {{ vote.percentStr }}\n      <tr class="total" ng-if="poll.has_votes && poll.pollmethod === \'votes\' && poll.getVote(\'votesno\').value !== null">\n        <td>\n          <translate>No</translate>\n        <td ng-init="vote = poll.getVote(\'votesno\')">\n          {{ vote.value | number:votesPrecision }} {{ vote.percentStr }}\n      <tr class="total" ng-if="poll.has_votes && poll.getVote(\'votesvalid\').value !== null">\n        <td>\n          <translate>Valid ballots</translate>\n        <td ng-init="vote = poll.getVote(\'votesvalid\')">\n          {{ vote.value | number:votesPrecision }} {{ vote.percentStr }}\n\n      <tr class="total" ng-if="poll.has_votes && poll.getVote(\'votesinvalid\').value !== null">\n        <td>\n          <translate>Invalid ballots</translate>\n        <td ng-init="vote = poll.getVote(\'votesinvalid\')">\n          {{ vote.value | number:votesPrecision }} {{ vote.percentStr }}\n\n      <tr class="total bg-info" ng-if="poll.has_votes && poll.getVote(\'votescast\').value !== null">\n        <td>\n          <translate>Casted ballots</translate>\n        <td ng-init="vote = poll.getVote(\'votescast\')">\n          {{ vote.value | number:votesPrecision }} {{ vote.percentStr }}\n      </table>\n    </div>\n\n  </div>\n</div>\n'),n.put("core/static/templates/core/checkbox-buttons.html",'<div class="form-group">\n  <div>\n    <label class="control-label" ng-if="to.label">\n      {{ to.label }}\n    </label>\n  </div>\n  <div class="btn-group">\n    <label ng-repeat="option in to.options" class="btn btn-default btn-sm" uib-btn-checkbox\n      ng-model="model[options.key][option.id]"\n      ng-disabled="option.disabled">\n        {{ option.name | translate }}\n    </label>\n  </div>\n</div>\n'),n.put("core/static/templates/core/checkbox.html","<div class=\"checkbox\">\n  <label ng-click=\"model[options.key] = !model[options.key]\">\n    <i class=\"fa\" ng-class=\"model[options.key] ? 'fa-check-square-o' : 'fa-square-o'\"></i>\n    {{to.label}}\n    {{to.required ? '*' : ''}}\n  </label>\n</div>\n"),n.put("core/static/templates/core/countdown-detail.html",'<div id="countdownWrapper">\n  <div>\n    <div id="countdown" ng-class="{\n        \'negative\': countdown.seconds <= 0,\n        \'warning_time\': countdown.seconds <= config(\'agenda_countdown_warning_time\') && countdown.seconds > 0 }">\n      <div class="row">\n        <div class="col-d-12">{{ countdown.seconds | osSecondsToTime}}</div>\n      </div>\n      <div class="row">\n        <div class="col-md-12 description">\n          <span class="pull-right">{{ countdown.description }}</span>\n        </div>\n      </div>\n    </div>\n  </div>\n</div>\n'),n.put("core/static/templates/core/editor.html",'\x3c!-- custom angular formly template for ckeditor textarea field --\x3e\n<textarea ckeditor="options.data.ckeditorOptions" ng-model="model[options.key]" class="form-control"></textarea>'),n.put("core/static/templates/core/file.html",'\x3c!-- custom angular formly template for uploading a file --\x3e\n<input type="file" ngf-select ngf-change="to.change(model, $files, $event, $rejectedFiles)" class="form-control">\n'),n.put("core/static/templates/core/login-form.html",'<form ng-submit="login()">\n  <div class="modal-header">\n    <img src="/static/img/openslides-logo.png" alt="OpenSlides" class="login-logo center-block">\n  </div>\n  <div class="modal-body loginForm">\n    <div uib-alert ng-repeat="alert in alerts" ng-class="\'alert-\' + (alert.type || \'warning\')" close="closeAlert($index)">\n      <span ng-bind-html="alert.msg | translate"><span>\n    </div>\n    <div class="input-group form-group">\n      <div class="input-group-addon"><i class="fa fa-user"></i></div>\n      <input os-focus-me type="text" ng-model="username" class="form-control input-lg"\n          placeholder="{{ \'Username\' | translate }}">\n    </div>\n    <div class="input-group form-group">\n      <div class="input-group-addon"><i class="fa fa-key"></i></div>\n      <input type="password" ng-model="password" class="form-control input-lg"\n          placeholder="{{ \'Password\' | translate }}">\n    </div>\n    <div class="form-group">\n      <button type="submit" class="btn btn-primary" translate>\n        Login\n      </button>\n      <button ng-if="guestAllowed" ng-click="guestLogin()" class="btn btn-default" translate>\n        Continue as guest\n      </button>\n      <template-hook hook-name="loginFormButtons"></template-hook>\n    </div>\n    <a href="" ng-click="openPrivacyPolicyDialog()" translate>Privacy policy</a>\n  </div>\n</form>\n'),
n.put("core/static/templates/core/manage-projectors.html",'<div class="header">\n  <div class="title">\n    <div class="submenu" os-perms="core.can_manage_projector">\n      \x3c!-- New --\x3e\n      <button class="btn btn-primary btn-sm" ng-bootbox-prompt="{{ \'Please enter a name for the new projector\' | translate }}"\n        ng-bootbox-prompt-action="createProjector(result)">\n        <i class="fa fa-plus"></i>\n        <translate>New</translate>\n      </button>\n      \x3c!-- Reference for current list of speakers --\x3e\n      <div class="btn-group" uib-dropdown>\n        <button class="btn btn-default btn-sm" id="menuListofSpeakers" uib-dropdown-toggle\n            uib-tooltip="{{ \'Select the projector to which the current list of speakers refers to.\' | translate }}"\n            aria-haspopup="true" aria-expanded="true">\n          <i class="fa fa-microphone"></i>\n          <translate>Reference for current list of speakers</translate>\n          <span class="caret"></span>\n        </button>\n        <ul class="dropdown-menu" uib-dropdown-menu aria-labelledby="menuListOfSpeakers">\n          <li ng-repeat="projector in projectors | orderBy:\'id\'">\n            <a href ng-click="setListOfSpeakers(projector)">\n              <i class="fa fa-check" ng-if="projector.id == currentListOfSpeakers"></i>\n              {{ projector.name | translate }}\n            </a>\n          </li>\n        </ul>\n      </div>\n      \x3c!-- Identity --\x3e\n      <button class="btn btn-sm" ng-click="identifyProjectors()" ng-class="identifyPromise ? \'btn-primary\' : \'btn-default\'"\n        uib-tooltip="{{ \'Display an identifier message on all projectors with the id and the name.\' | translate }}">\n        <i class="fa fa-binoculars"></i>\n        <translate>Identify</translate>\n      </button>\n    </div>\n    <h1 translate>Manage projectors</h1>\n  </div>\n</div>\n\n<div class="details" os-perms="core.can_manage_projector">\n    <div id="manage-projectors">\n\n    <div ng-repeat="projector in projectors | orderBy: \'id\'">\n      <div>\n        <a ui-sref="projector({id: projector.id})">\n          {{ projector.id }}:\n          <strong>{{ projector.name | translate }}</strong>\n        </a>\n        <span class="pull-right">\n          <a href="" ng-click="toggleEditMenu(projector.id)"><i class="fa" ng-class="edit[projector.id] ? \'fa-times\' : \'fa-pencil\'"></i></a>\n          <a href="" class="text-danger" style="padding-left: 5px;" \n            ng-hide="projector.id==1 || edit[projector.id]"\n            ng-bootbox-confirm="{{ \'Are you sure you want to delete this entry?\' | translate }}<br>\n            <b>{{ projector.name | translate }}</b>"\n            ng-bootbox-confirm-action="deleteProjector(projector)">\n            <i class="fa fa-trash"></i>\n          </a>\n        </span>\n      </div>\n\n      <div ng-show="edit[projector.id]" style="margin-bottom: -20px;">\n        <div class="form-group">\n          <label for="name{{ projector.id }}" class="control-label"><translate>Name</translate>:</label>\n          <input type="text" class="form-control" id="name{{ projector.id }}"\n            ng-model="projector.name" ng-change="editName(projector)"\n            ng-model-options="{debounce: 2000}"></input>\n        </div>\n\n        <div class="form-group">\n          <label for="menuProjector{{ projector.id }}" class="control-label"><translate>Projection defaults</translate>:</label>\n          <div class="dropdown" uib-dropdown>\n            <button class="btn btn-default btn-sm" id="menuProjector{{ projector.id }}" uib-dropdown-toggle>\n              --- <translate>Please select</translate> ---\n              <span class="caret"></span>\n            </button>\n            <ul class="dropdown-menu" uib-dropdown-menu aria-labelledby="menuProjector{{ projector.id }}">\n              <li ng-repeat="projectiondefault in projectiondefaults | orderBy:\'id\'">\n                <a href ng-click="setProjectionDefault(projector, projectiondefault)">\n                  <i class="fa fa-check" ng-if="projectiondefault.projector_id === projector.id"></i>\n                  {{ projectiondefault.display_name | translate }}\n                </a>\n              </li>\n            </ul>\n          </div>\n        </div>\n\n        <div class="form-group">\n          <label for="aspectRatio{{ projector.id }}" class="control-label"><translate>Aspect ratio</translate>:</label>\n          <div id="aspectRatio{{ projector.id }}">\n          <div class="dropdown" uib-dropdown>\n            <button class="btn btn-default btn-sm" uib-dropdown-toggle>\n              {{ resolutions[projector.id].aspectRatio }}\n              <span class="caret"></span>\n            </button>\n            <ul class="dropdown-menu" uib-dropdown-menu aria-labelledby="aspectRatio{{ projector.id }}">\n              <li ng-repeat="(aspectRatio, value) in aspectRatios track by $index">\n                <a href ng-click="setAspectRatio(projector, aspectRatio); saveResolution(projector);">\n                  <i class="fa fa-check" ng-if="aspectRatio === resolutions[projector.id].aspectRatio"></i>\n                  {{ aspectRatio }}\n                </a>\n              </li>\n            </ul>\n          </div>\n          </div>\n        </div>\n\n        <div class="form-group">\n          <label for="resolution{{ projector.id }}" class="control-label"><translate>Scaling</translate>:</label>\n          <div id="resolution{{ projector.id }}">\n              <rzslider class="os-slider"\n                rz-slider-model="sliders[projector.id].value"\n                rz-slider-options="sliders[projector.id].options"></rzslider>\n          </div>\n          <p class="help-block">\n            {{ resolutions[projector.id].error }}\n          </p>\n        </div>\n      </div>\n\n      <style>\n        #iframe_{{ projector.id }} {\n            width: {{ projector.width }}px;\n            height: {{ projector.height }}px;\n            -moz-transform: scale({{ projector.iframeScale }});\n            -webkit-transform: scale({{ projector.iframeScale }});\n            -o-transform: scale({{ projector.iframeScale }});\n            transform: scale({{ projector.iframeScale }});\n            /* IE8+ - must be on one line, unfortunately */\n            -ms-filter: "progid:DXImageTransform.Microsoft.Matrix(M11={{ projector.iframeScale }}, M12=0, M21=0, M22={{ projector.iframeScale }}, SizingMethod=\'auto expand\')";\n        }\n\n        #iframewrapper_{{ projector.id }} {\n            height: {{ projector.iframeHeight + 2 }}px;\n        }\n\n        #iframeoverlay_{{ projector.id }} {\n          height: {{ projector.iframeHeight }}px;\n        }\n      </style>\n\n      <a ui-sref="projector({id: projector.id})" target="_blank">\n        <div class="iframewrapper" id="iframewrapper_{{ projector.id }}">\n          <iframe class="iframe" id="iframe_{{ projector.id }}" ng-src="{{ \'/real-projector/\' + projector.id + \'/\' }}" frameborder="0"></iframe>\n          <div class="iframeoverlay" id="iframeoverlay_{{ projector.id }}"></div>\n        </div>\n      </a>\n      \x3c!-- projector control buttons --\x3e\n      <div class="nobr">\n        \x3c!-- edit --\x3e\n        <a ng-click="editCurrentSlide(projector)"\n          ng-disabled="!projector.getFormOrStateForCurrentSlide()"\n          class="btn btn-default btn-sm"\n          title="{{ \'Edit current slide\' | translate}}">\n          <i class="fa fa-pencil"></i>\n        </a>\n\n        \x3c!-- scale --\x3e\n        <div class="btn-group">\n          <a ng-click="projector.controlProjector(\'scale\', \'down\')"\n              class="btn btn-default btn-sm"\n              title="{{ \'Smaller\' | translate}}">\n            <i class="fa fa-search-minus"></i>\n          </a>\n          <a ng-click="projector.controlProjector(\'scale\', \'up\')"\n              class="btn btn-default btn-sm"\n              title="{{ \'Bigger\' | translate}}">\n            <i class="fa fa-search-plus"></i>\n          </a>\n          <a ng-click="projector.controlProjector(\'scale\', \'reset\')"\n              class="btn btn-default btn-sm"\n              title="{{ \'Reset scaling\' | translate}}">\n            <i class="fa fa-undo"></i>\n          </a>\n        </div>\n        <span ng-class="{\'notNull\': projector.scale != 0}">{{ projector.scale }}</span>\n\n        \x3c!-- scroll --\x3e\n        <div class="btn-group">\n          <a ng-click="projector.controlProjector(\'scroll\', \'down\')"\n              class="btn btn-default btn-sm"\n              title="{{ \'Scroll up\' | translate}}">\n            <i class="fa fa-arrow-up"></i>\n          </a>\n          <a ng-click="projector.controlProjector(\'scroll\', \'up\')"\n              class="btn btn-default btn-sm"\n              title="{{ \'Scroll down\' | translate}}">\n            <i class="fa fa-arrow-down"></i>\n          </a>\n          <a ng-click="projector.controlProjector(\'scroll\', \'reset\')"\n              class="btn btn-default btn-sm"\n              title="{{ \'Reset scrolling\' | translate}}">\n            <i class="fa fa-undo"></i>\n          </a>\n        </div>\n        <span ng-class="{\'notNull\': projector.scroll != 0}">{{ projector.scroll }}</span>\n      </div>\n\n      \x3c!-- Default, BC, Blank --\x3e\n      <div class="middle">\n        <div class="btn-group">\n          <button class="btn btn-sm" ng-class="broadcast == projector.id ? \'btn-danger\' : \'btn-default\'"\n            ng-click="projector.toggleBroadcast(projector)"\n            ng-disabled="broadcast > 0 && broadcast != projector.id"\n            uib-tooltip="{{ \'Broadcast the content of this projector to all other projectors.\' | translate }}"\n            tooltip-placement="bottom">\n            <i class="fa fa-bullhorn"></i>\n            <translate>Broadcast</translate>\n          </button>\n          <button class="btn btn-sm" ng-class="projector.blank ? \'btn-danger\' : \'btn-default\'"\n            ng-click="projector.toggleBlank(projector)"\n            ng-disabled="broadcast > 0 && broadcast != projector.id">\n            <i class="fa" ng-class="projector.blank ? \'fa-square\' : \'fa-square-o\'"></i>\n            <translate>Blank</translate>\n          </button>\n        </div>\n      </div>\n\n    </div>\n  </div>\n</div>\n'),n.put("core/static/templates/core/password.html",'<input type="password" ng-model="model[options.key]" class="form-control">\n'),n.put("core/static/templates/core/projector-controls.html",'<div class="details">\n\n  <div ng-controller="ProjectorControlCtrl">\n    \x3c!-- live view --\x3e\n    <div class="section" os-perms="core.can_see_projector">\n      <a href="#" ng-click="isLiveViewClosed = !isLiveViewClosed">\n        <i class="fa toggle-icon" ng-class="isLiveViewClosed ? \'fa-angle-down\' : \'fa-angle-up\'"></i>\n        <h4 translate>Live view</h4>\n      </a>\n      <div uib-collapse="isLiveViewClosed" ng-cloak>\n        <style>\n          .col2 #iframe_sidebar {\n              width: {{ active_projector.width }}px;\n              height: {{ active_projector.height }}px;\n              -moz-transform: scale({{ scale }});\n              -webkit-transform: scale({{ scale }});\n              -o-transform: scale({{ scale }});\n              transform: scale({{ scale }});\n              /* IE8+ - must be on one line, unfortunately */\n              -ms-filter: "progid:DXImageTransform.Microsoft.Matrix(M11={{ scale }}, M12=0, M21=0, M22={{ scale }}, SizingMethod=\'auto expand\')";\n          }\n\n          .col2 #iframewrapper_sidebar {\n              height: {{ iframeHeight }}px;\n          }\n\n          .col2 #iframeoverlay_sidebar {\n            height: {{ iframeHeight }}px;\n          }\n        </style>\n        <div class="projectorSelector">\n          <div>\n            <div ng-show="projectors.length > 1" uib-dropdown>\n              <button class="btn btn-default btn-sm dropdown-toggle" id="menuProjector" data-toggle="dropdown"\n                aria-haspopup="true" aria-expanded="true">\n                {{ active_projector.name | translate }}\n                <span class="caret"></span>\n              </button>\n              <ul class="dropdown-menu dropdown-entries" aria-labelledby="menuProjector">\n                <li ng-repeat="projector in projectors | orderBy:\'id\'">\n                  <a href ng-class="{\'projected\': projector === active_projector}"\n                    ng-click="changeProjector(projector)">\n                    <i ng-show="projector === active_projector" class="fa fa-check"></i>\n                    {{ projector.name | translate }}\n                    <i ng-show="projector.id == broadcast" class="fa fa-star-o spacer-left"></i>\n                  </a>\n                </li>\n              </ul>\n            </div>\n            <div os-perms="core.can_manage_projector">\n              <button class="btn btn-sm" ng-click="active_projector.toggleBlank()" ng-hide="projectors.length > 1"\n                ng-class="active_projector.blank ? \'btn-danger\' : \'btn-default\'">\n                <i class="fa" ng-class="active_projector.blank ? \'fa-square\' : \'fa-square-o\'"></i>\n                <translate>Blank</translate>\n              </button>\n            </div>\n            <a os-perms="core.can_manage_projector" class="btn btn-primary btn-sm manageBtn" ui-sref="manage-projectors">\n              <i class="fa fa-cog fa-lg"></i>\n              <translate>Manage</translate>\n            </a>\n          </div>\n        </div>\n\n        <a ui-sref="projector({id: active_projector.id })" target="_blank">\n          <div class="iframewrapper" id="iframewrapper_sidebar">\n            <iframe class="iframe" id="iframe_sidebar" ng-src="{{ \'/real-projector/\' + active_projector.id + \'/\'}}" frameborder="0"></iframe>\n            <div class="iframeoverlay" id="iframeoverlay_sidebar"></div>\n          </div>\n        </a>\n        \x3c!-- projector control buttons --\x3e\n        <div os-perms="core.can_manage_projector" class="nobr">\n          \x3c!-- edit --\x3e\n          <a ng-click="editCurrentSlide(active_projector)"\n            ng-disabled="!active_projector.getFormOrStateForCurrentSlide()"\n            class="btn btn-default btn-sm"\n            title="{{ \'Edit current slide\' | translate}}">\n            <i class="fa fa-pencil"></i>\n          </a>\n\n          \x3c!-- scale --\x3e\n          <div class="btn-group">\n            <a ng-click="active_projector.controlProjector(\'scale\', \'down\')"\n                class="btn btn-default btn-sm"\n                title="{{ \'Smaller\' | translate}}">\n              <i class="fa fa-search-minus"></i>\n            </a>\n            <a ng-click="active_projector.controlProjector(\'scale\', \'up\')"\n                class="btn btn-default btn-sm"\n                title="{{ \'Bigger\' | translate}}">\n              <i class="fa fa-search-plus"></i>\n            </a>\n            <a ng-click="active_projector.controlProjector(\'scale\', \'reset\')"\n                class="btn btn-default btn-sm"\n                title="{{ \'Reset scaling\' | translate}}">\n              <i class="fa fa-undo"></i>\n            </a>\n          </div>\n          <span ng-class="{ \'notNull\': active_projector.scale != 0 }">{{ active_projector.scale }}</span>\n\n          \x3c!-- scroll --\x3e\n          <div class="btn-group">\n            <a ng-click="active_projector.controlProjector(\'scroll\', \'down\')"\n                class="btn btn-default btn-sm"\n                title="{{ \'Scroll up\' | translate}}">\n              <i class="fa fa-arrow-up"></i>\n            </a>\n            <a ng-click="active_projector.controlProjector(\'scroll\', \'up\')"\n                class="btn btn-default btn-sm"\n                title="{{ \'Scroll down\' | translate}}">\n              <i class="fa fa-arrow-down"></i>\n            </a>\n            <a ng-click="active_projector.controlProjector(\'scroll\', \'reset\')"\n                class="btn btn-default btn-sm"\n                title="{{ \'Reset scrolling\' | translate}}">\n              <i class="fa fa-undo"></i>\n            </a>\n          </div>\n          <span ng-class="{ \'notNull\': active_projector.scroll != 0 }">{{ active_projector.scroll }}</span>\n        </div>\n      </div>\n    </div>\n\n    \x3c!-- countdowns --\x3e\n    <div class="section" os-perms="core.can_manage_projector">\n      <a href="#" ng-click="isCountdowns = !isCountdowns">\n        <i class="fa toggle-icon" ng-class="isCountdowns ? \'fa-angle-up\' : \'fa-angle-down\'"></i>\n        <h4 translate>Countdowns</h4>\n      </a>\n      <div uib-collapse="!isCountdowns" ng-cloak>\n        <div ng-repeat="countdown in countdowns | orderBy: \'index\'" id="countdown{{countdown.id}}" class="countdown panel panel-default">\n          <div class="panel-heading">\n            <span ng-if="countdown.description">{{ countdown.description }}</span>\n            <span ng-if="!countdown.description">Countdown {{ $index +1 }}</span>\n            \x3c!-- remove countdown button --\x3e\n            <button type="button" class="close"\n                ng-click="removeCountdown(countdown)"\n                title="{{ \'Remove countdown\' | translate}}">\n                <i class="fa fa-times"></i>\n            </button>\n            \x3c!-- edit countdown button --\x3e\n            <button type="button" class="close icons"\n                ng-click="countdown.editFlag=true; countdown.new_description = countdown.description;"\n                title="{{ \'Edit countdown\' | translate}}">\n                <i class="fa fa-pencil"></i>\n            </button>\n            <a ui-sref="core.countdown.detail({id: countdown.id})" class="close icons" target="_blank"\n              uib-tooltip="{{ \'Open countdown in fullscreen\' | translate }}">\n              <i class="fa fa-arrows-alt"></i>\n            </a>\n          </div>\n          <div class="panel-body"\n            ng-class="{ \'projected\': isProjected(countdown).length }">\n            <projector-button model="countdown" default-projector-id="countdownDefaultProjectorId"></projector-button>\n            &nbsp;&nbsp;\n            \x3c!-- countdown controls --\x3e\n            <a class="btn btn-default vcenter"\n                ng-click="countdown.reset()"\n                ng-class="{ \'disabled\': !countdown.running && countdown.default_time == countdown.countdown_time }"\n                title="{{ \'Reset countdown\' | translate}}">\n              <i class="fa fa-stop"></i>\n            </a>\n            <a ng-if="!countdown.running" class="btn btn-default vcenter"\n                ng-click="countdown.start()"\n                title="{{ \'Start\' | translate}}">\n              <i  class="fa fa-play"></i>\n              <i ng-if="countdown.running" class="fa fa-pause"></i>\n            </a>\n            <a ng-if="countdown.running" class="btn btn-default vcenter"\n                ng-click="countdown.stop()"\n                title="{{ \'Pause\' | translate}}">\n              <i  class="fa fa-pause"></i>\n            </a>\n            <span ng-if="!countdown.editTime" class="countdown_timer vcenter"\n                  ng-class="{\n                    \'negative\': countdown.seconds <= 0,\n                    \'warning_time\': countdown.seconds <= config(\'agenda_countdown_warning_time\') && countdown.seconds > 0 }">\n                {{ countdown.seconds | osSecondsToTime }}\n            </span>\n            \x3c!-- edit countdown form --\x3e\n            <form ng-show="countdown.editFlag"\n              ng-submit="editCountdown(countdown)">\n              <div class="form-group">\n                <label translate>Description</label>\n                <input ng-model="countdown.new_description" type="text" class="form-control input-sm">\n              </div>\n              <div class="form-group">\n                <label translate>Start time</label>\n                <div class="input-group">\n                  <input data-ng-model="countdown.default_time" min-sec-format\n                    type="text" placeholder="mm:ss" class="form-control input-sm">\n                </div>\n              </div>\n              <button type="submit" title="{{ \'Save\' | translate}}"\n                  class="btn btn-sm btn-primary">\n                <i class="fa fa-check"></i>\n              </button>\n              <button ng-click="countdown.editFlag=false;"\n                  title="{{ \'Cancel\' | translate}}"\n                  class="btn btn-default btn-sm">\n                <i class="fa fa-times"></i>\n              </button>\n            </form>\n          </div>\n        </div>\n        \x3c!-- Add countdown button --\x3e\n        <a ng-click="addCountdown()"\n            class="btn btn-default btn-sm"\n            title="{{ \'Add countdown\' | translate}}">\n          <i class="fa fa-plus"></i> <translate>Add new countdown</translate>\n        </a>\n      </div>\n    </div>\n\n    \x3c!-- messages --\x3e\n    <div class="section" os-perms="core.can_manage_projector">\n      <a href="#" ng-click="isMessages = !isMessages">\n        <i class="fa toggle-icon" ng-class="isMessages ? \'fa-angle-up\' : \'fa-angle-down\'"></i>\n        <h4 translate>Messages</h4>\n      </a>\n      <div uib-collapse="!isMessages" ng-cloak>\n        <div ng-repeat="message in messages" id="message{{message.id}}" class="message panel panel-default">\n\n          <div class="panel-heading">\n              <span>{{ \'Message\' | translate }} {{ $index + 1 }}</span>\n            \x3c!-- remove message button --\x3e\n            <button type="button" class="close"\n              ng-click="removeMessage(message)"\n              title="{{ \'Remove message\' | translate}}">\n              <i class="fa fa-times"></i>\n            </button>\n            <button type="button" class="close editicon"\n              ng-click="editMessage(message)"\n              title="{{ \'Edit message\' | translate}}">\n              <i class="fa fa-pencil"></i>\n            </button>\n          </div>\n\n          <div class="panel-body"\n              ng-class="{ \'projected\': isProjected(message).length }">\n            <projector-button model="message" default-projector-id="messageDefaultProjectorId"></projector-button>\n            &nbsp;&nbsp;\n            <div class="innermessage" ng-bind-html="message.message | trusted"></div>\n          </div>\n        </div>\n        \x3c!-- Add message button --\x3e\n        <a ng-click="addMessage()"\n            class="btn btn-default btn-sm"\n            title="{{ \'Add message\' | translate}}">\n          <i class="fa fa-plus"></i> <translate>Add new message</translate>\n        </a>\n      </div>\n    </div>\n    \x3c!-- list of speakers overlay --\x3e\n    <div class="section" os-perms="core.can_manage_projector">\n      <a href="#" ng-click="isSpeakerList = !isSpeakerList">\n        <i class="fa toggle-icon" ng-class="isSpeakerList ? \'fa-angle-up\' : \'fa-angle-down\'"></i>\n        <h4 translate>List of speakers</h4>\n      </a>\n      <div uib-collapse="!isSpeakerList" ng-cloak>\n\n        \x3c!-- Current list of speakers projector button --\x3e\n        <div class="btn-group button" uib-dropdown\n          uib-tooltip="{{ \'Project the current list of speakers\' | translate }}"\n          os-perms="core.can_manage_projector">\n          <button type="button" class="btn btn-default btn-sm"\n              ng-click="currentListOfSpeakers.project(listOfSpeakersDefaultProjectorId, currentListOfSpeakersAsOverlay)"\n              ng-class="{ \'btn-primary\': currentListOfSpeakers.isProjected().length && inArray(currentListOfSpeakers.isProjected(), listOfSpeakersDefaultProjectorId)}">\n            <i class="fa fa-video-camera"></i>\n            <translate>Current list of speakers</translate>\n          </button>\n          <button type="button" class="btn btn-default btn-sm slimDropDown"\n            ng-if="projectors.length > 1"\n            uib-dropdown-toggle\n            ng-class="{ \'btn-primary\': currentListOfSpeakers.isProjected().length && !inArray(currentListOfSpeakers.isProjected(), listOfSpeakersDefaultProjectorId)}">\n            <span class="caret"></span>\n          </button>\n          <ul class="dropdown-menu" role="menu" aria-labelledby="split-button" ng-if="projectors.length > 1">\n            <li role="menuitem">\n              <a href="" ng-click="setOverlay(false); $event.stopPropagation();">\n                <i class="fa" ng-class="currentListOfSpeakersAsOverlay ? \'fa-circle-o\' : \'fa-check-circle-o\'"></i>\n                <translate>Project as slide</translate>\n              </a>\n            </li>\n            <li role="menuitem">\n              <a href="" ng-click="setOverlay(true); $event.stopPropagation();">\n                <i class="fa" ng-class="currentListOfSpeakersAsOverlay ? \'fa-check-circle-o\' : \'fa-circle-o\'"></i>\n                <translate>Project as overlay</translate>\n              </a>\n            </li>\n            <li class="divider"></li>\n            <li role="menuitem" ng-repeat="projector in projectors | orderBy:\'id\'">\n              <a href="" ng-click="currentListOfSpeakers.project(projector.id, currentListOfSpeakersAsOverlay)"\n                ng-class="{ \'projected\': inArray(currentListOfSpeakers.isProjected(), projector.id) }">\n                <i class="fa fa-video-camera" ng-show="inArray(currentListOfSpeakers.isProjected(), projector.id)"></i>\n                {{ projector.name | translate }}\n                <span ng-if="projector.id == listOfSpeakersDefaultProjectorId">(<translate>Default</translate>)</span>\n              </a>\n            </li>\n          </ul>\n        </div>\n\n        <button os-perms="agenda.can_manage"\n          ng-disabled="!currentListOfSpeakersItem()"\n          ng-click="goToListOfSpeakers()" class="btn btn-default btn-sm"\n          uib-tooltip="{{ \'Manage the current list of speakers\' | translate}}">\n          <i class="fa fa-microphone"></i>\n        </button>\n      </div>\n    </div>\n  </div>\x3c!-- end div ProjectorControlCtrl --\x3e\n\n</div>\n'),n.put("core/static/templates/core/projector-message-form.html",'<h1 translate>Edit message</h1>\n\n<form name="messageForm" ng-submit="save(model)" novalidate>\n  <formly-form model="model" fields="formFields">\n    <button type="submit" ng-disabled="motionForm.$invalid" class="btn btn-primary" translate>\n      Save\n    </button>\n    <button type="button" ng-click="closeThisDialog()" class="btn btn-default" translate>\n      Cancel\n    </button>\n  </formly-form>\n</form>\n'),n.put("core/static/templates/core/radio-buttons.html",'<div class="form-group">\n  <div ng-if="to.label">\n    <label class="control-label">\n      {{ to.label | translate }}\n    </label>\n  </div>\n  <div class="btn-group">\n    <label ng-repeat="option in to.options" class="btn btn-default btn-sm"\n      ng-class="{active: (model[options.key] === option.value)}"\n      ng-disabled="option.disabled">\n      <input type="radio" ng-value="option.value"\n        ng-model="model[options.key]" ng-checked="model[options.key] === option.value"\n        ng-disabled="option.disabled" ng-change="to.change(option.value)">\n        {{ option.name | translate }}\n    </label>\n  </div>\n</div>\n'),n.put("core/static/templates/core/select-multiple.html",'\x3c!-- custom angular formly template for angular-chosen multiple form field --\x3e\n<select multiple chosen\n    data-ng-model="model[options.key]"\n    ng-required="{{ to.required }}"\n    ng-options="{{ to.ngOptions }}"\n    search-contains="true"\n    placeholder-text-multiple="\'{{ to.placeholder }}\'"\n    no-results-text="\'No results available ...\' | translate"\n    class="form-control">\n</select>\n'),n.put("core/static/templates/core/select-single.html",'\x3c!-- custom angular formly template for angular-chosen single form field --\x3e\n<select chosen\n    data-ng-model="model[options.key]"\n    ng-required="{{ to.required }}"\n    ng-options="{{ to.ngOptions }}"\n    allow-single-deselect="true"\n    search-contains="true"\n    placeholder-text-single="\'{{ to.placeholder }}\'"\n    no-results-text="\'No results available ...\' | translate"\n    class="form-control">\n  <option value=""></option>\n</select>\n'),n.put("core/static/templates/core/slide_clock.html",'<div ng-controller="SlideClockCtrl" id="currentTime">\n  <i class="fa fa-clock-o"></i>\n  {{ servertime | date:\'HH:mm\' }}\n</div>\n'),n.put("core/static/templates/core/slide_countdown.html",'<div ng-controller="SlideCountdownCtrl">\n  <div class="countdown well pull-right"\n      ng-class="{\n        \'negative\': countdown.seconds <= 0,\n        \'warning_time\': countdown.seconds <= config(\'agenda_countdown_warning_time\') && countdown.seconds > 0 }">\n    {{ countdown.seconds | osSecondsToTime}}\n    <div class="description">{{ countdown.description }}</div>\n  </div>\n</div>\n'),n.put("core/static/templates/core/slide_message.html",'<div ng-controller="SlideMessageCtrl">\n  <div class="message_background"></div>\n  <div class="message well" ng-class="{\'identify\': element.identify}" ng-bind-html="(element.identify ? identifyMessage : message.message) | trusted"></div>\n</div>\n'),n.put("core/static/templates/core/tag-form.html",'<h1 ng-if="model.id" translate>Edit tag</h1>\n<h1 ng-if="!model.id" translate>New tag</h1>\n\n<div uib-alert ng-show="alert.show" ng-class="\'alert-\' + (alert.type || \'warning\')" close="alert={}">\n  {{ alert.msg }}\n</div>\n\n<form name="userForm" ng-submit="save(model)">\n  <formly-form model="model" fields="formFields">\n    <button type="submit" ng-disabled="userForm.$invalid" class="btn btn-primary" translate>\n      Save\n    </button>\n    <button ng-click="closeThisDialog()" class="btn btn-default" translate>\n      Cancel\n    </button>\n  </formly-form>\n</form>\n'),
n.put("core/static/templates/core/tag-list.html",'<div class="header">\n  <div class="title">\n    <div class="submenu">\n      <a href="javascript:history.back()" class="btn btn-sm btn-default">\n        <i class="fa fa-angle-double-left fa-lg"></i>\n        <translate>Back to overview</translate>\n      </a>\n      <a href="" ng-click="editOrCreate()" os-perms="core.can_manage_tags" class="btn btn-primary btn-sm">\n        <i class="fa fa-plus fa-lg"></i>\n        <translate>New</translate>\n      </a>\n    </div>\n    <h1 translate>Tags</h1>\n  </div>\n</div>\n\n<div class="details">\n  <div class="row form-group">\n    <div class="col-sm-8">\n      <div uib-alert ng-show="alert.show" ng-class="\'alert-\' + (alert.type || \'warning\')" close="alert={}">\n        {{ alert.msg }}\n      </div>\n    </div>\n    <div class="col-sm-4">\n      <input type="text" ng-model="filter.search" class="form-control"\n          placeholder="{{ \'Filter\' | translate}}">\n    </div>\n  </div>\n\n  <table os-perms="core.can_manage_tags" class="table table-striped table-bordered table-hover">\n    <thead>\n      <tr>\n        <th ng-click="toggleSort(\'name\')" class="sortable">\n          <translate>Name</translate>\n          <i class="pull-right fa" ng-show="sortColumn === \'name\' && header.sortable != false"\n              ng-class="reverse ? \'fa-sort-desc\' : \'fa-sort-asc\'">\n          </i>\n    <tbody>\n      <tr ng-repeat="tag in tags | filter: filter.search |\n          orderBy: sortColumn:reverse">\n        <td ng-mouseover="tag.hover=true" ng-mouseleave="tag.hover=false">\n          <strong>{{ tag.name }}</strong>\n          <div class="hoverActions" ng-class="{\'hiddenDiv\': !tag.hover}">\n            <a href="" ng-click="editOrCreate(tag)" translate>Edit</a> &middot;\n            <a href="" class="text-danger"\n              ng-bootbox-confirm="{{ \'Are you sure you want to delete this entry?\' | translate }}<br>\n              <b>{{ tag.name }}</b>"\n              ng-bootbox-confirm-action="delete(tag)" translate>Delete</a>\n          </div>\n  </table>\n</div>\n'),n.put("mediafiles/static/templates/mediafiles/image-plugin.html",'<table class="imageTable">\n  <tr>\n    <td style="width: 55%; border-right: 2px solid #ddd">\n      <div id="imageBrowser"></div>\n    </td>\n    <td style="width: 45%;">\n      <div id="imagePreviewSection" class="hidden">\n        <div id="imagePreview">\n          <div id="fullSizeContainer">\n            <img src=""/>\n          </div>\n        </div>\n        <div>\n          <span id="scaleLabel"></span>\n        </div>\n        <div>\n          <input type="number" id="image-scale" class="cke_dialog_ui_input_text"> %\n        </div>\n        <div id="originalSizeText"></div>\n      </div>\n    </td>\n  </tr>\n</table>\n'),n.put("mediafiles/static/templates/mediafiles/mediafile-form.html",'<h1 translate>Edit File</h1>\n\n<div uib-alert ng-show="alert.show" ng-class="\'alert-\' + (alert.type || \'warning\')" close="alert={}">\n  {{ alert.msg }}\n</div>\n\n<form name="mediafileForm" ng-submit="save(model)" novalidate>\n  <formly-form model="model" fields="formFields">\n    <i ng-if="model.file.$error.maxSize">File too large\n      {{ picFile.size / 1000000|number:1}}MB: max {{ mediafile.mediafile.$errorParam}}</i>\n\n    <uib-progressbar ng-if="activeUpload" value="progress" animate="false">\n      <span class="nobr">{{ progress }}%</span>\n    </uib-progressbar>\n\n    <button type="submit" ng-disabled="mediafileForm.$invalid || activeUpload" class="btn btn-primary" translate>\n      Save\n    </button>\n    <button type="button" ng-click="closeThisDialog()" class="btn btn-default" translate>\n      Cancel\n    </button>\n  </formly-form>\n</form>\n'),n.put("mediafiles/static/templates/mediafiles/mediafile-list.html",'<div class="header">\n  <div class="title">\n    <div class="submenu">\n      <a  ng-click="openDialog()" os-perms="mediafiles.can_upload" class="btn btn-primary btn-sm">\n        <i class="fa fa-plus fa-lg"></i>\n        <translate>New</translate>\n      </a>\n    </div>\n    <h1 translate>Files</h1>\n  </div>\n</div>\n\n<div class="meta" os-perms="core.can_manage_projector">\n  <div class="title" ng-click="isMeta = !isMeta">\n    <div class="name">\n      <i class="fa fa-play-circle"></i>\n      <translate>Presentation control elements</translate>\n    </div>\n    <div class="icon">\n      <i class="fa fa-lg" ng-class="isMeta ? \'fa-angle-down\' : \'fa-angle-up\'"></i>\n    </div>\n  </div>\n  <div class="detail" uib-collapse="isMeta">\n    \x3c!-- mediafile pdf controls --\x3e\n    <div class="row">\n      <div class="col-md-12">\n        <div ng-repeat="presentedMediafile in presentedMediafiles">\n          <h3>{{ getTitle(presentedMediafile) }}</h3>\n          \x3c!-- PDF --\x3e\n          <nav ng-show="getType(presentedMediafile) === \'pdf\'" ng-class="getNavStyle(scroll)" class="form-inline">\n            <div class="btn-group">\n              <button class="btn btn-default" ng-click="mediafileGoToPage(presentedMediafile, presentedMediafile.page - 1)"\n                  ng-class="{ \'disabled\': (presentedMediafile.page - 1) < 1 }"\n                  title="{{ \'Previous page\' | translate }}">\n                <i class="fa fa-backward"></i>\n              </button>\n              <button class="btn btn-default" ng-click="mediafileGoToPage(presentedMediafile, presentedMediafile.page + 1)"\n                  ng-class="{ \'disabled\': (presentedMediafile.page + 1) > presentedMediafile.numPages }"\n                  title="{{ \'Next page\' | translate }}">\n                <i class="fa fa-forward"></i>\n              </button>\n            </div>\n            <div class="input-group">\n              <span class="input-group-addon" translate>Page</span>\n              <input type="number" min=1 ng-model="presentedMediafile.page" class="form-control" style="width: 80px"\n                  ng-change="mediafileGoToPage(presentedMediafile, presentedMediafile.page)">\n              <span class="input-group-addon"><translate>of</translate> {{presentedMediafile.numPages}}</span>\n            </div>\n            <div class="btn-group">\n              <button class="btn btn-default" ng-click="mediafileRotate(presentedMediafile)"\n                  title="{{ \'Rotate clockwise\' | translate }}">\n                <i class="fa fa-repeat"></i>\n              </button>\n            </div>\n            <div class="btn-group">\n              <button class="btn btn-default" ng-click="mediafileZoomOut(presentedMediafile)"\n                  title="{{ \'Zoom out\' | translate }}">\n                <i class="fa fa-search-minus"></i>\n              </button>\n              <button class="btn" ng-click="mediafileFit(presentedMediafile)"\n                  title="{{ \'Reset zoom\' | translate }}"\n                  ng-class="presentedMediafile.scale==\'page-fit\' ? \'btn-primary\' : \'btn-default\'">\n                <i class="fa fa-undo"></i>\n              </button>\n              <button class="btn btn-default" ng-click="mediafileZoomIn(presentedMediafile)"\n                  title="{{ \'Zoom in\' | translate }}">\n                <i class="fa fa-search-plus"></i>\n              </button>\n            </div>\n          </nav>\n\n          \x3c!-- Image --\x3e\n          <nav ng-show="getType(presentedMediafile) === \'image\'" ng-class="getNavStyle(scroll)" class="form-inline">\n            <div class="btn-group">\n              <button class="btn btn-default" ng-click="mediafileToggleFullscreen(presentedMediafile)"\n                  title="{{ \'Toggle fullscreen\' | translate }}"\n                  ng-class="presentedMediafile.fullscreen ? \'btn-primary\' : \'btn-default\'">\n                <i class="fa fa-arrows-alt"></i>\n              </button>\n            </div>\n            <div class="btn-group">\n              <button class="btn btn-default" ng-click="mediafileRotate(presentedMediafile)"\n                  title="{{ \'Rotate clockwise\' | translate }}">\n                <i class="fa fa-repeat"></i>\n              </button>\n            </div>\n          </nav>\n\n          \x3c!-- Video --\x3e\n          <nav ng-show="getType(presentedMediafile) === \'video\'" ng-class="getNavStyle(scroll)" class="form-inline">\n            <div class="btn-group">\n              <button class="btn btn-default" ng-click="mediafileToggleFullscreen(presentedMediafile)"\n                  title="{{ \'Toggle fullscreen\' | translate }}"\n                  ng-class="presentedMediafile.fullscreen ? \'btn-primary\' : \'btn-default\'">\n                <i class="fa fa-arrows-alt"></i>\n              </button>\n            </div>\n            <div class="btn-group">\n              <button class="btn btn-default" ng-click="mediafileTogglePlaying(presentedMediafile)"\n                  title="{{ \'Start/stop video\' | translate }}">\n                <i class="fa" ng-class="presentedMediafile.playing ? \'fa-stop\' : \'fa-play\'"></i>\n              </button>\n            </div>\n          </nav>\n        </div>\n        <div ng-show="!presentedMediafiles.length" class="spacer">\n          <i translate>No media file projected.</i>\n        </div>\n      </div>\n    </div>\n  </div>\n</div>\n\n<div class="details">\n  <div class="row form-group">\n    <div class="col-sm-6">\n      <form class="form-inline">\n        \x3c!-- select mode --\x3e\n        <button os-perms="mediafiles.can_manage" class="btn btn-sm"\n            ng-class="$parent.isSelectMode ? \'btn-primary\' : \'btn-default\'"\n            ng-click="$parent.isSelectMode = !$parent.isSelectMode; uncheckAll()">\n          <i class="fa fa-check-square-o"></i>\n          <translate>Select ...</translate>\n        </button>\n      </form>\n    </div>\n    <div class="col-sm-6"></div>\n  </div>\n  <div uib-collapse="!isSelectMode" class="row spacer">\n    <div class="col-sm-12 text-left">\n      \x3c!-- delete button --\x3e\n      <a ng-show="isSelectMode"\n          os-perms="mediafiles.can_manage" ng-click="deleteMultiple()"\n          class="btn btn-default btn-sm btn-danger">\n        <i class="fa fa-trash fa-lg"></i>\n        <translate>Delete selected mediafiles</translate>\n      </a>\n    </div>\n  </div>\n\n  <div class="spacer-top-lg italic row">\n    <div class="col-md-6">\n      {{ mediafilesFiltered.length }} /\n      {{ mediafiles.length }} {{ "files" | translate }}<span ng-if="(mediafiles|filter:{selected:true}).length > 0">,\n      {{(mediafiles|filter:{selected:true}).length}} {{ "selected" | translate }}</span>\n    </div>\n    <div class="col-md-6" ng-show="mediafilesFiltered.length > pagination.itemsPerPage">\n      <span class="pull-right">\n        <a href="" class="pagination-arrow" ng-click="pagination.prevPage()"\n          ng-if="pagination.showPrevPageArrow()">\n          &laquo;\n        </a>\n        <translate>Page</translate> {{ pagination.currentPage }} /\n        {{ pagination.getPageCount(mediafilesFiltered) }}\n        <a href="" class="pagination-arrow" ng-click="pagination.nextPage(mediafilesFiltered)"\n          ng-if="pagination.showNextPageArrow(mediafilesFiltered)">\n          &raquo;\n        </a>\n      </span>\n    </div>\n  </div>\n\n  <div id="mediafile-table" class="os-table container-fluid">\n    <div class="row header-row">\n      <div class="col-xs-1 centered" ng-show="isSelectMode" os-perms="mediafiles.can_manage">\n        <i class="fa text-danger pointer" ng-class="selectedAll ? \'fa-check-square-o\' : \'fa-square-o\'"\n          ng-click="checkAll()"></i>\n      </div>\n      <div class="col-xs-11 main-header">\n        <span class="form-inline text-right pull-right">\n          \x3c!-- reset Filters --\x3e\n          <span class="sort-spacer pointer" ng-click="filter.reset(isSelectMode)"\n            ng-if="filter.areFiltersSet()" ng-disabled="isSelectMode"\n            ng-class="{\'disabled\': isSelectMode}">\n            <i class="fa fa-window-close"></i>\n            <translate>Filter</translate>\n          </span>\n          \x3c!-- boolean Filters --\x3e\n          <span ng-repeat="(name, booleanFilter) in filter.booleanFilters"\n            ng-if="!booleanFilter.needExtraPermission || operator.hasPerms(\'mediafiles.can_see_hidden\')" uib-dropdown>\n            <span class="pointer" id="dropdown{{ name }}" uib-dropdown-toggle\n              ng-class="{\'bold\': booleanFilter.value !== undefined, \'disabled\': isSelectMode}"\n              ng-disabled="isSelectMode">\n              {{ booleanFilter.displayName | translate }}\n              <span class="caret"></span>\n            </span>\n            <ul class="dropdown-menu dropdown-menu-right" aria-labelledby="dropdown{{ name }}">\n              <li>\n                <a href ng-click="booleanFilter.value = (booleanFilter.value ? undefined : true); filter.save();">\n                  <i class="fa" ng-class="{\'fa-check\': booleanFilter.value === true}"></i>\n                  {{ booleanFilter.choiceYes | translate }}\n                </a>\n              </li>\n              <li>\n                <a href ng-click="booleanFilter.value = (booleanFilter.value === false) ? undefined : false; filter.save();">\n                  <i class="fa" ng-class="{\'fa-check\': booleanFilter.value === false}"></i>\n                  {{ booleanFilter.choiceNo | translate }}\n                </a>\n              </li>\n            </ul>\n          </span>\n          \x3c!-- dropdown sort --\x3e\n          <span uib-dropdown>\n            <span class="pointer" id="dropdownSort" uib-dropdown-toggle\n              ng-class="{\'disabled\': isSelectMode}"\n              ng-disabled="isSelectMode">\n              <translate>Sort</translate>\n              <span class="caret"></span>\n            </span>\n            <ul class="dropdown-menu dropdown-menu-right" aria-labelledby="dropdownSort">\n              <li ng-repeat="option in sortOptions">\n                <a href ng-click="sort.toggle(option.name)">\n                  <span ng-style="{\'font-weight\': sort.column === option.name ? \'bold\' : \'normal\'}">\n                    {{ option.display_name | translate }}\n                  </span>\n                  <span class="spacer-right pull-right"></span>\n                  <i class="pull-right fa"\n                    ng-style="{\'visibility\': sort.column === option.name ? \'visible\' : \'hidden\'}"\n                    ng-class="sort.reverse ? \'fa-sort-amount-desc\' : \'fa-sort-amount-asc\'">\n                  </i>\n                </a>\n              </li>\n            </ul>\n          </span>\n          \x3c!-- search field --\x3e\n          <span class="form-group">\n            <span class="input-group">\n              <span class="input-group-addon"><i class="fa fa-search"></i></span>\n              <input type="text" ng-model="filter.filterString" class="form-control"\n                 placeholder="{{ \'Search\' | translate}}" ng-disabled="isSelectMode"\n                 ng-change="filter.save()">\n            </span>\n          </span>\n        </span>\n        \x3c!-- show all selected multiselectoptions --\x3e\n        <span>\n          \x3c!-- for all boolean Filters --\x3e\n          <span ng-repeat="(name, booleanFilter) in filter.booleanFilters"\n            ng-hide="booleanFilter.value === undefined"\n            class="pointer spacer-left-lg"\n            ng-click="booleanFilter.value = undefined; filter.save();"\n            ng-class="{\'disabled\': isSelectMode}">\n            <span class="nobr">\n              <i class="fa fa-times-circle"></i>\n              {{ booleanFilter.value ? booleanFilter.choiceYes : booleanFilter.choiceNo | translate }}\n            </span>\n          </span>\n        </span>\n      </div>\n    </div>\n\n    \x3c!-- main table --\x3e\n    <div class="row data-row" ng-mouseover="mediafile.hover=true"\n      ng-mouseleave="mediafile.hover=false"\n      ng-class="{\'projected\': mediafile.isProjected().length}"\n      ng-repeat="mediafile in mediafilesFiltered = (mediafiles\n      | hiddenFilter\n      | osFilter: filter.filterString : filter.getObjectQueryString\n      | filter: {filetype: (filter.booleanFilters.isPdf.value ? \'application/pdf\' : (filter.booleanFilters.isPdf.value === false ? \'!application/pdf\' : \'\'))}\n      | filter: {hidden: filter.booleanFilters.isHidden.value}\n      | orderByEmptyLast: sort.column : sort.reverse)\n      | limitTo: pagination.itemsPerPage : pagination.limitBegin">\n\n      \x3c!-- select column --\x3e\n      <div ng-show="isSelectMode" os-perms="mediafiles.can_manage" class="col-xs-1 centered">\n        <i class="fa text-danger pointer" ng-click="mediafile.selected=!mediafile.selected"\n        ng-class="mediafile.selected ? \'fa-check-square-o\' : \'fa-square-o\'"></i>\n      </div>\n      \x3c!-- projector column --\x3e\n      <div class="col-xs-1 centered projector" os-perms="core.can_manage_projector">\n        <div class="btn-group" style="min-width:{{ projectors.length > 1 ? \'54\' : \'34\' }}px;" uib-dropdown\n          ng-if="mediafile.is_presentable"\n          uib-tooltip="{{ \'Projector\' | translate }} {{ mediafile.isProjected()[0] || \'\' }}"\n          tooltip-enable="mediafile.isProjected().length">\n          <button type="button" class="btn btn-default btn-sm"\n            ng-click="showMediafile(defaultProjectorId, mediafile)"\n            ng-class="{ \'btn-primary\': inArray(mediafile.isProjected(), defaultProjectorId)  }">\n            <i class="fa fa-video-camera"></i>\n          </button>\n          <button type="button" class="btn btn-default btn-sm slimDropDown"\n            ng-class="{ \'btn-primary\': (mediafile.isProjected().length && !inArray(mediafile.isProjected(), defaultProjectorId) ) }"\n            ng-if="projectors.length > 1"\n            uib-dropdown-toggle>\n            <span class="caret"></span>\n          </button>\n          <ul class="dropdown-menu" ng-if="projectors.length > 1">\n            <li role="menuitem" ng-repeat="projector in projectors | orderBy:\'id\'">\n              <a href="" ng-click="showMediafile(projector.id, mediafile)"\n                ng-class="{ \'projected\': inArray(mediafile.isProjected(), projector.id)  }">\n                <i class="fa fa-video-camera" ng-show="inArray(mediafile.isProjected(), projector.id) "></i>\n                {{ projector.name | translate }}\n                <span ng-if="defaultProjectorId == projector.id">(<translate>Default</translate>)</span>\n              </a>\n            </li>\n          </ul>\n        </div>\n      </div>\n      <div class="no-projector-spacer" os-perms="!core.can_manage_projector"></div>\n      \x3c!-- main content column --\x3e\n      <div class="col-xs-5 content">\n        <div class="icon-column"> \x3c!-- horizontal block --\x3e\n          <i ng-style="{\'visibility\': mediafile.hidden ? \'visible\' : \'hidden\'}" class="fa fa-lock fa-lg"\n              title="{{ \'Is hidden\' | translate }}"></i>\n          <span os-perms="core.can_manage_logos_and_fonts" class="spacer-left">\n            <i ng-if="mediafile.isUsedAsLogo()" class="fa fa-picture-o fa-lg"\n            title="{{ \'Is used as a logo\' | translate }}"></i>\n            <i ng-if="mediafile.isUsedAsFont()" class="fa fa-font fa-lg"\n              title="{{ \'Is used as a font\' | translate }}"></i>\n          </span>\n        </div>\n        <div class="title-column">\n          <div> \x3c!-- vertical block --\x3e\n            <a ng-href="{{ mediafile.mediafileUrl }}" class="title" target="_blank">{{ mediafile.title_or_filename }}</a>\n          </div>\n          <div><small>{{ mediafile.uploader.get_full_name() }}</small></div>\n          <div os-perms="mediafiles.can_manage" ng-class="{\'hiddenDiv\': !mediafile.hover}">\n            <small>\n              <a href="" ng-click="openDialog(mediafile)" translate>Edit</a> &middot;\n              <a href="" class="text-danger"\n                ng-bootbox-confirm="{{ \'Are you sure you want to delete this file?\' | translate }}<br>\n                <b>{{ mediafile.title }} [{{ mediafile.mediafile.name }}]</b>"\n                ng-bootbox-confirm-action="delete(mediafile)" translate>Delete</a>\n            </small>\n          </div>\n        </div>\n      </div>\n\n      \x3c!-- additional content column --\x3e\n      <div class="col-xs-4 content" ng-style="{\'width\': isSelectMode ? \'calc(50% - 120px)\' : \'calc(50% - 70px)\'}">\n        <div style="width: 60%;" class="optional">\n          <small>\n            <div>\n              <i class="fa fa-file"></i> {{ mediafile.filetype }}\n              <span ng-if="mediafile.mediafile.encrypted">(<translate>Encrypted</translate>)</span>\n            </div>\n            <div><i class="fa fa-database"></i> {{ mediafile.filesize }}</div>\n            <div><i class="fa fa-upload"></i> {{ mediafile.timestamp | date:\'yyyy-MM-dd HH:mm:ss\' }}</div>\n          </small>\n        </div>\n        <div style="width: 40%;" class="pull-right optional">\n          \x3c!-- Logo placeholder dropdown for manage user --\x3e\n          <div os-perms="core.can_manage_logos_and_fonts"\n              ng-mouseover="mediafile.logoHover=true"\n              ng-mouseleave="mediafile.logoHover=false"\n              ng-show="mediafile.canBeUsedAsLogo()">\n            <span uib-dropdown>\n              <span id="dropdownLogo{{ mediafile.id }}" class="pointer nobr" uib-dropdown-toggle>\n                <span uib-tooltip="{{ \'Manage logos\' | translate }}" tooltip-class="nobr">\n                  <span ng-if="!mediafile.isUsedAsLogo()" ng-show="mediafile.hover">\n                    <i class="fa fa-picture-o"></i>\n                    <i class="fa fa-plus"></i>\n                  </span>\n                  <span ng-if="mediafile.isUsedAsLogo()">\n                    <span ng-repeat="logo in mediafile.getLogos()">\n                      <i class="fa fa-picture-o spacer-right"\n                         ng-style="{\'visibility\': $first ? \'visible\' : \'hidden\'}"></i>\n                      <small>\n                        {{ logo.display_name | translate }}<span ng-if="!$last">,</br></span>\n                      </small>\n                    </span>\n                  </span>\n                </span>\n                <span ng-if="hasProjectorHeaderLogo(mediafile) && mediafile.logoHover"\n                    uib-tooltip="{{ \'The projector header should have a default size of 1024x70px. Adapt the image width if you change the projector resolution.\' | translate }}">\n                  <i class="fa fa-info-circle"></i>\n                </span>\n                <i class="fa fa-cog fa-lg spacer-left" ng-show="mediafile.logoHover && mediafile.isUsedAsLogo()"></i>\n              </span>\n              <ul class="dropdown-menu" aria-labelledby="dropdownLogos{{ mediafile.id }}">\n                <li ng-repeat="logo in logos">\n                  <a href ng-click="mediafile.toggleLogo(logo)">\n                    <i class="fa fa-check" ng-if="mediafile.hasLogo(logo)"></i>\n                    {{ logo.display_name | translate }}\n                  </a>\n                </li>\n              </ul>\n            </span>\n          </div>\n          \x3c!-- Font placeholder dropdown for manage user --\x3e\n          <div os-perms="core.can_manage_logos_and_fonts"\n              ng-mouseover="mediafile.fontHover=true"\n              ng-mouseleave="mediafile.fontHover=false"\n              ng-show="mediafile.canBeUsedAsFont()">\n            <span uib-dropdown>\n              <span id="dropdownFont{{ mediafile.id }}" class="pointer nobr" uib-dropdown-toggle>\n                <span uib-tooltip="{{ \'Manage fonts\' | translate }}" tooltip-class="nobr">\n                  <span ng-if="!mediafile.isUsedAsFont()" ng-show="mediafile.hover">\n                    <i class="fa fa-font"></i>\n                    <i class="fa fa-plus"></i>\n                  </span>\n                  <span ng-if="mediafile.isUsedAsFont()">\n                    <span ng-repeat="font in mediafile.getFonts()">\n                      <i class="fa fa-font spacer-right"\n                         ng-style="{\'visibility\': $first ? \'visible\' : \'hidden\'}"></i>\n                      <small>\n                        {{ font.display_name | translate }}<span ng-if="!$last">,</br></span>\n                      </small>\n                    </span>\n                  </span>\n                </span>\n                <i class="fa fa-cog fa-lg spacer-left" ng-show="mediafile.fontHover && mediafile.isUsedAsFont()"></i>\n              </span>\n              <ul class="dropdown-menu" aria-labelledby="dropdownFonts{{ mediafile.id }}">\n                <li ng-repeat="font in fonts">\n                  <a href ng-click="mediafile.toggleFont(font)">\n                    <i class="fa fa-check" ng-if="mediafile.hasFont(font)"></i>\n                    {{ font.display_name | translate }}\n                  </a>\n                </li>\n              </ul>\n            </span>\n          </div>\n\n        </div>\n      </div>\n\n    </div>\x3c!-- end data row --\x3e\n  </div>\x3c!-- end os-table --\x3e\n\n  <ul uib-pagination\n      ng-show="mediafilesFiltered.length > pagination.itemsPerPage"\n      total-items="mediafilesFiltered.length"\n      items-per-page="pagination.itemsPerPage"\n      ng-model="pagination.currentPage"\n      ng-change="pagination.pageChanged()"\n      class="pagination-sm"\n      direction-links="false"\n      boundary-links="true"\n      first-text="&laquo;"\n      last-text="&raquo;">\n  </ul>\n</div>\n'),n.put("mediafiles/static/templates/mediafiles/mediafile-upload-form.html",'<h1 translate>Upload files</h1>\n\n<div uib-alert ng-show="alert.show" ng-class="\'alert-\' + (alert.type || \'warning\')" close="alert={}">\n  {{ alert.msg }}\n</div>\n\n<form editable-form name="mediafileForm" ng-submit="upload()" novalidate>\n  <div class="form-group" ng-hide="uploading">\n    <div id="dropzone" ngf-drop ngf-select ng-model="dropFiles" ngf-drag-over-class="\'dragover\'" ngf-multiple="true">\n      <translate>Drop files into this area OR</translate>\n      <a href= ng-disabled="files.length" type="button" ngf-select="addFiles($files)" multiple translate>\n        select files\n      </a>\n    </div>\n  </div>\n\n  <div class="form-group" ng-if="files.length">\n    <table class="table table-striped table-bordered table-hover">\n      <thead>\n        <tr>\n          <th translate>\n            File information\n          </th>\n          <th translate>\n            Title\n          </th>\n          <th ng-if="!uploading && operator.hasPerms(\'mediafiles.can_see_hidden\')" translate>\n            Hidden\n          </th>\n          <th ng-if="!uploading && operator.hasPerms(\'mediafiles.can_manage\')" translate>\n            Uploader\n          </th>\n          <th ng-if="uploading" translate>\n            Upload status\n          </th>\n        </tr>\n      </thead>\n      <tbody>\n        <tr ng-repeat="file in files">\n          <td>\n            <div>\n              {{ $index+1 }}. {{ file.name }}\n              <span class="pull-right pointer" ng-click="removeFile(file.id)">\n                <i class="fa fa-times text-danger"></i>\n              </span>\n            </div>\n            <div ng-if="file.type"><i class="fa fa-file"></i> {{ file.type }}</div>\n            <div><i class="fa fa-database"></i> {{ file.humanSize }}</div>\n            <div ng-if="file.error" class="text-danger">\n              {{ file.error }}\n            </div>\n          </td>\n          <td ng-if="!uploading">\n            <input type="text" class="form-control" ng-model="file.title">\n          </td>\n          <td ng-if="uploading">\n            {{ file.title }}\n          </td>\n          <td ng-if="!uploading && operator.hasPerms(\'mediafiles.can_see_hidden\')">\n            <i class="fa" ng-class="file.hidden ? \'fa-check-square-o\' : \'fa-square-o\'"\n              ng-click="file.hidden = !file.hidden"></i>\n          </td>\n          <td ng-if="!uploading && operator.hasPerms(\'mediafiles.can_manage\')">\n            <select chosen\n                data-ng-model="file.uploader_id"\n                ng-options="user.id as user.full_name for user in users"\n                allow-single-deselect="true"\n                search-contains="true"\n                placeholder-text-single="\'Select or search a participant ...\' | translate"\n                no-results-text="\'No results available ...\' | translate"\n                class="form-control">\n              <option value=""></option>\n            </select>\n          </td>\n          <td ng-if="uploading">\n            <uib-progressbar value="file.progress" animate="false">\n              <span class="nobr">{{ file.progress }}%</span>\n            </uib-progressbar>\n          </td>\n        </tr>\n      </tbody>\n    </table>\n  </div>\n\n\n  <div class="form-field">\n    <button type="submit" ng-disabled="files.length === 0 || uploading" class="btn btn-primary" translate>\n      Upload\n    </button>\n    <button type="button" ng-disabled="uploading" ng-click="clear()" class="btn btn-default" translate>\n      Clear list\n    </button>\n    <button type="button" ng-click="close()" class="btn btn-default pull-right" translate>\n      Close\n    </button>\n  </div>\n</form>\n'),n.put("mediafiles/static/templates/mediafiles/slide_mediafile.html",'<div ng-controller="SlideMediafileCtrl" class="content" ng-class="{\'fullscreen\': element.fullscreen, \'video-container\': element.is_video}">\n    \x3c!-- PDF --\x3e\n    <ng-pdf ng-if="mediafile.is_pdf && showPdf" template-url="/static/templates/mediafiles/slide_mediafile_partial.html"\n         scale="{{ element.scale }}"\n         ng-attr-page="{{ element.page }}">\n    </ng-pdf>\n\n    \x3c!-- Image --\x3e\n    <img ng-if="mediafile.is_image && !element.fullscreen" class=\'projector-image rotate{{element.rotate}}\'\n        ng-src=\'{{mediafile.mediafileUrl}}\'></img>\n    <div ng-if="mediafile.is_image && element.fullscreen" class=\'projector-image rotate{{element.rotate}}\'\n        style=\'background-image: url("{{mediafile.mediafileUrl}}")\'></div>\n\n    \x3c!-- Video --\x3e\n    <div ng-if="mediafile.is_video" class=\'video-container\'>\n        <video id=\'video-player\' ng-src="{{mediafile.mediafileUrl}}"></video>\n    </div>\n</div>\n'),n.put("mediafiles/static/templates/mediafiles/slide_mediafile_partial.html",'<canvas id="pdf-canvas" class="rotate{{element.rotate}} scrollcontent"></canvas>\n'),n.put("motions/static/templates/motions/amendment-paragraph-choose-form.html",'<h1 translate>Please choose the paragraph to amend</h1>\n\n<div uib-alert ng-show="alert.show" ng-class="\'alert-\' + (alert.type || \'warning\')" close="alert={}">\n    {{ alert.msg }}\n</div>\n\n<form name="motionForm" ng-submit="gotoMotionForm(model)" novalidate>\n\n    <div class="paragraph-select-list motion-text">\n        <div ng-repeat="paragraph in paragraphs" class="paragraph-select-holder"\n             ng-class="model.paragraph_selected == paragraph.paragraphNo ? \'selected\' : \'\'">\n            <div class="paragraph-select">\n                <input type="radio" name="paragraph_selected" value="{{ paragraph.paragraphNo }}"\n                       ng-model="model.paragraph_selected">\n            </div>\n            <div class="text-holder" ng-click="model.paragraph_selected = paragraph.paragraphNo"\n                 ng-bind-html="paragraph.text | trusted"></div>\n        </div>\n    </div>\n\n    <button type="submit" ng-disabled="model.paragraph_selected === null" class="btn btn-primary" translate>\n        Continue\n    </button>\n    <button type="button" ng-click="closeThisDialog()" class="btn btn-default" translate>\n        Cancel\n    </button>\n</form>\n'),
n.put("motions/static/templates/motions/category-form.html",'<h1 ng-if="model.id" translate>Edit category</h1>\n<h1 ng-if="!model.id" translate>New category</h1>\n\n<div uib-alert ng-show="alert.show" ng-class="\'alert-\' + (alert.type || \'warning\')" close="alert={}">\n  {{ alert.msg }}\n</div>\n\n<form name="categoryForm" ng-submit="save(model)">\n  <formly-form model="model" fields="formFields">\n    <button type="submit" ng-disabled="categoryForm.$invalid" class="btn btn-primary" translate>\n      Save\n    </button>\n    <button ng-click="closeThisDialog()" class="btn btn-default" translate>\n      Cancel\n    </button>\n  </formly-form>\n</form>\n'),n.put("motions/static/templates/motions/category-list.html",'<div class="header">\n  <div class="title">\n    <div class="submenu">\n      <a ui-sref="motions.motion.list" class="btn btn-sm btn-default">\n        <i class="fa fa-angle-double-left fa-lg"></i>\n        <translate>Back to overview</translate>\n      </a>\n      <a href="" os-perms="motions.can_manage" class="btn btn-primary btn-sm" ng-click="editOrCreate()">\n        <i class="fa fa-plus fa-lg"></i>\n        <translate>New</translate>\n      </a>\n    </div>\n    <h1 translate>Categories</h1>\n  </div>\n</div>\n\n<div class="details">\n  <div class="row form-group">\n    <div class="col-sm-4 pull-right">\n      <input type="text" ng-model="filter.search" class="form-control"\n          placeholder="{{ \'Filter\' | translate }}">\n    </div>\n  </div>\n\n  <table class="table table-striped table-bordered table-hover">\n    <thead>\n      <tr>\n        <th ng-click="toggleSort(\'name\')" class="sortable">\n          <translate>Name</translate>\n          <i class="pull-right fa" ng-show="sortColumn === \'name\' && header.sortable != false"\n              ng-class="reverse ? \'fa-sort-desc\' : \'fa-sort-asc\'">\n          </i>\n        <th ng-click="toggleSort(\'prefix\')" class="sortable">\n          <translate>Prefix</translate>\n          <i class="pull-right fa" ng-show="sortColumn === \'prefix\' && header.sortable != false"\n              ng-class="reverse ? \'fa-sort-desc\' : \'fa-sort-asc\'">\n          </i>\n    <tbody>\n      <tr ng-repeat="category in categories | filter: filter.search | orderBy: sortColumn:reverse">\n        <td ng-mouseover="category.hover=true" ng-mouseleave="category.hover=false">\n          <strong>{{ category.name }}</strong>\n          <div class="hoverActions" ng-class="{\'hiddenDiv\': !category.hover}">\n            \x3c!-- sort --\x3e\n            <a ui-sref="motions.category.sort({ id: category.id })" translate>Sort</a> &middot;\n            \x3c!-- edit --\x3e\n            <a href="" ng-click="editOrCreate(category)" translate>Edit</a> &middot;\n            \x3c!-- delete --\x3e\n            <a href="" class="text-danger"\n              ng-bootbox-confirm="{{ \'Are you sure you want to delete this entry?\' | translate }}<br>\n                <b>{{ category.name }}</b>"\n              ng-bootbox-confirm-action="delete(category)" translate>Delete</a>\n          </div>\n        <td>{{ category.prefix }}\n  </table>\n</div>\n'),n.put("motions/static/templates/motions/category-sort.html",'<div class="header">\n  <div class="title">\n    <div class="submenu">\n      <a ui-sref="motions.category.list" class="btn btn-sm btn-default">\n        <i class="fa fa-angle-double-left fa-lg"></i>\n        <translate>Back to categories</translate>\n      </a>\n    </div>\n    <h1><translate>Category</translate> {{ category.name }}</h1>\n  </div>\n</div>\n\n<div class="details">\n  <div class="lead-div">\n    <p translate>\n      Drag and drop motions to reorder the category. Then click the button to renumber.\n    </p>\n    <a os-perms="motions.can_manage" class="btn btn-primary btn-sm" ng-click="numbering()">\n      <i class="fa fa-sort-numeric-asc fa-lg"></i>\n      <translate>Numbering</translate>\n    </a>\n  </div>\n  <div uib-alert ng-show="alert.show" ng-class="\'alert-\' + (alert.type || \'warning\')" ng-click="alert={}" close="alert={}">\n    {{ alert.msg }}\n  </div>\n  <div ui-tree="treeOptions" data-max-depth="1" data-empty-placeholder-enabled="false">\n    <ol ui-tree-nodes ng-model="items">\n      <li ui-tree-node ng-repeat="item in items">\n        <i ui-tree-handle="" class="fa fa-arrows-v"></i>\n        <a ui-sref="motions.motion.detail({id: item.item.id})">{{ item.item.identifier }}: {{ item.item.getTitle() }}\n    </ol>\n  </div>\n</div>\n'),n.put("motions/static/templates/motions/change-recommendation-form.html",'<h1 ng-if="model.id" translate>Edit change recommendation</h1>\n<h1 ng-if="!model.id" translate>New change recommendation</h1>\n\n<div uib-alert ng-show="alert.show" ng-class="\'alert-\' + (alert.type || \'warning\')" close="alert={}">\n  {{ alert.msg }}\n</div>\n\n<form name="changeRecommendationForm" ng-submit="save(model)">\n  <formly-form model="model" fields="formFields">\n    <button type="submit" ng-disabled="changeRecommendation.$invalid" class="btn btn-primary" translate>\n      Save\n    </button>\n    <button ng-click="closeThisDialog()" class="btn btn-default" translate>\n      Cancel\n    </button>\n  </formly-form>\n</form>\n'),n.put("motions/static/templates/motions/motion-amendment-list.html",'<div ng-controller="MotionListCtrl">\n<div ng-controller="MotionAmendmentListCtrl">\n<div class="header">\n  <div class="title">\n    <div class="submenu">\n      <a ui-sref="motions.motion.list" class="btn btn-sm btn-default">\n        <i class="fa fa-angle-double-left fa-lg"></i>\n        <translate>Back to motions overview</translate>\n      </a>\n      <button type="button" class="btn btn-sm"\n        ng-class="expandContent ? \'btn-primary\' : \'btn-default\'"\n        ng-click="toggleExpandContent(); saveExpandState(expandContent)">\n        <i class="fa fa-arrows-h fa-lg"></i>\n        <span ng-if="!expandContent" translate>Expand</span>\n        <span ng-if="expandContent" translate>Reduce</span>\n      </button>\n    </div>\n    <h1 translate>Amendments</h1>\n    <div ng-mouseover="selectHover=true" ng-mouseleave="selectHover=false"\n        class="dropdown-hover-space">\n      <h3>\n        <a ui-sref="motions.motion.detail({id: leadMotion.id})" ng-if="leadMotion">\n          <span ng-if="leadMotion.identifier">\n            {{ leadMotion.identifier }} &mdash;\n          </span>\n          {{ leadMotion.getTitle() }}\n        </a>\n        <span ng-if="!leadMotion" translate>\n          All motions\n        </span>\n        <span ng-class="{\'hiddenDiv\': !selectHover}" uib-dropdown>\n          <i class="fa fa-cog pointer" uib-dropdown-toggle id="selectDropdown"></i>\n          <ul class="dropdown-menu" aria-labelledby="selectDropdown">\n            <li>\n              <a href ng-click="selectLeadMotion(null)" translate>\n                All motions\n              </a>\n            </li>\n            <li class="divider"></li>\n            <li ng-repeat="motion in leadMotions">\n              <a href ng-click="selectLeadMotion(motion)">\n                <span ng-if="motion.identifier">\n                  {{ motion.identifier }} &mdash;\n                </span>\n                {{ motion.getTitle() | limitTo: 35 }}{{ motion.getTitle().length > 35 ? \'...\' : \'\' }}\n              </a>\n            </li>\n          </ul>\n        </span>\n      </h3>\n    </div>\n  </div>\n</div>\n\n<div class="details">\n\n  <div class="row">\n    <div class="col-sm-12">\n      \x3c!-- select mode --\x3e\n      <button os-perms="motions.can_manage" class="btn btn-sm"\n          ng-class="$parent.isSelectMode ? \'btn-primary\' : \'btn-default\'"\n          ng-click="$parent.isSelectMode = !$parent.isSelectMode; uncheckAll()">\n        <i class="fa fa-check-square-o"></i>\n        <translate>Select ...</translate>\n      </button>\n      \x3c!-- Export dropdown --\x3e\n      <div class="pull-right" uib-dropdown>\n        <button type="button" class="btn btn-default btn-sm" id="dropdownExport" uib-dropdown-toggle>\n          <i class="fa fa-upload"></i>\n          <span ng-if="amendmentsFiltered.length === amendments.length" translate>\n            Export all\n          </span>\n          <span ng-if="amendmentsFiltered.length !== amendments.length" translate>\n            Export filtered\n          </span>\n          <span class="caret"></span>\n        </button>\n        <ul class="dropdown-menu dropdown-menu-right" aria-labelledby="dropdownExport">\n          \x3c!-- PDF export --\x3e\n          <li os-perms="motions.can_manage">\n            <a href="" ng-click="openExportDialog(amendmentsFiltered)">\n              <i class="fa fa-file-pdf-o"></i>\n              <translate>Export dialog</translate>\n            </a>\n          </li>\n          <li os-perms="!motions.can_manage">\n            <a href="" ng-click="pdfExport(amendmentsFiltered)">\n              <i class="fa fa-file-pdf-o"></i>\n              PDF\n            </a>\n          </li>\n          \x3c!-- amendment PDF export --\x3e\n          <li>\n            <a href="" ng-click="amendmentPdfExport(amendmentsFiltered)">\n              <i class="fa fa-file-pdf-o"></i>\n              <translate>Amendment list PDF</translate>\n            </a>\n          </li>\n          \x3c!-- CSV export --\x3e\n          <li>\n            <a href="" ng-click="exportCsv(amendmentsFiltered)">\n              <i class="fa fa-file-text-o"></i>\n              CSV\n            </a>\n          </li>\n        </ul>\n      </div>\n    </div>\n  </div>\n\n  <div uib-collapse="!isSelectMode" class="row spacer">\n    <div class="col-sm-12 text-left form-inline" ng-show="isSelectMode" os-perms="motions.can_manage">\n      \x3c!-- actions --\x3e\n      <select ng-model="selectedAction" class="form-control input-sm">\n        <option value="" translate>--- Select action ---</option>\n        <option value="delete" translate>Delete</option>\n        <option value="setStatus" translate>Set status</option>\n        <option value="setCategory" ng-if="categories.length" translate>Set category</option>\n        <option value="setMotionBlock" ng-if="motionBlocks.length" translate>Set motion block</option>\n      </select>\n      \x3c!-- state select --\x3e\n      <select ng-show="selectedAction == \'setStatus\'" ng-model="selectedState" class="form-control input-sm">\n        <option value="" translate>--- Select state ---</option>\n        <option ng-repeat="state in states" ng-if="!state.divider" ng-disabled="state.workflowHeader" value="{{ state.id }}">\n          {{ (state.workflowHeader ? state.headername : state.name) | translate }}\n        </option>\n      </select>\n      \x3c!-- set state button --\x3e\n      <a ng-show="selectedAction == \'setStatus\' && selectedState"\n          ng-click="setStatusMultiple(amendmentsFiltered, selectedState)" class="btn btn-default btn-sm">\n        <translate>Set status</translate>\n      </a>\n      \x3c!-- category select --\x3e\n      <select ng-show="selectedAction == \'setCategory\'" ng-model="selectedCategory" class="form-control input-sm">\n        <option value="" translate>--- Select category ---</option>\n        <option ng-repeat="category in categories | orderBy: config(\'motions_export_category_sorting\')"\n            value="{{ category.id }}">\n          {{ category.prefix }} &ndash; {{ category.name }}\n        </option>\n        <option value="no_category_selected" translate>No category</option>\n      </select>\n      \x3c!-- set category button --\x3e\n      <a ng-show="selectedAction == \'setCategory\' && selectedCategory"\n          ng-click="setCategoryMultiple(amendmentsFiltered, selectedCategory)" class="btn btn-default btn-sm">\n        <translate>Set category</translate>\n      </a>\n      \x3c!-- motionBlock select --\x3e\n      <select ng-show="selectedAction == \'setMotionBlock\'" ng-model="selectedMotionBlock" class="form-control input-sm">\n        <option value="" translate>--- Select motion block ---</option>\n        <option ng-repeat="motionBlock in motionBlocks" value="{{ motionBlock.id }}">\n          {{ motionBlock.title }}\n        </option>\n        <option value="no_motionBlock_selected" translate>No motion block</option>\n      </select>\n      \x3c!-- set motion block button --\x3e\n      <a ng-show="selectedAction == \'setMotionBlock\' && selectedMotionBlock"\n         ng-click="setMotionBlockMultiple(amendmentsFiltered, selectedMotionBlock)" class="btn btn-default btn-sm">\n        <translate>Set motion block</translate>\n      </a>\n      \x3c!-- delete button --\x3e\n      <a ng-show="selectedAction == \'delete\'"\n        ng-bootbox-confirm="{{ \'Are you sure you want to delete all selected amendments?\' | translate }}"\n        ng-bootbox-confirm-action="deleteMultiple(amendmentsFiltered)"\n        class="btn btn-default btn-sm btn-danger">\n        <i class="fa fa-trash fa-lg"></i>\n        <translate>Delete selected amendments</translate>\n      </a>\n    </div>\n  </div>\n\n  <div class="spacer-top-lg italic row">\n    <div class="col-md-6">\n      {{ amendmentsFiltered.length }} /\n      {{ amendments.length }}\n      <translate>amendments</translate><span ng-if="(amendments|filter:{selected:true}).length > 0">,\n      {{(amendments|filter:{selected:true}).length}} {{ "selected" | translate }}</span>\n    </div>\n    <div class="col-md-6" ng-show="amendmentsFiltered.length > pagination.itemsPerPage">\n      <span class="pull-right">\n        <translate>Page</translate> {{ pagination.currentPage }} /\n        {{ Math.ceil(amendmentsFiltered.length/pagination.itemsPerPage) }}\n      </span>\n    </div>\n  </div>\n\n  <div class="os-table container-fluid">\n    <div class="row header-row">\n      <div class="col-xs-1 centered" ng-if="isSelectMode">\n        <i class="fa text-danger pointer" ng-class=" selectedAll ? \'fa-check-square-o\' : \'fa-square-o\'"\n          ng-click="checkAll(amendmentsFiltered)"></i>\n      </div>\n      <div class="col-xs-11 main-header" ng-style="{\'width\': isSelectMode ? \'\' : \'100%\'}">\n        <ng-include src="\'static/templates/motions/motion-table-filters.html\'"></ng-include>\n      </div>\n    </div>\n\n    \x3c!-- main table --\x3e\n    <div class="row data-row" ng-repeat="amendment in amendmentsFiltered = (amendments\n      | osFilter: filter.filterString : filter.getObjectQueryString\n      | MultiselectFilter: stateFilter : getItemId.state\n      | MultiselectFilter: filter.multiselectFilters.comment : getItemId.comment\n      | MultiselectFilter: filter.multiselectFilters.category : getItemId.category\n      | MultiselectFilter: filter.multiselectFilters.motionBlock : getItemId.motionBlock\n      | MultiselectFilter: filter.multiselectFilters.recommendation : getItemId.recommendation\n      | MultiselectFilter: filter.multiselectFilters.tag : getItemId.tag\n      | filter: {star: filter.booleanFilters.isFavorite.value}\n      | filter: {hasPersonalNote: filter.booleanFilters.hasPersonalNote.value}\n      | filter: {isAmendment: filter.booleanFilters.isAmendment.value}\n      | toArray\n      | orderByEmptyLast: sort.column : sort.reverse)\n      | limitTo : pagination.itemsPerPage : pagination.limitBegin"\n      ng-class="{\'projected\': amendment.isProjected().length}">\n\n      \x3c!-- select column --\x3e\n      <div ng-show="isSelectMode" os-perms="motions.can_manage" class="col-xs-1 centered">\n        <i class="fa text-danger pointer" ng-click="amendment.selected=!amendment.selected"\n        ng-class="amendment.selected ? \'fa-check-square-o\' : \'fa-square-o\'"></i>\n      </div>\n      \x3c!-- projector column --\x3e\n      <div class="col-xs-1 centered projector" os-perms="core.can_manage_projector">\n        <projector-button model="amendment" default-projector-id="defaultProjectorId">\n        </projector-button>\n      </div>\n      <div class="no-projector-spacer" os-perms="!core.can_manage_projector"></div>\n      \x3c!-- data --\x3e\n      <div class="col-xs-2 content">\n        <div>\n          \x3c!-- ID and title --\x3e\n          <div>\n            <a class="title" ui-sref="motions.motion.detail({id: amendment.id})">\n              <span ng-if="amendment.identifier">{{ amendment.identifier }}</span>\n              <span ng-if="!amendment.identifier">{{ amendment.getTitle() }}</span>\n              <span ng-if="amendment.isParagraphBasedAmendment()"\n                  ng-init="paragraph = amendment.getAmendmentParagraphsLinesDiff()[0]">\n                <span ng-if="paragraph">\n                  <br>\n                  <span ng-if="paragraph.diffLineTo == paragraph.diffLineFrom + 1">\n                    (<translate>Line</translate> {{ paragraph.diffLineFrom }})\n                  </span>\n                  <span ng-if="paragraph.diffLineTo != paragraph.diffLineFrom + 1">\n                    (<translate>Line</translate> {{ paragraph.diffLineFrom }}-{{ paragraph.diffLineTo }})\n                  </span>\n                </span>\n              </span>\n            </a>\n            <a href="" ng-click="toggleStar(amendment)">\n              <i class="fa" ng-class="amendment.personalNote.star ? \'fa-star\' : \'fa-star-o\'"\n                title="{{ \'Set as favorite\' | translate }}" ng-if="(amendment.personalNote.star || amendment.hover) && operator.user"></i>\n            </a>\n            <i class="fa fa-paperclip" ng-if="amendment.attachments_id.length > 0"></i>\n          </div>\n\n          \x3c!-- state --\x3e\n          <div os-perms="!motions.can_manage">\n            <span class="label" ng-class="\'label-\'+amendment.state.css_class">\n              {{ amendment.getStateName() }}\n            </span>\n          </div>\n          <div os-perms="motions.can_manage" uib-dropdown>\n            <a class="pointer label" uib-dropdown-toggle id="stateDropdown{{ amendment.id }}"\n               ng-class="\'label-\'+amendment.state.css_class">\n              {{ amendment.getStateName() }}\n            </a>\n            <ul class="dropdown-menu" aria-labelledby="stateDropdown{{ amendment.id }}">\n              <li ng-repeat="state in amendment.state.getNextStates()">\n                <a href ng-click="amendment.setState(state.id)">{{ state.action_word | translate }}</a>\n              </li>\n              <li class="divider" ng-if="amendment.state.getNextStates().length"></li>\n              <li>\n                <a href ng-if="amendment.isAllowed(\'reset_state\')" ng-click="amendment.setState(null)">\n                  <i class="fa fa-exclamation-triangle"></i>\n                  <translate>Reset state</translate>\n                </a>\n              </li>\n            </ul>\n          </div>\n\n          \x3c!-- recommendation --\x3e\n          <div ng-if="config(\'motions_recommendations_by\')">\n            <span os-perms="!motions.can_manage">\n              <span ng-if="amendment.recommendation" class="label"\n                ng-class="\'label-\'+amendment.recommendation.css_class">\n                {{ amendment.getRecommendationName() }}\n              </span>\n              <span ng-if="!amendment.recommendation" class="label label-default"\n                uib-tooltip="{{ config(\'motions_recommendations_by\') }}" translate>\n                No recomendation set\n              </span>\n            </span>\n            <span os-perms="motions.can_manage" uib-dropdown>\n              <a class="pointer" uib-dropdown-toggle id="recommendationDropdown{{ amendment.id }}">\n                <span ng-if="amendment.recommendation" class="label"\n                  ng-class="\'label-\'+amendment.recommendation.css_class">\n                  {{ amendment.getRecommendationName() }}\n                </span>\n                <span ng-if="!amendment.recommendation" class="label label-default"\n                  uib-tooltip="{{ config(\'motions_recommendations_by\') }}" translate>\n                  No recomendation set\n                </span>\n              </a>\n              <ul class="dropdown-menu" aria-labelledby="recommendationDropdown{{ amendment.id }}">\n                <li ng-repeat="recommendation in amendment.state.getRecommendations()">\n                  <a href ng-click="amendment.setRecommendation(recommendation.id)">\n                    {{ recommendation.recommendation_label | translate }}\n                  </a>\n                </li>\n                <li class="divider" ng-if="amendment.state.getRecommendations().length && amendment.recommendation"></li>\n                <li ng-if="amendment.recommendation">\n                  <a href ng-click="amendment.setRecommendation(null)">\n                    <i class="fa fa-exclamation-triangle"></i>\n                    <translate>Reset recommendation</translate>\n                  </a>\n                </li>\n              </ul>\n            </span>\n          </div>\n          \x3c!-- Submitters --\x3e\n          <div ng-if="amendment.submitters.length">\n            <small>\n              <span class="optional" translate>by</span>\n              <span class="optional" ng-repeat="submitter in amendment.submitters | orderBy: \'weight\' | limitTo:1">\n                {{ submitter.user.get_full_name() }}<span ng-if="!$last">,</span></span><span ng-if="amendment.submitters.length > 1">,\n                ... [+{{ amendment.submitters.length - 1 }}]</span>\n              \x3c!-- sorry for merging them together, but otherwise there would be a whitespace because of the new line --\x3e\n            </small>\n          </div>\n          \x3c!-- hover menu --\x3e\n          <div ng-if="amendment.isAllowed(\'update\')">\n            <small>\n              <a href="" ng-click="openDialog(amendment)" translate>Edit</a>\n              <span ng-if="amendment.isAllowed(\'update_submitters\')"> &middot;\n                <a ui-sref="motions.motion.submitters({id: amendment.id})" translate>\n                  Edit submitters\n                </a>\n              </span>\n              <span ng-if="amendment.isAllowed(\'delete\')"> &middot;\n                <a href="" class="text-danger"\n                    ng-bootbox-confirm="{{ \'Are you sure you want to delete this entry?\' | translate }}<br><b>{{ amendment.getTitle() }}</b>"\n                    ng-bootbox-confirm-action="delete(amendment)" translate>Delete</a>\n              </span>\n            </small>\n          </div>\n        </div>\n      </div>\n      <div class="col-xs-6 col-space">\n        \x3c!-- The diff --\x3e\n        <section class="motion-text-holder" ng-if="amendment.isParagraphBasedAmendment()"\n          ng-init="paragraphs = amendment.getAmendmentParagraphsLinesDiff()">\n          <div ng-if="!paragraphs.length" translate>\n            No changes at the text.\n          </div>\n          <div ng-repeat="paragraph in paragraphs" class="motion-text motion-text-diff line-numbers-none">\n            <div ng-bind-html="paragraph.text | trusted"></div>\n          </div>\n        </section> \x3c!-- Diff end --\x3e\n        <div ng-if="!amendment.isParagraphBasedAmendment()">\n          {{ getTextPreview(amendment.getText(), 400) }}\n        </div>\n      </div>\n      \x3c!-- last column --\x3e\n      <div class="col-xs-4 content" ng-style="{\'width\': isSelectMode ? \'calc(33.33% - 120px)\' : \'calc(33.33% - 70px)\'}">\n        <div style="width: 90%;">\n          <div ng-repeat="(id, field) in noSpecialCommentsFields">\n            <div class="nobr" style="overflow: hidden;">\n              <i class="fa pointer spacer-right" ng-class="field[amendment.id] ? \'fa-caret-down\' : \'fa-caret-right\'"\n                ng-click="field[amendment.id] = !field[amendment.id]"\n                ng-if="isTextExpandable(amendment.comments[id], 30)"></i>\n              <strong>{{ field.name }}</strong>\n            </div>\n            <div ng-if="!field[amendment.id]">\n              {{ getTextPreview(amendment.comments[id], 30) }}\n            </div>\n            <div ng-if="field[amendment.id]" ng-bind-html="amendment.comments[id]"></div>\n          </div>\n\n          <div class="spacer-top" os-perms="motions.can_manage">\n            <button class="btn-link" ng-click="createModifiedAmendment(amendment)">\n              <translate>Create modified amendment</translate>\n            </button>\n          </div>\n        </div>\n\n        <div class="pull-right" style="width: 10%;">\n          <div class="centered" ng-if="config(\'motions_min_supporters\') != 0"\n            uib-tooltip="{{ amendment.supporters.length }} {{ \'Supporters\' | translate }}\n            {{ (config(\'motions_min_supporters\') - amendment.supporters.length) > 0 ? \'(\' +  (config(\'motions_min_supporters\') - amendment.supporters.length) + \' \' + (\'needed\' | translate) + \')\': \'\' }}"\n            tooltip-class="nobr">\n            <span class="badge"\n              ng-class="amendment.supporters.length < config(\'motions_min_supporters\') ? \'badge-info\' : \'badge-success\'">\n              {{ amendment.supporters.length }}\n            </span>\n          </div>\n        </div>\n\n      </div>\n    </div>\n\n    <ul uib-pagination\n        ng-show="amendmentsFiltered.length > pagination.itemsPerPage"\n        total-items="amendmentsFiltered.length"\n        items-per-page="pagination.itemsPerPage"\n        ng-model="pagination.currentPage"\n        ng-change="pagination.pageChanged()"\n        class="pagination-sm"\n        direction-links="false"\n        boundary-links="true"\n        first-text="&laquo;"\n        last-text="&raquo;">\n    </ul>\n\n  </div> \x3c!-- container --\x3e\n</div>\n</div>\n</div>\n'),n.put("motions/static/templates/motions/motion-block-detail.html",'<div class="header">\n  <div class="title">\n    <div class="submenu">\n      <a ui-sref="motions.motionBlock.list" class="btn btn-sm btn-default">\n        <i class="fa fa-angle-double-left fa-lg"></i>\n        <translate>Back to overview</translate>\n      </a>\n      \x3c!-- List of speakers --\x3e\n      <a ui-sref="agenda.item.detail({id: motionBlock.agenda_item_id})" class="btn btn-sm btn-default">\n        <i class="fa fa-microphone fa-lg"></i>\n        <translate>List of speakers</translate>\n      </a>\n      \x3c!-- project --\x3e\n      <projector-button model="motionBlock" default-projector-id="defaultProjectorId">\n      </projector-button>\n      \x3c!-- edit --\x3e\n      <a ng-click="openDialog(motionBlock)"\n          os-perms="motions.can_manage"\n          class="btn btn-default btn-sm"\n          title="{{ \'Edit\' | translate}}">\n        <i class="fa fa-pencil"></i>\n      </a>\n    </div>\n    <h1>{{ motionBlock.agenda_item.getTitle() }}</h1>\n    <h2 translate>Motion block</h2>\n  </div>\n</div>\n\n<div class="details">\n  <a os-perms="motions.can_manage" class="btn btn-default btn btn-sm"\n      ng-bootbox-confirm="{{ \'Are you sure you want to override the state of all motions of this motion block?\' | translate }}"\n      ng-bootbox-confirm-action="followRecommendations()">\n    <i class="fa fa-magic fa-lg"></i>\n    <translate>Follow recommendations for all motions</translate>\n  </a>\n\n  <div class="row spacer form-group">\n    <div class="col-sm-4 pull-right">\n      <input type="text" ng-model="filter.search" class="form-control"\n          placeholder="{{ \'Filter\' | translate }}">\n    </div>\n    <div class="col-sm-4 italic">\n      {{ motionsFiltered.length }} /\n      {{ motionBlock.motions.length }} {{ "motions" | translate }}\n    </div>\n  </div>\n\n  <table class="table table-striped table-bordered table-hover">\n    <thead>\n      <tr>\n        <th><translate>Motion</translate>\n        <th><translate>State</translate>\n        <th><translate>Recommendation</translate>\n    <tbody>\n      <tr ng-repeat="motion in motionsFiltered = (motionBlock.motions | filter: filter.search | orderBy: \'identifier\')">\n        <td ng-mouseover="motion.hover=true" ng-mouseleave="motion.hover=false">\n          <strong>\n            <a ui-sref="motions.motion.detail({id: motion.id})">{{ motion.identifier }} {{ motion.getTitle() }}</a>\n          </strong>\n          <div os-perms="motions.can_manage" class="hoverActions" ng-class="{\'hiddenDiv\': !motion.hover}">\n            \x3c!-- delete --\x3e\n            <a href="" class="text-danger"\n              ng-bootbox-confirm="{{ \'Are you sure you want to remove this motion from motion block?\' | translate }}<br>\n                <b>{{ motion.getTitle() }}</b>"\n              ng-bootbox-confirm-action="delete(motion)" translate>Remove from motion block</a>\n          </div>\n        <td>\n          <div class="label" ng-class="\'label-\'+motion.state.css_class">\n            {{ motion.getStateName() }}\n          </div>\n        <td>\n          <div class="label" ng-class="\'label-\'+motion.recommendation.css_class">\n            {{ motion.getRecommendationName() }}\n          </div>\n  </table>\n</div>\n'),n.put("motions/static/templates/motions/motion-block-form.html",'<h1 ng-if="model.id" translate>Edit motion block</h1>\n<h1 ng-if="!model.id" translate>New motion block</h1>\n\n<div uib-alert ng-show="alert.show" ng-class="\'alert-\' + (alert.type || \'warning\')" close="alert={}">\n  {{ alert.msg }}\n</div>\n\n<form name="motionBlockForm" ng-submit="save(model)">\n  <formly-form model="model" fields="formFields">\n    <button type="submit" ng-disabled="motionBlockForm.$invalid" class="btn btn-primary" translate>\n      Save\n    </button>\n    <button ng-click="closeThisDialog()" class="btn btn-default" translate>\n      Cancel\n    </button>\n  </formly-form>\n</form>\n'),n.put("motions/static/templates/motions/motion-block-list.html",'<div class="header">\n  <div class="title">\n    <div class="submenu">\n      <a ui-sref="motions.motion.list" class="btn btn-sm btn-default">\n        <i class="fa fa-angle-double-left fa-lg"></i>\n        <translate>Back to overview</translate>\n      </a>\n      <a ng-click="openFormDialog()" os-perms="motions.can_manage" class="btn btn-primary btn-sm">\n        <i class="fa fa-plus fa-lg"></i>\n        <translate>New</translate>\n      </a>\n    </div>\n    <h1 translate>Motion blocks</h1>\n  </div>\n</div>\n\n<div class="details">\n  <div class="row form-group">\n    <div class="col-sm-4 pull-right">\n      <input type="text" ng-model="filter.search" class="form-control"\n          placeholder="{{ \'Filter\' | translate }}">\n    </div>\n  </div>\n\n  <table class="table table-striped table-bordered table-hover">\n    <thead>\n      <tr>\n        <th os-perms="core.can_manage_projector" class="minimum">\n        <th><translate>Name</translate>\n        <th><translate>Motions</translate>\n    <tbody>\n      <tr ng-repeat="motionBlock in motionBlocks | filter: filter.search | orderBy: \'title\'">\n        <td os-perms="core.can_manage_projector">\n          <projector-button model="motionBlock" default-projector-id="defaultProjectorId">\n          </projector-button>\n        <td ng-mouseover="motionBlock.hover=true" ng-mouseleave="motionBlock.hover=false">\n          <strong>\n            <a ui-sref="motions.motionBlock.detail({id: motionBlock.id})">{{ motionBlock.title }}</a>\n          </strong>\n          <div os-perms="motions.can_manage"  class="hoverActions" ng-class="{\'hiddenDiv\': !motionBlock.hover}">\n            \x3c!-- edit --\x3e\n            <a href="" ng-click="openFormDialog(motionBlock)" translate>Edit</a> |\n            \x3c!-- delete --\x3e\n            <a href="" class="text-danger"\n              ng-bootbox-confirm="{{ \'Are you sure you want to delete this entry?\' | translate }}<br>\n                <b>{{ motionBlock.name }}</b>"\n              ng-bootbox-confirm-action="delete(motionBlock)" translate>Delete</a>\n          </div>\n        <td>\n          {{ motionBlock.motions.length }}\n  </table>\n</div>\n'),
n.put("motions/static/templates/motions/motion-comment-form.html",'<h1>{{ title }}</h1>\n\n<div uib-alert ng-show="alert.show" ng-class="\'alert-\' + (alert.type || \'warning\')" close="alert={}">\n  {{ alert.msg }}\n</div>\n\n<form name="motionCommentForm" ng-submit="save(model)" novalidate>\n  <formly-form model="model" fields="formFields">\n    <button type="submit" ng-disabled="motionCommentForm.$invalid" class="btn btn-primary" translate>\n      Save\n    </button>\n    <button type="button" ng-click="closeThisDialog()" class="btn btn-default" translate>\n      Cancel\n    </button>\n  </formly-form>\n</form>\n'),
n.put("motions/static/templates/motions/motion-detail.html",'<div class="header motion-header">\n  <div class="title">\n    <div class="submenu">\n      <a ng-if="motion.isAmendment" ui-sref="motions.motion.amendment-list({id: motion.getParentMotion().id })"\n        class="btn btn-sm btn-default">\n        <i class="fa fa-angle-double-left fa-lg"></i>\n        <translate>Back to overview</translate>\n      </a>\n      <a ng-if="!motion.isAmendment" ui-sref="motions.motion.list"\n        class="btn btn-sm btn-default">\n        <i class="fa fa-angle-double-left fa-lg"></i>\n        <translate>Back to overview</translate>\n      </a>\n      <a ng-if="motion.hasAmendments()" ui-sref="motions.motion.amendment-list({id: motion.id})"\n        class="btn btn-sm btn-default">\n        <i class="fa fa-book fa-lg"></i>\n        <translate>Amendments</translate>\n      </a>\n      \x3c!-- List of speakers --\x3e\n      <a ui-sref="agenda.item.detail({id: motion.agenda_item_id})"\n          os-perms="agenda.can_see" class="btn btn-sm btn-default">\n        <i class="fa fa-microphone fa-lg"></i>\n        <translate>List of speakers</translate>\n      </a>\n      \x3c!-- project button --\x3e\n      <div class="btn-group button" uib-dropdown\n           uib-tooltip="{{ \'Projector\' | translate }} {{ motion.isProjected()[0] || \'\' }} ({{ projectionMode.label | translate }})"\n        tooltip-enable="motion.isProjected().length"\n        os-perms="core.can_manage_projector">\n        <button type="button" class="btn btn-default btn-sm"\n            title="{{ \'Project\' | translate }}"\n            ng-click="motion.project(defaultProjectorId, projectionMode.mode)"\n            ng-class="{ \'btn-primary\': motion.isProjected().length && inArray(motion.isProjected(), defaultProjectorId)}">\n          <i class="fa fa-video-camera"></i>\n        </button>\n        <button type="button" class="btn btn-default btn-sm slimDropDown" uib-dropdown-toggle\n            ng-if="projectors.length > 1 || has_proposed_changes"\n            ng-class="{ \'btn-primary\': motion.isProjected().length && !inArray(motion.isProjected(), defaultProjectorId)}">\n          <span class="caret"></span>\n        </button>\n        <ul class="dropdown-menu" role="menu" aria-labelledby="split-button"\n          ng-if="projectors.length > 1 || has_proposed_changes">\n          <li role="menuitem" ng-repeat="mode in projectionModes" ng-if="has_proposed_changes">\n            <a href="" ng-click="setProjectionMode(mode); $event.stopPropagation();">\n              <i class="fa" ng-class="mode.mode == $parent.projectionMode.mode ? \'fa-check-square-o\' : \'fa-square-o\'"></i>\n              <span ng-if="mode.mode!=\'agreed\'">{{ mode.label | translate }}</span>\n              <span ng-if="mode.mode==\'agreed\'"><translate translate-context="resolution">Final version</translate></span>\n            </a>\n          </li>\n          <li class="divider" ng-show="projectors.length > 1 && has_proposed_changes"></li>\n          <li role="menuitem" ng-repeat="projector in projectors | orderBy:\'id\'" ng-show="projectors.length > 1">\n            <a href="" ng-click="motion.project(projector.id, projectionMode.mode)"\n              ng-class="{ \'projected\': inArray(motion.isProjected(), projector.id) }">\n              <i class="fa fa-video-camera" ng-show="inArray(motion.isProjected(), projector.id) "></i>\n              {{ projector.name | translate }}\n              <span ng-if="projector.id === defaultProjectorId">(<translate>Default</translate>)</span>\n            </a>\n          </li>\n        </ul>\n      </div>\n      \x3c!-- edit --\x3e\n      <a ng-if="motion.isAllowed(\'update\')" ng-click="openDialog(motion)"\n          class="btn btn-default btn-sm"\n          title="{{ \'Edit\' | translate}}">\n        <i class="fa fa-pencil"></i>\n      </a>\n      \x3c!-- pdf --\x3e\n      <a ng-click="pdfExport()" class="btn btn-default btn-sm"\n          title="{{ \'Export as PDF\' | translate}}">\n        <i class="fa fa-file-pdf-o fa-lg"></i>\n        <translate>PDF</translate>\n      </a>\n    </div>\n\n    <h1 class="motion-title">\n        <span ng-if="!motion.isAmendment && viewChangeRecommendations.mode == \'original\'">\n          <span class="title-change-indicator" ng-if="title_change_recommendation"\n                ng-click="viewChangeRecommendations.scrollToDiffBox(title_change_recommendation.id)"></span>\n          <span class="change-title" ng-if="motion.isAllowed(\'update\') && !title_change_recommendation"></span>\n        </span>\n\n        {{ motion.getTitleWithChanges(viewChangeRecommendations.mode) }}\n\n        <i class="fa pointer" ng-class="motion.personalNote.star ? \'fa-star\' : \'fa-star-o\'"\n           ng-if="operator.user"\n           title="{{ \'Set as favorite\' | translate }}" ng-click="toggleStar()"></i>\n    </h1>\n\n    <div class="row">\n      <div class="col-sm-6">\n        <h2>\n            <translate>Motion</translate> {{ motion.identifier }}\n            <span ng-if="motion.versions.length > 1" >| Version {{ motion.getVersion(version).version_number }}</span>\n            <span ng-if="motion.active_version != version" class="label label-warning">\n              <i class="fa fa-exclamation-triangle"></i>\n              <translate>This version is not permitted.</translate>\n            </span>\n            <small>\n              <translate>Sequential number</translate> {{ motion.getSequentialNumber() }}\n\n              <span ng-if="motion.isAmendment">\n                &middot;\n                <a ui-sref="motions.motion.detail({id: motion.getParentMotion().id })" ng-if="motion.isAmendment">\n                  <translate>Amendment to</translate>\n                  {{ motion.getParentMotion().identifier || motion.getParentMotion().getTitle() }}\n                </a>\n              </span>\n            </small>\n        </h2>\n      </div>\n      <div class="col-sm-6">\n        <span class="pull-right" ng-if="navigation.count > 2">\n          <a ui-sref="motions.motion.detail({id: navigation.previousMotion.id})"\n            class="btn btn-default btn-sm" ng-disabled="!navigation.previousMotion">\n            <i class="fa fa-angle-double-left"></i>\n            <translate>Motion</translate> {{ navigation.previousMotion.identifier }}\n          </a>\n          <a ui-sref="motions.motion.detail({id: navigation.nextMotion.id})"\n            class="btn btn-default btn-sm" ng-disabled="!navigation.nextMotion">\n            <translate>Motion</translate> {{ navigation.nextMotion.identifier }}\n            <i class="fa fa-angle-double-right"></i>\n          </a>\n        </span>\n      </div>\n    </div>\n  </div>\n</div>\n\n<div class="meta motion-detail">\n  <div class="title" ng-click="isMeta = !isMeta">\n    <div class="name">\n      <i class="fa fa-info-circle"></i>\n      <translate>Meta information</translate>\n    </div>\n    <div class="icon">\n      <i class="fa fa-lg" ng-class="isMeta ? \'fa-angle-down\' : \'fa-angle-up\'"></i>\n    </div>\n  </div>\n  <div class="detail" uib-collapse="isMeta">\n    <div class="row">\n      <div class="col-sm-4">\n          \x3c!-- submitters --\x3e\n          <h3 ng-if="!motion.isAllowed(\'update_submitters\')" class="heading" translate>Submitters</h3>\n          <h3 ng-if="motion.isAllowed(\'update_submitters\')" class="heading">\n            <translate>Submitters</translate>\n            <a ui-sref="motions.motion.submitters({id: motion.id})" uib-tooltip="{{ \'Sort submitters\' | translate }}">\n              <i class="fa fa-cog"></i>\n            </a>\n          </h3>\n          <div ng-repeat="submitter in motion.submitters | orderBy: \'weight\'">\n            {{ submitter.user.get_full_name() }}\n          </div>\n\n          \x3c!-- supporters --\x3e\n          <div ng-if="config(\'motions_min_supporters\') > 0">\n            <h3 translate>Supporters</h3>\n            <ol>\n              <li ng-repeat="supporters in motion.supporters">\n                {{ supporters.get_full_name() }}\n            </ol>\n            \x3c!-- support button --\x3e\n            <button ng-if="motion.isAllowed(\'support\')" ng-click="support()" class="btn btn-default btn-sm">\n              <i class="fa fa-heart"></i>\n              <translate>Support motion</translate>\n            </button>\n            \x3c!-- unsupport button --\x3e\n            <button ng-if="motion.isAllowed(\'unsupport\')" ng-click="unsupport()" class="btn btn-default btn-sm">\n              <i class="fa fa-heart-o"></i>\n              <translate>Unsupport motion</translate>\n            </button>\n          </div>\n\n          \x3c!-- Amendments --\x3e\n          <div ng-if="!motion.isAmendment && motion.isAllowed(\'can_see_amendments\')">\n            <h3 translate>Amendments</h3>\n            <a ng-if="motion.hasAmendments()" ui-sref="motions.motion.amendment-list({id: motion.id})">\n              {{ motion.getAmendments().length }} {{ (motion.getAmendments().length === 1 ? \'Amendment\' : \'Amendments\') | translate }}<br>\n            </a>\n            <button ng-if="motion.isAllowed(\'can_create_amendment\')" ng-click="newAmendment()" class="btn btn-default btn-sm">\n              <i class="fa fa-plus"></i>\n              <translate>New amendment</translate>\n            </button>\n          </div>\n      </div>\n      <div class="col-sm-4">\n          \x3c!-- State --\x3e\n          <h3 ng-if="!motion.isAllowed(\'change_state\')" class="heading" translate>State</h3>\n          <div ng-if="motion.isAllowed(\'change_state\')" class="heading">\n            <span uib-dropdown>\n              <span id="state-dropdown" class="drop-down-name pointer" uib-dropdown-toggle>\n                <translate>State</translate>\n                <i class="fa fa-cog"></i>\n              </span>\n              <ul uib-dropdown-menu class="dropdown-menu" aria-labelledby="state-dropdown">\n                <li ng-repeat="state in motion.state.getNextStates()">\n                  <a href ng-click="motion.setState(state.id)">\n                    {{ state.action_word | translate }}\n                    <span ng-if="state.show_state_extension_field">...</span>\n                  </a>\n                <li class="divider" ng-if="motion.state.getNextStates().length && motion.isAllowed(\'reset_state\')">\n                <li ng-if="motion.isAllowed(\'reset_state\')">\n                  <a href ng-click="motion.setState(null)">\n                    <i class="fa fa-exclamation-triangle"></i>\n                    <translate>Reset state</translate>\n                  </a>\n              </ul>\n            </span>\n          </div>\n          <div class="label" ng-class="\'label-\'+motion.state.css_class">\n            {{ motion.getStateName() }}\n          </div>\n          <div os-perms="motions.can_manage" class="input-group spacer"\n              ng-show="motion.state.show_state_extension_field">\n            <label class="sr-only" for="stateExtensionField">{{ commentsFields[commentFieldForStateId].name }}</label>\n            <input type="text" ng-model="stateExtension"\n                id="stateNameExtensionField" class="form-control input-sm"\n                placeholder="{{ commentsFields[commentFieldForStateId].name }}">\n            <span class="input-group-btn">\n              <button ng-click="saveAdditionalStateField(stateExtension)" class="btn btn-default btn-sm">\n                <i class="fa fa-check"></i>\n              </button>\n            </span>\n          </div>\n\n          \x3c!-- Recommendation --\x3e\n          <div ng-if="config(\'motions_recommendations_by\')">\n            <h3 ng-if="!motion.isAllowed(\'change_recommendation\')" class="heading">\n              {{ config(\'motions_recommendations_by\') }}\n            </h3>\n            <div ng-if="motion.isAllowed(\'change_recommendation\')" class="heading">\n              <span uib-dropdown>\n                <span id="recommendation-dropdown" class="drop-down-name pointer" uib-dropdown-toggle>\n                  {{ config(\'motions_recommendations_by\') | translate }}\n                  <i class="fa fa-cog"></i>\n                </span>\n                <ul uib-dropdown-menu class="dropdown-menu" aria-labelledby="recommendation-dropdown">\n                  <li ng-repeat="recommendation in motion.state.getRecommendations()">\n                    <a href ng-click="motion.setRecommendation(recommendation.id)">\n                      {{ recommendation.recommendation_label | translate }}\n                      <span ng-if="recommendation.show_recommendation_extension_field">...</span>\n                    </a>\n                  <li class="divider" ng-if="motion.state.getRecommendations().length && motion.recommendation">\n                  <li ng-if="motion.recommendation">\n                    <a href ng-click="motion.setRecommendation(null)">\n                      <i class="fa fa-exclamation-triangle"></i>\n                      <translate>Reset recommendation</translate>\n                    </a>\n                </ul>\n              </span>\n            </div>\n            <div class="label" ng-if="motion.recommendation" ng-class="\'label-\'+motion.recommendation.css_class">\n              {{ motion.getRecommendationName() }}\n            </div>\n            <div os-perms="motions.can_manage" class="input-group spacer"\n                ng-show="motion.recommendation.show_recommendation_extension_field">\n              <label class="sr-only" for="recommendationExtensionField">\n                {{ commentsFields[commentFieldForRecommendationId].name }}\n              </label>\n              <input type="text" ng-model="$parent.$parent.recommendationExtension"\n                  id="recommendationExtensionField" class="form-control input-sm"\n                  placeholder="{{ commentsFields[commentFieldForRecommendationId].name }}">\n              <span class="input-group-btn">\n                <button ng-click="saveAdditionalRecommendationField(recommendationExtension)" class="btn btn-default btn-sm">\n                  <i class="fa fa-check"></i>\n                </button>\n              </span>\n              <span class="input-group-btn">\n                <span uib-dropdown>\n                  <span id="motion-dropdown" class="drop-down-name btn btn-default btn-sm" uib-dropdown-toggle>\n                    <i class="fa fa-plus"></i>\n                    <translate>Motion</translate>\n                  </span>\n                  <ul uib-dropdown-menu class="dropdown-menu" aria-labelledby="motion-dropdown">\n                    <li ng-repeat="m in motions | orderBy: \'identifier\'">\n                      <a href ng-click="addMotionToRecommendationField(m)">\n                        {{ m.identifier ? m.identifier + \':\' : \'\' }}\n                        {{ m.getTitle() | limitTo: 35 }}{{ m.getTitle().length > 35 ? \'...\' : \'\' }}\n                      </a>\n                    </li>\n                  </ul>\n                </span>\n              </span>\n            </div>\n            <button\n                ng-if="motion.recommendation &&\n                       motion.isAllowed(\'change_state\') &&\n                       motion.state.next_states_id.indexOf(motion.recommendation.id) !== -1"\n                ng-click="followRecommendation()"\n                class="btn btn-default btn-sm">\n              <i class="fa fa-magic"></i>\n              <translate>Follow recommendation</translate>\n            </button>\n          </div>\n\n          \x3c!-- Category --\x3e\n          <h3 class="heading" os-perms="!motions.can_manage" ng-show="motion.category" translate>Category</h3>\n          <div class="heading" os-perms="motions.can_manage" ng-show="categories.length > 0">\n            <span uib-dropdown>\n              <span id="category-dropdown" class="drop-down-name pointer" uib-dropdown-toggle>\n                <translate>Category</translate>\n                <i class="fa fa-cog"></i>\n              </span>\n              <ul class="dropdown-menu" aria-labelledby="category-dropdown">\n                <li ng-repeat="category in categories | orderBy: config(\'motions_export_category_sorting\')">\n                  <a href ng-click="toggleCategory(category)">\n                    <i class="fa fa-check" ng-if="category.id == motion.category.id"></i>\n                    {{ category.prefix }} &ndash; {{ category.name }}\n                  </a>\n                </li>\n              </ul>\n            </span>\n          </div>\n          <div ng-show="motion.category">\n            {{ motion.category.prefix }} &ndash; {{ motion.category.name }}\n          </div>\n\n          \x3c!-- Motion block --\x3e\n          <h3 class="heading" os-perms="!motions.can_manage" ng-show="motion.motionBlock" translate>Motion block</h3>\n          <div class="heading" os-perms="motions.can_manage" ng-show="motionBlocks.length > 0">\n            <span uib-dropdown>\n              <span id="motionBlock-dropdown" class="drop-down-name pointer" uib-dropdown-toggle>\n                <translate>Motion block</translate>\n                <i class="fa fa-cog"></i>\n              </span>\n              <ul class="dropdown-menu" aria-labelledby="motionBlock-dropdown">\n                <li ng-repeat="motionBlock in motionBlocks">\n                  <a href ng-click="toggleMotionBlock(motionBlock)">\n                    <i class="fa fa-check" ng-if="motionBlock.id == motion.motionBlock.id"></i>\n                    {{ motionBlock.title }}\n                  </a>\n                </li>\n              </ul>\n            </span>\n          </div>\n          <a ui-sref="motions.motionBlock.detail({id: motion.motionBlock.id})"\n              os-perms="motions.can_manage">{{ motion.motionBlock.title }}</a>\n          <span os-perms="!motions.can_manage">{{ motion.motionBlock.title }}</span>\n\n          \x3c!-- Tags --\x3e\n          <h3 class="heading" os-perms="!motions.can_manage" ng-show="motion.tags.length" translate>Tags</h3>\n          <div class="heading" os-perms="motions.can_manage" ng-show="tags.length > 0">\n            <span uib-dropdown>\n              <span id="tag-dropdown" class="drop-down-name pointer" uib-dropdown-toggle>\n                <translate>Tags</translate>\n                <i class="fa fa-cog"></i>\n              </span>\n              <ul class="dropdown-menu" aria-labelledby="tag-dropdown">\n                <li ng-repeat="tag in tags">\n                  <a href ng-click="toggleTag(tag)">\n                    <i class="fa fa-check" ng-if="inArray(motion.tags_id, tag.id)"></i>\n                    {{ tag.name }}\n                  </a>\n                </li>\n              </ul>\n            </span>\n          </div>\n          <span ng-repeat="tag in motion.tags">\n            {{ tag.name }}{{$last ? \'\' : \', \'}}\n          </span>\n\n          \x3c!-- Origin --\x3e\n          <h3 ng-if="motion.origin" translate>Origin</h3>\n          {{ motion.origin }}\n\n      </div>\n      <div class="col-sm-4">\n          <h3 ng-if="motion.polls.length > 0" translate>Voting result</h3>\n          <template-hook hook-name="motionPollVotingHeader"></template-hook>\n          <ol>\n            <li ng-controller="MotionPollDetailCtrl" ng-repeat="poll in motion.polls" class="spacer"\n                ng-if="poll.has_votes || operator.hasPerms(\'motions.can_manage\')">\n              <strong translate-comment=\'ballot of a motion\' translate>Vote</strong>\n\n              \x3c!-- Edit poll --\x3e\n              <button os-perms="motions.can_manage" ng-click="openPollDialog(poll, $index+1)"\n                  class="btn btn-default btn-xs" title="{{ \'Edit\' | translate }}">\n                <i class="fa fa-pencil"></i>\n              </button>\n\n              \x3c!-- Delete poll --\x3e\n              <button os-perms="motions.can_manage" class="btn btn-default btn-xs"\n                  ng-bootbox-confirm="{{ \'Are you sure you want to delete this poll?\' | translate }}"\n                  ng-bootbox-confirm-action="delete_poll(poll)"\n                  title="{{ \'Delete\' | translate }}">\n                <i class="fa fa-times"></i>\n              </button>\n\n              \x3c!-- Print poll PDF --\x3e\n              <a os-perms="motions.can_manage" ng-click="createPollPdf()" class="btn btn-default btn-xs"\n                  title="{{ \'Print ballot paper\' | translate }}">\n                <i class="fa fa-file-pdf-o"></i>\n              </a>\n\n              \x3c!-- Template hook for motion poll buttons --\x3e\n              <template-hook hook-name="motionPollSmallButtons"></template-hook>\n\n              \x3c!-- Poll results --\x3e\n              <div ng-show="poll.has_votes" class="pollresults">\n                <table class="table">\n                  \x3c!-- yes --\x3e\n                  <tr>\n                    <td class="icon">\n                      <i class="fa fa-thumbs-up fa-2x"></i>\n                    <td ng-init="voteYes = poll.getVote(poll.yes, \'yes\')">\n                      <span class="result-label"><translate>Yes</translate>:</span>\n                      <span class="result_value">\n                        {{ voteYes.value | number:votesPrecision }} {{ voteYes.percentStr }}\n                      </span>\n                      <div ng-if="voteYes.percentNumber">\n                        <uib-progressbar value="voteYes.percentNumber" type="success"></uib-progressbar>\n                      </div>\n                  \x3c!-- no --\x3e\n                  <tr>\n                    <td class="icon">\n                      <i class="fa fa-thumbs-down fa-2x"></i>\n                    <td ng-init="voteNo = poll.getVote(poll.no, \'no\')">\n                      <span class="result-label"><translate>No</translate>:</span>\n                      <span class="result_value" >\n                        {{ voteNo.value | number:votesPrecision }} {{ voteNo.percentStr }}\n                      </span>\n                      <div ng-if="voteNo.percentNumber">\n                        <uib-progressbar value="voteNo.percentNumber" type="danger"></uib-progressbar>\n                      </div>\n                  \x3c!-- abstain --\x3e\n                  <tr>\n                    <td class="icon">\n                      <strong style="font-size: 26px">&empty;</strong>\n                    <td ng-init="voteAbstain = poll.getVote(poll.abstain, \'abstain\')">\n                      <span class="result-label"><translate>Abstain</translate>:</span>\n                      <span class="result_value">\n                        {{ voteAbstain.value | number:votesPrecision }} {{ voteAbstain.percentStr }}\n                      </span>\n                      <div ng-if="voteAbstain.percentNumber">\n                        <uib-progressbar value="voteAbstain.percentNumber" type="warning"></uib-progressbar>\n                      </div>\n                  \x3c!-- valid votes --\x3e\n                  <tr ng-if="poll.votesvalid !== null">\n                    <td class="icon">\n                      <i class="fa fa-check fa-lg"></i>\n                    <td ng-init="votesValid = poll.getVote(poll.votesvalid, \'votesvalid\')">\n                      <span class="result-label"><translate>Valid votes</translate>:</span>\n                      <span class="result_value">\n                        {{ votesValid.value | number:votesPrecision }} {{ votesValid.percentStr }}\n                      </span>\n                  \x3c!-- invalid votes --\x3e\n                  <tr ng-if="poll.votesinvalid !== null">\n                    <td class="icon">\n                      <i class="fa fa-ban fa-lg"></i>\n                    <td ng-init="votesInvalid = poll.getVote(poll.votesinvalid, \'votesinvalid\')">\n                      <span class="result-label"><translate>Invalid votes</translate>:</span>\n                      <span class="result_value">\n                        {{ votesInvalid.value | number:votesPrecision }} {{ votesInvalid.percentStr }}\n                      </span>\n                  \x3c!-- votes cast --\x3e\n                  <tr class="total" ng-if="poll.votescast !== null">\n                    <td class="icon">\n                      <strong style="font-size: 16px">&sum;</strong>\n                    <td ng-init="votesCast = poll.getVote(poll.votescast, \'votescast\')">\n                      <span class="result-label"><translate>Votes cast</translate>:</span>\n                      <span class="result_value">\n                        {{ votesCast.value | number:votesPrecision }} {{ votesCast.percentStr }}\n                      </span>\n\n                  \x3c!-- majority calculation --\x3e\n                  <tr>\n                    <td>\n                    <td>\n                      <div os-perms="motions.can_manage"\n                           ng-hide="hideMajorityCalculation()"\n                           ng-cloak>\n                        <div class="input-group">\n                          <span><translate>Required majority</translate>: </span>\n                          <select ng-model="$parent.method"\n                                  ng-options="option.value as option.display_name | translate for option in methodChoices">\n                        </div>\n                      </div>\n                  <tr>\n                    <td>\n                    <td>\n                      <div os-perms="motions.can_manage">\n                        <span class="text-success" ng-if="isReached() >= 0" translate>\n                          Quorum ({{ (voteYes.value - isReached()) | number:votesPrecision }}) reached.\n                        </span>\n                        <span class="text-danger" ng-if="isReached() < 0" translate>\n                          Quorum ({{ (voteYes.value - isReached()) | number:votesPrecision }}) not reached.\n                       </span>\n                      </div>\n\n                </table>\n          </ol>\n\n          <template-hook hook-name="motionPollNewVoteButton">\n            <button ng-if="motion.isAllowed(\'create_poll\')" ng-click="create_poll()" class="btn btn-default btn-sm">\n              <i class="fa fa-bar-chart fa-lg"></i>\n              <translate>New vote</translate>\n            </button>\n          </template-hook>\n\n          <div class="spacer-top pull-right nobr">\n            <a href ng-click="gotoPersonalNote()" translate>Personal note</a>\n            <span ng-click="pinPersonalNote()" class="spacer-left pointer" title="{{ \'Pin personal note\' || translate }}">\n              <i class="fa fa-thumb-tack" ng-class="{\'rotate-45-deg-right\': !personalNotePinned}"></i>\n            </span>\n          </div>\n      </div>\n    </div>\n  </div>\n</div>\n\n<div class="details">\n  <div class="row">\n\n    \x3c!-- Motion toolbar --\x3e\n    <ng-include src="\'static/templates/motions/motion-detail/toolbar.html\'" ng-if="!motion.isParagraphBasedAmendment()"></ng-include>\n\n    <div ng-class="{\'col-sm-8\': (lineNumberMode != \'outside\'), \'col-sm-12\': (lineNumberMode == \'outside\')}"\n         ng-if="!motion.isParagraphBasedAmendment()">\n\n      <ng-include ng-if="viewChangeRecommendations.mode == \'diff\'"\n          src="\'static/templates/motions/motion-detail/change-summary.html\'"></ng-include>\n\n      <div><p>{{ config(\'motions_preamble\') | translate }}</p></div>\n\n      <div class="motion-text-holder">\n\n        \x3c!-- Original view --\x3e\n        <ng-include src="\'static/templates/motions/motion-detail/view-original.html\'"></ng-include>\n\n        \x3c!-- Diff View --\x3e\n        <ng-include src="\'static/templates/motions/motion-detail/view-diff.html\'"></ng-include>\n\n        \x3c!-- Changed View --\x3e\n        <div ng-if="viewChangeRecommendations.mode == \'changed\'">\n          <div ng-bind-html="motion.getTextByMode(\'changed\', version, highlight) | trusted"\n               class="motion-text motion-text-changed line-numbers-{{ lineNumberMode }}"></div>\n\n          <div style="text-align: right;" ng-if="motion.state.versioning && (change_recommendations | filter:{motion_version_id:version}:true).length > 0">\n            <button class="btn btn-default"\n                    ng-bootbox-confirm="{{ \'Do you want to create a new version of this motion based on this changes?\' | translate }}"\n                    ng-bootbox-confirm-action="viewChangeRecommendations.newVersionIncludingChanges(motion, version, true)">\n              <i class="fa fa-file-text"></i>\n              <translate>New version on these changes</translate>\n            </button>\n          </div>\n        </div>\n\n        \x3c!-- Agreed View --\x3e\n        <div ng-if="viewChangeRecommendations.mode == \'agreed\'">\n          <div class="alert alert-danger" ng-if="changed_version_has_accepted_collissions">\n              <i class="fa fa-warning"></i>\n              <translate>\n                  At least two amendments or change recommendations affecting the same line are to be integrated.\n                  This leads to undeterministic results.\n                  Please resolve this conflict by not accepting multiple changes affecting the same line.\n              </translate>\n          </div>\n\n          <div style="text-align: right;" ng-if="(change_recommendations | filter:{motion_version_id:version}:true).length > 0">\n            <button class="btn btn-default btn-sm" os-perms="motions.can_manage"\n                    ng-bootbox-confirm="{{ \'Do you want to copy the final version to the final print template?\' | translate }}"\n                    ng-bootbox-confirm-action="viewChangeRecommendations.copyToModifiedFinalVersion(motion, version)">\n              <i class="fa fa-file-text"></i>\n              <translate>Create final print template</translate>\n            </button>\n          </div>\n\n          <div style="text-align: right;" ng-if="motion.state.versioning && (change_recommendations | filter:{motion_version_id:version}:true).length > 0">\n            <button class="btn btn-default btn-sm"\n                    ng-bootbox-confirm="{{ \'Do you want to create a new version of this motion based on this changes?\' | translate }}"\n                    ng-bootbox-confirm-action="viewChangeRecommendations.newVersionIncludingChanges(motion, version, false)">\n              <i class="fa fa-file-text"></i>\n              <translate>New version on these changes</translate>\n            </button>\n          </div>\n\n          <div ng-bind-html="motion.getTextByMode(\'agreed\', version, highlight) | trusted"\n               class="motion-text motion-text-changed line-numbers-{{ lineNumberMode }}"></div>\n        </div>\n\n        \x3c!-- modified agreed view --\x3e\n        <ng-include src="\'static/templates/motions/motion-detail/view-modified-agreed.html\'"></ng-include>\n\n      </div>\n    </div>\n\n    \x3c!-- Paragraph-based Amendments --\x3e\n    <ng-include src="\'static/templates/motions/motion-detail/amendment-paragraph-diff.html\'"></ng-include>\n\n  </div>\n  <div class="row">\n    <div class="col-md-8">\n      \x3c!-- reason --\x3e\n      <div ng-if="motion.getReason(version) != \'\'">\n        <h3 translate>Reason</h3>\n        <div id="reason-inline-editor" ng-bind-html="motion.getReason(version) | trusted"\n          contenteditable="{{ reasonInlineEditing.isEditable }}">\n        </div>\n      </div>\n\n      \x3c!-- attachments --\x3e\n      <h3 ng-if="motion.attachments.length > 0" translate>Attachments</h3>\n      <ul>\n        <li ng-repeat="attachment in motion.attachments">\n          <a href="{{ attachment.mediafileUrl }}" target="_blank">{{ attachment.title_or_filename }}</a>\n      </ul>\n\n      \x3c!-- version history --\x3e\n      <div ng-if="motion.versions.length > 1">\n        <h3 translate>Version history</h3>\n        <ul>\n          <li ng-repeat="version in motion.versions">\n              <span ng-if="$parent.version == version.id">\n                <strong><translate>Version</translate> {{ version.version_number }}</strong>\n              </span>\n              <a href="" ng-if="$parent.version != version.id" ng-click="showVersion(version)">\n                <translate>Version</translate> {{ version.version_number }}\n              </a>\n              \x3c!-- active version --\x3e\n              <i ng-if="motion.active_version == version.id" class="fa fa-star"\n                  title="{{ \'This is the last active version.\' | translate }}"></i>\n              \x3c!-- permit version --\x3e\n              <button os-perms="motions.can_manage" ng-show="motion.active_version != version.id"\n                  ng-click="permitVersion(version)"\n                  class="btn btn-default btn-xs" title="{{ \'Permit and activate\' | translate }}">\n                <i class="fa fa-check"></i>\n              </button>\n              \x3c!-- delete version --\x3e\n              <button os-perms="motions.can_manage" ng-show="motion.active_version != version.id"\n                  class="btn btn-default btn-xs"\n                  ng-bootbox-confirm="{{ \'Are you sure you want to delete this version?\' | translate }}<br>\n                      <strong><translate>Version</translate> {{ version.version_number }}</strong>"\n                  ng-bootbox-confirm-action="deleteVersion(version)"\n                  title="{{ \'Delete\' | translate }}">\n                <i class="fa fa-times"></i>\n              </button>\n            <br><translate>Last modified</translate>: {{ version.creation_time | date:\'yyyy-MM-dd HH:mm:ss\' }}\n        </ul>\n      </div>\n\n      \x3c!-- log --\x3e\n      <div os-perms="motions.can_manage">\n        <button type="button" class="btn btn-sm btn-default spacer" ng-click="isCollapsed = !isCollapsed" translate>\n          Show history\n        </button>\n        <div uib-collapse="isCollapsed">\n          <div class="well well-sm">\n            <ul class="list-unstyled">\n              <li ng-repeat="message in motion.log_messages">\n                <small>{{ message.message }}</small>\n              </li>\n            </ul>\n          </div>\n        </div>\n      </div>\n    </div>\n\n  </div>\n</div>\n\n\x3c!-- Comments section --\x3e\n<ng-include src="\'static/templates/motions/motion-detail/comments.html\'"></ng-include>\n\n\x3c!-- Personal note section --\x3e\n<ng-include src="\'static/templates/motions/motion-detail/personal-note.html\'" ng-if="operator.user"></ng-include>\n\n<template-hook hook-name="motionDetailViewDetailContainer"></template-hook>\n'),
n.put("motions/static/templates/motions/motion-export-form.html",'<h1 translate ng-if="!singleMotion && motions.length !== 1">Export motions</h1>\n<h1 translate ng-if="!singleMotion && motions.length === 1">Export motion</h1>\n<h1 ng-if="singleMotion"><translate>Export motion</translate> "{{ motions.getTitle() }}"</h1>\n\n<form name="motionPdfExportForm" ng-submit="export(params)">\n  <formly-form model="params" fields="formFields">\n    <button type="submit" ng-disabled="motionPdfExportForm.$invalid" class="btn btn-primary" translate>\n      Export as {{ params.format.toUpperCase() | translate }}\n    </button>\n    <button ng-click="closeThisDialog()" class="btn btn-default" translate>\n      Cancel\n    </button>\n  </formly-form>\n</form>\n'),n.put("motions/static/templates/motions/motion-form.html",'<h1 ng-if="model.id" translate>Edit motion</h1>\n<h1 ng-if="!model.id && !parent" translate>New motion</h1>\n<h1 ng-if="parent"><translate>New amendment to motion</translate> {{ parent.identifier || parent.getTitle() }}</h1>\n\n<div uib-alert ng-show="alert.show" ng-class="\'alert-\' + (alert.type || \'warning\')" close="alert={}">\n  {{ alert.msg }}\n</div>\n\n<form name="motionForm" ng-submit="save(model, gotoDetailView)" novalidate>\n  <formly-form model="model" fields="formFields">\n    <hr class="smallhr">\n    <div class="checkbox pointer" ng-click="$parent.$parent.gotoDetailView = !$parent.$parent.gotoDetailView">\n      <i class="fa" ng-class="$parent.$parent.gotoDetailView ? \'fa-check-square-o\' : \'fa-square-o\'"></i>\n      <translate>Open motion detail view after save.</translate>\n    </div>\n    <button type="submit" ng-disabled="motionForm.$invalid" class="btn btn-primary" translate>\n      Save\n    </button>\n    <button type="button" ng-click="closeThisDialog()" class="btn btn-default" translate>\n      Cancel\n    </button>\n  </formly-form>\n</form>\n'),n.put("motions/static/templates/motions/motion-import.html",'<div class="header">\n  <div class="title">\n    <div class="submenu">\n      <a ui-sref="motions.motion.list" class="btn btn-sm btn-default">\n        <i class="fa fa-angle-double-left fa-lg"></i>\n        <translate>Back to overview</translate>\n      </a>\n    </div>\n    <h1 translate>Import motions</h1>\n  </div>\n</div>\n\n<div class="details">\n\n  <h3 translate>Select a CSV file</h3>\n  <csv-import change="onCsvChange(csv)" config="csvConfig"></csv-import>\n\n  <h4 translate>Please note:</h4>\n  <ul class="indentation">\n      <li><translate>Required comma or semicolon separated values with these column header names in the first row</translate>:<br>\n        <code>\n          <translate>Identifier</translate>,\n          <translate>Title</translate>,\n          <translate>Text</translate>,\n          <translate>Reason</translate>,\n          <translate>Submitter</translate>,\n          <translate>Category</translate>,\n          <translate>Origin</translate>,\n          <translate>Motion block</translate>\n        </code>\n      <li translate>Identifier, reason, submitter, category, origin and motion block are optional and may be empty.\n      <li translate>Additional columns after the required ones may be present and won\'t affect the import.\n      <li translate>Only double quotes are accepted as text delimiter (no single quotes).\n      <li><a id="downloadLink" href="" ng-click="downloadCSVExample()" translate>Download CSV example file</a>\n  </ul>\n\n  <div ng-if="motions.length">\n    <h3 translate>Preview</h3>\n    <div class="scroll-x-container">\n      <table class="table table-striped table-bordered table-condensed">\n        <thead>\n          <tr>\n            <th>\n            <th>#\n            <th translate>Identifier\n            <th translate>Title\n            <th translate>Text\n            <th translate>Reason\n            <th translate>Submitter\n            <th translate>Category\n            <th translate>Origin\n            <th translate>Motion block</th>\n        <tbody ng-repeat="motion in motions">\n          <tr>\n            <td class="minimum"\n                ng-class="{ \'text-danger\': motion.importerror, \'text-success\': motion.imported }">\n              <span ng-if="motion.importerror">\n                <i class="fa fa-exclamation-triangle fa-lg"></i>\n              </span>\n              <span ng-if="!motion.importerror && !motion.imported" class="pointer">\n                <i class="fa fa-check-circle-o fa-lg" ng-if="motion.selected" ng-click="motion.selected=false; calcStats();"></i>\n                <i class="fa fa-circle-o fa-lg" ng-if="!motion.selected" ng-click="motion.selected=true; calcStats();"></i>\n              </span>\n              <span ng-if="motion.imported">\n                <i class="fa fa-check-circle fa-lg"></i>\n              </span>\n            <td>\n              {{ $index + 1 }}\n            <td ng-class="{ \'text-danger\': motion.identifier_error }">\n              <span ng-if="motion.identifier_error" title="{{ motion.identifier_error | translate }}">\n                <i class="fa fa-exclamation-triangle pointer"></i>\n              </span>\n              {{ motion.identifier }}\n            <td ng-class="{ \'text-danger\': motion.title_error }">\n              <span ng-if="motion.title_error" title="{{ motion.title_error | translate }}">\n                <i class="fa fa-exclamation-triangle"></i>\n              </span>\n              {{ motion.title }}\n            <td ng-class="{ \'text-danger\': motion.text_error }">\n              <span ng-if="motion.text_error" title="{{ motion.text_error | translate }}">\n                <i class="fa fa-exclamation-triangle"></i>\n              </span>\n              <span class="import-preview" ng-bind-html="motion.text | limitTo:90 | trusted"></span>\n              {{ motion.text.length > 90 ? \'...\' : \'\' }}\n            <td>\n              <span class="import-preview" ng-bind-html="motion.reason | limitTo:90 | trusted"></span>\n              {{ motion.reason.length > 90 ? \'...\' : \'\' }}\n            <td ng-class="{ \'text-warning\': motion.submitter_create }">\n              <span ng-if="motion.submitter_create" title="{{ motion.submitter_create | translate }}">\n                <i class="fa fa-plus-circle"></i>\n              </span>\n              {{ motion.submitter }}\n            <td ng-class="{ \'text-warning\': motion.category_create }">\n              <span ng-if="motion.category_create" title="{{ motion.category_create | translate }}">\n                <i class="fa fa-plus-circle"></i>\n              </span>\n              {{ motion.category }}\n            <td>{{ motion.origin | limitTo:30 }}{{ motion.origin.length > 30 ? \'...\' : \'\' }}\n            <td ng-class="{ \'text-warning\': motion.motionBlock_create }">\n              <span ng-if="motion.motionBlock_create" title="{{ motion.motionBlock_create | translate }}">\n                <i class="fa fa-plus-circle"></i>\n              </span>\n              {{ motion.motionBlock }}\n      </table>\n    </div>\n\n    <div ng-if="motionsWillNotBeImported" class="text-danger">\n      <i class="fa fa-exclamation-triangle"></i>\n      {{ motionsWillNotBeImported }}\n      <translate>motions will be not imported.</translate>\n    </div>\n    <div>\n      <i class="fa fa-check-circle-o fa-lg"></i>\n      {{ motionsWillBeImported }}\n      <translate>motions will be imported.</translate>\n    </div>\n    <div ng-repeat="motion in motionsImported = (motions | filter:{imported:true})"></div>\n    <div ng-if="motionsImported.length > 0" class="text-success">\n      <hr class="smallhr">\n      <i class="fa fa-check-circle fa-lg"></i>\n      {{ motionsImported.length }}\n      <translate>motions were successfully imported.</translate>\n      (<translate>Users created</translate>: {{ usersCreated }},\n      <translate>Categories created</translate>: {{ categoriesCreated }},\n        <translate>Motion blocks created</translate>: {{ motionBlocksCreated }})\n    </div>\n\n    <div class="spacer">\n      <button ng-click="clear()" class="btn btn-default btn-sm" translate>\n        Clear preview\n      </button>\n      <button ng-if="!csvImporting && motionsWillBeImported > 0" ng-click="import()" class="btn btn-primary btn-sm" translate>\n        Import {{ motionsWillBeImported }} motions\n      </button>\n    </div>\n    <div class="spacer">\n      <a ng-if="csvimported" ui-sref="motions.motion.list" class="btn btn-default btn-sm">\n        <i class="fa fa-angle-double-left fa-lg"></i>\n        <translate>Back to motions overview</translate>\n      </a>\n    </div>\n  </div>\n</div>\n'),
n.put("motions/static/templates/motions/motion-list.html",'<div class="header">\n  <div class="title">\n    <div class="submenu">\n      <a ng-click="openDialog()" os-perms="motions.can_create" class="btn btn-primary btn-sm">\n        <i class="fa fa-plus fa-lg"></i>\n        <translate>New</translate>\n      </a>\n      <a ui-sref="motions.motion.allamendments" ng-if="config(\'motions_amendments_enabled\')"\n        class="btn btn-default btn-sm">\n        <i class="fa fa-book fa-lg"></i>\n        <translate>Amendments</translate>\n      </a>\n      <a ui-sref="motions.category.list" os-perms="motions.can_manage" class="btn btn-default btn-sm">\n        <i class="fa fa-sitemap fa-lg"></i>\n        <translate>Categories</translate>\n      </a>\n      <a ui-sref="motions.motionBlock.list" os-perms="motions.can_manage" class="btn btn-default btn-sm">\n        <i class="fa fa-th-large fa-lg"></i>\n        <translate>Motion blocks</translate>\n      </a>\n      <a ui-sref="motions.workflow.list" os-perms="motions.can_manage" class="btn btn-default btn-sm">\n        <i class="fa fa-code-fork fa-lg"></i>\n        <translate>Workflows</translate>\n      </a>\n      <a ui-sref="core.tag.list" os-perms="core.can_manage_tags" class="btn btn-default btn-sm">\n        <i class="fa fa-tags fa-lg"></i>\n        <translate>Tags</translate>\n      </a>\n      <a ui-sref="motions.motion.import" os-perms="motions.can_manage" class="btn btn-default btn-sm">\n        <i class="fa fa-download fa-lg"></i>\n        <translate>Import</translate>\n      </a>\n      <template-hook hook-name="motionListMenuButton"></template-hook>\n    </div>\n    <h1 translate>Motions</h1>\n  </div>\n</div>\n\n<div class="details">\n  <div class="row">\n    <div class="col-sm-12">\n      \x3c!-- select mode --\x3e\n      <button os-perms="motions.can_manage" class="btn btn-sm"\n          ng-class="$parent.isSelectMode ? \'btn-primary\' : \'btn-default\'"\n          ng-click="$parent.isSelectMode = !$parent.isSelectMode; uncheckAll()">\n        <i class="fa fa-check-square-o"></i>\n        <translate>Select ...</translate>\n      </button>\n      \x3c!-- Export button --\x3e\n      <button type="button" class="btn btn-default btn-sm pull-right"\n        os-perms="motions.can_manage" ng-click="openExportDialog(motionsFiltered)">\n        <i class="fa fa-upload"></i>\n        <span ng-if="motionsFiltered.length === motions.length" translate>\n          Export all\n        </span>\n        <span ng-if="motionsFiltered.length !== motions.length" translate>\n          Export filtered\n        </span>\n      </button>\n      <button type="button" class="btn btn-default btn-sm pull-right"\n        os-perms="!motions.can_manage" ng-click="pdfExport(motionsFiltered)">\n        <i class="fa fa-file-pdf-o"></i>\n        <span ng-if="motionsFiltered.length === motions.length" translate>\n          Export all\n        </span>\n        <span ng-if="motionsFiltered.length !== motions.length" translate>\n          Export filtered\n        </span>\n      </button>\n    </div>\n  </div>\n\n  <div uib-collapse="!isSelectMode" class="row spacer">\n    <div class="col-sm-12 text-left form-inline" ng-show="isSelectMode" os-perms="motions.can_manage">\n      \x3c!-- actions --\x3e\n      <select ng-model="selectedAction" class="form-control input-sm">\n        <option value="" translate>--- Select action ---</option>\n        <option value="delete" translate>Delete</option>\n        <option value="setStatus" translate>Set status</option>\n        <option value="setCategory" ng-if="categories.length" translate>Set category</option>\n        <option value="setMotionBlock" ng-if="motionBlocks.length" translate>Set motion block</option>\n      </select>\n      \x3c!-- state select --\x3e\n      <select ng-show="selectedAction == \'setStatus\'" ng-model="selectedState" class="form-control input-sm">\n        <option value="" translate>--- Select state ---</option>\n        <option ng-repeat="state in states" ng-if="!state.divider" ng-disabled="state.workflowHeader" value="{{ state.id }}">\n          {{ (state.workflowHeader ? state.headername : state.name) | translate }}\n        </option>\n      </select>\n      \x3c!-- set state button --\x3e\n      <a ng-show="selectedAction == \'setStatus\' && selectedState"\n          ng-click="setStatusMultiple(motionsFiltered, selectedState)" class="btn btn-default btn-sm">\n        <translate>Set status</translate>\n      </a>\n      \x3c!-- category select --\x3e\n      <select ng-show="selectedAction == \'setCategory\'" ng-model="selectedCategory" class="form-control input-sm">\n        <option value="" translate>--- Select category ---</option>\n        <option ng-repeat="category in categories | orderBy: config(\'motions_export_category_sorting\')"\n            value="{{ category.id }}">\n          {{ category.prefix }} &ndash; {{ category.name }}\n        </option>\n        <option value="no_category_selected" translate>No category</option>\n      </select>\n      \x3c!-- set category button --\x3e\n      <a ng-show="selectedAction == \'setCategory\' && selectedCategory"\n          ng-click="setCategoryMultiple(motionsFiltered, selectedCategory)" class="btn btn-default btn-sm">\n        <translate>Set category</translate>\n      </a>\n      \x3c!-- motionBlock select --\x3e\n      <select ng-show="selectedAction == \'setMotionBlock\'" ng-model="selectedMotionBlock" class="form-control input-sm">\n        <option value="" translate>--- Select motion block ---</option>\n        <option ng-repeat="motionBlock in motionBlocks | orderBy: \'title\'" value="{{ motionBlock.id }}">\n          {{ motionBlock.title }}\n        </option>\n        <option value="no_motionBlock_selected" translate>No motion block</option>\n      </select>\n      \x3c!-- set motion block button --\x3e\n      <a ng-show="selectedAction == \'setMotionBlock\' && selectedMotionBlock"\n         ng-click="setMotionBlockMultiple(motionsFilterd, selectedMotionBlock)" class="btn btn-default btn-sm">\n        <translate>Set motion block</translate>\n      </a>\n      \x3c!-- delete button --\x3e\n      <a ng-show="selectedAction == \'delete\'"\n        ng-bootbox-confirm="{{ \'Are you sure you want to delete all selected motions?\' | translate }}"\n        ng-bootbox-confirm-action="deleteMultiple(motionsFiltered)"\n        class="btn btn-default btn-sm btn-danger">\n        <i class="fa fa-trash fa-lg"></i>\n        <translate>Delete selected motions</translate>\n      </a>\n    </div>\n  </div>\n\n  <div class="spacer-top-lg italic row">\n    <div class="col-md-6">\n      {{ motionsFiltered.length }} /\n      {{ motions.length }}\n      <translate>motions</translate><span ng-if="(motions|filter:{selected:true}).length > 0">,\n      {{(motions|filter:{selected:true}).length}} {{ "selected" | translate }}</span>\n    </div>\n    <div class="col-md-6" ng-show="motionsFiltered.length > pagination.itemsPerPage">\n      <span class="pull-right">\n        <a href="" class="pagination-arrow" ng-click="pagination.prevPage()"\n          ng-if="pagination.showPrevPageArrow()">\n          &laquo;\n        </a>\n        <translate>Page</translate> {{ pagination.currentPage }} /\n        {{ pagination.getPageCount(motionsFiltered) }}\n        <a href="" class="pagination-arrow" ng-click="pagination.nextPage(motionsFiltered)"\n          ng-if="pagination.showNextPageArrow(motionsFiltered)">\n          &raquo;\n        </a>\n      </span>\n    </div>\n  </div>\n\n  <div class="os-table container-fluid">\n    <div class="row header-row">\n      <div class="col-xs-1 centered" ng-if="isSelectMode">\n        <i class="fa text-danger pointer" ng-class=" selectedAll ? \'fa-check-square-o\' : \'fa-square-o\'"\n          ng-click="checkAll(motionsFiltered)"></i>\n      </div>\n      <div class="col-xs-11 main-header" ng-style="{\'width\': isSelectMode ? \'\' : \'100%\'}">\n        <ng-include src="\'static/templates/motions/motion-table-filters.html\'"></ng-include>\n      </div>\n    </div>\n\n    \x3c!-- main table --\x3e\n    <div class="row data-row" ng-mouseover="motion.hover=true"\n      ng-mouseleave="motion.hover=false"\n      ng-class="{\'projected\': motion.isProjected().length,\n      \'related-projected\': motion.isRelatedProjected().length}"\n      ng-repeat="motion in motionsFiltered = (motions\n        | osFilter: filter.filterString : filter.getObjectQueryString\n        | MultiselectFilter: stateFilter : getItemId.state\n        | MultiselectFilter: filter.multiselectFilters.comment : getItemId.comment\n        | MultiselectFilter: filter.multiselectFilters.category : getItemId.category\n        | MultiselectFilter: filter.multiselectFilters.motionBlock : getItemId.motionBlock\n        | MultiselectFilter: filter.multiselectFilters.recommendation : getItemId.recommendation\n        | MultiselectFilter: filter.multiselectFilters.tag : getItemId.tag\n        | filter: {star: filter.booleanFilters.isFavorite.value}\n        | filter: {hasPersonalNote: filter.booleanFilters.hasPersonalNote.value}\n        | toArray\n        | orderByEmptyLast: sort.column : sort.reverse)\n        | limitTo : pagination.itemsPerPage : pagination.limitBegin">\n\n      \x3c!-- select column --\x3e\n      <div ng-show="isSelectMode" os-perms="motions.can_manage" class="col-xs-1 centered">\n        <i class="fa text-danger pointer" ng-click="motion.selected=!motion.selected"\n        ng-class="motion.selected ? \'fa-check-square-o\' : \'fa-square-o\'"></i>\n      </div>\n      \x3c!-- projector column --\x3e\n      <div class="col-xs-1 centered projector" os-perms="core.can_manage_projector">\n        <projector-button model="motion" default-projector-id="defaultProjectorId">\n        </projector-button>\n      </div>\n      <div class="no-projector-spacer" os-perms="!core.can_manage_projector"></div>\n      \x3c!-- main content column --\x3e\n      <div class="col-xs-6 content">\n        <div class="id-col">\n          <span ng-show="motion.identifier">\n            {{ motion.identifier }}\n          </span>\n        </div>\n        <div class="id-col-space">\n          \x3c!-- ID and title --\x3e\n          <div>\n            <a class="title" ui-sref="motions.motion.detail({id: motion.id})">{{ motion.getTitle() }}</a>\n            <a href="" ng-click="toggleStar(motion)">\n              <i class="fa" ng-class="motion.personalNote.star ? \'fa-star\' : \'fa-star-o\'"\n                title="{{ \'Set as favorite\' | translate }}" ng-if="(motion.personalNote.star || motion.hover) && operator.user"></i>\n            </a>\n            <i class="fa fa-paperclip" ng-if="motion.attachments_id.length > 0"></i>\n          </div>\n          \x3c!-- state --\x3e\n          <div>\n            <span ng-mouseover="motion.stateHover=true" ng-mouseleave="motion.stateHover=false"\n                class="dropdown-hover-space">\n              <span class="label" ng-class="\'label-\'+motion.state.css_class">\n                {{ motion.getStateName() }}\n              </span>\n              <span os-perms="motions.can_manage" ng-class="{\'hiddenDiv\': !motion.stateHover}" uib-dropdown>\n                <i class="fa fa-cog pointer" uib-dropdown-toggle id="stateDropdown{{ motion.id }}"></i>\n                <ul class="dropdown-menu" aria-labelledby="stateDropdown{{ motion.id }}">\n                  <li ng-repeat="state in motion.state.getNextStates()">\n                    <a href ng-click="motion.setState(state.id)">{{ state.action_word | translate }}</a>\n                  </li>\n                  <li class="divider" ng-if="motion.state.getNextStates().length"></li>\n                  <li>\n                    <a href ng-if="motion.isAllowed(\'reset_state\')" ng-click="motion.setState(null)">\n                      <i class="fa fa-exclamation-triangle"></i>\n                      <translate>Reset state</translate>\n                    </a>\n                  </li>\n                </ul>\n              </span>\n            </span>\n          </div>\n          \x3c!-- recommendation --\x3e\n          <div ng-if="motion.recommendation && config(\'motions_recommendations_by\')">\n            <span ng-mouseover="motion.recommendationHover=true" ng-mouseleave="motion.recommendationHover=false"\n                class="dropdown-hover-space">\n              <span class="label" ng-class="\'label-\'+motion.recommendation.css_class" uib-tooltip="{{ config(\'motions_recommendations_by\') }}">\n                {{ motion.getRecommendationName() }}\n              </span>\n              <span os-perms="motions.can_manage" ng-class="{\'hiddenDiv\': !motion.recommendationHover}" uib-dropdown>\n                <i class="fa fa-cog pointer" uib-dropdown-toggle id="recommendationDropdown{{ motion.id }}"></i>\n                <ul class="dropdown-menu" aria-labelledby="recommendationDropdown{{ motion.id }}">\n                  <li ng-repeat="recommendation in motion.state.getRecommendations()">\n                    <a href ng-click="motion.setRecommendation(recommendation.id)">\n                      {{ recommendation.recommendation_label | translate }}\n                    </a>\n                  </li>\n                  <li class="divider" ng-if="motion.state.getRecommendations().length && motion.recommendation"></li>\n                  <li ng-if="motion.recommendation">\n                    <a href ng-click="motion.setRecommendation(null)">\n                      <i class="fa fa-exclamation-triangle"></i>\n                      <translate>Reset recommendation</translate>\n                    </a>\n                  </li>\n                </ul>\n              </span>\n            </span>\n          </div>\n          \x3c!-- Submitters --\x3e\n          <div ng-if="motion.submitters.length">\n            <small>\n              <span class="optional" translate>by</span>\n              <span class="optional" ng-repeat="submitter in motion.submitters | orderBy: \'weight\' | limitTo:1">\n                {{ submitter.user.get_full_name() }}<span ng-if="!$last">,</span></span><span ng-if="motion.submitters.length > 1">,\n                ... [+{{ motion.submitters.length - 1 }}]</span>\n              \x3c!-- sorry for merging them together, but otherwise there would be a whitespace because of the new line --\x3e\n            </small>\n          </div>\n          \x3c!-- hover menu --\x3e\n          <div ng-if="motion.isAllowed(\'update\')" ng-class="{\'hiddenDiv\': !motion.hover}">\n            <small>\n              <span ng-if="motion.isAllowed(\'update\')">\n                <a href="" ng-click="openDialog(motion)" translate>Edit</a>\n              </span>\n              <span ng-if="motion.isAllowed(\'update_submitters\')"> &middot;\n                <a ui-sref="motions.motion.submitters({id: motion.id})" translate>\n                  Edit submitters\n                </a>\n              </span>\n              <span ng-if="motion.isAllowed(\'delete\')"> &middot;\n                <a href="" class="text-danger"\n                    ng-bootbox-confirm="{{ \'Are you sure you want to delete this entry?\' | translate }}<br><b>{{ motion.getTitle() }}</b>"\n                    ng-bootbox-confirm-action="delete(motion)" translate>Delete</a>\n              </span>\n            </small>\n          </div>\n\n        </div>\n      </div>\n      \x3c!-- additional content column --\x3e\n      <div class="col-xs-4 content" ng-style="{\'width\': isSelectMode ? \'calc(50% - 120px)\' : \'calc(50% - 70px)\'}">\n        <div style="width: 45%;" class="optional">\n          <small>\n            \x3c!-- Category dropdown for manage user --\x3e\n            <div os-perms="motions.can_manage" ng-show="categories.length > 0"\n                ng-mouseover="motion.categoryHover=true"\n                ng-mouseleave="motion.categoryHover=false">\n              <span uib-dropdown>\n                <span id="dropdownCategory{{ motion.id }}" class="pointer"\n                  uib-dropdown-toggle uib-tooltip="{{ \'Set a category\' | translate }}"\n                  tooltip-class="nobr">\n                  <span ng-if="motion.category == null" ng-show="motion.hover">\n                    <i class="fa fa-sitemap"></i>\n                    <i class="fa fa-plus"></i>\n                  </span>\n                  <span ng-if="motion.category != null">\n                    <i class="fa fa-sitemap spacer-right"></i>\n                    {{ motion.category.prefix }} &ndash; {{ motion.category.name }}\n                    <i class="fa fa-cog fa-lg spacer-left" ng-show="motion.categoryHover"></i>\n                  </span>\n                </span>\n                <ul class="dropdown-menu" aria-labelledby="dropdownCategory{{ motion.id }}">\n                  <li ng-repeat="category in categories | orderBy: config(\'motions_export_category_sorting\')">\n                    <a href ng-click="toggleCategory(motion, category)">\n                      <i class="fa fa-check" ng-if="category.id == motion.category.id"></i>\n                      {{ category.prefix }} &ndash; {{ category.name }}\n                    </a>\n                  </li>\n                </ul>\n              </span>\n            </div>\n            \x3c!-- Category string for normal user --\x3e\n            <div os-perms="!motions.can_manage" ng-show="motion.category != null">\n              <i class="fa fa-sitemap spacer-right"></i>\n              {{ motion.category.prefix }} &ndash; {{ motion.category.name }}\n            </div>\n\n            \x3c!-- Motion block dropdown for manage user --\x3e\n            <div os-perms="motions.can_manage" ng-show="motionBlocks.length > 0"\n                ng-mouseover="motion.motionBlockHover=true"\n                ng-mouseleave="motion.motionBlockHover=false">\n              <span uib-dropdown>\n                <span id="dropdownMotionBlock{{ motion.id }}" class="pointer"\n                  uib-dropdown-toggle uib-tooltip="{{ \'Set a motion block\' | translate }}"\n                  tooltip-class="nobr">\n                  <span ng-if="motion.motionBlock == null" ng-show="motion.hover">\n                    <i class="fa fa-th-large"></i>\n                    <i class="fa fa-plus"></i>\n                  </span>\n                  <span ng-if="motion.motionBlock != null">\n                    <i class="fa fa-th-large spacer-right"></i>\n                    {{ motion.motionBlock.title }}\n                    <i class="fa fa-cog fa-lg spacer-left" ng-show="motion.motionBlockHover"></i>\n                  </span>\n                </span>\n                <ul class="dropdown-menu" aria-labelledby="dropdownMotionBlock{{ motion.id }}">\n                  <li ng-repeat="motionBlock in motionBlocks | orderBy: \'title\'">\n                    <a href ng-click="toggleMotionBlock(motion, motionBlock)">\n                      <i class="fa fa-check" ng-if="motionBlock.id == motion.motionBlock.id"></i>\n                      {{ motionBlock.title }}\n                    </a>\n                  </li>\n                </ul>\n              </span>\n            </div>\n            \x3c!-- Motion block string for normal user --\x3e\n            <div os-perms="!motions.can_manage" ng-show="motion.motionBlock != null">\n              <i class="fa fa-th-large spacer-right"></i>\n              {{ motion.motionBlock.title }}\n            </div>\n\n            \x3c!-- Tag dropdown for manage user --\x3e\n            <div os-perms="motions.can_manage" ng-show="tags.length > 0"\n                ng-mouseover="motion.tagHover=true"\n                ng-mouseleave="motion.tagHover=false">\n              <span uib-dropdown>\n                <span id="dropdownTags{{ motion.id }}" class="pointer"\n                  uib-dropdown-toggle uib-tooltip="{{ \'Add a tag\' | translate }}"\n                  tooltip-class="nobr">\n                  <span ng-if="motion.tags.length == 0" ng-show="motion.hover">\n                    <i class="fa fa-tags"></i>\n                    <i class="fa fa-plus"></i>\n                  </span>\n                  <span ng-if="motion.tags.length > 0">\n                    <i class="fa fa-tags spacer-right"></i>\n                    <span ng-repeat="tag in motion.tags">\n                      {{ tag.name }}<span ng-if="!$last">,</span>\n                    </span>\n                    <i class="fa fa-cog fa-lg spacer-left" ng-show="motion.tagHover"></i>\n                  </span>\n                </span>\n                <ul class="dropdown-menu" aria-labelledby="dropdownTags{{ motion.id }}">\n                  <li ng-repeat="tag in tags">\n                    <a href ng-click="toggleTag(motion, tag)">\n                      <i class="fa fa-check" ng-if="hasTag(motion, tag)"></i>\n                      {{ tag.name }}\n                    </a>\n                  </li>\n                </ul>\n              </span>\n            </div>\n            \x3c!-- Tag string for normal user --\x3e\n            <div os-perms="!motions.can_manage" ng-show="motion.tags.length > 0">\n              <i class="fa fa-tags spacer-right"></i>\n              <span ng-repeat="tag in motion.tags">\n                {{ tag.name }}<span ng-if="!$last">,</span>\n              </span>\n            </div>\n\n            \x3c!-- Origin --\x3e\n            <div ng-if="motion.origin">\n              <i class="fa fa-share spacer-right" uib-tooltip="{{ \'Origin\' | translate }}"></i>\n                <div class="popover-wrapper">\n                  <span editable-text="motion.origin" onaftersave="save(motion)">\n                    {{ motion.origin | limitTo:25 }}{{ motion.origin.length > 25 ? \'...\' : \'\' }}\n                  </span>\n                </div>\n            </div>\n            <template-hook hook-name="motionListAdditionalContentColumn"></template-hook>\n          </small>\n        </div>\n        <div style="width: 10%;" class="pull-right optional">\n          <div class="centered" ng-if="config(\'motions_min_supporters\') != 0"\n            uib-tooltip="{{ motion.supporters.length }} {{ \'Supporters\' | translate }}\n            {{ (config(\'motions_min_supporters\') - motion.supporters.length) > 0 ? \'(\' +  (config(\'motions_min_supporters\') - motion.supporters.length) + \' \' + (\'needed\' | translate) + \')\': \'\' }}"\n            tooltip-class="nobr">\n            <span class="badge"\n              ng-class="motion.supporters.length < config(\'motions_min_supporters\') ? \'badge-info\' : \'badge-success\'">\n              {{ motion.supporters.length }}\n            </span>\n          </div>\n        </div>\n        <div style="width: 15%;" class="pull-right">\n          <div class="centered" ng-if="(motion.agenda_item.speakers | filter: {\'begin_time\': null}).length"\n            uib-tooltip="{{ (motion.agenda_item.speakers | filter: {\'begin_time\': null}).length }} {{ \'speakers\' | translate }}"\n            tooltip-class="nobr">\n            <a ui-sref="agenda.item.detail({id: motion.agenda_item_id})" os-perms="agenda.can_see" class="badge">\n              <i class="fa fa-comment-o"></i>\n              {{ (motion.agenda_item.speakers | filter: {\'begin_time\': null}).length }}\n            </a>\n          </div>\n          <div class="centered" ng-if="motion.hasAmendments()"\n            uib-tooltip="{{ motion.getAmendments().length }} {{ \'amendments\' | translate }}"\n            tooltip-class="nobr">\n            <a ui-sref="motions.motion.amendment-list({id: motion.id})" class="badge">\n              <i class="fa fa-book"></i>\n              {{ motion.getAmendments().length }}\n            </a>\n          </div>\n        </div>\n        <div style="width: 30%;" class="pull-right">\n          <div class="centered">{{ motion.agenda_item.getItemNumberWithAncestors() }}</div>\n        </div>\n      </div>\n    </div> \x3c!-- data row --\x3e\n\n    <ul uib-pagination\n        ng-show="motionsFiltered.length > pagination.itemsPerPage"\n        total-items="motionsFiltered.length"\n        items-per-page="pagination.itemsPerPage"\n        ng-model="pagination.currentPage"\n        ng-change="pagination.pageChanged()"\n        class="pagination-sm"\n        direction-links="false"\n        boundary-links="true"\n        first-text="&laquo;"\n        last-text="&raquo;">\n    </ul>\n\n  </div> \x3c!-- container --\x3e\n</div> \x3c!-- details --\x3e\n'),n.put("motions/static/templates/motions/motion-poll-form.html",'<h1><translate>Vote</translate> {{ voteNumber }}</h1>\n\n<div uib-alert ng-show="alert.show" ng-class="\'alert-\' + (alert.type || \'warning\')" ng-click="alert={}" close="alert={}">\n  {{ alert.msg }}\n</div>\n\n<p>\n  <translate>Special values</translate>:\n  <span class="badge badge-success">-1</span> = <translate>majority</translate>\n  <span class="badge">-2</span> = <translate>undocumented</translate>\n\n<form name="motionPollForm" ng-submit="save(model)">\n  <formly-form model="model" fields="formFields">\n    <template-hook hook-name="motionPollFormButtons"></template-hook>\n    <button type="submit" ng-disabled="motionPollForm.$invalid" class="btn btn-primary" translate>\n      Save\n    </button>\n    <button ng-click="closeThisDialog()" class="btn btn-default" translate>\n      Cancel\n    </button>\n  </formly-form>\n</form>\n'),n.put("motions/static/templates/motions/motion-submitters.html",'<div class="header">\n  <div class="title">\n    <div class="submenu">\n      <a href="javascript:history.back()" class="btn btn-sm btn-default">\n        <i class="fa fa-angle-double-left fa-lg"></i>\n        <translate>Back</translate>\n      </a>\n    </div>\n    <h1>{{ motion.getAgendaTitle() }}</h1>\n    <h2 translate>Sort submitters</h2>\n  </div>\n</div>\n\n<div class="details">\n  \x3c!-- Submitters --\x3e\n  <div ui-tree="treeOptions" data-empty-placeholder-enabled="false">\n    <ol ui-tree-nodes="" ng-model="submitters">\n      <li ng-repeat="submitter in submitters" ui-tree-node>\n        <i ui-tree-handle="" class="fa fa-arrows-v"></i>\n        {{ $index + 1 }}.\n        {{ submitter.user.get_full_name() }}\n        <button ng-click="removeSubmitter(submitter.user.id)"\n            class="btn btn-default btn-sm" title="{{ \'Remove\' | translate }}">\n          <i class="fa fa-times"></i>\n        </button>\n    </ol>\n  </div>\n\n  \x3c!-- Select new submitter form --\x3e\n  <div class="form-group spacer-top-lg">\n    <div uib-alert ng-show="alert.show" ng-class="\'alert-\' + (alert.type || \'warning\')" ng-click="alert={}" close="alert={}">\n      {{ alert.msg }}\n    </div>\n    <select chosen\n        ng-model="submitterSelectBox.selected"\n        ng-change="addSubmitter(submitterSelectBox.selected)"\n        ng-options="user.id as user.get_full_name() for user in users"\n        search-contains="true"\n        placeholder-text-single="\'Select or search a participant ...\' | translate"\n        no-results-text="\'No results available ...\' | translate"\n        class="form-control">\n    <select>\n  </div>\n</div>\n'),
n.put("motions/static/templates/motions/motion-table-filters.html",'<div class="form-inline text-right pull-right">\n  \x3c!-- State filter --\x3e\n  <span uib-dropdown>\n    <span class="pointer" id="dropdownState" uib-dropdown-toggle\n      ng-class="{\'bold\': filter.multiselectFilters.state.length > 0, \'disabled\': isSelectMode}"\n      ng-disabled="isSelectMode">\n      <translate>State</translate>\n      <span class="caret"></span>\n    </span>\n    <ul class="dropdown-menu dropdown-menu-left" aria-labelledby="dropdownState">\n      <li ng-repeat="state in states" ng-class="{\'dropdown-header\': state.workflowHeader, \'divider\': state.divider}">\n        <a ng-if="state.workflowHeader">\n          {{ state.headername | translate }}\n        </a>\n        <a href ng-if="!state.workflowHeader && !state.divider"\n          ng-click="operateStateFilter(state.id, isSelectMode)">\n          <i class="fa fa-check" ng-if="filter.multiselectFilters.state.indexOf(state.id) > -1"></i>\n          {{ state.name | translate }}\n        </a>\n      </li>\n      <li class="divider"></li>\n      <li>\n        <a href ng-click="operateStateFilter(-1, isSelectMode)">\n          <i class="fa fa-check" ng-if="filter.multiselectFilters.state.indexOf(-1) > -1"></i>\n          <translate>done</translate>\n        </a>\n      </li>\n      <li>\n        <a href ng-click="operateStateFilter(-2, isSelectMode)">\n          <i class="fa fa-check" ng-if="filter.multiselectFilters.state.indexOf(-2) > -1"></i>\n          <translate>undone</translate>\n        </a>\n      </li>\n    </ul>\n  </span>\n  \x3c!-- recommendation filter --\x3e\n  <span uib-dropdown ng-if="config(\'motions_recommendations_by\') != \'\'">\n    <span class="pointer" id="dropdownRecommendation" uib-dropdown-toggle\n      ng-class="{\'bold\': filter.multiselectFilters.recommendation.length > 0, \'disabled\': isSelectMode}"\n      ng-disabled="isSelectMode">\n      <translate>Recommendation</translate>\n      <span class="caret"></span>\n    </span>\n    <ul class="dropdown-menu dropdown-menu-left" aria-labelledby="dropdownRecommentation">\n      <li ng-repeat="recommendation in recommendations" ng-class="recommendation.workflowHeader ? \'dropdown-header\' : \'\'">\n        <a ng-if="recommendation.workflowHeader">\n          {{ recommendation.headername | translate }}\n        </a>\n        <a href ng-if="!recommendation.workflowHeader"\n          ng-click="filter.operateMultiselectFilter(\'recommendation\', recommendation.id, isSelectMode)">\n          <i class="fa fa-check" ng-if="filter.multiselectFilters.recommendation.indexOf(recommendation.id) > -1"></i>\n          {{ recommendation.recommendation_label | translate }}\n        </a>\n      </li>\n      <li class="divider"></li>\n      <li>\n        <a href ng-click="filter.operateMultiselectFilter(\'recommendation\', -1, isSelectMode)">\n          <i class="fa fa-check" ng-if="filter.multiselectFilters.recommendation.indexOf(-1) > -1"></i>\n          <translate>No recommendation set</translate>\n        </a>\n      </li>\n    </ul>\n  </span>\n  \x3c!-- Category filter --\x3e\n  <span uib-dropdown ng-if="categories.length > 0">\n    <span class="pointer" id="dropdownCategory" uib-dropdown-toggle\n      ng-class="{\'bold\': filter.multiselectFilters.category.length > 0, \'disabled\': isSelectMode}"\n      ng-disabled="isSelectMode">\n      <translate>Category</translate>\n      <span class="caret"></span>\n    </span>\n    <ul class="dropdown-menu dropdown-menu-right" aria-labelledby="dropdownCategory">\n    <li ng-repeat="category in categories | orderBy: config(\'motions_export_category_sorting\')">\n        <a href ng-click="filter.operateMultiselectFilter(\'category\', category.id, isSelectMode)">\n          <i class="fa fa-check" ng-if="filter.multiselectFilters.category.indexOf(category.id) > -1"></i>\n          {{ category.prefix }} &ndash; {{ category.name }}\n        </a>\n      </li>\n      <li class="divider"></li>\n      <li>\n        <a href ng-click="filter.operateMultiselectFilter(\'category\', -1, isSelectMode)">\n          <i class="fa fa-check" ng-if="filter.multiselectFilters.category.indexOf(-1) > -1"></i>\n          <translate>No category set</translate>\n        </a>\n      </li>\n    </ul>\n  </span>\n  \x3c!-- Motion block filter --\x3e\n  <span uib-dropdown ng-if="motionBlocks.length > 0">\n    <span class="pointer" id="dropdownBlock" uib-dropdown-toggle\n      ng-class="{\'bold\': filter.multiselectFilters.motionBlock.length > 0, \'disabled\': isSelectMode}"\n      ng-disabled="isSelectMode">\n      <translate>Motion block</translate>\n      <span class="caret"></span>\n    </span>\n    <ul class="dropdown-menu dropdown-menu-right" aria-labelledby="dropdownBlock">\n      <li ng-repeat="block in motionBlocks | orderBy: \'title\'">\n        <a href ng-click="filter.operateMultiselectFilter(\'motionBlock\', block.id, isSelectMode)">\n          <i class="fa fa-check" ng-if="filter.multiselectFilters.motionBlock.indexOf(block.id) > -1"></i>\n          {{ block.title }}\n        </a>\n      </li>\n      <li class="divider"></li>\n      <li>\n        <a href ng-click="filter.operateMultiselectFilter(\'motionBlock\', -1, isSelectMode)">\n          <i class="fa fa-check" ng-if="filter.multiselectFilters.motionBlock.indexOf(-1) > -1"></i>\n          <translate>No motion block set</translate>\n        </a>\n      </li>\n    </ul>\n  </span>\n  \x3c!-- Comment filter --\x3e\n  <span uib-dropdown ng-if="showCommentsFilter()">\n    <span class="pointer" id="dropdownComment" uib-dropdown-toggle\n      ng-class="{\'bold\': filter.multiselectFilters.comment.length > 0, \'disabled\': isSelectMode}"\n      ng-disabled="isSelectMode">\n      <translate>Comment</translate>\n      <span class="caret"></span>\n    </span>\n    <ul class="dropdown-menu dropdown-menu-left" aria-labelledby="dropdownComment">\n      <li ng-repeat="(index, commentsField) in noSpecialCommentsFields">\n        <a href ng-click="filter.operateMultiselectFilter(\'comment\', index, isSelectMode)">\n          <i class="fa fa-check" ng-if="filter.multiselectFilters.comment.indexOf(index) > -1"></i>\n          {{ commentsField.name }} <translate>is set</translate>\n        </a>\n      </li>\n      <li class="divider"></li>\n      <li>\n        <a href ng-click="filter.operateMultiselectFilter(\'comment\', -1, isSelectMode)">\n          <i class="fa fa-check" ng-if="filter.multiselectFilters.comment.indexOf(-1) > -1"></i>\n          <translate>No comments set</translate>\n        </a>\n      </li>\n    </ul>\n  </span>\n  \x3c!-- Tag filter --\x3e\n  <span uib-dropdown ng-if="tags.length > 0">\n    <span class="pointer" id="dropdownTag" uib-dropdown-toggle\n      ng-class="{\'bold\': filter.multiselectFilters.tag.length > 0, \'disabled\': isSelectMode}"\n      ng-disabled="isSelectMode">\n      <translate>Tag</translate>\n      <span class="caret"></span>\n    </span>\n    <ul class="dropdown-menu dropdown-menu-right" aria-labelledby="dropdownTag">\n      <li ng-repeat="tag in tags">\n        <a href ng-click="filter.operateMultiselectFilter(\'tag\', tag.id, isSelectMode)">\n          <i class="fa fa-check" ng-if="filter.multiselectFilters.tag.indexOf(tag.id) > -1"></i>\n          {{ tag.name }}\n        </a>\n      </li>\n      <li class="divider"></li>\n      <li>\n        <a href ng-click="filter.operateMultiselectFilter(\'tag\', -1, isSelectMode)">\n          <i class="fa fa-check" ng-if="filter.multiselectFilters.tag.indexOf(-1) > -1"></i>\n          <translate>No tag set</translate>\n        </a>\n      </li>\n    </ul>\n  </span>\n  \x3c!-- boolean Filters (customized!) --\x3e\n  <span ng-if="operator.user.id" uib-dropdown>\n    <span class="pointer" id="dropdownMisc" uib-dropdown-toggle\n      ng-class="{\'bold\': (filter.booleanFilters.isFavorite.value !== undefined) ||\n      (filter.booleanFilters.hasPersonalNote.value !== undefined), \'disabled\': isSelectMode}"\n      ng-disabled="isSelectMode">\n      <translate>Misc</translate>\n      <span class="caret"></span>\n    </span>\n    <ul class="dropdown-menu dropdown-menu-right" aria-labelledby="dropdownMisc">\n      <li>\n        <a href ng-click="filter.booleanFilters.isFavorite.value = (filter.booleanFilters.isFavorite.value ? undefined : true); filter.save();">\n          <i class="fa" ng-class="{\'fa-check\': filter.booleanFilters.isFavorite.value === true}"></i>\n          {{ filter.booleanFilters.isFavorite.choiceYes | translate }}\n        </a>\n      </li>\n      <li>\n        <a href ng-click="filter.booleanFilters.isFavorite.value = (filter.booleanFilters.isFavorite.value === false) ? undefined : false; filter.save();">\n          <i class="fa" ng-class="{\'fa-check\': filter.booleanFilters.isFavorite.value === false}"></i>\n          {{ filter.booleanFilters.isFavorite.choiceNo | translate }}\n        </a>\n      </li>\n      <li class="divider"></li>\n      <li>\n        <a href ng-click="filter.booleanFilters.hasPersonalNote.value = (filter.booleanFilters.hasPersonalNote.value ? undefined : true); filter.save();">\n          <i class="fa" ng-class="{\'fa-check\': filter.booleanFilters.hasPersonalNote.value === true}"></i>\n          {{ filter.booleanFilters.hasPersonalNote.choiceYes | translate }}\n        </a>\n      </li>\n      <li>\n        <a href ng-click="filter.booleanFilters.hasPersonalNote.value = (filter.booleanFilters.hasPersonalNote.value === false) ? undefined : false; filter.save();">\n          <i class="fa" ng-class="{\'fa-check\': filter.booleanFilters.hasPersonalNote.value === false}"></i>\n          {{ filter.booleanFilters.hasPersonalNote.choiceNo | translate }}\n        </a>\n      </li>\n    </ul>\n  </span>\n  \x3c!-- dropdown sort --\x3e\n  <span uib-dropdown>\n    <span class="pointer" id="dropdownSort" uib-dropdown-toggle\n      ng-class="{\'disabled\': isSelectMode}"\n      ng-disabled="isSelectMode">\n      <translate>Sort</translate>\n      <span class="caret"></span>\n    </span>\n    <ul class="dropdown-menu dropdown-menu-right" aria-labelledby="dropdownSort">\n      \x3c!-- item --\x3e\n      <li>\n        <a href ng-click="sort.toggle(\'agenda_item.getItemNumberWithAncestors()\')">\n          <translate translate-comment="short form of agenda item">Item</translate>\n          <span class="spacer-right pull-right"></span>\n          <i class="pull-right fa"\n            ng-style="{\'visibility\': sort.column === \'agenda_item.getItemNumberWithAncestors()\' ? \'visible\' : \'hidden\'}"\n            ng-class="sort.reverse ? \'fa-sort-desc\' : \'fa-sort-asc\'">\n          </i>\n        </a>\n      </li>\n      \x3c!-- all other sortOptions --\x3e\n      <li ng-repeat="option in sortOptions">\n        <a href ng-click="sort.toggle(option.name)">\n        {{ option.display_name | translate }}\n        <span class="spacer-right pull-right"></span>\n          <i class="pull-right fa"\n            ng-style="{\'visibility\': sort.column === option.name ? \'visible\' : \'hidden\'}"\n            ng-class="sort.reverse ? \'fa-sort-amount-desc\' : \'fa-sort-amount-asc\'">\n          </i>\n        </a>\n      </li>\n    </ul>\n  </span>\n  \x3c!-- search field --\x3e\n  <span class="form-group">\n    <span class="input-group">\n      <span class="input-group-addon"><i class="fa fa-search"></i></span>\n      <input type="text" ng-model="filter.filterString" class="form-control"\n         placeholder="{{ \'Search\' | translate}}" ng-disabled="isSelectMode"\n         ng-change="filter.save()">\n    </span>\n  </span>\n</div>\n\x3c!-- show all selected multiselectoptions --\x3e\n<div>\n  \x3c!-- clear all filters --\x3e\n  <span class="spacer-left-lg pointer" ng-click="resetFilters(isSelectMode)"\n    ng-if="filter.areFiltersSet()" ng-disabled="isSelectMode"\n    ng-class="{\'disabled\': isSelectMode}">\n    <i class="fa fa-window-close"></i>\n    <strong translate>All Filters</strong>\n  </span>\n  \x3c!-- state --\x3e\n  <span ng-repeat="state in states" class="pointer spacer-left-lg"\n    ng-if="!state.workflowHeader && filter.multiselectFilters.state.indexOf(state.id) > -1"\n    ng-click="operateStateFilter(state.id, isSelectMode)"\n    ng-class="{\'disabled\': isSelectMode}">\n    <span class="nobr">\n      <i class="fa fa-times-circle"></i>\n      {{ state.name | translate }}\n    </span>\n  </span>\n  <span ng-if="filter.multiselectFilters.state.indexOf(-1) > -1" class="pointer spacer-left-lg"\n    ng-click="operateStateFilter(-1, isSelectMode)"\n    ng-class="{\'disabled\': isSelectMode}">\n    <i class="fa fa-times-circle"></i>\n    <translate>done</translate>\n  </span>\n  <span ng-if="filter.multiselectFilters.state.indexOf(-2) > -1" class="pointer spacer-left-lg"\n    ng-click="operateStateFilter(-2, isSelectMode)"\n    ng-class="{\'disabled\': isSelectMode}">\n    <i class="fa fa-times-circle"></i>\n    <translate>undone</translate>\n  </span>\n  \x3c!-- category --\x3e\n  <span ng-repeat="category in categories | orderBy: config(\'motions_export_category_sorting\')"\n    class="pointer spacer-left-lg"\n    ng-if="filter.multiselectFilters.category.indexOf(category.id) > -1"\n    ng-click="filter.operateMultiselectFilter(\'category\', category.id, isSelectMode)"\n    ng-class="{\'disabled\': isSelectMode}">\n    <span class="nobr">\n      <i class="fa fa-times-circle"></i>\n      {{ category.prefix }} &ndash; {{ category.name }}\n    </span>\n  </span>\n  <span ng-if="filter.multiselectFilters.category.indexOf(-1) > -1" class="pointer spacer-left-lg"\n    ng-click="filter.operateMultiselectFilter(\'category\', -1, isSelectMode)"\n    ng-class="{\'disabled\': isSelectMode}">\n    <i class="fa fa-times-circle"></i>\n    <translate>No category set</translate>\n  </span>\n  \x3c!-- motion block --\x3e\n  <span ng-repeat="motionBlock in motionBlocks | orderBy: \'title\'" class="pointer spacer-left-lg"\n    ng-if="filter.multiselectFilters.motionBlock.indexOf(motionBlock.id) > -1"\n    ng-click="filter.operateMultiselectFilter(\'motionBlock\', motionBlock.id, isSelectMode)"\n    ng-class="{\'disabled\': isSelectMode}">\n    <span class="nobr">\n      <i class="fa fa-times-circle"></i>\n      {{ motionBlock.title }}\n    </span>\n  </span>\n  \x3c!-- comment --\x3e\n  <span ng-repeat="(index, commentsField) in noSpecialCommentsFields" class="pointer spacer-left-lg"\n    ng-if="filter.multiselectFilters.comment.indexOf(index) > -1"\n    ng-click="filter.operateMultiselectFilter(\'comment\', index, isSelectMode)"\n    ng-class="{\'disabled\': isSelectMode}">\n    <span class="nobr">\n      <i class="fa fa-times-circle"></i>\n      {{ commentsField.name }}\n    </span>\n  </span>\n  <span ng-if="filter.multiselectFilters.comment.indexOf(-1) > -1" class="pointer spacer-left-lg"\n    ng-click="filter.operateMultiselectFilter(\'comment\', -1, isSelectMode)"\n    ng-class="{\'disabled\': isSelectMode}">\n    <i class="fa fa-times-circle"></i>\n    <translate>No comments set</translate>\n  </span>\n  \x3c!-- recommendation --\x3e\n  <span ng-repeat="recommendation in recommendations" class="pointer spacer-left-lg"\n    ng-if="filter.multiselectFilters.recommendation.indexOf(recommendation.id) > -1"\n    ng-click="filter.operateMultiselectFilter(\'recommendation\', recommendation.id, isSelectMode)"\n    ng-class="{\'disabled\': isSelectMode}">\n    <span class="nobr">\n      <i class="fa fa-times-circle"></i>\n      {{ recommendation.recommendation_label | translate }}\n    </span>\n  </span>\n  <span ng-if="filter.multiselectFilters.motionBlock.indexOf(-1) > -1" class="pointer spacer-left-lg"\n    ng-click="filter.operateMultiselectFilter(\'motionBlock\', -1, isSelectMode)"\n    ng-class="{\'disabled\': isSelectMode}">\n    <i class="fa fa-times-circle"></i>\n    <translate>No motion block set</translate>\n  </span>\n  \x3c!-- tags --\x3e\n  <span ng-repeat="tag in tags" class="pointer spacer-left-lg"\n    ng-if="filter.multiselectFilters.tag.indexOf(tag.id) > -1"\n    ng-click="filter.operateMultiselectFilter(\'tag\', tag.id, isSelectMode)"\n    ng-class="{\'disabled\': isSelectMode}">\n    <span class="nobr">\n      <i class="fa fa-times-circle"></i>\n      {{ tag.name }}\n    </span>\n  </span>\n  <span ng-if="filter.multiselectFilters.tag.indexOf(-1) > -1" class="pointer spacer-left-lg"\n    ng-click="filter.operateMultiselectFilter(\'tag\', -1, isSelectMode)"\n    ng-class="{\'disabled\': isSelectMode}">\n    <i class="fa fa-times-circle"></i>\n    <translate>No tag set</translate>\n  </span>\n  \x3c!-- for all boolean Filters --\x3e\n  <span ng-repeat="(name, booleanFilter) in filter.booleanFilters"\n    ng-hide="booleanFilter.value === undefined"\n    class="pointer spacer-left-lg"\n    ng-click="booleanFilter.value = undefined; filter.save();"\n    ng-class="{\'disabled\': isSelectMode}">\n    <span class="nobr">\n      <i class="fa fa-times-circle"></i>\n      {{ booleanFilter.value ? booleanFilter.choiceYes : booleanFilter.choiceNo | translate }}\n    </span>\n  </span>\n</div>\n'),n.put("motions/static/templates/motions/slide_motion.html",'<div ng-controller="SlideMotionCtrl" class="content">\n  <div id="sidebox" ng-if="!config(\'motions_disable_sidebox_on_projector\')">\n    \x3c!-- State --\x3e\n    <h3 translate>State</h3>\n    {{ motion.getStateName() }}\n\n    \x3c!-- Recommendation --\x3e\n    <div ng-if="motion.getRecommendationName() != \'\' && !config(\'motions_disable_recommendation_on_projector\')">\n      <h3>{{ config(\'motions_recommendations_by\') }}</h3>\n      {{ motion.getRecommendationName() }}\n    </div>\n\n    \x3c!-- Submitters --\x3e\n    <h3 ng-if="motion.submitters.length > 0" translate>Submitters</h3>\n    <div ng-repeat="submitter in motion.submitters | orderBy: \'weight\'">\n      {{ submitter.user.get_full_name() }}<span ng-hide="$last">,</span>\n    </div>\n\n    \x3c!-- Poll results --\x3e\n    <h3 ng-if="motion.polls.length > 0 && motion.polls[0].has_votes" translate>Voting result</h3>\n      <div ng-repeat="poll in motion.polls | orderBy:\'-id\'" class="spacer">\n        <div ng-show="poll.has_votes" class="pollresults">\n          <strong ng-if="motion.polls.length > 1">\n            <translate>Vote</translate> {{ motion.polls.length - $index }}:\n          </strong>\n          <table class="transparentTable spacer">\n            \x3c!-- yes --\x3e\n            <tr>\n              <td class="icon">\n                <i class="fa fa-thumbs-up fa-lg"></i>\n              <td ng-init="voteYes = poll.getVote(poll.yes, \'yes\')">\n                <span class="result_label"><translate>Yes</translate>:</span>\n                <span class="result_value">\n                  {{ voteYes.value | number:getPollVotesPrecision(poll) }} {{ voteYes.percentStr }}\n                </span>\n                <div ng-if="voteYes.percentNumber">\n                  <uib-progressbar value="voteYes.percentNumber" type="success"></uib-progressbar>\n                </div>\n            \x3c!-- no --\x3e\n            <tr>\n              <td class="icon">\n                <i class="fa fa-thumbs-down fa-lg"></i>\n              <td ng-init="voteNo = poll.getVote(poll.no, \'no\')">\n                <span class="result_label"><translate>No</translate>:</span>\n                <span class="result_value" >\n                  {{ voteNo.value | number:getPollVotesPrecision(poll) }} {{ voteNo.percentStr }}\n                </span>\n                <div ng-if="voteNo.percentNumber">\n                  <uib-progressbar value="voteNo.percentNumber" type="danger"></uib-progressbar>\n                </div>\n            \x3c!-- abstain --\x3e\n            <tr>\n              <td class="icon">\n                <strong style="font-size: 26px">&empty;</strong>\n              <td ng-init="voteAbstain = poll.getVote(poll.abstain, \'abstain\')">\n                <span class="result_label"><translate>Abstain</translate>:</span>\n                <span class="result_value">\n                  {{ voteAbstain.value | number:getPollVotesPrecision(poll) }} {{ voteAbstain.percentStr }}\n                </span>\n                <div ng-if="voteAbstain.percentNumber">\n                  <uib-progressbar value="voteAbstain.percentNumber" type="warning"></uib-progressbar>\n                </div>\n          </table>\n        </div>\n      </div>\n  </div>\n\n  <div ng-style="{\'width\': config(\'motions_disable_sidebox_on_projector\') ? \'100%\' : \'calc(100% - 230px)\'}"\n      class="scrollcontent">\n    \x3c!-- Title --\x3e\n    <div id="title">\n      <h1>{{ motion.getTitleWithChanges(mode) }}</h1>\n      <h2>\n        <translate>Motion</translate> {{ motion.identifier }}\n        <span ng-if="motion.versions.length > 1" >| Version {{ motion.getVersion().version_number }}</span>\n        <span ng-if="motion.isParagraphBasedAmendment()"\n            ng-init="paragraph = motion.getAmendmentParagraphsLinesDiff()[0]">\n          <span ng-if="paragraph">\n            <span ng-if="paragraph.diffLineTo == paragraph.diffLineFrom + 1">\n              (<translate>Line</translate> {{ paragraph.diffLineFrom }})\n            </span>\n            <span ng-if="paragraph.diffLineTo != paragraph.diffLineFrom + 1">\n              (<translate>Line</translate> {{ paragraph.diffLineFrom }}-{{ paragraph.diffLineTo }})\n            </span>\n          </span>\n        </span>\n      </h2>\n    </div>\n\n    <div class="zoomcontent" ng-if="!motion.isParagraphBasedAmendment()">\n      \x3c!-- Preamble --\x3e\n      <div><p>{{ config(\'motions_preamble\') | translate }}</p></div><br>\n\n      \x3c!-- Text --\x3e\n      \x3c!-- Original view --\x3e\n      <div ng-if="mode == \'original\'">\n        <div id="view-original-inline-editor" ng-bind-html="motion.getTextWithLineBreaks(null, highlight) | trusted"\n          class="motion-text motion-text-original line-numbers-{{ config(\'motions_default_line_numbering\') }}"\n          contenteditable="false"></div>\n      </div>\n\n      \x3c!-- Diff View --\x3e\n      <div ng-if="mode == \'diff\'">\n          <div ng-if="title_change_recommendation" class="diff-box-{{ title_change_recommendation.id }} diff-box-title">\n              <div class="motion-text motion-text-diff line-numbers-{{ lineNumberMode }}">\n                  <div class="description">\n                      <translate>New title</translate>:\n                  </div>\n                  <div>{{ title_change_recommendation.text }}</div>\n              </div>\n          </div>\n\n        \x3c!-- The actual diff view --\x3e\n        <div class="motion-text-with-diffs line-numbers-{{ config(\'motions_default_line_numbering\') }}">\n          <div ng-repeat="change in amendments_crs">\n            <div class="motion-text original-text line-numbers-{{ config(\'motions_default_line_numbering\') }}"\n                  ng-if="$index === 0 || amendments_crs[$index - 1].line_to < change.line_from"\n                  ng-bind-html="motion.getTextBetweenChanges(version, amendments_crs[$index - 1], change, highlight) | trusted">\n            </div>\n            <div class="diff-box diff-box-{{ change.id }} clearfix motion-text motion-text-diff line-numbers-{{ config(\'motions_default_line_numbering\') }}">\n              <div ng-bind-html="change.getDiff(motion, null, highlight) | trusted"></div>\n            </div>\n          </div>\n          <div class="motion-text original-text line-numbers-{{ config(\'motions_default_line_numbering\') }}"\n            ng-bind-html="motion.getTextRemainderAfterLastChange(version, amendments_crs, highlight) | trusted">\n          </div>\n\n        </div>\n      </div>\n\n      \x3c!-- Changed View --\x3e\n      <div ng-if="mode == \'changed\'">\n        <div ng-bind-html="motion.getTextByMode(\'changed\', null, highlight) | trusted"\n          class="motion-text motion-text-changed line-numbers-{{ config(\'motions_default_line_numbering\') }}"></div>\n      </div>\n\n      \x3c!-- Agreed View --\x3e\n      <div ng-if="mode == \'agreed\'">\n        <div ng-bind-html="motion.getTextByMode(\'agreed\', null, highlight) | trusted"\n          class="motion-text motion-text-changed line-numbers-{{ config(\'motions_default_line_numbering\') }}"></div>\n      </div>\n\n      \x3c!-- Modified agreed View --\x3e\n      <div ng-if="mode == \'modified_agreed\'">\n        <div ng-bind-html="motion.getTextByMode(\'modified_agreed\', null, highlight) | trusted"\n          class="motion-text motion-text-changed line-numbers-{{ config(\'motions_default_line_numbering\') }}"></div>\n      </div>\n\n      \x3c!-- Reason --\x3e\n      <div ng-if="motion.getReason() && !config(\'motions_disable_reason_on_projector\')">\n        <h3 translate>Reason</h3>\n        <div ng-bind-html="motion.getReason() | trusted"></div>\n      </div>\n    </div>\n\n\n    \x3c!-- Amendments --\x3e\n    <div class="zoomcontent" ng-if="motion.isParagraphBasedAmendment()">\n      <div ng-repeat="paragraph in amendment_diff_paragraphs" class="motion-text motion-text-diff line-numbers-{{ lineNumberMode }}"\n           ng-class="{\'amendment-context\': showAmendmentContext}">\n        <div ng-bind-html="paragraph.text | trusted"></div>\n      </div>\n\n      \x3c!-- Reason --\x3e\n      <div ng-if="motion.getReason() && !config(\'motions_disable_reason_on_projector\')">\n        <h3 translate>Reason</h3>\n        <div ng-bind-html="motion.getReason() | trusted"></div>\n      </div>\n    </div>\n  </div>\n</div>\n'),n.put("motions/static/templates/motions/slide_motion_block.html",'<div ng-controller="SlideMotionBlockCtrl" class="content scrollcontent">\n  \x3c!-- Title --\x3e\n  <div id="title">\n    <h1>{{ motionBlock.agenda_item.getTitle() }}</h1>\n    <h2><translate>Motion block</translate> &mdash; {{motionBlock.motions.length }} <translate>Motions</translate></h2>\n  </div>\n\n  \x3c!-- motion list --\x3e\n  <div class="motion-block zoomcontent">\n    <div ng-repeat="motion in motionBlock.motions">\n      {{ motion.identifier }}:\n      {{ getShortTitle(motion) }}\n      <br>\n      <span class="label" ng-class="\'label-\'+motion.recommendation.css_class">\n        {{ motion.getRecommendationName() }}\n      </span>\n    </div>\n  </div>\n</div>\n'),n.put("motions/static/templates/motions/state-edit.html",'<h1 ng-if="state" translate>Edit state</h1>\n<h1 ng-if="!state" translate>Create new state</h1>\n<div uib-alert ng-show="alert.show" class="alert-danger" ng-click="alert={}" close="alert={}">\n  {{ alert.msg }}\n</div>\n\n<form name="stateForm" ng-submit="save()">\n  <label for="name" translate>\n    Name\n  </label>\n  <div>\n    <input class="form-control" id="name" type="text" ng-model="newName">\n  </div>\n  <label for="actionword" class="spacer-top" translate>\n    Action word\n  </label>\n  <div>\n    <input class="form-control" id="actionword" type="text" ng-model="actionWord">\n  </div>\n  <div class="spacer-top-lg">\n    <button type="submit" ng-disabled="newName == \'\'" class="btn btn-primary" translate>\n      Save\n    </button>\n    <button ng-click="closeThisDialog()" class="btn btn-default" translate>\n      Cancel\n    </button>\n  </div>\n</form>\n'),
n.put("motions/static/templates/motions/workflow-detail.html",'<div class="header">\n  <div class="title">\n    <div class="submenu">\n      <a ui-sref="motions.workflow.list" class="btn btn-sm btn-default">\n        <i class="fa fa-angle-double-left fa-lg"></i>\n        <translate>Back to overview</translate>\n      </a>\n      <a os-perms="motions.can_manage" class="btn btn-primary btn-sm"\n        ng-click="openStateDialog()" title="add new state">\n        <i class="fa fa-plus fa-lg"></i>\n        <translate>New</translate>\n      </a>\n      <button type="button" class="btn btn-sm"\n        ng-class="expandContent ? \'btn-primary\' : \'btn-default\'"\n        ng-click="toggleExpandContent(); saveExpandState(expandContent)">\n        <i class="fa fa-arrows-h fa-lg"></i>\n        <span ng-if="!expandContent" translate>Expand</span>\n        <span ng-if="expandContent" translate>Reduce</span>\n      </button>\n    </div>\n    <h1>\n      {{ workflow.name | translate }}\n      <i class="fa fa-pencil pointer" ng-click="openWorkflowDialog()"></i>\n    </h1>\n  </div>\n  <div class="title">\n    <h3>\n      <translate>First state</translate>:\n      {{ workflow.getFirstState().name | translate }}\n    </h3>\n  </div>\n</div>\n\n<div class="details">\n  <div uib-alert ng-show="alert.show" class="alert-danger" ng-click="alert={}" close="alert={}">\n    {{ alert.msg }}\n  </div>\n  <table id="multi-table" class="table table-bordered">\n    <thead>\n      <tr>\n        <th class="info-head small">\n          <h4 translate>Permissions</h4>\n        <th ng-repeat="state in states" ng-mouseover="thHover=true" ng-mouseleave="thHover=false">\n          <span class="optional">\n            {{ state.name | translate }}\n          </span>\n          <span class="optional-show" uib-tooltip="{{ state.name | translate }}">\n            {{ state.name | translate | limitTo: 1 }}...\n          </span>\n          <div os-perms="motions.can_manage" class="hoverActions text-center"\n            ng-class="{\'hiddenDiv\': !thHover}">\n            \x3c!--edit name--\x3e\n            <a href="" ng-click="openStateDialog(state)">\n              <i class="fa fa-pencil fa-lg"></i></a>\n                &nbsp;\n            \x3c!--delete--\x3e\n            <a href="" class="text-danger" ng-if="state.id !== workflow.first_state_id"\n              ng-bootbox-confirm="{{ \'Are you sure you want to delete this entry?\' | translate }}<br>\n              <b>{{ state.name | translate }}</b>"\n              ng-bootbox-confirm-action="delete(state)">\n                <i class="fa fa-trash fa-lg"></i>\n            </a>\n          </div>\n        </th>\n      </tr>\n    </thead>\n    <tbody>\n      <tr>\n        <td>\n          <b translate>Action word</b>\n        </td>\n        <td ng-repeat="state in states" ng-mouseover="tdHover=true" ng-mouseleave="tdHover=false">\n          <div class="popover-wrapper">\n            <span editable-text="state.newActionWord"\n              onaftersave="setMember(state, \'action_word\', state.newActionWord)">\n              <div class="no-overflow" ng-if="state.action_word">\n                {{ state.action_word | translate }}\n              </div>\n              <span class="text-muted" ng-if="!state.action_word">\n                &mdash;\n              </span>\n              <i class="fa fa-pencil" ng-if="tdHover"></i>\n            </span>\n          </div>\n        </td>\n      </tr>\n      <tr>\n        <td>\n          <b translate>Recommendation label</b>\n        </td>\n        <td ng-repeat="state in states" ng-mouseover="tdHover=true" ng-mouseleave="tdHover=false">\n          <div class="popover-wrapper">\n            <span editable-text="state.newRecommendationLabel"\n              onaftersave="setMember(state, \'recommendation_label\', state.newRecommendationLabel)">\n              <div class="no-overflow" ng-if="state.recommendation_label">\n                {{ state.recommendation_label | translate }}\n              </div>\n              <span class="text-muted" ng-if="!state.recommendation_label">\n                &mdash;\n              </span>\n              <i class="fa fa-pencil" ng-if="tdHover"></i>\n            </span>\n          </div>\n        </td>\n      </tr>\n      <tr ng-repeat="member in booleanMembers">\n        <td>\n          <b>{{ member.displayName | translate }}</b>\n        </td>\n        <td ng-repeat="state in states" class="pointer"\n          ng-click="changeBooleanMember(state, member.name)">\n          \x3c!-- Simulating a checkbox with FontAwesome icons. --\x3e\n          <i class="fa"\n            ng-class="xor(state[member.name], member.inverse) ? \'fa-check-square-o\' : \'fa-square-o\'"></i>\n        </td>\n      </tr>\n      <tr>\n        <td>\n          <b translate>Label color</b>\n        </td>\n        <td ng-repeat="state in states" ng-mouseover="tdHover=true" ng-mouseleave="tdHover=false">\n          <span uib-dropdown>\n            <span id="dropdownCssClass{{ state.id }}" class="pointer" uib-dropdown-toggle>\n              <span class="label" ng-class="\'label-\' + state.css_class">\n                {{ cssClasses[state.css_class] | translate }}\n              </span>\n              <i class="fa fa-cog" ng-if="tdHover"></i>\n            </span>\n            <ul class="dropdown-menu" aria-labelledby="dropdownCssClass{{ state.id }}">\n              <li ng-repeat="(class, name) in cssClasses">\n                <a href ng-click="setMember(state, \'css_class\', class)">\n                  <i class="fa fa-check" ng-if="state.css_class === class"></i>\n                  {{ name | translate }}\n                </a>\n              </li>\n            </ul>\n          </span>\n        </td>\n      </tr>\n      <tr>\n        <td>\n          <b translate>Required permission to see</b>\n        </td>\n        <td ng-repeat="state in states" ng-mouseover="tdHover=true" ng-mouseleave="tdHover=false">\n          <span uib-dropdown>\n            <span id="dropdownPermission{{ state.id }}" class="pointer" uib-dropdown-toggle>\n              <div class="no-overflow">\n                <span ng-if="state.required_permission_to_see">\n                  {{ getPermissionDisplayName(state.required_permission_to_see) | translate }}\n                </span>\n                <span class="text-muted" ng-if="!state.required_permission_to_see">\n                  &mdash;\n                </span>\n                <i class="fa fa-cog" ng-if="tdHover"></i>\n              </div>\n            </span>\n            <ul class="dropdown-menu" aria-labelledby="dropdownPermission{{ state.id }}">\n              <li ng-repeat="permission in permissions">\n                <a href ng-click="clickPermission(state, permission)">\n                  <i class="fa fa-check" ng-if="state.required_permission_to_see === permission.value"></i>\n                  {{ permission.display_name | translate }}\n                </a>\n              </li>\n            </ul>\n          </span>\n        </td>\n      </tr>\n      <tr>\n        <td>\n          <b translate>Next states</b>\n        </td>\n        <td ng-repeat="state in states" ng-mouseover="tdHover=true" ng-mouseleave="tdHover=false">\n          <span ng-if="state.getNextStates().length === 0" class="text-muted">\n            &mdash;\n          </span>\n          <div class="no-overflow">\n            <span ng-repeat="nextState in state.getNextStates()">\n              {{ nextState.name | translate }}<span ng-if="!$last">,</br></span>\n            </span>\n          </div>\n          <span uib-dropdown>\n            <span id="dropdownNextStates{{ state.id }}" class="pointer"\n              uib-dropdown-toggle>\n              <i class="fa fa-cog" ng-if="tdHover"></i>\n            </span>\n            <ul class="dropdown-menu" aria-labelledby="dropdownNextStates{{ state.id }}">\n              <li ng-repeat="s in states">\n                <a href ng-click="clickNextStateEntry(state, s.id)">\n                  <i class="fa fa-check" ng-if="state.next_states_id.indexOf(s.id) > -1"></i>\n                  {{ s.name | translate }}\n                </a>\n              </li>\n            </ul>\n          </span>\n        </td>\n      </tr>\n    </tbody>\n  </table>\n</div>\n'),n.put("motions/static/templates/motions/workflow-edit.html",'<h1 ng-if="workflow" translate>Edit name</h1>\n<h1 ng-if="!workflow" translate>Create new workflow</h1>\n<div uib-alert ng-show="alert.show" class="alert-danger" ng-click="alert={}" close="alert={}">\n  {{ alert.msg }}\n</div>\n\n<form name="workflowForm" ng-submit="save()">\n<label for="name_1">\n  <span ng-if="workflow" translate>\n    Please enter a new workflow name:\n  </span>\n  <span ng-if="!workflow" translate>\n    Please enter a name for the new workflow:\n  </span>\n</label>\n<div>\n  <div>\n    <input class="form-control" id="name_1" type="text" ng-model="newName">\n  </div>\n  <div class="spacer-top-lg">\n    <button type="submit" ng-disabled="newName == \'\'" class="btn btn-primary" translate>\n      Save\n    </button>\n    <button ng-click="closeThisDialog()" class="btn btn-default" translate>\n      Cancel\n    </button>\n  </div>\n</div>\n</form>\n'),n.put("motions/static/templates/motions/workflow-list.html",'<div class="header">\n  <div class="title">\n    <div class="submenu">\n      <a ui-sref="motions.motion.list" class="btn btn-sm btn-default">\n        <i class="fa fa-angle-double-left fa-lg"></i>\n        <translate>Back to overview</translate>\n      </a>\n      <a href="" os-perms="motions.can_manage" class="btn btn-primary btn-sm" ng-click="create()">\n        <i class="fa fa-plus fa-lg"></i>\n        <translate>New</translate>\n      </a>\n    </div>\n    <h1 translate>Workflows</h1>\n  </div>\n</div>\n\n<div class="details">\n  <div uib-alert ng-show="alert.show" class="alert-danger" ng-click="alert={}" close="alert={}">\n    {{ alert.msg }}\n  </div>\n  <table class="table table-striped table-bordered table-hover">\n    <thead>\n      <tr>\n        <th>\n          <translate>Name</translate>\n        </th>\n      </tr>\n    </thead>\n    <tbody>\n      <tr ng-repeat="workflow in workflows | orderBy: \'name\'">\n        <td ng-mouseover="workflow.hover=true" ng-mouseleave="workflow.hover=false">\n          <strong>{{ workflow.name | translate }}</strong>\n          <div class="hoverActions" ng-class="{\'hiddenDiv\': !workflow.hover}">\n            \x3c!-- edit --\x3e\n            <a ui-sref="motions.workflow.detail({id: workflow.id})" translate>Edit</a> &middot;\n            \x3c!-- delete --\x3e\n            <a href="" class="text-danger"\n              ng-bootbox-confirm="{{ \'Are you sure you want to delete this entry?\' | translate }}<br>\n                <b>{{ workflow.name }}</b>"\n              ng-bootbox-confirm-action="delete(workflow)" translate>Delete</a>\n          </div>\n        </td>\n      </tr>\n    </tbody>\n  </table>\n</div>\n'),n.put("topics/static/templates/topics/slide_topic.html",'<div ng-controller="SlideTopicCtrl" class="content scrollcontent">\n  <h1>{{ topic.agenda_item.getTitle() }}</h1>\n  <div ng-bind-html="topic.text | trusted" class="zoomcontent topictext"></div>\n</div>\n'),n.put("topics/static/templates/topics/topic-detail.html",'<div class="header">\n  <div class="title">\n    <div class="submenu">\n      <a ui-sref="agenda.item.list" class="btn btn-sm btn-default">\n        <i class="fa fa-angle-double-left fa-lg"></i>\n        <translate>Back to overview</translate>\n      </a>\n      \x3c!-- List of speakers --\x3e\n      <a ui-sref="agenda.item.detail({id: topic.agenda_item_id})" class="btn btn-sm btn-default">\n        <i class="fa fa-microphone fa-lg"></i>\n        <translate>List of speakers</translate>\n      </a>\n      \x3c!-- project --\x3e\n      <projector-button model="topic" default-projector-id="defaultProjectorId"\n        title="{{ \'Project\' | translate }}">\n      </projector-button>\n      \x3c!-- edit --\x3e\n      <a os-perms="agenda.can_manage" ng-click="openDialog(topic)"\n          class="btn btn-default btn-sm"\n          title="{{ \'Edit\' | translate}}">\n        <i class="fa fa-pencil fa-lg"></i>\n      </a>\n    </div>\n    <h1>{{ topic.agenda_item.getTitle() }}</h1>\n    <h2 translate>Topic</h2>\n  </div>\n</div>\n\n<div class="details">\n  <div ng-bind-html="topic.text | trusted" class="topictext"></div>\n  <h3 ng-if="topic.attachments.length > 0" translate>Attachments</h3>\n  <ul>\n    <li ng-repeat="attachment in topic.attachments | orderBy: \'title_or_filename\'">\n      <a href="{{ attachment.mediafileUrl }}" target="_blank">\n        {{ attachment.title_or_filename }}\n      </a>\n  </ul>\n</div>\n\n<template-hook hook-name="topicDetailViewDetailContainer"></template-hook>\n'),n.put("topics/static/templates/topics/topic-form.html",'<h1 ng-if="model.id" translate>Edit topic</h1>\n<h1 ng-if="!model.id" translate>New topic</h1>\n\n<div uib-alert ng-show="alert.show" ng-class="\'alert-\' + (alert.type || \'warning\')" ng-click="alert={}" close="alert={}">\n  {{ alert.msg }}\n</div>\n\n<form name="topicForm" ng-submit="save(model)">\n  <formly-form model="model" fields="formFields">\n    <button type="submit" ng-disabled="topicForm.$invalid" class="btn btn-primary" translate>\n      Save\n    </button>\n    <button type="button" ng-click="closeThisDialog()" class="btn btn-default" translate>\n      Cancel\n    </button>\n  </formly-form>\n</form>\n'),n.put("topics/static/templates/topics/topic-import.html",'<div class="header">\n  <div class="title">\n    <div class="submenu">\n      <a ui-sref="agenda.item.list" class="btn btn-sm btn-default">\n        <i class="fa fa-angle-double-left fa-lg"></i>\n        <translate>Back to overview</translate>\n      </a>\n    </div>\n    <h1 translate>Import topics</h1>\n  </div>\n</div>\n\n<div class="details">\n<h2 translate>Import by copy/paste</h2>\n<p translate>Copy and paste your topic titles in this textbox. Keep each item in a single line.</p>\n\n<div class="row">\n  <div class="form-group col-sm-6">\n    <textarea ng-model="itemlist" rows="5" class="form-control" ng-list="/\\n/"></textarea>\n  </div>\n</div>\n\n<div class="clearfix">\n  <button ng-click="importByLine()" class="btn btn-primary btn-sm pull-left" translate>Import</button>\n  <div class="col-xs-5" ng-if="titleItems">\n    <progressbar animate="false" type="success" max="titleItems.length" value="importcounter">\n      <i>{{ importcounter }} / {{ titleItems.length }} {{ "imported" | translate }}</i>\n    </progressbar>\n  </div>\n</div>\n<div class="spacer">\n  <a ng-if="importcounter > 0 && importcounter == titleItems.length" ui-sref="agenda.item.list"\n      class="btn btn-default btn-sm">\n    <i class="fa fa-angle-double-left fa-lg"></i>\n    <translate>Back to agenda</translate>\n  </a>\n</div>\n\n<hr>\n\n<h2 translate>Import by CSV file</h2>\n\n  <h3 translate>Select a CSV file</h3>\n  <csv-import change="onCsvChange(csv)" config="csvConfig"></csv-import>\n\n  <h4 translate>Please note:</h4>\n  <ul class="indentation">\n      <li><translate>Required comma or semicolon separated values with these column header names in the first row</translate>:<br>\n          <code>\n            <translate>Title</translate>,\n            <translate>Text</translate>,\n            <translate>Duration</translate>,\n            <translate>Comment</translate>,\n            <translate>Internal item</translate>\n          </code>\n      <li translate>Title is required. All other fields are optional and may be empty.\n      <li translate>Only double quotes are accepted as text delimiter (no single quotes).\n      <li><a id="downloadLink" href="" ng-click="downloadCSVExample()" translate>Download CSV example file</a>\n  </ul>\n\n  <div ng-if="items.length">\n    <h3 translate>Preview</h3>\n    <div class="scroll-x-container">\n      <table ng-if="!csvImporting" class="table table-striped table-bordered table-condensed">\n        <thead>\n          <tr>\n            <th>\n            <th>#\n            <th translate>Title\n            <th translate>Text\n            <th translate>Duration\n            <th translate>Comment\n            <th translate>Internal item</th>\n        <tbody ng-repeat="item in items">\n          <tr>\n            <td class="minimum"\n                ng-class="{ \'text-danger\': item.importerror, \'text-success\': item.imported }">\n              <span ng-if="item.importerror">\n                <i class="fa fa-exclamation-triangle fa-lg"></i>\n              </span>\n              <span ng-if="!item.importerror && !item.imported" class="pointer">\n                <i class="fa fa-check-circle-o fa-lg" ng-if="item.selected" ng-click="item.selected=false; calcStats();"></i>\n                <i class="fa fa-circle-o fa-lg" ng-if="!item.selected" ng-click="item.selected=true; calcStats();"></i>\n              </span>\n              <span ng-if="item.imported">\n                <i class="fa fa-check-circle fa-lg"></i>\n              </span>\n            <td class="minimum">{{ $index + 1 }}\n            <td ng-class="{ \'text-danger\': item.title_error }">\n              <span ng-if="item.title_error" title="{{ item.title_error | translate }}">\n                <i class="fa fa-exclamation-triangle"></i>\n              </span>\n              {{ item.title }}\n            <td>{{ item.text | limitTo:80 }}{{ item.text.length > 80 ? \'...\' : \'\' }}\n            <td><span ng-if="item.duration">{{ item.duration | osMinutesToTime }}</span>\n            <td>{{ item.comment }}\n            <td>{{ item.is_hidden }}\n      </table>\n    </div>\n\n    <div ng-if="itemsWillNotBeImported" class="text-danger">\n      <i class="fa fa-exclamation-triangle"></i>\n      {{ itemsWillNotBeImported }}\n      <translate>topics will be not imported.</translate>\n    </div>\n    <div>\n      <i class="fa fa-check-circle-o fa-lg"></i>\n      {{ itemsWillBeImported }}\n      <translate>topics will be imported.</translate>\n    </div>\n    <div ng-repeat="item in itemsImported = (items | filter:{imported:true})"></div>\n    <div ng-if="itemsImported.length > 0" class="text-success">\n      <hr class="smallhr">\n      <i class="fa fa-check-circle fa-lg"></i>\n      {{ itemsImported.length }}\n      <translate>topics were successfully imported.</translate>\n    </div>\n\n    <div class="spacer">\n      <button ng-click="clear()" class="btn btn-default btn-sm" translate>\n        Clear preview\n      </button>\n      <button ng-if="!csvImporting && itemsWillBeImported > 0" ng-click="import()" class="btn btn-primary btn-sm" translate>\n        Import {{ itemsWillBeImported }} topics\n      </button>\n    </div>\n    <div class="spacer">\n      <a ng-if="csvimported" ui-sref="agenda.item.list" class="btn btn-default btn-sm">\n        <i class="fa fa-angle-double-left fa-lg"></i>\n        <translate>Back to agenda</translate>\n      </a>\n    </div>\n  </div>\n</div>\n'),n.put("users/static/templates/users/group-edit.html",'<h1 ng-if="group" translate>Edit name</h1>\n<h1 ng-if="!group" translate>Create new group</h1>\n<div uib-alert ng-show="alert.show" class="alert-danger" ng-click="alert={}" close="alert={}">\n  {{ alert.msg }}\n</div>\n\n<form name="groupForm" ng-submit="save()">\n<label for="name_1">\n  <span ng-if="group">\n    <translate>Please enter a new group name:</translate>\n  </span>\n  <span ng-if="!group" translate>\n    Please enter a name for the new group:\n  </span>\n</label>\n<div>\n  <div>\n    <input class="form-control" id="name_1" type="text" ng-model="new_name">\n  </div>\n  <div class="spacer-top-lg">\n    <button type="submit" ng-disabled="new_name == \'\'" class="btn btn-primary" translate>\n      Save\n    </button>\n    <button ng-click="closeThisDialog()" class="btn btn-default" translate>\n      Cancel\n    </button>\n  </div>\n</div>\n</form>\n'),n.put("users/static/templates/users/group-list.html",'<div class="header">\n  <div class="title">\n    <div class="submenu">\n      <a ui-sref="users.user.list" class="btn btn-sm btn-default">\n        <i class="fa fa-angle-double-left fa-lg"></i>\n        <translate>Back to overview</translate>\n      </a>\n      <a os-perms="users.can_manage" class="btn btn-primary btn-sm"\n        ng-click="openDialog()" title="add new group">\n        <i class="fa fa-plus fa-lg"></i>\n        <translate>New</translate>\n      </a>\n    </div>\n    <h1 translate>Groups</h1>\n  </div>\n</div>\n\n<div class="details">\n  <p translate>\n    All your changes are saved immediately. Changes you make are only effective once you (or the users concerned) reload the page.\n  </p>\n  <table id="multi-table" class="table table-bordered">\n    <thead>\n      <tr>\n        <th class="info-head">\n          <h4 translate>Permissions</h4>\n        <th ng-repeat="group in groups" ng-mouseover="group.hover=true" ng-mouseleave="group.hover=false">\n          <span class="optional">\n            {{ group.name | translate }}\n          </span>\n          <span class="optional-show" uib-tooltip="{{ group.name | translate }}">\n            {{ group.name | translate | limitTo: 1 }}...\n          </span>\n          <i class="fa fa-info-circle" ng-if="group.id == 1"\n            uib-tooltip="{{ \'Users without any assigned group gain the permissions from this group.\' | translate }}"></i>\n          <div os-perms="users.can_manage" ng-hide="group.id == 1" class="hoverActions text-center"\n            ng-class="{\'hiddenDiv\': !group.hover}">\n            \x3c!--edit name--\x3e\n            <a href="" ng-click="openDialog(group)">\n              <i class="fa fa-pencil fa-lg"></i></a>\n                &nbsp;\n            \x3c!--delete--\x3e\n            <a href="" class="text-danger"\n              ng-if="group_danger.id != group.id"\n              ng-bootbox-confirm="{{ \'Are you sure you want to delete this entry?\' | translate }}<br>\n              <b>{{ group.name | translate }}</b>"\n              ng-bootbox-confirm-action="delete(group)">\n                <i class="fa fa-trash fa-lg"></i>\n            </a>\n          </div>\n      <tbody ng-repeat="app in apps" os-perms="users.can_manage">\n          <tr class="pointer bg-grey" ng-click="app.app_visible=!app.app_visible">\n            <td>\n              <b>{{ app.app_name | translate}}</b>\n              <i class="fa" ng-class="app.app_visible ? \'fa-minus-square\' : \'fa-plus-square\'">\n            <td ng-repeat="group in groups">\n              \x3c!-- empty, just filling the table --\x3e\n          <tr ng-repeat="permission in app.permissions" ng-class="{\'collapse\': !app.app_visible}">\n            <td>\n              {{ permission.display_name | translate }}\n            <td class="pointer" ng-repeat="group in groups"\n              ng-click="changePermission(group, permission)">\n              \x3c!-- Simulating a checkbox with FontAwesome icons. --\x3e\n              <i class="fa"\n                ng-if="!danger(group, permission)"\n                ng-class="hasPerm(group, permission) ? \'fa-check-square-o\' : \'fa-square-o\'"></i>\n              <span class="fa fa-stack"\n                 ng-if="danger(group, permission)"\n                 uib-tooltip="{{ \'You are not allowed to lock yourself out of the configuration!\' | translate }}">\n                <i class="fa fa-check-square-o fa-stack-1x"></i>\n                <i class="fa fa-ban fa-stack-2x text-danger"></i>\n              </span>\n  </table>\n</div>\n'),n.put("users/static/templates/users/profile-password-form.html",'<h1>{{ title | translate }}</h1>\n\n<div uib-alert ng-show="alert.show" ng-class="\'alert-\' + (alert.type || \'warning\')" close="alert={}">\n  {{ alert.msg }}\n</div>\n\n<form name="profileForm" ng-submit="save(model)">\n  <formly-form model="model" fields="formFields">\n    <button type="submit" ng-disabled="profileForm.$invalid" class="btn btn-primary" translate>\n      Save\n    </button>\n    <button ng-click="closeThisDialog()" class="btn btn-default" translate>\n      Cancel\n    </button>\n  </formly-form>\n</form>\n'),n.put("users/static/templates/users/slide_user.html",'<div ng-controller="SlideUserCtrl" class="content scrollcontent zoomcontent">\n    <h1>{{ user.get_full_name() }}</h1>\n</div>\n'),n.put("users/static/templates/users/user-change-password.html",'<div class="header">\n  <div class="title">\n    <div class="submenu">\n      <a ui-sref="users.user.list" class="btn btn-sm btn-default">\n        <i class="fa fa-angle-double-left fa-lg"></i>\n        <translate>Back to overview</translate>\n      </a>\n    </div>\n    <h1 translate>Change password for {{ user.get_short_name() }}</h1>\n  </div>\n</div>\n\n<div class="details">\n  <form name="userForm">\n    <h3 class="text-danger" style="margin-top: 0;">\n      <i class="fa fa-exclamation-triangle"></i>\n      <translate>You override the personally set password of</translate> {{ user.get_short_name() }}!\n    </h3>\n    <div uib-alert ng-show="alert.show" ng-class="\'alert-\' + (alert.type || \'warning\')" ng-click="alert={}" close="alert={}">\n      {{ alert.msg }}\n    </div>\n    <div class="form-group">\n      <label for="inputNewPassword" translate>New password</label>\n      <div class="input-group">\n        <input show-password="showPassword"\n           ng-model="new_password"\n           class="form-control"\n           name="inputNewPassword"\n           required>\n        </input>\n        <div class="input-group-addon pointer" ng-click="generatePassword()">\n          <i class="fa fa-magic"></i>\n          <translate>Generate</translate>\n        </div>\n      </div>\n      <div class="spacer-top">\n        <translate>Initial password</translate>: {{ user.default_password }}\n        <span uib-tooltip="{{ \'Initial password can not be changed.\' | translate }}">\n          <i class="fa fa-info-circle"></i>\n        </span><br>\n        <translate>Username</translate>: {{ user.username }}\n        <span class="pull-right spacer-right pointer" ng-click="showPassword = !showPassword">\n          <translate>Show password</translate>\n          <i class="fa" ng-class="showPassword ? \'fa-check-square-o\' : \'fa-square-o\'"></i>\n        </span>\n      </div>\n    </div>\n    <button type="submit" ng-click="save(user)" class="btn btn-primary btn-sm" translate>\n      Change password\n    </button>\n    <button ui-sref="users.user.list" class="btn btn-default btn-sm" translate>\n      Cancel\n    </button>\n  </form>\n</div>\n'),n.put("users/static/templates/users/user-detail.html",'<div class="header">\n  <div class="title">\n    <div class="submenu">\n      <a ui-sref="users.user.list" class="btn btn-sm btn-default">\n        <i class="fa fa-angle-double-left fa-lg"></i>\n        <translate>Back to overview</translate>\n      </a>\n      \x3c!-- project --\x3e\n      <projector-button model="user" default-projector-id="defaultProjectorId"\n        title="{{ \'Project\' | translate }}">\n      </projector-button>\n      \x3c!-- edit --\x3e\n      <a os-perms="users.can_manage" ng-click="openDialog(user)"\n          class="btn btn-default btn-sm"\n          title="{{ \'Edit\' | translate}}">\n        <i class="fa fa-pencil"></i>\n      </a>\n    </div>\n    <h1>{{ user.get_short_name() }}</h1>\n    <h2 translate>Participant</h2>\n  </div>\n</div>\n\n<div class="details">\n  <div class="user_details form-group">\n    <fieldset>\n      <legend translate>Personal data</legend>\n      <label translate>Structure level</label>\n        {{ user.structure_level }}\n      <label translate>Groups</label>\n        <div ng-repeat="group in user.groups_id">\n          {{ (groups | filter: {id: group})[0].name | translate }}\n        </div>\n      <label translate>Participant number</label>\n        {{ user.number }}\n      <label translate>Email</label>\n        {{ user.email }}\n      <label ng-if="user.last_email_send" translate>Last email send</label>\n        {{ user.last_email_send | date: \'yyyy-MM-dd HH:mm:ss\' }}\n      <label translate>About me</label>\n        <div ng-bind-html="user.about_me | trusted"></div>\n    </fieldset>\n\n    <fieldset os-perms="users.can_manage">\n      <legend translate>Administrative data</legend>\n      <label translate>Username</label>\n        {{ user.username }}\n      <label translate>Comment</label>\n        <div class="white-space-pre-line">{{ user.comment }}</div>\n    </fieldset>\n  </div>\n</div>\n'),n.put("users/static/templates/users/user-form.html",'<h1 ng-if="model.id" translate>Edit participant</h1>\n<h1 ng-if="!model.id" translate>New participant</h1>\n\n<div uib-alert ng-show="alert.show" ng-class="\'alert-\' + (alert.type || \'warning\')" close="alert={}">\n  {{ alert.msg }}\n</div>\n\n<form name="userForm" ng-submit="save(model)">\n  <formly-form model="model" fields="formFields">\n    <button type="submit" ng-disabled="userForm.$invalid" class="btn btn-primary" translate>\n      Save\n    </button>\n    <button ng-click="closeThisDialog()" class="btn btn-default" translate>\n      Cancel\n    </button>\n  </formly-form>\n</form>\n'),
n.put("users/static/templates/users/user-import.html",'<div class="header">\n  <div class="title">\n    <div class="submenu">\n      <a ui-sref="users.user.list" class="btn btn-sm btn-default">\n        <i class="fa fa-angle-double-left fa-lg"></i>\n        <translate>Back to overview</translate>\n      </a>\n    </div>\n    <h1 translate>Import participants</h1>\n  </div>\n</div>\n\n<div class="details">\n  <div uib-alert ng-show="alert.show" ng-class="\'alert-\' + (alert.type || \'warning\')" close="alert={}">\n    {{ alert.msg }}\n  </div>\n\n  <h2 translate>Import by copy/paste</h2>\n  <p translate>Copy and paste your participant names in this textbox.\n  Keep each person in a single line.</p>\n\n  <div class="row">\n    <div class="form-group col-sm-6">\n      <textarea ng-model="userlist" rows="5" class="form-control" ng-list="/\\n/"></textarea>\n    </div>\n  </div>\n\n  <div class="clearfix">\n    <button ng-click="importByLine()" class="btn btn-primary btn-sm pull-left" translate>Import</button>\n  </div>\n  <div class="spacer">\n    <a ng-if="importcounter > 0 && importcounter == usernames.length" ui-sref="users.user.list"\n        class="btn btn-default btn-sm">\n      <i class="fa fa-angle-double-left fa-lg"></i>\n      <translate>Back to users overview</translate>\n    </a>\n  </div>\n\n  <hr>\n\n  <h2 translate>Import by CSV file</h2>\n\n  <h3 translate>Select a CSV file</h3>\n  <csv-import change="onCsvChange(csv)" config="csvConfig"></csv-import>\n\n  <h4 translate>Please note:</h4>\n  <ul class="indentation">\n      <li><translate>Required comma or semicolon separated values with these column header names in the first row</translate>:<br>\n        <code>\n          <translate>Title</translate>,\n          <translate>Given name</translate>,\n          <translate>Surname</translate>,\n          <translate>Structure level</translate>,\n          <translate>Participant number</translate>,\n          <translate>Groups</translate>,\n          <translate>Comment</translate>,\n          <translate>Is active</translate>,\n          <translate>Is present</translate>,\n          <translate>Is committee</translate>,\n          <translate>Initial password</translate>\n          <translate>Email</translate>\n        </code>\n      <li translate>At least given name or surname have to be filled in. All\n        other fields are optional and may be empty.\n      <li translate>Only double quotes are accepted as text delimiter (no single quotes).\n      <li><a id="downloadLink" href="" ng-click="downloadCSVExample()" translate>Download CSV example file</a>\n  </ul>\n\n  <div ng-show="users.length">\n    <h3 translate>Preview</h3>\n    <div class="clearfix" ng-if="users.length > pagination.itemsPerPage">\n      <span class="pull-right">\n        <translate>Page</translate> {{ pagination.currentPage }} /\n        {{ Math.ceil(users.length/pagination.itemsPerPage) }}\n      </span>\n    </div>\n    <div class="scroll-x-container">\n      <table class="table table-striped table-bordered table-condensed">\n        <thead>\n          <tr>\n            <th>\n            <th>#\n            <th translate>Title\n            <th translate>Given name\n            <th translate>Surname\n            <th translate>Structure level\n            <th translate>Participant number\n            <th translate>Groups\n            <th translate>Comment\n            <th translate>Is active\n            <th translate>Is present\n            <th translate>Is committee\n            <th translate>Initial password\n            <th translate>Email\n            <th ng-if="duplicates > 0">\n              <i class="fa fa-exclamation-triangle text-danger"></i>\n              <strong class="text-danger" ng-if="duplicates == 1">1 <translate>duplicate</translate></strong>\n              <strong class="text-danger" ng-if="duplicates > 1">{{ duplicates }} <translate>duplicates</translate></strong>\n\n                <div uib-dropdown>\n                  <button id="GlobalAction" type="button" class="btn btn-default btn-danger btn-sm" uib-dropdown-toggle>\n                    <translate>Set global action</translate>\n                    <span class="caret"></span>\n                  </button>\n                  <ul class="dropdown-menu" aria-labelledby="GlobalAction">\n                    <li ng-repeat="action in duplicateActions">\n                      <a href ng-click="setGlobalAction(action)">\n                        {{ action | translate }}\n                      </a>\n                    </li>\n                  </ul>\n                </div>\n            </th>\n        <tbody>\n          <tr ng-repeat="user in users | limitTo : pagination.itemsPerPage : pagination.limitBegin">\n            <td class="minimum"\n                ng-class="{ \'text-danger\': (user.importerror || user.duplicateAction == duplicateActions[0]), \'text-success\': user.imported }">\n              <span ng-if="user.importerror || user.duplicateAction == duplicateActions[0]">\n                <i class="fa fa-exclamation-triangle fa-lg"></i>\n              </span>\n              <span ng-if="!user.importerror && !user.imported && user.duplicateAction != duplicateActions[0]" class="pointer">\n                <i class="fa fa-check-circle-o fa-lg" ng-if="user.selected" ng-click="user.selected=false; calcStats();"></i>\n                <i class="fa fa-circle-o fa-lg" ng-if="!user.selected" ng-click="user.selected=true; calcStats();"></i>\n              </span>\n              <span ng-if="user.imported">\n                <i class="fa fa-check-circle fa-lg"></i>\n              </span>\n            <td class="nobr">\n              {{ (pagination.currentPage - 1) * pagination.itemsPerPage + $index + 1 }}\n            <td>\n              {{ user.title }}\n            <td ng-class="{ \'text-danger\': user.name_error }">\n              <span ng-if="!user.first_name && user.name_error" title="{{ user.name_error | translate }}">\n                <i class="fa fa-exclamation-triangle"></i>\n              </span>\n              {{ user.first_name }}\n            <td ng-class="{ \'text-danger\': user.name_error }">\n              <span ng-if="!user.last_name && user.name_error" title="{{ user.name_error | translate }}">\n                <i class="fa fa-exclamation-triangle"></i>\n              </span>\n              {{ user.last_name }}\n            <td>\n              {{ user.structure_level }}\n            <td>\n              {{ user.number }}\n            <td>\n              <div ng-repeat="groupname in user.groupsNotToCreate">\n                {{ groupname | translate }}\n              </div>\n              <div ng-repeat="groupname in user.groupsToCreate" class="text-warning">\n                <i class="fa fa-plus-circle"></i>\n                {{ groupname | translate }}\n              </div>\n            <td style="max-width: 130px;">\n              <span uib-tooltip="{{ user.comment }}">\n                {{ user.comment | limitTo: 30 }}{{ user.comment.length > 30 ? \'...\' : \'\' }}\n              </span>\n            <td>\n              <i class="fa pointer" ng-class="user.is_active ? \'fa-check-square-o\' : \'fa-square-o\'"\n                ng-click="user.is_active = !user.is_active"></i>\n            <td>\n              <i class="fa pointer" ng-class="user.is_present ? \'fa-check-square-o\' : \'fa-square-o\'"\n                ng-click="user.is_present = !user.is_present"></i>\n            <td>\n              <i class="fa pointer" ng-class="user.is_committee ? \'fa-check-square-o\' : \'fa-square-o\'"\n                ng-click="user.is_committee = !user.is_committee"></i>\n            <td>\n              {{ user.default_password }}\n            <td>\n              {{ user.email }}\n            <td ng-if="duplicates > 0">\n                <div ng-if="user.duplicate" uib-tooltip="{{ user.duplicate_info }}" uib-dropdown>\n                  <button id="UserAction{{ $index }}" type="button" class="btn btn-default btn-sm"\n                    uib-dropdown-toggle ng-class="user.duplicateAction == duplicateActions[0] ? \'btn-warning\' : (user.duplicateAction == duplicateActions[1] ? \'btn-danger\' : \'btn-success\')">\n                    {{ user.duplicateAction | translate }}\n                    <span class="caret"></span>\n                  </button>\n                  <ul class="dropdown-menu" aria-labelledby="UserAction{{ $index }}">\n                    <li ng-repeat="action in duplicateActions">\n                        <a href ng-click="user.duplicateAction = action; calcStats()">\n                          <i class="fa fa-check" ng-if="user.duplicateAction == action"></i>\n                          {{ action | translate }}\n                        </a>\n                    </li>\n                  </ul>\n      </table>\n    </div>\n    <ul uib-pagination\n        ng-show="users.length > pagination.itemsPerPage"\n        total-items="users.length"\n        items-per-page="pagination.itemsPerPage"\n        ng-model="pagination.currentPage"\n        ng-change="pagination.pageChanged()"\n        class="pagination-sm"\n        direction-links="false"\n        boundary-links="true"\n        first-text="&laquo;"\n        last-text="&raquo;">\n    </ul>\n\n    <div class="spacer-top-lg">\n      <div class="text-danger" ng-if="usersWillNotBeImported">\n        <i class="fa fa-exclamation-triangle"></i>\n        {{ usersWillNotBeImported }}\n        <translate>participants will be not imported.</translate>\n      </div>\n      <div class="text-danger" ng-if="duplicates > 0">\n        <i class="fa fa-exclamation-triangle"></i>\n        {{ duplicates }}\n        <translate>duplicates</translate>!\n      </div>\n      <div>\n        <i class="fa fa-check-circle-o fa-lg"></i>\n        {{ usersWillBeImported }}\n        <translate>participants will be imported.</translate>\n        <span ng-if="csvImporting && !csvimported">\n          <i class="fa fa-spinner fa-pulse fa-lg"></i>\n        </span>\n      </div>\n      <div ng-repeat="user in usersImported = (users | filter:{imported:true})"></div>\n      <div ng-if="usersImported.length > 0" class="text-success">\n        <hr class="smallhr">\n        <i class="fa fa-check-circle fa-lg"></i>\n        {{ usersImported.length }}\n        <translate>participants were successfully imported.</translate>\n        (<translate>Groups created</translate>: {{ groupsCreated }})\n      </div>\n    </div>\n\n    <div class="spacer">\n      <button ng-click="clear()" class="btn btn-default btn-sm" translate>\n        Clear preview\n      </button>\n      <button ng-if="someImportedUsers()" ng-click="excludeImportedUsers()" class="btn btn-default btn-sm" translate>\n        Exclude already imported users\n      </button>\n      <button ng-if="!csvImporting && usersWillBeImported > 0" ng-click="import()" class="btn btn-primary btn-sm" translate>\n        Import {{ usersWillBeImported }} participants\n      </button>\n    </div>\n    <div class="spacer">\n      <a ng-if="csvimported" ui-sref="users.user.list" class="btn btn-default btn-sm">\n        <i class="fa fa-angle-double-left fa-lg"></i>\n        <translate>Back to users overview</translate>\n      </a>\n    </div>\n  </div>\n</div>\n'),
n.put("users/static/templates/users/user-list.html",'<div class="header">\n  <div class="title">\n    <div class="submenu">\n      <a ng-click="openDialog()" os-perms="users.can_manage" class="btn btn-primary btn-sm">\n        <i class="fa fa-plus fa-lg"></i>\n        <translate>New</translate>\n      </a>\n      <span ng-if="config(\'users_enable_presence_view\')">\n        <a ui-sref="users.user.presence" os-perms="users.can_manage" class="btn btn-default btn-sm">\n          <i class="fa fa-barcode fa-lg"></i>\n          <translate>Presence</translate>\n        </a>\n      </span>\n      <a ui-sref="users.group.list" os-perms="users.can_manage" class="btn btn-default btn-sm">\n        <i class="fa fa-group fa-lg"></i>\n        <translate>Groups</translate>\n      </a>\n      <a ui-sref="users.user.import" os-perms="users.can_manage" class="btn btn-default btn-sm">\n        <i class="fa fa-download fa-lg"></i>\n        <translate>Import</translate>\n      </a>\n      <template-hook hook-name="userListMenuButtons"></template-hook>\n    </div>\n    <h1 translate>Participants</h1>\n  </div>\n</div>\n\n<div class="details">\n  <div uib-alert ng-show="alert.show" ng-class="\'alert-\' + (alert.type || \'warning\')" close="alert={}">\n    {{ alert.msg }}\n  </div>\n  <div class="row">\n    <div class="col-sm-6">\n      \x3c!-- select mode --\x3e\n      <button os-perms="users.can_manage" class="btn btn-sm"\n          ng-class="$parent.isSelectMode ? \'btn-primary\' : \'btn-default\'"\n          ng-click="$parent.isSelectMode = !$parent.isSelectMode; uncheckAll()">\n        <i class="fa fa-check-square-o"></i>\n        <translate>Select ...</translate>\n      </button>\n    </div>\n    <div class="col-sm-6">\n      <div class="dropdown pull-right" uib-dropdown>\n        <button os-perms="users.can_manage" class="btn btn-default btn-sm" uib-dropdown-toggle\n            id="user-pdf-dropdown">\n          <i class="fa fa-upload"></i>\n          <span ng-if="usersFiltered.length == users.length" translate>\n            Export all\n          </span>\n          <span ng-if="usersFiltered.length != users.length" translate>\n            Export filtered\n          </span>\n          <span class="caret"></span>\n        </button>\n        <ul class="dropdown-menu" dropdown-menu-right aria-labelledby="user-pdf-dropdown">\n          <li>\n              <a href="" ng-click="pdfExportUserList()">\n                <i class="fa fa-list fa-fw"></i>\n                <translate>List of participants</translate> (PDF)\n              </a>\n          <li os-perms="users.can_manage">\n              <a href="" ng-click="pdfExportUserAccessDataList()">\n                <i class="fa fa-qrcode fa-fw"></i>\n                <translate>List of access data</translate> (PDF)\n              </a>\n          <li>\n              <a href="" id="downloadLinkCSV" ng-click="csvExport()">\n                <i class="fa fa-file-text-o fa-fw"></i>\n                CSV\n              </a>\n        </ul>\n      </div>\n\n      <template-hook hook-name="userListSubmenuRight"></template-hook>\n    </div>\n  </div>\n  <div uib-collapse="!isSelectMode" class="row spacer">\n    <div os-perms="users.can_manage" ng-show="isSelectMode" class="col-sm-12 text-left form-inline">\n      \x3c!-- actions --\x3e\n      <select ng-model="selectedAction" class="form-control input-sm">\n        <option value="" translate>--- Select action ---</option>\n        <option value="delete" translate>Delete</option>\n        <option value="addGroup" translate>Add group</option>\n        <option value="removeGroup" translate>Remove group</option>\n        <option value="generatePasswords" translate>Generate new passwords</option>\n        <option value="is_active" translate>Set/Unset \'is active\'</option>\n        <option value="is_present" translate>Set/Unset \'is present\'</option>\n        <option value="is_committee" translate>Set/Unset \'is a committee\'</option>\n        <option value="send_invite_email" translate>Send invitation emails</option>\n      </select>\n      \x3c!-- delete button --\x3e\n      <a ng-show="selectedAction == \'delete\'"\n        ng-bootbox-confirm="{{ \'Are you sure you want to delete all selected users?\' | translate }}"\n        ng-bootbox-confirm-action="deleteMultiple()"\n        class="btn btn-default btn-sm btn-danger">\n        <i class="fa fa-trash fa-lg"></i>\n        <translate>Delete selected participants</translate>\n      </a>\n      \x3c!-- group select --\x3e\n      <select ng-show="selectedAction == \'addGroup\' || selectedAction == \'removeGroup\'"\n          ng-model="selectedGroup" class="form-control input-sm">\n        <option value="" translate>--- Select group ---</option>\n        <option ng-repeat="group in groups | orderBy: \'id\'" value="{{ group.id }}">{{ group.name | translate }}</option>\n      </select>\n      \x3c!-- add group button --\x3e\n      <a ng-show="selectedAction == \'addGroup\'"\n          ng-click="addGroupMultiple(selectedGroup)" class="btn btn-default btn-sm">\n        <i class="fa fa-plus"></i>\n        <translate>Add group</translate>\n      </a>\n      \x3c!-- remove group button --\x3e\n      <a ng-show="selectedAction == \'removeGroup\'"\n          ng-click="removeGroupMultiple(selectedGroup)" class="btn btn-default btn-sm">\n        <i class="fa fa-minus"></i>\n        <translate>Remove group</translate>\n      </a>\n      \x3c!-- generate new password button --\x3e\n      <a ng-show="selectedAction == \'generatePasswords\'" class="btn btn-default btn-sm"\n        ng-click="generateNewPasswordsMultiple()">\n        <i class="fa fa-magic"></i>\n        <translate>Generate new passwords</translate>\n      </a>\n      \x3c!-- set bool property button --\x3e\n      <a ng-show="inArray([\'is_active\', \'is_present\', \'is_committee\'], selectedAction)"\n        ng-click="setBoolPropertyMultiple(selectedAction, true)" class="btn btn-default btn-sm">\n        <i class="fa fa-check"></i>\n        <span ng-if="selectedAction == \'is_active\'" translate>Is active</span>\n        <span ng-if="selectedAction == \'is_present\'" translate>Is present</span>\n        <span ng-if="selectedAction == \'is_committee\'" translate>Is committee</span>\n      </a>\n      \x3c!-- unset bool property button --\x3e\n      <a ng-show="inArray([\'is_active\', \'is_present\', \'is_committee\'], selectedAction)"\n        ng-click="setBoolPropertyMultiple(selectedAction, false)" class="btn btn-default btn-sm">\n        <i class="fa fa-ban"></i>\n        <span ng-if="selectedAction == \'is_active\'" translate>Is not active</span>\n        <span ng-if="selectedAction == \'is_present\'" translate>Is not present</span>\n        <span ng-if="selectedAction == \'is_committee\'" translate>Is not a committee</span>\n      </a>\n      \x3c!-- send_invite_email --\x3e\n      <a ng-show="selectedAction == \'send_invite_email\'" class="btn btn-default btn-sm"\n        ng-click="sendInvitationEmails()">\n        <translate>Send invitation emails</translate>\n      </a>\n    </div>\n  </div>\n\n  <div class="spacer-top-lg italic row">\n    <div class="col-md-6">\n      {{ usersFiltered.length }} /\n      {{ users.length }} {{ "participants" | translate }}<span ng-if="(users|filter:{selected:true}).length > 0">,\n      {{(users|filter:{selected:true}).length}} {{ "selected" | translate }}</span>\n      <template-hook hook-name="userListTableStats"></template-hook>\n    </div>\n    <div class="col-md-6" ng-show="usersFiltered.length > pagination.itemsPerPage">\n      <span class="pull-right">\n        <a href="" class="pagination-arrow" ng-click="pagination.prevPage()"\n          ng-if="pagination.showPrevPageArrow()">\n          &laquo;\n        </a>\n        <translate>Page</translate> {{ pagination.currentPage }} /\n        {{ pagination.getPageCount(usersFiltered) }}\n        <a href="" class="pagination-arrow" ng-click="pagination.nextPage(usersFiltered)"\n          ng-if="pagination.showNextPageArrow(usersFiltered)">\n          &raquo;\n        </a>\n      </span>\n    </div>\n  </div>\n\n  \x3c!-- filter users (for user with \'can_see_extra_data\' permission) - consider present filter --\x3e\n  <div os-perms="users.can_see_extra_data">\n    <span ng-repeat="user in $parent.usersFiltered = (users\n      | osFilter: filter.filterString : filter.getObjectQueryString\n      | filter: {is_present: filter.booleanFilters.isPresent.value}\n      | filter: {is_active: filter.booleanFilters.isActive.value}\n      | filter: {is_committee: filter.booleanFilters.isCommittee.value}\n      | filter: {has_last_email_send: filter.booleanFilters.hasLastEmailSend.value}\n      | MultiselectFilter: filter.multiselectFilters.group : getItemId.group\n      | orderByEmptyLast: sort.column: sort.reverse)"></span>\n  </div>\n  \x3c!-- filter users (for user without \'can_see_extra_data\' permission) --\x3e\n  <div os-perms="!users.can_see_extra_data"\n      ng-repeat="user in $parent.usersFiltered = (users\n      | osFilter: filter.filterString : filter.getObjectQueryString\n      | filter: {is_committee: filter.booleanFilters.isCommittee.value}\n      | MultiselectFilter: filter.multiselectFilters.group : getItemId.group\n      | orderByEmptyLast: sort.column: sort.reverse)"></div>\n\n  <div class="os-table container-fluid">\n    <div class="row header-row">\n      <div class="col-xs-1 centered" ng-show="isSelectMode" os-perms="users.can_manage">\n        <i class="fa text-danger pointer" ng-class="selectedAll ? \'fa-check-square-o\' : \'fa-square-o\'"\n          ng-click="checkAll()"></i>\n      </div>\n      <div class="col-xs-11 main-header">\n        <span class="form-inline text-right pull-right">\n          \x3c!-- reset Filters --\x3e\n          <span class="sort-spacer pointer" ng-click="filter.reset(isSelectMode)"\n            ng-if="filter.areFiltersSet()" ng-disabled="isSelectMode"\n            ng-class="{\'disabled\': isSelectMode}">\n            <i class="fa fa-window-close"></i>\n            <translate>Filter</translate>\n          </span>\n          \x3c!-- Group filter --\x3e\n          <span uib-dropdown>\n            <span class="pointer" id="dropdownGroup" uib-dropdown-toggle\n              ng-class="{\'bold\': filter.multiselectFilters.group.length > 0, \'disabled\': isSelectMode}"\n              ng-disabled="isSelectMode">\n              <translate>Groups</translate>\n              <span class="caret"></span>\n            </span>\n            <ul class="dropdown-menu dropdown-menu-right" aria-labelledby="dropdownGroup">\n              <li ng-repeat="group in groups | orderBy: \'id\'">\n                <a href ng-click="filter.operateMultiselectFilter(\'group\', group.id, isSelectMode)">\n                  <i class="fa fa-check" ng-if="filter.multiselectFilters.group.indexOf(group.id) > -1"></i>\n                  {{ group.name | translate }}\n                </a>\n              </li>\n              <li class="divider"></li>\n              <li>\n                <a href ng-click="filter.operateMultiselectFilter(\'group\', -1, isSelectMode)">\n                  <i class="fa fa-check" ng-if="filter.multiselectFilters.group.indexOf(-1) > -1"></i>\n                  <translate>No group set</translate>\n                </a>\n              </li>\n            </ul>\n          </span>\n          \x3c!-- boolean Filters --\x3e\n          <span ng-repeat="(name, booleanFilter) in filter.booleanFilters"\n            ng-if="!booleanFilter.needExtraPermission || operator.hasPerms(\'users.can_see_extra_data\')" uib-dropdown>\n            <span class="pointer" id="dropdown{{ name }}" uib-dropdown-toggle\n              ng-class="{\'bold\': booleanFilter.value !== undefined, \'disabled\': isSelectMode}"\n              ng-disabled="isSelectMode">\n              {{ booleanFilter.displayName | translate }}\n              <span class="caret"></span>\n            </span>\n            <ul class="dropdown-menu dropdown-menu-right" aria-labelledby="dropdown{{ name }}">\n              <li>\n                <a href ng-click="booleanFilter.value = (booleanFilter.value ? undefined : true); filter.save();">\n                  <i class="fa" ng-class="{\'fa-check\': booleanFilter.value === true}"></i>\n                  {{ booleanFilter.choiceYes | translate }}\n                </a>\n              </li>\n              <li>\n                <a href ng-click="booleanFilter.value = (booleanFilter.value === false) ? undefined : false; filter.save();">\n                  <i class="fa" ng-class="{\'fa-check\': booleanFilter.value === false}"></i>\n                  {{ booleanFilter.choiceNo | translate }}\n                </a>\n              </li>\n            </ul>\n          </span>\n          \x3c!-- dropdown sort --\x3e\n          <span uib-dropdown>\n            <span class="pointer" id="dropdownSort" uib-dropdown-toggle\n              ng-class="{\'disabled\': isSelectMode}"\n              ng-disabled="isSelectMode">\n              <translate>Sort</translate>\n              <span class="caret"></span>\n            </span>\n            <ul class="dropdown-menu dropdown-menu-right dropdown-entries" aria-labelledby="dropdownSort">\n              <li ng-repeat="option in sortOptions">\n                <a href ng-click="sort.toggle(option.name)">\n                  <span ng-style="{\'font-weight\': sort.column === option.name ? \'bold\' : \'normal\'}">\n                    {{ option.display_name | translate }}\n                  </span>\n                  <span class="spacer-right pull-right"></span>\n                  <i class="pull-right fa"\n                    ng-style="{\'visibility\': sort.column === option.name ? \'visible\' : \'hidden\'}"\n                    ng-class="sort.reverse ? \'fa-sort-amount-desc\' : \'fa-sort-amount-asc\'">\n                  </i>\n                </a>\n              </li>\n            </ul>\n          </span>\n          \x3c!-- search field --\x3e\n          <span class="form-group">\n            <span class="input-group">\n              <span class="input-group-addon"><i class="fa fa-search"></i></span>\n              <input type="text" ng-model="filter.filterString" class="form-control" ng-model-options="{debounce: 500}" \n                 placeholder="{{ \'Search\' | translate}}" ng-disabled="isSelectMode"\n                 ng-change="filter.save()">\n            </span>\n          </span>\n        </span>\n        \x3c!-- show all selected multiselectoptions --\x3e\n        <span>\n          <span ng-repeat="group in groups | orderBy: \'id\'" class="pointer spacer-left-lg"\n            ng-if="filter.multiselectFilters.group.indexOf(group.id) > -1"\n            ng-click="filter.operateMultiselectFilter(\'group\', group.id, isSelectMode)"\n            ng-class="{\'disabled\': isSelectMode}">\n            <span class="nobr">\n              <i class="fa fa-times-circle"></i>\n              {{ group.name | translate }}\n            </span>\n          </span>\n          <span ng-if="filter.multiselectFilters.group.indexOf(-1) > -1" class="pointer spacer-left-lg"\n            ng-click="filter.operateMultiselectFilter(\'group\', -1, isSelectMode)"\n            ng-class="{\'disabled\': isSelectMode}">\n            <i class="fa fa-times-circle"></i>\n            <translate>No group set</translate>\n          </span>\n          \x3c!-- for all boolean Filters --\x3e\n          <span ng-repeat="(name, booleanFilter) in filter.booleanFilters"\n            ng-hide="booleanFilter.value === undefined"\n            class="pointer spacer-left-lg"\n            ng-click="booleanFilter.value = undefined; filter.save();"\n            ng-class="{\'disabled\': isSelectMode}">\n            <span class="nobr">\n              <i class="fa fa-times-circle"></i>\n              {{ booleanFilter.value ? booleanFilter.choiceYes : booleanFilter.choiceNo | translate }}\n            </span>\n          </span>\n        </span>\n      </div>\n    </div>\n\n    \x3c!-- main table --\x3e\n    <div class="row data-row" ng-mouseover="user.hover=true"\n      ng-mouseleave="user.hover=false"\n      ng-class="{\'projected\': user.isProjected().length}"\n      ng-repeat="user in usersFiltered\n      | limitTo : pagination.itemsPerPage : pagination.limitBegin">\n\n      \x3c!-- select column --\x3e\n      <div ng-show="isSelectMode" os-perms="users.can_manage" class="col-xs-1 centered">\n        <i class="fa text-danger pointer" ng-click="user.selected=!user.selected"\n        ng-class="user.selected ? \'fa-check-square-o\' : \'fa-square-o\'"></i>\n      </div>\n      \x3c!-- projector column --\x3e\n      <div class="col-xs-1 centered projector" os-perms="core.can_manage_projector">\n        <projector-button model="user" default-projector-id="defaultProjectorId">\n        </projector-button>\n      </div>\n      <div class="no-projector-spacer" os-perms="!core.can_manage_projector"></div>\n      \x3c!-- main content column --\x3e\n      <div class="col-xs-6 content">\n        <div class="spacer-right"> \x3c!-- horizontal block --\x3e\n          <i ng-style="{\'visibility\': user.is_active === false ? \'visible\' : \'hidden\'}" class="fa fa-ban"\n            title="{{ \'Is inactive\' | translate }}"></i>\n          <i ng-style="{\'visibility\': user.is_committee ? \'visible\' : \'hidden\'}" class="fa fa-university"\n            title="{{ \'Is a committee\' | translate }}"></i>\n        </div>\n        <div>\n          <div> \x3c!-- vertical block --\x3e\n            <a ui-sref="users.user.detail({id: user.id})" class="title">{{ user.get_short_name() }}</a>\n          </div>\n          <div os-perms="users.can_manage"> \x3c!-- user number --\x3e\n            <div ng-if="user.number" editable-text="user.number" onaftersave="save(user)">\n              <translate translate-comment="abbreviation for number">No.</translate> {{ user.number }}\n            </div>\n          </div>\n          <div os-perms="!users.can_manage" ng-if="user.number">\n              <translate translate-comment="abbreviation for number">No.</translate> {{ user.number }}\n          </div>\n          <div os-perms="users.can_manage" ng-class="{\'hiddenDiv\': !user.hover}">\n            <small>\n              <template-hook hook-name="userListEditButton">\n                <span>\n                  <a href="" ng-click="openDialog(user)" translate>Edit</a> &middot;\n                </span>\n              </template-hook>\n              <a ui-sref="users.user.change-password({id: user.id})" translate>Change password</a> &middot;\n              <a href="" class="text-danger"\n                  ng-bootbox-confirm="{{ \'Are you sure you want to delete this entry?\' | translate }}<br>\n                  <b>{{ user.get_short_name() }}</b>"\n                  ng-bootbox-confirm-action="delete(user)" translate>Delete</a>\n            </small>\n          </div>\n        </div>\n      </div>\n\n      \x3c!-- additional content column --\x3e\n      <div class="col-xs-4 content" ng-style="{\'width\': isSelectMode ? \'calc(50% - 120px)\' : \'calc(50% - 70px)\'}">\n        <div style="width: 60%;" class="optional">\n          <small>\n            \x3c!-- Group dropdown for manage user --\x3e\n            <div os-perms="users.can_manage" ng-show="groups.length > 0"\n              uib-tooltip="{{ \'Groups\' | translate }}" tooltip-placement="top-left"\n              ng-mouseover="user.groupHover=true"\n              ng-mouseleave="user.groupHover=false">\n              <span uib-dropdown>\n                <span id="dropdown-group{{ user.id }}" class="pointer" uib-dropdown-toggle>\n                  <span ng-if="!user.groups_id.length" ng-show="user.hover">\n                    <i class="fa fa-users"></i>\n                    <i class="fa fa-plus"></i>\n                  </span>\n                  <span ng-if="user.groups_id.length">\n                    <i class="fa fa-users"></i>\n                    <span ng-repeat="group in user.groups_id | limitTo:2">\n                      {{ (groups | filter: {id: group}:true)[0].name | translate }}<span ng-if="!$last">,</span></span><span ng-if="user.groups_id.length > 2">,\n                      ... [+{{ user.groups_id.length - 2}}]</span>\n                    <i class="fa fa-cog fa-lg spcaer-left" ng-show="user.groupHover"></i>\n                  </span>\n                </span>\n                <ul class="dropdown-menu" aria-labelledby="dropdown-group{{ user.id }}">\n                  <li ng-repeat="group in groups | orderBy: \'id\'">\n                    <a href ng-click="toggleGroup(user, group)">\n                      <i class="fa fa-check" ng-if="inArray(user.groups_id, group.id)"></i>\n                      {{ group.name | translate }}\n                    </a>\n                  </li>\n                </ul>\n              </span>\n            </div>\n            \x3c!-- Group dropdown for normal user --\x3e\n            <div os-perms="!users.can_manage" ng-show="user.groups_id.length"\n              uib-tooltip="{{ \'Groups\' | translate }}" tooltip-placement="top-left">\n              <i class="fa fa-users"></i>\n              <span ng-repeat="group in user.groups_id | limitTo:2">\n                {{ (groups | filter: {id: group})[0].name | translate }}<span ng-if="!$last">,</span></span><span ng-if="user.groups_id.length > 2">,\n                ... [+{{ user.groups_id.length - 2}}]</span>\n              \x3c!-- sorry for merging them together, but otherwise there would be a whitespace because of the new line --\x3e\n            </div>\n\n            <div os-perms="users.can_manage" ng-show="user.structure_level || user.hover">\n              <div class="popover-wrapper">\n                <i class="fa fa-flag"></i>\n                <span editable-text="user.structure_level" onaftersave="save(user)">\n                  <span ng-if="!user.structure_level" translate>Set structure level ...</span>\n                  <span ng-if="user.structure_level">{{ user.structure_level }}</span>\n                </span>\n              </div>\n            </div>\n            <div os-perms="!users.can_manage">\n              <div ng-if="user.structure_level" uib-tooltip="{{ \'Structure level\' | translate }}" tooltip-placement="top-left">\n                <i class="fa fa-flag"></i>\n                {{ user.structure_level }}\n              </div>\n            </div>\n\n            <div os-perms="users.can_manage" ng-show="user.comment || user.hover">\n              <div class="popover-wrapper">\n                <i class="fa fa-info-circle"></i>\n                <span editable-text="user.comment" onaftersave="save(user)">\n                  <span ng-if="!user.comment" translate>Set comment ...</span>\n                  <span ng-if="user.comment">{{ user.comment }}</span>\n                </span>\n              </div>\n            </div>\n            <div os-perms="!users.can_manage">\n              <div ng-if="user.comment" uib-tooltip="{{ \'Comment\' | translate }}" tooltip-placement="top-left">\n                <i class="fa fa-info-circle"></i>\n                {{ user.comment | limitTo:25}}{{ user.comment.length > 25 ? \'...\' : \'\' }}\n              </div>\n            </div>\n\n            <div os-perms="users.can_manage" ng-show="user.last_email_send">\n              <div uib-tooltip="{{ \'Last email send to the user\' | translate }}" tooltip-placement="top-left">\n                <i class="fa fa-envelope"></i>\n                {{ user.last_email_send | date: \'yyyy-MM-dd HH:mm:ss\' }}\n              </div>\n            </div>\n          </small>\n        </div>\n        <div style="width: 40%;" class="pull-right">\n          <div os-perms="users.can_see_extra_data users.can_manage"\n               ng-style="{\'visibility\': (user.hover || user.is_present) ? \'visible\' : \'hidden\'}">\n            <span class="pointer nobr" ng-click="user.is_present = !user.is_present; save(user);">\n              <i class="fa" ng-class="user.is_present ? \'fa-check-square-o\' : \'fa-square-o\'"></i>\n              <span class="spacer-left" translate>Present</span>\n            </span>\n          </div>\n          <div os-perms="!users.can_manage" class="nobr"\n            ng-style="{\'visibility\': user.is_present ? \'visible\' : \'hidden\'}">\n            <i class="fa fa-check-square-o"></i>\n            <span class="spacer-left" translate>Present</span>\n          </div>\n          <template-hook hook-name="userListExtraContent"></template-hook>\n        </div>\n      </div>\n\n    </div>\x3c!-- end data row --\x3e\n  </div>\x3c!-- end os-table --\x3e\n\n  <ul uib-pagination\n      ng-show="usersFiltered.length > pagination.itemsPerPage"\n      total-items="usersFiltered.length"\n      items-per-page="pagination.itemsPerPage"\n      ng-model="pagination.currentPage"\n      ng-change="pagination.pageChanged()"\n      class="pagination-sm"\n      direction-links="false"\n      boundary-links="true"\n      first-text="&laquo;"\n      last-text="&raquo;">\n  </ul>\n</div>\n'),n.put("users/static/templates/users/user-presence.html",'<div class="header">\n  <div class="title">\n    <div class="submenu">\n      <a ui-sref="users.user.list" class="btn btn-sm btn-default">\n        <i class="fa fa-angle-double-left fa-lg"></i>\n        <translate>Back to overview</translate>\n      </a>\n    </div>\n    <h1 translate>Presence</h1>\n  </div>\n</div>\n\n<div class="details">\n\n  <div uib-alert ng-show="alert.show" ng-class="\'alert-\' + (alert.type || \'warning\')" close="alert={}">\n    {{ alert.msg }}\n  </div>\n\n  <form ng-submit="changeState()" class="row">\n    <div class="col-md-6">\n      <div class="form-group">\n        <label for="userNumber" translate>Enter participant number</label>\n        <input type="text" class="form-control" id="userNumber"\n          ng-model="number" ng-change="updateSuggestions()">\n      </div>\n      <button type="submit" class="btn btn-sm btn-primary" translate>\n        Change presence\n      </button>\n    </div>\n  </form>\n</div>\n'),n.put("motions/static/templates/motions/motion-detail/amendment-paragraph-diff.html",'<div class="motion-toolbar" ng-if="motion.isParagraphBasedAmendment()">\n    <div class="toolbar-left {{ lineNumberMode }}">\n        <div class="btn-group pull-right" data-toggle="buttons">\n            <label class="btn btn-sm btn-default" ng-class="{active: showAmendmentContext}" ng-click="setShowAmendmentContext($event)">\n                <input type="checkbox" autocomplete="off" ng-model="showAmendmentContext" ng-checked="showAmendmentContext">\n                <translate>Show entire motion text</translate>\n            </label>\n        </div>\n        <ng-include src="\'static/templates/motions/motion-detail/toolbar-line-numbering.html\'"></ng-include>\n    </div>\n</div>\n\n<div ng-class="{\'col-sm-8\': (lineNumberMode != \'outside\'), \'col-sm-12\': (lineNumberMode == \'outside\')}"\n     ng-if="motion.isParagraphBasedAmendment()">\n    <section class="motion-text-holder">\n        <div class="alert alert-info" ng-if="amendment_diff_paragraphs.length === 0">\n            <translate>No changes at the text.</translate>\n        </div>\n        <div ng-repeat="paragraph in amendment_diff_paragraphs" class="motion-text motion-text-diff line-numbers-{{ lineNumberMode }}"\n             ng-class="{\'amendment-context\': showAmendmentContext}">\n\n            <div class="amendment-context" ng-if="showAmendmentContext">\n                <div ng-bind-html="motion.getParentMotion().getTextInLineRange(null, 1, paragraph.paragraphLineFrom) | trusted"\n                     class="context"></div>\n            </div>\n\n            <h3 ng-if="paragraph.diffLineTo == paragraph.diffLineFrom + 1 && !showAmendmentContext" class="amendment-line-header">\n               <translate>Line</translate> {{ paragraph.diffLineFrom }}:\n            </h3>\n            <h3 ng-if="paragraph.diffLineTo != paragraph.diffLineFrom + 1 && !showAmendmentContext" class="amendment-line-header">\n                <translate>Line</translate> {{ paragraph.diffLineFrom }} - {{ paragraph.diffLineTo - 1 }}:\n            </h3>\n\n            <div class="paragraph-context" ng-bind-html="paragraph.textPre | trusted"></div>\n            <div ng-bind-html="paragraph.text | trusted"></div>\n            <div class="paragraph-context" ng-bind-html="paragraph.textPost | trusted"></div>\n\n            <div class="amendment-context" ng-if="showAmendmentContext">\n                <div ng-bind-html="motion.getParentMotion().getTextInLineRange(null, paragraph.paragraphLineTo, null) | trusted"></div>\n            </div>\n        </div>\n    </section>\n</div>\n'),
n.put("motions/static/templates/motions/motion-detail/change-summary.html",'\x3c!-- A summary of all changes --\x3e\n<section class="change-recommendation-overview">\n    <strong>\n        <translate>Summary of changes</translate>:\n    </strong>\n\n    <button os-perms="motions.can_manage" class="btn btn-sm btn-default pull-right"\n        uib-tooltip="{{ \'Note: You have to reject all change recommendations if the plenum does not follow the recommendation. This does not affect amendments.\' | translate }}"\n        ng-click="viewChangeRecommendations.rejectAllChangeRecommendations(motion)">\n      <i class="fa fa-thumbs-down"></i>\n      <translate>Reject all change recommendations</translate>\n    </button>\n\n    <ul ng-if="has_proposed_changes">\n        <li ng-if="title_change_recommendation">\n            <a href=\'\' ng-click="viewChangeRecommendations.scrollToDiffBox(title_change_recommendation.id)">\n                <span class="line-number"><translate>Title</translate>:</span>\n                <span class="operation"><translate>Replacement</translate></span>\n                <span class="status">\n                    <translate ng-if="title_change_recommendation.rejected">Rejected</translate>\n                </span>\n            </a>\n        </li>\n        <li ng-repeat="change in amendments_crs">\n          <a href=\'\' ng-click="viewChangeRecommendations.scrollToDiffBox(change.id)"\n             ng-class="{amendment: change.type === \'amendment\', recommendation: change.type === \'recommendation\'}">\n            <span ng-if="change.line_from >= change.line_to - 1" class="line-number">\n                <translate>Line</translate> {{ change.line_from }}<span ng-if="change.type === \'recommendation\'"></span>\n            </span>\n            <span ng-if="change.line_from < change.line_to - 1" class="line-number">\n                <translate>Line</translate> {{ change.line_from }} -\n                    {{ change.line_to - 1 }}<span ng-if="change.type === \'recommendation\'"></span>\n            </span>\n            <span ng-if="change.type === \'recommendation\'">(<translate>Change recommendation</translate>)</span>\n            <span ng-if="change.type === \'amendment\'">({{ change.original.identifier }})</span>\n            <span class="operation" ng-if="change.type === \'recommendation\'">–\n                <translate ng-if="change.original.getType(motion.getVersion(version).text) == 0">Replacement</translate>\n                <translate ng-if="change.original.getType(motion.getVersion(version).text) == 1">Insertion</translate>\n                <translate ng-if="change.original.getType(motion.getVersion(version).text) == 2">Deletion</translate>\n                <span ng-if="change.original.getType(motion.getVersion(version).text) == 3">\n                  {{ change.other_description }}\n                </span>\n            </span>\n            <span class="status">\n                <translate ng-if="change.rejected">Rejected</translate>\n                <translate ng-if="change.accepted && change.type === \'amendment\'">Accepted</translate>\n            </span>\n          </a>\n        </li>\n    </ul>\n\n    <div ng-if="!has_proposed_changes" class="no-changes">\n        <translate>No change recommendations yet</translate>\n    </div>\n</section>\n'),n.put("motions/static/templates/motions/motion-detail/comments.html",'<div class="details" ng-repeat="(id, field) in noSpecialCommentsFields">\n  <div class="row">\n    \x3c!-- inline editing toolbar --\x3e\n    <div class="motion-toolbar">\n      <div class="pull-right inline-editing-activator">\n        <button ng-click="exportComment(id)" class="btn btn-default btn-sm"\n          uib-tooltip="{{ \'Export comments only\' | translate }}">\n          <i class="fa fa-file-pdf-o"></i>\n          <translate>PDF</translate>\n        </button>\n        <span ng-if="motion.isAllowed(\'change_comments\')">\n          <button ng-if="!commentsInlineEditing.active(id)" ng-click="commentsInlineEditing.enable(id)"\n            class="btn btn-sm btn-default">\n            <i class="fa fa-pencil-square-o"></i>\n            <translate>Inline editing</translate>\n          </button>\n          <button ng-if="commentsInlineEditing.active(id)" ng-click="commentsInlineEditing.disable(id)"\n            class="btn btn-sm btn-default">\n            <i class="fa fa-times-circle"></i>\n            <translate>Inline editing</translate>\n          </button>\n        </span>\n      </div>\n      <h1 class="toolbar-left">{{ field.name }}\n        <span ng-if="!field.public" class="label label-warning" translate>internal</span>\n      </h1>\n    </div>\n    \x3c!-- comment fields --\x3e\n    <div class="col-sm-12">\n      <div id="view-original-comment-inline-editor-{{ id }}" style="min-height: 14px;"\n        ng-bind-html="motion.comments[id] | trusted" contenteditable="{{ commentsInlineEditing.editors[id].isEditable }}"></div>\n    </div>\n  </div>\n</div>\n\n\x3c!-- save toolbar --\x3e\n<div class="motion-save-toolbar" ng-class="{ \'visible\': commentsInlineEditing.saveToolbarVisible() }">\n  <div class="changed-hint" translate>A comment has been changed.</div>\n  <button type="button" ng-click="commentsInlineEditing.save()" class="btn btn-primary" translate>\n      Save\n  </button>\n  <button type="button" ng-click="commentsInlineEditing.revert()" class="btn btn-default" translate>\n      Revert\n  </button>\n</div>\n'),n.put("motions/static/templates/motions/motion-detail/personal-note.html",'<div id="personalNote" class="details" ng-class="{\'pinned\': personalNotePinned}">\n  <div class="row">\n    \x3c!-- inline editing toolbar --\x3e\n    <div class="motion-toolbar">\n      <div class="pull-right inline-editing-activator">\n        <button ng-click="exportPersonalNote()" class="btn btn-default btn-sm"\n          uib-tooltip="{{ \'Export personal note only\' | translate }}">\n          <i class="fa fa-file-pdf-o"></i>\n          <translate>PDF</translate>\n        </button>\n        <button ng-if="!personalNoteInlineEditing.active" ng-click="personalNoteInlineEditing.enable()"\n          class="btn btn-sm btn-default">\n          <i class="fa fa-pencil-square-o"></i>\n          <translate>Inline editing</translate>\n        </button>\n        <button ng-if="personalNoteInlineEditing.active" ng-click="personalNoteInlineEditing.disable()"\n          class="btn btn-sm btn-default">\n          <i class="fa fa-times-circle"></i>\n          <translate>Inline editing</translate>\n        </button>\n        <button ng-click="pinPersonalNote()" class="btn btn-sm btn-default">\n          <i class="fa fa-thumb-tack" ng-class="{\'rotate-45-deg-right\': !personalNotePinned}"></i>\n        </button>\n      </div>\n      <h1 class="toolbar-left" translate>Personal note</h1>\n    </div>\n\n    \x3c!-- personal note editor field --\x3e\n    <div class="col-sm-12">\n      <div id="personal-note-inline-editor"\n        ng-bind-html="motion.personalNote.note | trusted" contenteditable="{{ personalNoteInlineEditing.isEditable }}"></div>\n      \x3c!-- save toolbar --\x3e\n      <div class="motion-save-toolbar" ng-class="{ \'visible\': (personalNoteInlineEditing.changed && personalNoteInlineEditing.active) }">\n        <div class="changed-hint" translate>The personal note has been changed.</div>\n        <button type="button" ng-click="personalNoteInlineEditing.save()" class="btn btn-primary" translate>\n            Save\n        </button>\n        <button type="button" ng-click="personalNoteInlineEditing.revert()" class="btn btn-default" translate>\n            Revert\n        </button>\n      </div>\n    </div>\n  </div>\n</div>\n<div id="personalNoteSpacer" ng-class="{\'activeSpace\': personalNotePinned}"></div>\n'),n.put("motions/static/templates/motions/motion-detail/toolbar-line-numbering.html",'\x3c!-- line number mode for resonsive size medium/large (button group) --\x3e\n<div class="btn-group hidden-sm hidden-xs" data-toggle="buttons">\n            <span class="btn btn-sm btn-default disabled">\n                <i class="fa fa-list-ol" aria-hidden="true"></i>\n                <translate>Line numbering</translate>:\n            </span>\n    <label class="btn btn-sm btn-default" ng-class="{active: (lineNumberMode == \'none\')}"\n           ng-click="setLineNumberMode(\'none\')">\n        <input type="radio" name="lineNumberMode" value="none" ng-model="lineNumberMode"\n               ng-checked="lineNumberMode == \'none\'">\n        <translate>none</translate>\n    </label>\n    <label class="btn btn-sm btn-default" ng-class="{active: (lineNumberMode == \'inline\')}"\n           ng-click="setLineNumberMode(\'inline\')">\n        <input type="radio" name="lineNumberMode" value="inline" ng-model="lineNumberMode"\n               ng-checked="lineNumberMode == \'inline\'">\n        <translate>inline</translate>\n    </label>\n    <label class="btn btn-sm btn-default" ng-class="{active: (lineNumberMode == \'outside\')}"\n           ng-click="setLineNumberMode(\'outside\')">\n        <input type="radio" name="lineNumberMode" value="outside" ng-model="lineNumberMode"\n               ng-checked="lineNumberMode == \'outside\'">\n        <translate>outside</translate>\n    </label>\n</div>\n\x3c!-- line number mode for resonsive size small/extra small (dropdown) --\x3e\n<div class="dropdown hidden-md hidden-lg" uib-dropdown>\n    <button type="button" class="btn btn-default btn-sm" id="dropdownLineMode" uib-dropdown-toggle>\n        <i class="fa fa-list-ol" aria-hidden="true"></i>\n        <translate>Line numbering</translate>\n        <span class="caret"></span>\n    </button>\n    <ul class="dropdown-menu dropdown-menu-left" aria-labelledby="dropdownLineMode">\n        <li>\n            <a href="" ng-click="setLineNumberMode(\'none\')">\n                <i class="fa fa-check" ng-if="lineNumberMode == \'none\'"></i>\n                <translate>none</translate>\n            </a>\n        </li>\n        <li>\n            <a href="" ng-click="setLineNumberMode(\'inline\')">\n                <i class="fa fa-check" ng-if="lineNumberMode == \'inline\'"></i>\n                <translate>inline</translate>\n            </a>\n        </li>\n        <li>\n            <a href="" ng-click="setLineNumberMode(\'outside\')">\n                <i class="fa fa-check" ng-if="lineNumberMode == \'outside\'"></i>\n                <translate>outside</translate>\n            </a>\n        </li>\n    </ul>\n</div>\n'),n.put("motions/static/templates/motions/motion-detail/toolbar.html",'<div class="motion-toolbar">\n    \x3c!-- inline editing for original mode --\x3e\n    <div class="pull-right inline-editing-activator"\n         ng-if="motion.isAllowed(\'update\') && version == motion.getVersion(-1).id && viewChangeRecommendations.mode == \'original\'">\n        <button ng-if="!inlineEditing.active && !has_proposed_changes" ng-click="enableMotionInlineEditing()"\n                class="btn btn-sm btn-default">\n            <i class="fa fa-pencil-square-o"></i>\n            <translate>Inline editing</translate>\n        </button>\n        <button ng-if="inlineEditing.active && !has_proposed_changes" ng-click="disableMotionInlineEditing()"\n                class="btn btn-sm btn-default">\n            <i class="fa fa-times-circle"></i>\n            <translate>Inline editing</translate>\n        </button>\n        <button ng-if="has_proposed_changes" class="btn btn-sm btn-default" disabled\n                title="{{ \'Editing the text is not possible anymore once there are change recommendations.\' | translate }}">\n            <i class="fa fa-pencil-square-o"></i>\n            <translate>Inline editing</translate>\n        </button>\n    </div>\n\n    \x3c!-- inline editing for modified agreed view --\x3e\n    <div class="pull-right inline-editing-activator"\n         ng-if="motion.isAllowed(\'update\') && version == motion.getVersion(-1).id && viewChangeRecommendations.mode == \'modified_agreed\'">\n        <button ng-if="!modifiedFinalVersionInlineEditing.active"\n                ng-click="modifiedFinalVersionInlineEditing.enable()"\n                class="btn btn-sm btn-default">\n            <i class="fa fa-pencil-square-o"></i>\n            <translate>Inline editing</translate>\n        </button>\n        <button ng-if="modifiedFinalVersionInlineEditing.active"\n                ng-click="modifiedFinalVersionInlineEditing.disable()"\n                class="btn btn-sm btn-default">\n            <i class="fa fa-times-circle"></i>\n            <translate>Inline editing</translate>\n        </button>\n    </div>\n\n    <div class="toolbar-left {{ lineNumberMode }}">\n\n        <ng-include src="\'static/templates/motions/motion-detail/toolbar-line-numbering.html\'"></ng-include>\n\n        \x3c!-- go to line number --\x3e\n        <div class="popover-wrapper">\n            <span editable-number="gotoLinenumber" e-min="1" e-form="lineNumberForm"\n              e-placeholder="{{ \'Line\' | translate }}"\n              e-formclass="small-form"\n              onaftersave="scrollToAndHighlight(gotoLinenumber)">\n            </span>\n            <div class="btn-group" ng-if="lineNumberMode != \'none\'">\n              <button type="button" class="btn btn-sm btn-default" ng-click="lineNumberForm.$show()"\n                      uib-tooltip="{{ \'Go to line\' | translate }}">\n                  <i class="fa fa-share"></i>\n                  <translate>go</translate>\n              </button>\n              <button type="button" class="btn btn-sm btn-default"\n                      ng-if="lineNumberMode != \'none\' && motion.isProjected().length &&\n                      operator.hasPerms(\'core.can_manage_projector\')"\n                      ng-click="toggleLinesForProjector()"\n                      uib-tooltip="{{ \'Show highlighted line also on projector\' | translate }}">\n                  <i class="fa" ng-class="linesForProjector ? \'fa-check-square-o\' : \'fa-square-o\'"></i>&nbsp;\n                  <i class="fa fa-video-camera"></i>\n              </button>\n            </div>\n        </div>\n    </div>\n</div>\n\n\x3c!-- View Modes (Original, Diff, Changed) --\x3e\n<div class="motion-toolbar" ng-if="has_proposed_changes">\n    <div class="toolbar-left">\n\n        \x3c!-- change recommendations for resonsive size medium/large (button group) --\x3e\n        <div class="btn-group hidden-sm hidden-xs" data-toggle="buttons">\n            <span class="btn btn-sm btn-default disabled">\n                <i class="fa fa-edit" aria-hidden="true"></i>\n                <translate>Change recommendations</translate>:\n            </span>\n            <label class="btn btn-sm btn-default" ng-class="{active: (viewChangeRecommendations.mode == \'original\')}"\n                   ng-click="viewChangeRecommendations.mode = \'original\';">\n                <input type="radio" name="viewChangeRecommendations.mode" value="none"\n                       ng-model="viewChangeRecommendations.mode"\n                       ng-checked="viewChangeRecommendations.mode == \'original\'">\n                <translate>Original version</translate>\n\n            </label>\n            <label class="btn btn-sm btn-default" ng-class="{active: (viewChangeRecommendations.mode == \'changed\')}"\n                   ng-click="viewChangeRecommendations.mode = \'changed\'">\n                <input type="radio" name="viewChangeRecommendations.mode" value="changed"\n                       ng-model="viewChangeRecommendations.mode"\n                       ng-checked="viewChangeRecommendations.mode == \'changed\'">\n                <translate>Changed version</translate>\n            </label>\n            <label class="btn btn-sm btn-default" ng-class="{active: (viewChangeRecommendations.mode == \'diff\')}"\n                   ng-click="viewChangeRecommendations.mode = \'diff\'">\n                <input type="radio" name="viewChangeRecommendations.mode" value="diff" ng-model="lineNumberMode"\n                       ng-checked="viewChangeRecommendations.mode == \'diff\'">\n                <translate>Diff version</translate>\n            </label>\n            <label class="btn btn-sm btn-default" ng-class="{active: (viewChangeRecommendations.mode == \'agreed\')}"\n                   ng-click="viewChangeRecommendations.mode = \'agreed\'">\n                <input type="radio" name="viewChangeRecommendations.mode" value="agreed"\n                       ng-model="viewChangeRecommendations.mode"\n                       ng-checked="viewChangeRecommendations.mode == \'agreed\'">\n                <translate>Final version</translate>\n            </label>\n            <label class="btn btn-sm btn-default" os-perms="motions.can_manage"\n                   ng-show="motion.getModifiedFinalVersion()"\n                   ng-class="{active: (viewChangeRecommendations.mode == \'modified_agreed\')}"\n                   ng-click="viewChangeRecommendations.mode = \'modified_agreed\'">\n                <input type="radio" name="viewChangeRecommendations.mode" value="modified_agreed"\n                       ng-model="viewChangeRecommendations.mode"\n                       ng-checked="viewChangeRecommendations.mode == \'modified_agreed\'">\n                <translate>Final print template</translate>\n            </label>\n        </div>\n\n        \x3c!-- change recommendations for resonsive size small/extra small (dropdown) --\x3e\n        <div class="dropdown hidden-md hidden-lg" uib-dropdown>\n          <button type="button" class="btn btn-default btn-sm" id="dropdownChangeVersion" uib-dropdown-toggle>\n            <i class="fa fa-edit"></i>\n            <translate>Change recommendations</translate>\n            <span class="caret"></span>\n          </button>\n          <ul class="dropdown-menu dropdown-menu-left" aria-labelledby="dropdownChangeVersion">\n            <li>\n              <a href="" ng-click="viewChangeRecommendations.mode = \'original\'">\n                <i class="fa fa-check" ng-if="viewChangeRecommendations.mode == \'original\'"></i>\n                <translate>Original version</translate>\n              </a>\n            <li>\n              <a href="" ng-click="viewChangeRecommendations.mode = \'changed\'">\n                <i class="fa fa-check" ng-if="viewChangeRecommendations.mode == \'changed\'"></i>\n                <translate>Changed version</translate>\n              </a>\n            <li>\n              <a href="" ng-click="viewChangeRecommendations.mode = \'diff\'">\n                <i class="fa fa-check" ng-if="viewChangeRecommendations.mode == \'diff\'"></i>\n                <translate>Diff version</translate>\n              </a>\n            <li>\n              <a href="" ng-click="viewChangeRecommendations.mode = \'agreed\'">\n                <i class="fa fa-check" ng-if="viewChangeRecommendations.mode == \'agreed\'"></i>\n                <translate>Final version</translate>\n              </a>\n            <li os-perms="motions.can_manage">\n              <a href="" ng-click="viewChangeRecommendations.mode = \'modified_agreed\'">\n                <i class="fa fa-check" ng-if="viewChangeRecommendations.mode == \'modified_agreed\'"></i>\n                <translate>Final print template</translate>\n              </a>\n          </ul>\n        </div>\n    </div>\n</div>\n'),n.put("motions/static/templates/motions/motion-detail/view-diff.html",'<div ng-if="viewChangeRecommendations.mode == \'diff\'">\n    \x3c!-- The changed title --\x3e\n    <div ng-if="title_change_recommendation" ng-class="motion.isAllowed(\'can_manage\') ? \'diff-box\' : \'\'"\n         class="diff-box-{{ title_change_recommendation.id }} diff-box-title clearfix">\n        <div class="action-row" ng-if="motion.isAllowed(\'can_manage\')">\n            <div class="btn-group" data-toggle="buttons">\n                <label class="btn btn-sm btn-default" ng-class="{active: !title_change_recommendation.rejected}"\n                       title="{{ \'Not rejected\' | translate }}"\n                       ng-click="title_change_recommendation.rejected = false; title_change_recommendation.saveStatus();">\n                    <input type="radio" name="changeRecommendationRejected[{{ title_change_recommendation.id }}]" value="0"\n                           ng-change="title_change_recommendation.saveStatus()" ng-model="change.rejected"\n                           ng-checked="title_change_recommendation.rejected == false">\n                    <i class="fa fa-thumbs-up"></i>\n                </label>\n                <label class="btn btn-sm btn-default" ng-class="{active: title_change_recommendation.rejected}"\n                       title="{{ \'Rejected\' | translate }}" ng-click="title_change_recommendation.rejected = true; title_change_recommendation.saveStatus();">\n                    <input type="radio" name="changeRecommendationRejected[{{ title_change_recommendation.id }}]" value="1"\n                           ng-change="title_change_recommendation.saveStatus()" ng-model="change.rejected"\n                           ng-checked="title_change_recommendation.rejected == true">\n                    <i class="fa fa-thumbs-down"></i>\n                </label>\n            </div>\n\n            <button class="btn btn-default btn-sm pull-right btn-delete"\n                    ng-bootbox-confirm="{{ \'Are you sure you want to delete this change recommendation?\' | translate }}"\n                    ng-bootbox-confirm-action="viewChangeRecommendations.delete(title_change_recommendation.id)"\n                    title="{{ \'Delete\' | translate }}">\n                <i class="fa fa-trash"></i>\n            </button>\n\n            <button class="btn btn-default btn-sm pull-right btn-edit"\n                    ng-click="createChangeRecommendation.editTitleDialog(title_change_recommendation)"\n                    title="{{ \'Edit\' | translate }}">\n                <i class="fa fa-pencil"></i>\n            </button>\n        </div>\n        <div class="status-row" ng-if="!motion.isAllowed(\'can_manage\') && title_change_recommendation.rejected">\n            <i class="grey"><translate>Rejected</translate>:</i>\n        </div>\n\n        <div class="motion-text motion-text-diff line-numbers-{{ lineNumberMode }}">\n            <div class="description"><translate>New title</translate>:</div>\n            <div>{{ title_change_recommendation.text }}</div>\n        </div>\n    </div>\n\n    \x3c!-- The actual diff view --\x3e\n    <div class="motion-text-with-diffs line-numbers-{{ lineNumberMode }}">\n        <div ng-repeat="change in amendments_crs">\n            <div class="motion-text original-text line-numbers-{{ lineNumberMode }}"\n                 ng-if="$index === 0 || amendments_crs[$index - 1].line_to < change.line_from"\n                 ng-bind-html="motion.getTextBetweenChanges(version, amendments_crs[$index - 1], change, highlight) | trusted"></div>\n\n            <div ng-class="{\'collides\': change.getCollissions().length > 0}"\n                class="diff-box diff-box-{{ change.id }} clearfix">\n                <div class="collission-hint" ng-if="change.getCollissions().length > 0">\n                    <i class="fa fa-warning" uib-tooltip="{{ \'This change collides with another one.\' | translate }}"></i>\n                </div>\n                <div class="action-row">\n                    <span ng-if="motion.isAllowed(\'can_manage\')">\n                    <div class="btn-group" data-toggle="buttons" ng-if="change.type == \'recommendation\'">\n                        <label class="btn btn-sm btn-default"\n                               ng-class="{active: change.accepted, disabled: change.getAcceptedCollissions().length > 0}"\n                               title="{{ \'Not rejected\' | translate }}" ng-click="change.setAccepted($event)">\n                            <input type="radio" name="changeRecommendationRejected[{{ change.id }}]" value="0"\n                                   ng-disabled="change.getAcceptedCollissions().length > 0"\n                                   ng-change="change.saveStatus()" ng-model="change.rejected" ng-checked="change.accepted == true">\n                            <i class="fa fa-thumbs-up"></i>\n                        </label>\n                        <label class="btn btn-sm btn-default" ng-class="{active: change.rejected}"\n                               title="{{ \'Rejected\' | translate }}" ng-click="change.setRejected($event)">\n                            <input type="radio" name="changeRecommendationRejected[{{ change.id }}]" value="1"\n                               ng-change="change.saveStatus()" ng-model="change.rejected" ng-checked="change.rejected == true">\n                            <i class="fa fa-thumbs-down"></i>\n                        </label>\n                    </div>\n                    <button class="btn btn-default btn-sm pull-right btn-delete"\n                            ng-if="change.type == \'recommendation\'"\n                            ng-bootbox-confirm="{{ \'Are you sure you want to delete this change recommendation?\' | translate }}"\n                            ng-bootbox-confirm-action="viewChangeRecommendations.delete(change.original.id)"\n                            title="{{ \'Delete\' | translate }}">\n                        <i class="fa fa-trash"></i>\n                    </button>\n                    <button class="btn btn-default btn-sm pull-right btn-edit"\n                            ng-if="change.type == \'recommendation\'"\n                            ng-click="createChangeRecommendation.editTextDialog(change.original)"\n                            title="{{ \'Edit\' | translate }}">\n                        <i class="fa fa-pencil"></i>\n                    </button>\n                    </span>\n\n                    <a ng-if="change.type == \'amendment\'" ui-sref="motions.motion.detail({id: change.original.id})"\n                       uib-tooltip="{{ \'Open amendment\' | translate }}"\n                       class="btn btn-default btn-sm pull-right btn-amend-info">\n                        <i class="fa fa-info"></i>\n                        {{ change.original.identifier }}\n                    </a>\n                </div>\n                <div class="status-row" ng-if="!motion.isAllowed(\'can_manage\') && change.rejected">\n                    <i class="grey"><translate>Rejected</translate>:</i>\n                </div>\n\n                <div class="motion-text motion-text-diff line-numbers-{{ lineNumberMode }}"\n                     ng-bind-html="change.getDiff(motion, version, highlight) | trusted"></div>\n            </div>\n        </div>\n\n        <div class="motion-text original-text line-numbers-{{ lineNumberMode }}"\n             ng-bind-html="motion.getTextRemainderAfterLastChange(version, amendments_crs, highlight) | trusted"></div>\n    </div>\n</div>\n'),n.put("motions/static/templates/motions/motion-detail/view-modified-agreed.html",'\x3c!-- Modified agreed view --\x3e\n<div ng-if="viewChangeRecommendations.mode == \'modified_agreed\'">\n    <div style="text-align: right;">\n      <button class="btn btn-default btn-danger btn-sm" os-perms="motions.can_manage"\n          ng-bootbox-confirm="{{ \'Do you want to delete the final print template?\' | translate }}"\n          ng-bootbox-confirm-action="viewChangeRecommendations.deleteModifiedFinalVersion(motion, version)">\n        <i class="fa fa-trash"></i>\n        <translate>Delete final print template</translate>\n      </button>\n    </div>\n    <div id="view-modified-agreed-inline-editor" ng-bind-html="motion.getModifiedFinalVersionWithLineBreaks(version) | trusted"\n      class="motion-text motion-text-original line-numbers-{{ lineNumberMode }}"\n      contenteditable="{{ modifiedFinalVersionInlineEditing.isEditable }}">\n    </div>\n    <div class="motion-save-toolbar" ng-class="{ \'visible\': modifiedFinalVersionInlineEditing.active && modifiedFinalVersionInlineEditing.changed }">\n        <div class="changed-hint" translate>The final print template have been changed.</div>\n        <button type="button" ng-click="modifiedFinalVersionInlineEditing.save()" class="btn btn-primary" translate>\n            Save\n        </button>\n        <button type="button" ng-click="modifiedFinalVersionInlineEditing.revert()" class="btn btn-default" translate>\n            Revert\n        </button>\n        <label ng-if="motion.state.versioning && config(\'motions_allow_disable_versioning\')">\n            <input type="checkbox" ng-model="modifiedFinalVersionInlineEditing.trivialChange" value="1">\n            <span translate>Trivial change</span>\n        </label>\n    </div>\n</div>\n'),n.put("motions/static/templates/motions/motion-detail/view-original.html",'\x3c!-- Original view --\x3e\n<div ng-if="viewChangeRecommendations.mode == \'original\'">\n    <div id="view-original-text-inline-editor" ng-bind-html="motion.getTextWithLineBreaks(version, highlight) | trusted"\n      class="motion-text motion-text-original line-numbers-{{ lineNumberMode }}"\n      contenteditable="{{ inlineEditing.isEditable }}">\n    </div>\n    <div class="motion-save-toolbar" ng-class="{ \'visible\': textReasonSaveToolbarVisible() }">\n        <div class="changed-hint" translate>The text or reason have been changed.</div>\n        <button type="button" ng-click="textReasonSave()" class="btn btn-primary" translate>\n            Save\n        </button>\n        <button type="button" ng-click="textReasonRevert()" class="btn btn-default" translate>\n            Revert\n        </button>\n        <label ng-if="motion.state.versioning && config(\'motions_allow_disable_versioning\')">\n            <input type="checkbox" ng-model="inlineEditing.trivialChange" value="1">\n            <span translate>Trivial change</span>\n        </label>\n    </div>\n</div>\n\x3c!-- Original view, Change list --\x3e\n<ul ng-if="viewChangeRecommendations.mode == \'original\'" ng-show="lineNumberMode != \'none\'"\n    class="change-recommendation-list">\n    <li ng-repeat="change in change_recommendations | filter:{motion_version_id:version}:true"\n        ng-class="[\'replace\', \'insert\', \'delete\', \'other\'][change.getType(motion.getVersion(version).text)]"\n        ng-click="viewChangeRecommendations.scrollToDiffBox(change.id)"\n        data-line-from="{{ change.line_from }}" data-line-to="{{ change.line_to}}"\n        title="{{ change.getTitle(motion.getVersion(version).text) }}">\n        <div class="tooltip">\n            <div class="text" ng-bind-html="change.text || trusted"></div>\n\n            \x3c!-- delete change recommendation --\x3e\n            <button class="btn btn-default btn-xs"\n                    ng-bootbox-confirm="{{ \'Are you sure you want to delete this change recommendation?\' | translate }}"\n                    ng-bootbox-confirm-action="viewChangeRecommendations.delete(change.id)"\n                    title="{{ \'Delete\' | translate }}">\n                <i class="fa fa-times"></i>\n            </button>\n        </div>\n    </li>\n</ul>\n\n<div class="tooltip top tt_change_recommendation_create_help" role="tooltip">\n    <div class="tooltip-arrow"></div>\n    <div class="tooltip-inner" translate>Now choose the last line to be changed</div>\n</div>\n')}])}();