# Generated by Django 2.1.7 on 2019-03-20 15:49

from django.db import migrations


def copy_access_level(apps, schema_editor):
    """
    Sets new restriction field of states according to access_level.
    """
    # We get the model from the versioned app registry;
    # if we directly import it, it will be the wrong version.
    State = apps.get_model("motions", "State")
    for state in State.objects.all():
        if state.access_level == 3:
            state.restriction = ["managers_only"]
        elif state.access_level == 2:
            state.restriction = [
                "motions.can_see_internal",
                "motions.can_manage_metadata",
            ]
        elif state.access_level == 1:
            state.restriction = [
                "motions.can_see_internal",
                "motions.can_manage_metadata",
                "is_submitter",
            ]
        state.save(skip_autoupdate=True)


class Migration(migrations.Migration):

    dependencies = [("motions", "0024_state_restriction_1")]

    operations = [migrations.RunPython(copy_access_level)]
