# Generated by Django 2.2.6 on 2019-10-17 09:00

from decimal import Decimal

import django.core.validators
import django.db.models.deletion
from django.conf import settings
from django.db import migrations, models

import openslides.utils.models


class Migration(migrations.Migration):

    dependencies = [
        ("users", "0011_postgresql_auth_group_id_sequence"),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ("motions", "0032_category_cascade_delete"),
    ]

    operations = [
        migrations.AddField(
            model_name="motionpoll",
            name="groups",
            field=models.ManyToManyField(blank=True, to="users.Group"),
        ),
        migrations.AddField(
            model_name="motionpoll",
            name="state",
            field=models.IntegerField(
                choices=[
                    (1, "Created"),
                    (2, "Started"),
                    (3, "Finished"),
                    (4, "Published"),
                ],
                default=1,
            ),
        ),
        migrations.AddField(
            model_name="motionpoll",
            name="title",
            field=models.CharField(default="Poll", blank=True, max_length=255),
            preserve_default=False,
        ),
        migrations.AddField(
            model_name="motionpoll",
            name="type",
            field=models.CharField(
                choices=[
                    ("analog", "Analog"),
                    ("named", "Named"),
                    ("pseudoanonymous", "Pseudoanonymous"),
                ],
                default="analog",
                max_length=64,
            ),
            preserve_default=False,
        ),
        migrations.AddField(
            model_name="motionpoll",
            name="voted",
            field=models.ManyToManyField(blank=True, to=settings.AUTH_USER_MODEL),
        ),
        migrations.AddField(
            model_name="motionvote",
            name="user",
            field=models.ForeignKey(
                blank=True,
                default=None,
                null=True,
                on_delete=openslides.utils.models.SET_NULL_AND_AUTOUPDATE,
                to=settings.AUTH_USER_MODEL,
            ),
        ),
        migrations.AddField(
            model_name="motionpoll",
            name="pollmethod",
            field=models.CharField(
                choices=[("YN", "YN"), ("YNA", "YNA")], default="YNA", max_length=3
            ),
            preserve_default=False,
        ),
        migrations.AddField(
            model_name="motionpoll",
            name="majority_method",
            field=models.CharField(
                choices=[
                    ("simple", "Simple majority"),
                    ("two_thirds", "Two-thirds majority"),
                    ("three_quarters", "Three-quarters majority"),
                    ("disabled", "Disabled"),
                ],
                default="",
                max_length=14,
            ),
            preserve_default=False,
        ),
        migrations.AddField(
            model_name="motionpoll",
            name="onehundred_percent_base",
            field=models.CharField(
                choices=[
                    ("YN", "Yes/No"),
                    ("YNA", "Yes/No/Abstain"),
                    ("valid", "All valid ballots"),
                    ("cast", "All casted ballots"),
                    ("disabled", "Disabled (no percents)"),
                ],
                default="",
                max_length=8,
            ),
            preserve_default=False,
        ),
        migrations.AlterField(
            model_name="motionvote",
            name="option",
            field=models.ForeignKey(
                on_delete=openslides.utils.models.CASCADE_AND_AUTOUPDATE,
                related_name="votes",
                to="motions.MotionOption",
            ),
        ),
        migrations.AlterField(
            model_name="motionvote",
            name="value",
            field=models.CharField(
                choices=[("Y", "Y"), ("N", "N"), ("A", "A")], max_length=1
            ),
        ),
        migrations.AlterField(
            model_name="motionvote",
            name="weight",
            field=models.DecimalField(
                decimal_places=6,
                default=Decimal("1"),
                max_digits=15,
                validators=[django.core.validators.MinValueValidator(Decimal("-2"))],
            ),
        ),
        migrations.AlterField(
            model_name="motionoption",
            name="poll",
            field=models.ForeignKey(
                on_delete=openslides.utils.models.CASCADE_AND_AUTOUPDATE,
                related_name="options",
                to="motions.MotionPoll",
            ),
        ),
        migrations.AlterField(
            model_name="motionpoll",
            name="motion",
            field=models.ForeignKey(
                on_delete=openslides.utils.models.CASCADE_AND_AUTOUPDATE,
                related_name="polls",
                to="motions.Motion",
            ),
        ),
        migrations.RenameField(
            model_name="motionpoll", old_name="votescast", new_name="db_votescast"
        ),
        migrations.RenameField(
            model_name="motionpoll", old_name="votesinvalid", new_name="db_votesinvalid"
        ),
        migrations.RenameField(
            model_name="motionpoll", old_name="votesvalid", new_name="db_votesvalid"
        ),
        migrations.AlterModelOptions(
            name="motion",
            options={
                "default_permissions": (),
                "ordering": ("identifier",),
                "permissions": (
                    ("can_see", "Can see motions"),
                    ("can_see_internal", "Can see motions in internal state"),
                    ("can_create", "Can create motions"),
                    ("can_create_amendments", "Can create amendments"),
                    ("can_support", "Can support motions"),
                    ("can_manage_metadata", "Can manage motion metadata"),
                    ("can_manage", "Can manage motions"),
                    ("can_manage_polls", "Can manage motion polls"),
                ),
                "verbose_name": "Motion",
            },
        ),
    ]
